/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormcore.plot;

import at.tugraz.genome.arraynormcore.math.Univariate;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.math.MathFunctions;
import at.tugraz.genome.utils.JpegPngEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;

public class Scatterplot
extends JPanel {
    public static final Color DEFAULT_AXES_COLOR;
    public static final Font DEFAULT_FONT;
    public static final Color DEFAULT_FRAMEBACKGROUD_COLOR;
    public static final Color DEFAULT_GRAPHBACKGROUD_COLOR;
    public static final int DEFAULT_HEIGHT = 590;
    public static final Color DEFAULT_LINES_COLOR;
    public static final int DEFAULT_OFFSET = 40;
    public static final Color DEFAULT_POINT_COLOR;
    public static final int DEFAULT_POINT_SIZE = 4;
    public static final int DEFAULT_WIDTH = 600;
    public static final boolean DRAW_GRID = true;
    public static final String HORIZONTAL_LINE = "horizontal";
    public static final String VERTICAL_LINE = "vertical";
    protected boolean add_lines_ = false;
    protected Color color_ctrl_spots_;
    protected Color[] color_dataset_;
    private int count_;
    protected int count_datasets_ = 0;
    protected int[] data_marks_;
    protected boolean divide_points_ = false;
    private Graphics2D g_frame_;
    protected boolean have_label_;
    protected boolean have_multiple_datasets = false;
    protected int height_;
    private int image_height_;
    private int image_width_;
    private Vector info_set_ = new Vector();
    private int[] int_array_;
    protected int k = 0;
    protected float[] linX1;
    protected float[] linX2;
    protected float[] linY1;
    protected float[] linY2;
    protected float line_x1_;
    protected float line_x2_;
    protected float line_y1_;
    protected float line_y2_;
    protected int[] margins_;
    protected float[] max_x_data_;
    protected float max_x_glob_;
    protected float[] max_y_data_;
    protected float max_y_glob_;
    protected float[] min_x_data_;
    protected float min_x_glob_;
    protected float[] min_y_data_;
    protected float min_y_glob_;
    int mouse_x_;
    int mouse_y_;
    protected int num_of_added_lines_ = 0;
    protected int[] num_of_points_;
    protected boolean num_x_ticks_;
    protected boolean num_y_ticks_;
    protected String plot_title_;
    private JPanel plotting_area_panel_;
    protected int point_size_;
    private JPopupMenu popup_menu_;
    private boolean scale_fixed_;
    private Graphics2D scplot_graphix_;
    private BufferedImage scplot_image_;
    private JPanel scplot_panel_;
    protected Dimension size_;
    private MicroArrayData slide_data_;
    private static final Font trp10;
    protected int width_;
    protected String x_label_text_;
    protected int x_origin_;
    protected Univariate[] x_univ_dataset_ = null;
    private JTextField xy_coords_field_;
    protected String y_label_text_;
    protected int y_origin_;
    protected Univariate[] y_univ_dataset_ = null;

    static {
        DEFAULT_FONT = new Font("TimesRoman", 0, 9);
        trp10 = new Font("TimesRoman", 0, 12);
        DEFAULT_POINT_COLOR = Color.blue;
        DEFAULT_GRAPHBACKGROUD_COLOR = Color.white;
        DEFAULT_FRAMEBACKGROUD_COLOR = Color.lightGray;
        DEFAULT_AXES_COLOR = Color.black;
        DEFAULT_LINES_COLOR = Color.red;
    }

    public Scatterplot(int width, int height, String title, boolean scal_fix) {
        try {
            this.scale_fixed_ = scal_fix;
            this.plot_title_ = title;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Scatterplot(String title, boolean scal_fix) {
        try {
            this.scale_fixed_ = scal_fix;
            this.plot_title_ = title;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Scatterplot(boolean scal_fix) {
        try {
            this.scale_fixed_ = scal_fix;
            this.plot_title_ = "scatterplot";
            this.width_ = 600;
            this.height_ = 590;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addLabels(String xlab, String ylab) {
        this.addXLabel(xlab);
        this.addYLabel(ylab);
    }

    public void addMoreLines(float[] slopes, float[] intercepts) {
        this.add_lines_ = true;
        this.num_of_added_lines_ = slopes.length;
        if (slopes.length == intercepts.length) {
            this.linX1 = new float[this.num_of_added_lines_];
            this.linX2 = new float[this.num_of_added_lines_];
            this.linY1 = new float[this.num_of_added_lines_];
            this.linY2 = new float[this.num_of_added_lines_];
            int i = 0;
            while (i < this.num_of_added_lines_) {
                this.linX1[i] = this.min_x_glob_;
                this.linX2[i] = this.max_x_glob_;
                this.linY1[i] = slopes[i] * this.linX1[i] + intercepts[i];
                this.linY2[i] = slopes[i] * this.linX2[i] + intercepts[i];
                this.linX1[i] = Math.max(this.min_x_glob_, (this.min_y_glob_ - intercepts[i]) / slopes[i]);
                this.linX2[i] = Math.min(this.max_x_glob_, (this.max_y_glob_ - intercepts[i]) / slopes[i]);
                this.linY1[i] = Math.max(this.min_y_glob_, slopes[i] * this.linX1[i] + intercepts[i]);
                this.linY2[i] = Math.min(this.max_y_glob_, slopes[i] * this.linX2[i] + intercepts[i]);
                ++i;
            }
        } else {
            this.add_lines_ = false;
            return;
        }
    }

    public void addXLabel(String xlab) {
        this.x_label_text_ = xlab;
        if (!this.have_label_) {
            this.margins_[0] = this.margins_[0] + 10;
        }
        this.have_label_ = true;
    }

    public void addYLabel(String ylab) {
        this.y_label_text_ = ylab;
        if (!this.have_label_) {
            this.margins_[1] = this.margins_[1] + 10;
        }
        this.have_label_ = true;
    }

    public void additionalDataset(float[] data1, float[] data2, boolean plot) {
        this.have_multiple_datasets = true;
        ++this.count_datasets_;
        this.x_univ_dataset_[this.count_datasets_] = new Univariate(data1);
        this.y_univ_dataset_[this.count_datasets_] = new Univariate(data2);
        this.min_x_data_[this.count_datasets_] = (float)Math.floor(this.x_univ_dataset_[this.count_datasets_].min());
        this.max_x_data_[this.count_datasets_] = (float)Math.ceil(this.x_univ_dataset_[this.count_datasets_].max());
        this.min_y_data_[this.count_datasets_] = (float)Math.floor(this.y_univ_dataset_[this.count_datasets_].min());
        this.max_y_data_[this.count_datasets_] = (float)Math.ceil(this.y_univ_dataset_[this.count_datasets_].max());
        this.num_of_points_[this.count_datasets_] = this.x_univ_dataset_[this.count_datasets_].size();
        if (plot) {
            this.repaint();
        }
    }

    public void addline(float slope, float intercept) {
        this.add_lines_ = true;
        this.line_x1_ = this.min_x_glob_;
        this.line_x2_ = this.max_x_glob_;
        this.line_y1_ = slope * this.line_x1_ + intercept;
        this.line_y2_ = slope * this.line_x2_ + intercept;
        this.line_x1_ = Math.max(this.min_x_glob_, (this.min_y_glob_ - intercept) / slope);
        this.line_y1_ = Math.max(this.min_y_glob_, slope * this.line_x1_ + intercept);
        this.line_x2_ = Math.min(this.max_x_glob_, (this.max_y_glob_ - intercept) / slope);
        this.line_y2_ = Math.min(this.max_y_glob_, slope * this.line_x2_ + intercept);
    }

    private void createPopupMenu() {
        this.popup_menu_ = new JPopupMenu();
        AbstractAction pop_1 = new AbstractAction("Settings"){

            public void actionPerformed(ActionEvent e) {
            }
        };
        AbstractAction pop_2 = new AbstractAction("Capture"){

            public void actionPerformed(ActionEvent e) {
                JpegPngEncoder enc = new JpegPngEncoder(Scatterplot.this.scplot_panel_, Scatterplot.this.scplot_panel_);
            }
        };
        this.popup_menu_.add(pop_1);
        this.popup_menu_.add(pop_2);
    }

    private final void drawCircle(Graphics g, int xC, int yC, int radius, Color color) {
        if (color == null) {
            color = Color.green;
        }
        if (radius == 0) {
            radius = 6;
        }
        int thickness = 3;
        g.setColor(color);
        int t = 1;
        while (t <= thickness) {
            g.drawArc(xC - radius - 1, yC - radius - 1, 2 * radius + t, 2 * radius + t, 0, 360);
            ++t;
        }
    }

    private final void drawFilledCircle(Graphics g, int x, int y, int radius) {
        int r2 = radius / 2;
        int xC = x - r2;
        int yC = y - r2;
        g.fillOval(xC, yC, radius, radius);
    }

    private final void drawFilledColoredCircle(Graphics g, int x, int y, int radius, int red, int green, int blue) {
        int r2 = radius / 2;
        int xC = x - r2;
        int yC = y - r2;
        if (red > 255) {
            red = 255;
        }
        if (green > 255) {
            green = 255;
        }
        if (blue > 255) {
            blue = 255;
        }
        Color color = new Color(red, green, blue);
        g.setColor(color);
        g.fillOval(xC, yC, radius, radius);
    }

    private final void drawPlus(Graphics g, int x, int y) {
        int w = 1;
        g.drawLine(x, y - w, x, y + w);
        g.drawLine(x - w, y, x + w, y);
    }

    private final void drawPlus(Graphics g, int x, int y, Color color) {
        int w = 3;
        g.setColor(color);
        g.drawLine(x, y - w, x, y + w);
        g.drawLine(x - w, y, x + w, y);
    }

    private final void drawRectangleBin(Graphics g, int x, int y, int width, int height) {
        g.drawLine(x, y, x + width, y);
        g.drawLine(x, y - height, x + width, y - height);
        g.drawLine(x, y, x, y - height);
        g.drawLine(x + width, y, x + width, y - height);
    }

    private final void drawSquare(Graphics g, int xC, int yC, int radius, Color color) {
        int height_;
        if (color == null) {
            color = Color.green;
        }
        if (radius == 0) {
            radius = 5;
        }
        int width_ = height_ = 2 * radius + 1;
        g.setColor(color);
        g.drawRect(xC - radius, yC - radius, width_, height_);
    }

    private void findGlobalMinMaxCoords() {
        this.min_x_glob_ = MathFunctions.min(this.min_x_data_);
        this.max_x_glob_ = MathFunctions.max(this.max_x_data_);
        this.min_y_glob_ = MathFunctions.min(this.min_y_data_);
        this.max_y_glob_ = MathFunctions.max(this.max_y_data_);
    }

    void jbInit() throws Exception {
        this.setLocation(50, 50);
        this.setBackground(DEFAULT_FRAMEBACKGROUD_COLOR);
        this.margins_ = new int[4];
        this.margins_[0] = 40;
        this.margins_[1] = 40;
        this.margins_[2] = 10;
        this.margins_[3] = 10;
        this.point_size_ = 4;
        this.have_label_ = false;
        this.have_label_ = false;
        this.num_of_points_ = new int[5];
        this.min_x_data_ = new float[5];
        this.max_x_data_ = new float[5];
        this.min_y_data_ = new float[5];
        this.max_y_data_ = new float[5];
        this.x_univ_dataset_ = new Univariate[5];
        this.y_univ_dataset_ = new Univariate[5];
        this.color_dataset_ = new Color[5];
        this.color_dataset_[0] = Color.blue;
        this.color_dataset_[1] = Color.red;
        this.color_ctrl_spots_ = Color.magenta;
        this.plotting_area_panel_ = this;
        this.setBackground(Color.yellow);
        this.plotting_area_panel_.setBorder(BorderFactory.createEtchedBorder());
        this.g_frame_ = (Graphics2D)this.getGraphics();
        this.setVisible(true);
        this.createPopupMenu();
    }

    public void newDataset(float[] data1, float[] data2, float[] xlim, float[] ylim, boolean plot) {
        this.x_univ_dataset_[0] = new Univariate(data1);
        this.y_univ_dataset_[0] = new Univariate(data2);
        this.min_x_data_[0] = xlim[0];
        this.max_x_data_[0] = xlim[1];
        this.min_y_data_[0] = ylim[0];
        this.max_y_data_[0] = ylim[1];
        this.num_of_points_[0] = this.x_univ_dataset_[0].size();
        if (plot) {
            this.repaint();
        }
    }

    public void newDataset(float[] data1, float[] data2, int[] data_marks, boolean plot) {
        int i = 0;
        while (i < data1.length) {
            float d1 = data1[i];
            float d2 = data2[i];
            if (Float.isNaN(d1) || Float.isNaN(d2)) {
                data1[i] = Float.NaN;
                data2[2] = Float.NaN;
            }
            ++i;
        }
        this.x_univ_dataset_[0] = new Univariate(data1);
        this.y_univ_dataset_[0] = new Univariate(data2);
        this.data_marks_ = new int[data1.length];
        this.data_marks_ = data_marks;
        this.min_x_data_[0] = (float)Math.floor(this.x_univ_dataset_[0].min());
        this.max_x_data_[0] = (float)Math.ceil(this.x_univ_dataset_[0].max());
        this.min_y_data_[0] = (float)Math.floor(this.y_univ_dataset_[0].min());
        this.max_y_data_[0] = (float)Math.ceil(this.y_univ_dataset_[0].max());
        this.num_of_points_[0] = this.x_univ_dataset_[0].size();
        if (plot) {
            this.repaint();
        }
    }

    public void newDataset(float[] data1, float[] data2, boolean plot) {
        int i = 0;
        while (i < data1.length) {
            float d1 = data1[i];
            float d2 = data2[i];
            if (Float.isNaN(d1) || Float.isNaN(d2)) {
                data1[i] = Float.NaN;
                data2[i] = Float.NaN;
            }
            ++i;
        }
        this.x_univ_dataset_[0] = new Univariate(data1);
        this.y_univ_dataset_[0] = new Univariate(data2);
        this.data_marks_ = new int[data1.length];
        this.min_x_data_[0] = (float)Math.floor(this.x_univ_dataset_[0].min());
        this.max_x_data_[0] = (float)Math.ceil(this.x_univ_dataset_[0].max());
        this.min_y_data_[0] = (float)Math.floor(this.y_univ_dataset_[0].min());
        this.max_y_data_[0] = (float)Math.ceil(this.y_univ_dataset_[0].max());
        this.num_of_points_[0] = this.x_univ_dataset_[0].size();
        if (plot) {
            this.repaint();
        }
    }

    public void paint(Graphics g) {
        int y1;
        int x1;
        int bottom = -this.margins_[0];
        int left = this.margins_[1];
        int top = this.margins_[2];
        int right = this.margins_[3];
        this.x_origin_ = 40;
        this.y_origin_ = this.height_ + 40;
        g.setColor(DEFAULT_GRAPHBACKGROUD_COLOR);
        g.drawRect(40, 40, this.width_, this.height_);
        g.fillRect(40, 40, this.width_, this.height_);
        g.setColor(DEFAULT_GRAPHBACKGROUD_COLOR);
        if (this.scale_fixed_) {
            this.max_x_glob_ = 100000.0f;
            this.min_x_glob_ = 0.0f;
            this.max_y_glob_ = 100000.0f;
            this.min_y_glob_ = -1000.0f;
        } else {
            this.findGlobalMinMaxCoords();
        }
        float mx = (float)this.width_ / (this.max_x_glob_ - this.min_x_glob_);
        float bx = (float)this.x_origin_ - mx * this.min_x_glob_;
        float my = (float)this.height_ / (this.min_y_glob_ - this.max_y_glob_);
        float by = (float)this.y_origin_ - my * this.min_y_glob_;
        g.setFont(trp10);
        FontMetrics fm = this.getFontMetrics(trp10);
        g.setColor(DEFAULT_AXES_COLOR);
        g.drawLine(this.x_origin_, this.y_origin_, this.x_origin_ + this.width_, this.y_origin_);
        g.drawLine(this.x_origin_, this.y_origin_, this.x_origin_, this.y_origin_ - this.height_);
        g.drawLine(this.x_origin_, this.y_origin_ - this.height_, this.x_origin_ + this.width_, this.y_origin_ - this.height_);
        g.drawLine(this.x_origin_ + this.width_, this.y_origin_, this.x_origin_ + this.width_, this.y_origin_ - this.height_);
        int ytick = this.height_ / 4;
        int xtick = this.width_ / 4;
        int yzero = (int)Math.abs(this.min_y_glob_);
        int i = 0;
        while (i < 5) {
            g.drawLine(this.x_origin_ - 5, this.y_origin_ - i * ytick, this.x_origin_, this.y_origin_ - i * ytick);
            g.drawLine(this.x_origin_ + 5 + this.width_, this.y_origin_ - i * ytick, this.x_origin_ + this.width_, this.y_origin_ - i * ytick);
            g.drawLine(this.x_origin_, this.y_origin_ - i * ytick, this.x_origin_ + this.width_, this.y_origin_ - i * ytick);
            float yLabel = this.min_y_glob_ + (float)i * (this.max_y_glob_ - this.min_y_glob_) / 4.0f;
            g.drawString(Double.toString(yLabel), this.x_origin_ - 30, this.y_origin_ - i * ytick);
            g.drawLine(this.x_origin_ + i * xtick, this.y_origin_, this.x_origin_ + i * xtick, this.y_origin_ + 5);
            g.drawLine(this.x_origin_ + i * xtick, this.y_origin_ - this.height_, this.x_origin_ + i * xtick, this.y_origin_ - this.height_ - 5);
            g.drawLine(this.x_origin_ + i * xtick, this.y_origin_, this.x_origin_ + i * xtick, this.y_origin_ - this.height_);
            float xLabel = this.min_x_glob_ + (float)i * (this.max_x_glob_ - this.min_x_glob_) / 4.0f;
            g.drawString(Double.toString(xLabel), this.x_origin_ + i * xtick - 0, this.y_origin_ + 15);
            ++i;
        }
        g.setColor(Color.red);
        g.drawLine(this.x_origin_, Math.round(by), this.x_origin_ + this.width_, Math.round(by));
        g.drawString(Double.toString(0.0), this.x_origin_ - 30, Math.round(by));
        g.setColor(DEFAULT_AXES_COLOR);
        g.setColor(DEFAULT_POINT_COLOR);
        this.count_ = 0;
        while (this.count_ < this.count_datasets_ + 1) {
            g.setColor(this.color_dataset_[this.count_]);
            i = 0;
            while (i < this.num_of_points_[0]) {
                x1 = (int)(mx * this.x_univ_dataset_[this.count_].elementAt(i) + bx);
                y1 = (int)(my * this.y_univ_dataset_[this.count_].elementAt(i) + by);
                this.drawFilledCircle(g, x1, y1, 3);
                ++i;
            }
            g.setColor(this.color_ctrl_spots_);
            i = 0;
            while (i < this.num_of_points_[0]) {
                x1 = (int)(mx * this.x_univ_dataset_[this.count_].elementAt(i) + bx);
                y1 = (int)(my * this.y_univ_dataset_[this.count_].elementAt(i) + by);
                if (this.data_marks_[i] != 0) {
                    this.drawFilledCircle(g, x1, y1, 3);
                }
                ++i;
            }
            ++this.count_;
        }
        g.setColor(DEFAULT_LINES_COLOR);
        if (this.add_lines_) {
            int y2;
            int x2;
            if (this.num_of_added_lines_ > 1) {
                i = 0;
                while (i < this.num_of_added_lines_) {
                    x1 = (int)(mx * this.linX1[i] + bx);
                    x2 = (int)(mx * this.linX2[i] + bx);
                    y1 = (int)(my * this.linY1[i] + by);
                    y2 = (int)(my * this.linY2[i] + by);
                    g.drawLine(x1, y1, x2, y2);
                    ++i;
                }
            } else {
                x1 = (int)(mx * this.line_x1_ + bx);
                x2 = (int)(mx * this.line_x2_ + bx);
                y1 = (int)(my * this.line_y1_ + by);
                y2 = (int)(my * this.line_y2_ + by);
                g.drawLine(x1, y1, x2, y2);
            }
        }
        if (this.have_label_) {
            int xlabCenter = (int)((double)fm.stringWidth(this.x_label_text_) * 0.5);
            g.drawString(this.x_label_text_, left + (int)((double)(this.width_ - right) * 0.5) - xlabCenter + 190, this.y_origin_ + 10);
        }
        if (this.have_label_) {
            int stringHeight = (int)((double)fm.getHeight() * 0.75);
            int len = this.y_label_text_.length();
            int textCenter = (int)(0.5 * (double)len * (double)stringHeight);
            int axisCenter = (int)(0.5 * (double)(this.y_origin_ + bottom + top));
            int charWidth = 0;
            char[] charArray = new char[1];
            i = 0;
            while (i < len) {
                char character;
                charArray[0] = character = this.y_label_text_.charAt(i);
                String string = new String(charArray);
                charWidth = (int)(0.5 * (double)fm.stringWidth(string));
                g.drawString(string, 30 - charWidth, axisCenter - textCenter + i * stringHeight - 140);
                ++i;
            }
        }
    }

    public void paintComponent(Graphics g_frame_) {
        this.paint(g_frame_);
    }

    public void removeTitle() {
        this.margins_[2] = this.margins_[2] - 15;
    }

    public void removeXLabel() {
        this.have_label_ = false;
        this.margins_[0] = this.margins_[0] - 10;
    }

    public void removeYLabel() {
        this.have_label_ = false;
        this.margins_[1] = this.margins_[1] - 10;
    }
}

