/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui;

import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ProgramProperties {
    public String ArrayNormHomeDirectory;
    public String Build = "";
    public String DialogLabelText1 = "ArrayNorm";
    public String DialogLabelText2 = "by Roland Pieler 2003";
    public String Edition = null;
    public String FileOpeningPath;
    public String FileSavingPath;
    public String ImageSavingPath;
    public LogPrintStream MyLogPrintStream;
    private static ProgramProperties MyProgramProperties;
    public Vector Plugins;
    public Vector PreviousDatasetNames = new Vector();
    public Vector PreviousDatasetPlugins;
    public Vector PreviousDatasetURLs = new Vector();
    public String Release = "1.7.2";
    public JLabel StatusLabel;

    private ProgramProperties() {
        this.PreviousDatasetPlugins = new Vector();
        this.Plugins = new Vector();
        this.FileOpeningPath = System.getProperty("user.dir");
        this.ArrayNormHomeDirectory = System.getProperty("user.dir");
        this.FileSavingPath = System.getProperty("user.dir");
        this.ImageSavingPath = System.getProperty("user.dir");
        this.MyLogPrintStream = new LogPrintStream(System.out);
    }

    public static ProgramProperties GetInstance() {
        if (MyProgramProperties == null) {
            MyProgramProperties = new ProgramProperties();
        }
        return MyProgramProperties;
    }

    public boolean Read(Frame ParentFrame2, String Path2) {
        try {
            FileInputStream in = new FileInputStream(Path2);
            Properties MyProperties = new Properties();
            MyProperties.load(in);
            in.close();
            this.FileOpeningPath = MyProperties.getProperty("FileOpeningPath", ".");
            this.FileSavingPath = MyProperties.getProperty("FileSavingPath", ".");
            this.ImageSavingPath = MyProperties.getProperty("ImageSavingPath", ".");
            int counter = 1;
            String Dummy = MyProperties.getProperty("PreviousDatasetURL1", "");
            while (Dummy != "") {
                this.PreviousDatasetURLs.add(Dummy);
                Dummy = MyProperties.getProperty("PreviousDatasetURL" + String.valueOf(++counter), "");
            }
            counter = 1;
            Dummy = MyProperties.getProperty("PreviousDatasetName1", "");
            while (Dummy != "") {
                this.PreviousDatasetNames.add(Dummy);
                Dummy = MyProperties.getProperty("PreviousDatasetName" + String.valueOf(++counter), "");
            }
            counter = 1;
            Dummy = MyProperties.getProperty("PreviousDatasetPlugin1", "");
            while (Dummy != "") {
                this.PreviousDatasetPlugins.add(Dummy);
                Dummy = MyProperties.getProperty("PreviousDatasetPlugin" + String.valueOf(++counter), "");
            }
            counter = 1;
            Dummy = MyProperties.getProperty("Plugin1", "");
            while (Dummy != "") {
                this.Plugins.add(Dummy);
                Dummy = MyProperties.getProperty("Plugin" + String.valueOf(++counter), "");
            }
        }
        catch (IOException e) {
            String errorMessage = "\n\nThe " + Path2 + " file got somehow corrupted!\nArrayNorm tries to recover this file from the last valid stage";
            return false;
        }
        return true;
    }

    public boolean Write(Frame ParentFrame2, String Path2) {
        boolean Success = true;
        Properties MyProperties = new Properties();
        FileOutputStream out = null;
        MyProperties.put("FileOpeningPath", ProgramProperties.MyProgramProperties.FileOpeningPath);
        MyProperties.put("FileSavingPath", ProgramProperties.MyProgramProperties.FileSavingPath);
        MyProperties.put("ImageSavingPath", ProgramProperties.MyProgramProperties.ImageSavingPath);
        int i = 0;
        while (i < Math.min(this.PreviousDatasetURLs.size(), 10)) {
            MyProperties.put("PreviousDatasetName" + String.valueOf(i + 1), (String)this.PreviousDatasetNames.get(i));
            MyProperties.put("PreviousDatasetURL" + String.valueOf(i + 1), (String)this.PreviousDatasetURLs.get(i));
            MyProperties.put("PreviousDatasetPlugin" + String.valueOf(i + 1), (String)this.PreviousDatasetPlugins.get(i));
            ++i;
        }
        int i2 = 0;
        while (i2 < this.Plugins.size()) {
            MyProperties.put("Plugin" + String.valueOf(i2 + 1), (String)this.Plugins.get(i2));
            ++i2;
        }
        try {
            out = new FileOutputStream(Path2);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(ParentFrame2, "Can not open file " + Path2 + "!", e.toString(), 0);
            Success = false;
        }
        try {
            MyProperties.store(out, "ArrayNorm poperties");
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(ParentFrame2, "Can not write file " + Path2 + "!", e.toString(), 0);
            Success = false;
        }
        try {
            out.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(ParentFrame2, "Can not close file " + Path2 + "!", e.toString(), 0);
            Success = false;
        }
        return Success;
    }

    private class LogPrintStream
    extends PrintStream {
        public LogPrintStream(OutputStream out) {
            super(out);
        }
    }
}

