/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.gui.wizards;

import at.tugraz.genome.arraynormcore.analyze.CalcCoeffOfVariation;
import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormgui.gui.ArrayNormGUI;
import at.tugraz.genome.arraynormgui.gui.wizards.CalcCvGroupingPanel;
import at.tugraz.genome.arraynormgui.gui.wizards.CalcCvSetupPanel;
import at.tugraz.genome.math.MathFunctions;
import at.tugraz.genome.utils.EnhancedDialog;
import com.klg.jclass.swing.JCWizard;
import com.klg.jclass.swing.JCWizardEvent;
import com.klg.jclass.swing.JCWizardListener;
import com.klg.jclass.swing.JCWizardPage;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class CalcCvWizard
extends EnhancedDialog
implements JCWizardListener {
    CalcCvGroupingPanel an_groupspanel_;
    CalcCvSetupPanel an_setuppanel_;
    JCWizard anova_wiz_;
    static /* synthetic */ Class class$javax$swing$JDesktopPane;
    static /* synthetic */ Class class$javax$swing$JInternalFrame;
    public double cv_limit_ = 0.5;
    JCWizardEvent e_;
    ExperimentData experiment_;
    public int[] groups_assignment_;
    public int num_cv_calcs_;
    public int num_of_classes_;
    public int num_of_groups_;
    ArrayNormGUI parent_gui_;
    JCWizardPage setup_page_;
    JCWizardPage tab_page_;

    public CalcCvWizard(ArrayNormGUI parent, String title, boolean modal) {
        super(parent);
        this.parent_gui_ = parent;
        this.experiment_ = this.parent_gui_.the_experiment_;
        this.anova_wiz_ = new JCWizard();
        this.anova_wiz_.addWizardListener(this);
        this.anova_wiz_.setMinimumSize(new Dimension(550, 300));
        this.anova_wiz_.setPreferredSize(new Dimension(550, 300));
        this.num_of_classes_ = this.experiment_.num_expe_classes_;
        this.num_cv_calcs_ = this.experiment_.experiment_class_[0].merged_ratios_.length;
        this.setup_page_ = new JCWizardPage(26);
        this.setup_page_.setName("Setup Anova");
        this.setResizable(false);
        this.an_setuppanel_ = new CalcCvSetupPanel(this);
        this.setup_page_.getContentPane().add((Component)this.an_setuppanel_, "Center");
        this.anova_wiz_.add(this.setup_page_);
        this.tab_page_ = new JCWizardPage(28);
        this.tab_page_.setName("Define Groups");
        this.setResizable(false);
        this.anova_wiz_.add(this.tab_page_);
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void canceled(JCWizardEvent e) {
        this.closeWizard();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private void closeWizard() {
        Container c = SwingUtilities.getAncestorOfClass(class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = CalcCvWizard.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame, this);
        if (c == null) {
            JDesktopPane p = (JDesktopPane)SwingUtilities.getAncestorOfClass(class$javax$swing$JDesktopPane == null ? (class$javax$swing$JDesktopPane = CalcCvWizard.class$("javax.swing.JDesktopPane")) : class$javax$swing$JDesktopPane, this);
            if (p == null) {
                this.dispose();
            } else {
                try {
                    p.getAllFrames()[0].setClosed(true);
                }
                catch (PropertyVetoException j) {
                }
            }
        } else {
            JInternalFrame f = (JInternalFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JInternalFrame == null ? (class$javax$swing$JInternalFrame = CalcCvWizard.class$("javax.swing.JInternalFrame")) : class$javax$swing$JInternalFrame, this);
            try {
                f.setClosed(true);
            }
            catch (PropertyVetoException j) {
            }
        }
    }

    private void computeCvValues() {
        int group_size = 0;
        Vector anova_data_in = new Vector();
        float[][] cv_values = new float[this.num_of_groups_][this.num_cv_calcs_];
        int[][] cv_significance = new int[this.num_of_groups_][this.num_cv_calcs_];
        int[] reliable_cv_values = new int[this.num_of_groups_];
        int[] signific_cv_values = new int[this.num_of_groups_];
        float[] pcnt_sign_cv_values = new float[this.num_of_groups_];
        int i = 0;
        while (i < this.num_of_groups_) {
            int cnt = 0;
            int j = 0;
            while (j < this.num_of_classes_) {
                if (this.groups_assignment_[j] == i) {
                    ++cnt;
                }
                ++j;
            }
            group_size = cnt;
            float[][] group_data = new float[group_size][this.num_cv_calcs_];
            float[][] group_data_flip = new float[this.num_cv_calcs_][group_size];
            cnt = 0;
            int k = 0;
            while (k < this.num_of_classes_) {
                if (this.groups_assignment_[k] == i) {
                    group_data[cnt] = this.experiment_.experiment_class_[k].merged_ratios_;
                    ++cnt;
                }
                ++k;
            }
            int l = 0;
            while (l < this.num_cv_calcs_) {
                int j2 = 0;
                while (j2 < group_size) {
                    group_data_flip[l][j2] = group_data[j2][l];
                    ++j2;
                }
                ++l;
            }
            if (group_data_flip[0].length > 0) {
                cv_values[i] = CalcCoeffOfVariation.multipleCalcCV(group_data_flip);
            }
            reliable_cv_values[i] = MathFunctions.countReliableValues(cv_values[i]);
            signific_cv_values[i] = 0;
            int l2 = 0;
            while (l2 < this.num_cv_calcs_) {
                if (cv_values[i][l2] < 0.5f) {
                    cv_significance[i][l2] = 1;
                    int n = i;
                    signific_cv_values[n] = signific_cv_values[n] + 1;
                } else {
                    cv_significance[i][l2] = 0;
                }
                ++l2;
            }
            pcnt_sign_cv_values[i] = (float)signific_cv_values[i] / (float)reliable_cv_values[i] * 100.0f;
            System.out.println("how many reliable cvs::= " + reliable_cv_values[i]);
            System.out.println("how many signific cvs::= " + signific_cv_values[i]);
            System.out.println("percentage of signific vs. rel. cvs::= " + pcnt_sign_cv_values[i]);
            ++i;
        }
        this.experiment_.experiment_analyze_results_.setGroup_assignment_(this.groups_assignment_);
        this.experiment_.experiment_analyze_results_.setNum_testgroups_(this.num_of_groups_);
        this.experiment_.experiment_analyze_results_.setNum_classes_(this.num_of_classes_);
        this.experiment_.experiment_analyze_results_.setCoeff_var_(cv_values);
        this.experiment_.experiment_analyze_results_.setSignific_cv_(cv_significance);
        this.experiment_.experiment_analyze_results_.setPcnt_signif_cv_values_(pcnt_sign_cv_values);
        this.experiment_.experiment_analyze_results_.setReliable_cv_values_(reliable_cv_values);
        this.experiment_.experiment_analyze_results_.setSignific_cv_values_(signific_cv_values);
        this.experiment_.experiment_analyze_results_.setCv_available_(true);
        this.parent_gui_.showCvValuesPlot();
    }

    public void finished(JCWizardEvent e) {
        this.an_groupspanel_.updateWizard();
        e.setAllowChange(true);
        this.closeWizard();
        Thread thread = new Thread(){

            public void run() {
                CalcCvWizard.this.parent_gui_.setGUIStatusLine("Calculating coefficients of variation");
                CalcCvWizard.this.parent_gui_.setGUIProgressBarMin();
                CalcCvWizard.this.parent_gui_.setWaitingCursor();
                try {
                    CalcCvWizard.this.computeCvValues();
                    int i = 0;
                    while (i < 10000) {
                        ++i;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    CalcCvWizard.this.parent_gui_.setDefaultCursor();
                }
                CalcCvWizard.this.parent_gui_.setGUIStatusLine("Done.");
                CalcCvWizard.this.parent_gui_.setGUIProgressBarMax();
                CalcCvWizard.this.parent_gui_.setDefaultCursor();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                CalcCvWizard.this.parent_gui_.setGUIProgressBarMin();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void help(JCWizardEvent e) {
    }

    private void jbInit() throws Exception {
        this.getContentPane().add((Component)this.anova_wiz_, "Center");
        this.setTitle("Calculate Coefficient of Variation");
        this.pack();
        Dimension screen_size = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension bar_size = this.getSize();
        this.setLocation((screen_size.width - bar_size.width) / 2, (screen_size.height - bar_size.height) / 2);
        this.show();
    }

    public void nextBegin(JCWizardEvent e) {
        if (e.getCurrentPage().getName() == "Setup Anova") {
            this.an_setuppanel_.updateWizard();
            this.an_groupspanel_ = null;
            System.gc();
            this.tab_page_.getContentPane().removeAll();
            this.an_groupspanel_ = new CalcCvGroupingPanel(this);
            this.tab_page_.getContentPane().add((Component)this.an_groupspanel_, "Center");
            e.setAllowChange(true);
        }
        if (e.getCurrentPage().getName() == "Define Groups") {
            this.an_groupspanel_.updateWizard();
            e.setAllowChange(true);
        }
    }

    public void nextComplete(JCWizardEvent e) {
    }

    public void performEscapeAction(KeyEvent e) {
        this.closeWizard();
    }

    public void previousBegin(JCWizardEvent e) {
    }

    public void previousComplete(JCWizardEvent e) {
    }
}

