/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.plot;

import at.tugraz.genome.arraynormcore.microarrayobjects.ExperimentData;
import at.tugraz.genome.arraynormcore.microarrayobjects.MicroArrayData;
import at.tugraz.genome.arraynormcore.plot.AllSlidesBoxplot;
import at.tugraz.genome.arraynormcore.plot.ArrayViewer;
import at.tugraz.genome.arraynormcore.plot.ClasswiseMAPlot;
import at.tugraz.genome.arraynormcore.plot.CvValuesPlot;
import at.tugraz.genome.arraynormcore.plot.DiagnosticsPlot;
import at.tugraz.genome.arraynormcore.plot.FrequencyHistogram;
import at.tugraz.genome.arraynormcore.plot.OverUnderExpViewer;
import at.tugraz.genome.arraynormcore.plot.QQPlotSlide;
import at.tugraz.genome.arraynormcore.plot.SimpleMAPlot;
import at.tugraz.genome.arraynormcore.plot.SimpleScatterPlot;
import at.tugraz.genome.arraynormcore.plot.SubgridsBoxplot;
import at.tugraz.genome.arraynormcore.plot.TwoSlidesRegressionPlot;
import at.tugraz.genome.arraynormcore.plot.VisualDataModel;
import at.tugraz.genome.arraynormgui.gui.ArrayNormGUI;
import at.tugraz.genome.arraynormgui.plot.PlotBasisFrame;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PlottingManager {
    PlotBasisFrame basis_plot_frame_;
    String basis_title_;
    Vector default_plotter_params_ = new Vector();
    ExperimentData.ExpClass exp_class_;
    ExperimentData experiment;
    float[][] input_data_;
    int[][] input_grid_info_;
    MicroArrayData input_slide_;
    static final int loc_offset_ = 20;
    ArrayNormGUI parent_gui_;
    JPanel plot_panel_;
    PlotBasisFrame[] subplot_frame_;
    int which_plot_;

    public PlottingManager(ArrayNormGUI parent, String plot_title, float[] x_in, float[] y_in) {
        int x_loc;
        this.parent_gui_ = parent;
        this.basis_title_ = plot_title;
        this.basis_plot_frame_ = new PlotBasisFrame(this.parent_gui_, this.basis_title_);
        this.basis_plot_frame_.setVisible(true);
        this.parent_gui_.desktop_base_.add(this.basis_plot_frame_);
        this.parent_gui_.desktop_base_.getComponentCount();
        int y_loc = x_loc = 20 * this.parent_gui_.desktop_base_.getComponentCount();
        this.basis_plot_frame_.setLocation(x_loc, y_loc);
    }

    public PlottingManager(ArrayNormGUI parent, String plot_title, float[] x_in, float[] y_in, float[] y_out) {
        int x_loc;
        this.parent_gui_ = parent;
        this.basis_title_ = plot_title;
        this.basis_plot_frame_ = new PlotBasisFrame(this.parent_gui_, this.basis_title_);
        this.basis_plot_frame_.setVisible(true);
        this.parent_gui_.desktop_base_.add(this.basis_plot_frame_);
        this.parent_gui_.desktop_base_.getComponentCount();
        int y_loc = x_loc = 20 * this.parent_gui_.desktop_base_.getComponentCount();
        this.basis_plot_frame_.setLocation(x_loc, y_loc);
    }

    public PlottingManager(ArrayNormGUI parent, String plot_title, float[][] input_data, ExperimentData.ExpClass exp_cl, int which_plot) {
        int x_loc;
        this.parent_gui_ = parent;
        this.basis_title_ = which_plot == 110 || which_plot == 109 ? plot_title : plot_title + " (" + exp_cl.class_histo_.getNettoHistoryString() + ")";
        this.input_data_ = input_data;
        this.exp_class_ = exp_cl;
        this.which_plot_ = which_plot;
        this.basis_plot_frame_ = new PlotBasisFrame(this.parent_gui_, this.basis_title_);
        this.basis_plot_frame_.setVisible(true);
        this.parent_gui_.desktop_base_.add(this.basis_plot_frame_);
        this.parent_gui_.desktop_base_.getComponentCount();
        int y_loc = x_loc = 20 * this.parent_gui_.desktop_base_.getComponentCount();
        this.basis_plot_frame_.setLocation(x_loc, y_loc);
        this.makeThePlot();
    }

    public PlottingManager(ArrayNormGUI parent, String plot_title, MicroArrayData input_slide, int which_plot) {
        int x_loc;
        this.parent_gui_ = parent;
        this.basis_title_ = plot_title;
        this.input_slide_ = input_slide;
        this.which_plot_ = which_plot;
        this.basis_plot_frame_ = new PlotBasisFrame(this.parent_gui_, this.basis_title_);
        this.basis_plot_frame_.setVisible(true);
        this.parent_gui_.desktop_base_.add(this.basis_plot_frame_);
        this.parent_gui_.desktop_base_.getComponentCount();
        int y_loc = x_loc = 20 * this.parent_gui_.desktop_base_.getComponentCount();
        this.basis_plot_frame_.setLocation(x_loc, y_loc);
        this.makeThePlot();
    }

    public PlottingManager(ArrayNormGUI parent, ExperimentData exp, int which_plot) {
        boolean n_cl = false;
        int n_p = 0;
        int cnt = 0;
        this.which_plot_ = which_plot;
        this.parent_gui_ = parent;
        this.experiment = exp;
        if (this.which_plot_ == 111) {
            int x_loc;
            this.parent_gui_ = parent;
            this.basis_title_ = "";
            this.basis_plot_frame_ = new PlotBasisFrame(this.parent_gui_, this.basis_title_);
            this.basis_plot_frame_.setVisible(true);
            this.parent_gui_.desktop_base_.add(this.basis_plot_frame_);
            this.parent_gui_.desktop_base_.getComponentCount();
            int y_loc = x_loc = 20 * this.parent_gui_.desktop_base_.getComponentCount();
            this.basis_plot_frame_.setLocation(x_loc, y_loc);
            this.makeBoxplotAllSlides();
        } else if (which_plot == 112) {
            n_p = exp.num_expe_classes_;
            this.subplot_frame_ = new PlotBasisFrame[n_p];
            int i = 0;
            while (i < n_p) {
                this.subplot_frame_[i] = new PlotBasisFrame(this.parent_gui_, "");
                this.subplot_frame_[i].setResizable(true);
                this.subplot_frame_[i].setMaximizable(true);
                this.subplot_frame_[i].setPreferredSize(new Dimension(100, 100));
                ++i;
            }
            int xloc = 0;
            int yloc = 0;
            int i2 = 0;
            while (i2 < n_p) {
                this.parent_gui_.desktop_base_.add(this.subplot_frame_[i2]);
                this.subplot_frame_[i2].setLocation(xloc, yloc);
                xloc += 20;
                yloc += 20;
                ++i2;
            }
            int j = 0;
            while (j < exp.num_expe_classes_) {
                VisualDataModel newmod = new VisualDataModel(exp);
                ClasswiseMAPlot scpl = new ClasswiseMAPlot(newmod, j, exp.experiment_class_[j].class_name_);
                this.subplot_frame_[j].getContentPane().add(scpl);
                this.subplot_frame_[j].setTitle("MAplot Class " + exp.experiment_class_[j].class_name_);
                ++j;
            }
            try {
                this.subplot_frame_[0].setSelected(true);
            }
            catch (PropertyVetoException e) {
            }
        } else {
            int n_x;
            int n_y;
            n_p = exp.num_slides_;
            this.subplot_frame_ = new PlotBasisFrame[n_p];
            int i = 0;
            while (i < n_p) {
                this.subplot_frame_[i] = new PlotBasisFrame(this.parent_gui_, "");
                this.subplot_frame_[i].setResizable(true);
                this.subplot_frame_[i].setMaximizable(true);
                this.subplot_frame_[i].setPreferredSize(new Dimension(100, 100));
                ++i;
            }
            if (n_p > 1) {
                n_y = 2;
                n_x = n_p % 2 == 0 ? n_p / n_y : (n_p + 1) / n_y;
            } else {
                n_y = 1;
                n_x = n_p;
            }
            this.parent_gui_.desktop_base_.setLayout(new GridLayout(n_y, n_x, 5, 5));
            int i3 = 0;
            while (i3 < n_p) {
                this.parent_gui_.desktop_base_.add(this.subplot_frame_[i3]);
                ++i3;
            }
            this.input_data_ = new float[2][exp.num_spots_on_slide_];
            int j = 0;
            while (j < exp.num_expe_classes_) {
                VisualDataModel newmod;
                String sl_name;
                int i4 = 0;
                while (i4 < exp.experiment_class_[j].num_normal_slides_) {
                    sl_name = exp.experiment_class_[j].class_normal_slidenames_[i4];
                    this.input_data_[0] = exp.experiment_class_[j].expclass_normal_data_[i4][0];
                    this.input_data_[1] = exp.experiment_class_[j].expclass_normal_data_[i4][1];
                    switch (this.which_plot_) {
                        case 101: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SimpleScatterPlot scpl = new SimpleScatterPlot(newmod, "Scatterplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(scpl);
                            this.subplot_frame_[cnt].setTitle("Scatterplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 105: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SimpleMAPlot mapl = new SimpleMAPlot(newmod, "MAplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(mapl);
                            this.subplot_frame_[cnt].setTitle("MAplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 102: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SubgridsBoxplot sb_gboxpl = new SubgridsBoxplot(newmod, "Boxplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(sb_gboxpl);
                            this.subplot_frame_[cnt].setTitle("Boxplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 103: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            FrequencyHistogram histpl = new FrequencyHistogram(newmod, "Histogram:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(histpl);
                            this.subplot_frame_[cnt].setTitle("Histogram:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 108: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            QQPlotSlide qqplot = new QQPlotSlide(newmod, "QQplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(qqplot);
                            this.subplot_frame_[cnt].setTitle("QQplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                        }
                    }
                    this.parent_gui_.updateExperimentPlotsFolder(this.subplot_frame_[cnt], this.which_plot_);
                    ++cnt;
                    ++i4;
                }
                int i5 = 0;
                while (i5 < exp.experiment_class_[j].num_dysw_slides_) {
                    sl_name = exp.experiment_class_[j].class_dysw_slidenames_[i5];
                    this.input_data_[0] = exp.experiment_class_[j].expclass_dysw_data_[i5][0];
                    this.input_data_[1] = exp.experiment_class_[j].expclass_dysw_data_[i5][1];
                    switch (this.which_plot_) {
                        case 101: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SimpleScatterPlot scpl = new SimpleScatterPlot(newmod, "Scatterplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(scpl);
                            this.subplot_frame_[cnt].setTitle("Scatterplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 105: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SimpleMAPlot mapl = new SimpleMAPlot(newmod, "MAplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(mapl);
                            this.subplot_frame_[cnt].setTitle("MAplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 102: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            SubgridsBoxplot sb_gboxpl = new SubgridsBoxplot(newmod, "Boxplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(sb_gboxpl);
                            this.subplot_frame_[cnt].setTitle("Boxplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 103: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            FrequencyHistogram histpl = new FrequencyHistogram(newmod, "Histogram:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(histpl);
                            this.subplot_frame_[cnt].setTitle("Histogram:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                            break;
                        }
                        case 108: {
                            newmod = new VisualDataModel(this.input_data_, exp.experiment_class_[j]);
                            QQPlotSlide qqplot = new QQPlotSlide(newmod, "QQplot:: " + sl_name);
                            this.subplot_frame_[cnt].getContentPane().add(qqplot);
                            this.subplot_frame_[cnt].setTitle("QQplot:: " + sl_name + " (" + exp.experiment_class_[j].class_histo_.getNettoHistoryString() + ")");
                        }
                    }
                    this.parent_gui_.updateExperimentPlotsFolder(this.subplot_frame_[cnt], this.which_plot_);
                    ++cnt;
                    ++i5;
                }
                ++j;
            }
            try {
                this.subplot_frame_[0].setSelected(true);
            }
            catch (PropertyVetoException e) {
            }
        }
    }

    private void make2slidesRegressionPlot() {
        this.basis_title_ = "" + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        TwoSlidesRegressionPlot scpl = new TwoSlidesRegressionPlot(newmod, this.basis_title_);
        this.basis_plot_frame_.addPlot(scpl);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeArrayView() {
        JPanel help_panel = new JPanel();
        FlowLayout flow_layout_1 = new FlowLayout();
        help_panel.setLayout(flow_layout_1);
        this.basis_title_ = "ArrayView:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        JPanel av_panel = new JPanel();
        av_panel.setLayout(new GridLayout(1, 2, 5, 5));
        this.default_plotter_params_.add(this.input_slide_);
        int[] dummy_int = new int[]{500, 1, 1, 2};
        this.default_plotter_params_.add(dummy_int);
        ArrayViewer aview1_plot = new ArrayViewer(this.default_plotter_params_);
        this.default_plotter_params_.clear();
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.default_plotter_params_.add(this.input_slide_);
        dummy_int[0] = 502;
        dummy_int[1] = 1;
        dummy_int[2] = 1;
        dummy_int[3] = 2;
        this.default_plotter_params_.add(dummy_int);
        ArrayViewer aview2_plot = new ArrayViewer(this.default_plotter_params_);
        av_panel.add(aview1_plot);
        av_panel.add(aview2_plot);
        JScrollPane aview_scroller = new JScrollPane(av_panel);
        aview_scroller.setAutoscrolls(true);
        this.basis_plot_frame_.getContentPane().add((Component)aview_scroller, "Center");
        this.default_plotter_params_.clear();
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeBoxplot() {
        this.basis_title_ = "Boxplot:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        SubgridsBoxplot sb_gboxpl = new SubgridsBoxplot(newmod, this.basis_title_);
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.basis_plot_frame_.addPlot(sb_gboxpl);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeBoxplotAllSlides() {
        this.basis_title_ = "Boxplot:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        VisualDataModel newmod = new VisualDataModel(this.experiment);
        AllSlidesBoxplot sb_gboxpl = new AllSlidesBoxplot(newmod, "");
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.basis_plot_frame_.addPlot(sb_gboxpl);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeChannelIntensPlot() {
        JPanel dp_panel = new JPanel();
        dp_panel.setLayout(new GridLayout(2, 1, 5, 5));
        this.basis_title_ = "Channel Intensities:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        DiagnosticsPlot scplr = new DiagnosticsPlot(newmod, this.basis_title_, "red");
        DiagnosticsPlot scplg = new DiagnosticsPlot(newmod, this.basis_title_, "green");
        dp_panel.add(scplr);
        dp_panel.add(scplg);
        this.basis_plot_frame_.getContentPane().add((Component)dp_panel, "Center");
        this.default_plotter_params_.clear();
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void makeCvValuesPlot() {
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        CvValuesPlot asdf = new CvValuesPlot(newmod, this.basis_title_);
        this.basis_plot_frame_.getContentPane().add(asdf);
        this.basis_title_ = "CV-Plot " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void makeHistogram() {
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        FrequencyHistogram histpl = new FrequencyHistogram(newmod, this.basis_title_);
        this.basis_title_ = "Histogram:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.basis_plot_frame_.addPlot(histpl);
        try {
            this.basis_plot_frame_.setSelected(true);
            this.basis_plot_frame_.setMaximum(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeMAplot() {
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        SimpleMAPlot mapl = new SimpleMAPlot(newmod, this.basis_title_);
        this.basis_title_ = "MA-Plot:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.basis_plot_frame_.addPlot(mapl);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeOverUnderExpView() {
        JPanel help_panel = new JPanel();
        FlowLayout flow_layout_1 = new FlowLayout();
        help_panel.setLayout(flow_layout_1);
        this.basis_title_ = "Digital Expressions:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        JPanel av_panel = new JPanel();
        this.default_plotter_params_.add(this.input_slide_);
        int[] dummy_int = new int[]{500, 1, 1, 2};
        this.default_plotter_params_.add(dummy_int);
        OverUnderExpViewer ouview_plot = new OverUnderExpViewer(this.default_plotter_params_);
        av_panel.add(ouview_plot);
        JScrollPane aview_scroller = new JScrollPane(av_panel);
        aview_scroller.setAutoscrolls(true);
        this.basis_plot_frame_.getContentPane().add((Component)aview_scroller, "Center");
        this.default_plotter_params_.clear();
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeQQPlot() {
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        QQPlotSlide qqplot = new QQPlotSlide(newmod, this.basis_title_);
        this.basis_title_ = "QQ-Plot:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        this.basis_plot_frame_.addPlot(qqplot);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeScatterplot() {
        this.basis_title_ = "Scatterplot:: " + this.basis_title_;
        this.basis_plot_frame_.setTitle(this.basis_title_);
        VisualDataModel newmod = new VisualDataModel(this.input_data_, this.exp_class_);
        SimpleScatterPlot scpl = new SimpleScatterPlot(newmod, this.basis_title_);
        this.basis_plot_frame_.addPlot(scpl);
        try {
            this.basis_plot_frame_.setSelected(true);
        }
        catch (PropertyVetoException e) {
        }
    }

    private void makeThePlot() {
        switch (this.which_plot_) {
            case 100: {
                this.makeArrayView();
                break;
            }
            case 107: {
                this.makeOverUnderExpView();
                break;
            }
            case 101: {
                this.makeScatterplot();
                break;
            }
            case 105: {
                this.makeMAplot();
                break;
            }
            case 102: {
                this.makeBoxplot();
                break;
            }
            case 103: {
                this.makeHistogram();
                break;
            }
            case 108: {
                this.makeQQPlot();
                break;
            }
            case 106: {
                this.makeChannelIntensPlot();
                break;
            }
            case 109: {
                this.make2slidesRegressionPlot();
                break;
            }
            case 110: {
                this.makeCvValuesPlot();
                break;
            }
        }
        this.parent_gui_.updateExperimentPlotsFolder(this.basis_plot_frame_, this.which_plot_);
    }
}

