/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.arraynormgui.xml;

import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class GenerateXML {
    Document doc;
    Vector vData;

    public GenerateXML() {
        this.loadData();
    }

    public void generate() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.doc = db.newDocument();
        }
        catch (Exception e) {
            System.out.println("Error " + e);
        }
        Element main = this.doc.createElement("Personnel");
        main.appendChild(this.doc.createTextNode("\n"));
        String name = "";
        String age = "";
        String sex = "";
        int i = 0;
        while (i < this.vData.size()) {
            String data = (String)this.vData.elementAt(i);
            StringTokenizer st = new StringTokenizer(data, "$");
            name = st.nextToken();
            age = st.nextToken();
            sex = st.nextToken();
            Element root = this.doc.createElement("Employee");
            root.appendChild(this.doc.createTextNode("\n"));
            Element item = this.doc.createElement("Name");
            item.appendChild(this.doc.createTextNode(name));
            root.appendChild(item);
            root.appendChild(this.doc.createTextNode("\n"));
            item = this.doc.createElement("Age");
            item.appendChild(this.doc.createTextNode(age));
            root.appendChild(item);
            root.appendChild(this.doc.createTextNode("\n"));
            item = this.doc.createElement("Sex");
            item.appendChild(this.doc.createTextNode(sex));
            root.appendChild(item);
            root.appendChild(this.doc.createTextNode("\n"));
            main.appendChild(root);
            main.appendChild(this.doc.createTextNode("\n"));
            ++i;
        }
        this.doc.appendChild(main);
    }

    private void loadData() {
        this.vData = new Vector();
        this.vData.addElement("John$35$M");
        this.vData.addElement("Jessie$30$F");
        this.vData.addElement("Jonathan$28$M");
        this.vData.addElement("Laila$20$F");
        this.vData.add("Roli$27$M");
    }

    public static void main(String[] args) {
        GenerateXML gxml = new GenerateXML();
        gxml.generate();
        gxml.print();
    }

    public void print() {
        this.walk(this.doc);
    }

    private void walk(Node node) {
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                System.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                break;
            }
            case 1: {
                System.out.print('<' + node.getNodeName());
                NamedNodeMap nnm = node.getAttributes();
                if (nnm != null) {
                    int len = nnm.getLength();
                    int i = 0;
                    while (i < len) {
                        Attr attr = (Attr)nnm.item(i);
                        System.out.print(' ' + attr.getNodeName() + "=\"" + attr.getNodeValue() + '\"');
                        ++i;
                    }
                }
                System.out.print('>');
                break;
            }
            case 5: {
                System.out.print('&' + node.getNodeName() + ';');
                break;
            }
            case 4: {
                System.out.print("<![CDATA[" + node.getNodeValue() + "]]>");
                break;
            }
            case 3: {
                System.out.print(node.getNodeValue());
                break;
            }
            case 7: {
                System.out.print("<?" + node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    System.out.print(' ');
                    System.out.print(data);
                }
                System.out.println("?>");
                break;
            }
        }
        Node child = node.getFirstChild();
        while (child != null) {
            this.walk(child);
            child = child.getNextSibling();
        }
        if (type == 1) {
            System.out.print("</" + node.getNodeName() + ">");
        }
    }
}

