/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsclient;

import at.tugraz.genome.marsclient.AboutDialog;
import at.tugraz.genome.marsclient.AccountDialog;
import at.tugraz.genome.marsclient.DatabaseTable;
import at.tugraz.genome.marsclient.DatabaseTableListing;
import at.tugraz.genome.marsclient.MarsConnectionListener;
import at.tugraz.genome.marsclient.MyTreeCellRenderer;
import at.tugraz.genome.marsclient.ServerConnection;
import at.tugraz.genome.marsclient.ServerConnectionDialog;
import at.tugraz.genome.marsclient.TreeNodeContent;
import at.tugraz.genome.marsclient.UploadFileChooser;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.FileUploadDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.RawbioassayDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO;
import at.tugraz.genome.util.FileUtils;
import at.tugraz.genome.util.swing.MessageDialog;
import at.tugraz.genome.util.swing.WaitingDialog;
import at.tugraz.genome.util.swing.WaitingPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Explorer
extends JDialog
implements ActionListener {
    public static final int MARS_EXPERIMENT = 10;
    public static final int MARS_EXPERIMENTCLASS = 30;
    public static final int MARS_EXPERIMENTCLASSRAWBIOASSAY = 40;
    public static final int MARS_EXPERIMENTCLASSRAWBIOASSAY_DYESWAPPED = 41;
    public static final int MARS_ROOT = 1;
    public static final int MARS_ROOT_DISABLED = 2;
    public static final int MARS_SUBEXPERIMENT = 20;
    static /* synthetic */ Class class$at$tugraz$genome$marsclient$Explorer;
    private JButton connectButton;
    private JLabel connectionLabel;
    private DefaultMutableTreeNode currentNode = null;
    private JButton disconnectButton;
    private JPanel emptyPanel;
    private Color highlightColor;
    private String homeDirectory;
    private JButton loadDatasetButton;
    private Log log;
    private int mode = 0;
    private Frame parentFrame;
    private JPanel progressPanel;
    private DefaultMutableTreeNode root = null;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private Color shadowColor = new Color(172, 168, 153);
    private JSplitPane splitPane;
    private Border standardBorder;
    private Border standardInverseBorder;
    private JLabel statusLabel;
    private JTree tree;
    private DefaultTreeModel treeModel;
    private WaitingPanel waitingPanel;

    public Explorer(JFrame parentFrame, String homeDirectory) {
        super(parentFrame);
        this.highlightColor = Color.white;
        this.log = LogFactory.getLog(this.getClass());
        this.log.info("Initializing MARS Explorer");
        this.parentFrame = parentFrame;
        ServerConnection.getInstance().setHomeDirectory(homeDirectory);
        ServerConnection.getInstance().setParentFrame(parentFrame);
        ServerConnection.getInstance().setParent(this);
        this.setTitle("MARS Database Explorer");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(800, 600);
        this.setLocation((int)(screenSize.getWidth() - 800.0) / 2, (int)(screenSize.getHeight() - 600.0) / 2);
        this.createMenu();
        String marsClientHomePath = System.getProperty("user.dir");
        String marsClientUserHomePath = System.getProperty("user.home") + System.getProperty("file.separator") + ".mars";
        File dummyFile = new File(marsClientHomePath + "/mars.properties.template");
        while (!dummyFile.exists()) {
            marsClientHomePath = marsClientHomePath.substring(0, Math.max(marsClientHomePath.lastIndexOf("/"), marsClientHomePath.lastIndexOf("\\")));
            dummyFile = new File(marsClientHomePath + "/mars.properties.template");
        }
        if (!FileUtils.exists(marsClientUserHomePath)) {
            this.log.info("Creating directory " + marsClientUserHomePath);
            if (!FileUtils.createDirectory(marsClientUserHomePath)) {
                this.log.error("Could not create mandatory directory " + marsClientUserHomePath);
                System.exit(-1);
            }
            this.log.info("Hiding directory " + marsClientUserHomePath);
            if (!FileUtils.makeHidden(marsClientUserHomePath)) {
                this.log.error("Could not hide directory " + marsClientUserHomePath);
            }
        }
        if (!FileUtils.exists(marsClientUserHomePath + "/mars.properties")) {
            this.log.info("Copy " + marsClientHomePath + "/mars.properties.template" + " to " + marsClientUserHomePath + "/mars.properties");
            FileUtils.copyFile(marsClientHomePath + "/mars.properties.template", marsClientUserHomePath + "/mars.properties");
        }
        this.log.info("MarsClient home: " + marsClientHomePath);
        this.log.info("MarsClient user home: " + marsClientUserHomePath);
        ServerConnection.getInstance().setHomeDirectory(marsClientHomePath);
        ServerConnection.getInstance().setUserHomeDirectory(marsClientUserHomePath);
        ServerConnection.getInstance().readServerPropertiesFile();
        this.standardBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.highlightColor), BorderFactory.createMatteBorder(0, 0, 1, 1, this.shadowColor));
        this.standardInverseBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.shadowColor), BorderFactory.createMatteBorder(0, 0, 1, 1, this.highlightColor));
        this.createMenu();
        this.createToolBar();
        this.statusLabel = new JLabel("Ready");
        this.statusLabel.setFont(new Font("Dialog", 0, 11));
        this.statusLabel.setForeground(Color.black);
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BorderLayout());
        statusPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 2, 2, 0), new CompoundBorder(new MatteBorder(1, 1, 0, 0, this.shadowColor), new MatteBorder(0, 0, 1, 1, Color.white))));
        statusPanel.add((Component)this.statusLabel, "West");
        this.connectionLabel = new JLabel(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Connection16.gif")));
        this.connectionLabel.setDisabledIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/ConnectionDisabled16.gif")));
        this.connectionLabel.setEnabled(false);
        this.connectionLabel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 3, 2, 0), new CompoundBorder(new MatteBorder(1, 1, 0, 0, this.shadowColor), new MatteBorder(0, 0, 1, 1, Color.white))));
        this.waitingPanel = new WaitingPanel(0, 0);
        this.progressPanel = new JPanel();
        this.progressPanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), new CompoundBorder(new MatteBorder(1, 1, 0, 0, this.shadowColor), new MatteBorder(0, 0, 1, 1, Color.white))));
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add((Component)this.waitingPanel, "Center");
        JToolBar statusBar = new JToolBar();
        JPanel statusPanel2 = new JPanel();
        statusPanel2.setLayout(new BorderLayout());
        statusPanel2.add((Component)this.connectionLabel, "Center");
        statusPanel2.add((Component)this.progressPanel, "East");
        statusBar.setBorder(this.standardBorder);
        statusBar.setLayout(new BorderLayout());
        statusBar.add((Component)statusPanel, "Center");
        statusBar.add((Component)statusPanel2, "East");
        this.getContentPane().add((Component)statusBar, "South");
        JPanel treeTopPanel = new JPanel();
        treeTopPanel.setBorder(this.standardBorder);
        treeTopPanel.setPreferredSize(new Dimension(1, 20));
        this.root = new DefaultMutableTreeNode(new TreeNodeContent("MARS", 2, null));
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new MyTreeCellRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)Explorer.this.tree.getLastSelectedPathComponent();
                Explorer.this.onTreeEvent(node);
            }
        });
        if (UIManager.getLookAndFeel().toString().compareTo("[The CDE/Motif Look and Feel - com.sun.java.swing.plaf.motif.MotifLookAndFeel]") != 0) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)this.tree.getUI();
            basicTreeUI.setCollapsedIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/TreeCollapsedIcon.gif")));
            basicTreeUI.setExpandedIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/TreeExpandedIcon.gif")));
        }
        this.tree.setEditable(false);
        this.tree.addMouseListener(new MyTreeListener());
        this.scrollPane1 = new JScrollPane(this.tree);
        this.scrollPane1.setBorder(this.standardBorder);
        this.emptyPanel = new JPanel();
        this.emptyPanel.setLayout(new BorderLayout());
        this.emptyPanel.setBackground(Color.white);
        JPanel emptyTopPanel = new JPanel();
        emptyTopPanel.setBorder(new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 0, 0, this.highlightColor), BorderFactory.createMatteBorder(0, 0, 1, 0, this.shadowColor)));
        emptyTopPanel.setPreferredSize(new Dimension(1, 20));
        this.emptyPanel.add((Component)emptyTopPanel, "North");
        this.scrollPane2 = new JScrollPane(this.emptyPanel);
        this.scrollPane2.getViewport().setBackground(Color.white);
        this.scrollPane2.setBorder(new CompoundBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 0, 3, 3), this.standardInverseBorder), BorderFactory.createMatteBorder(0, 0, 1, 1, this.shadowColor)));
        JPanel treePanel = new JPanel();
        treePanel.setBorder(new CompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 0), this.standardInverseBorder));
        treePanel.setLayout(new BorderLayout());
        treePanel.add((Component)treeTopPanel, "North");
        treePanel.add((Component)this.scrollPane1, "Center");
        this.splitPane = new JSplitPane(1, treePanel, this.scrollPane2);
        this.splitPane.setDividerLocation(200);
        this.splitPane.setBorder(this.standardBorder);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(8);
        this.getContentPane().add((Component)this.splitPane, "Center");
    }

    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source.getText() == "Server connection...") {
            ServerConnectionDialog serverConnectionDialog = new ServerConnectionDialog(this.parentFrame);
        }
        if (source.getText() == "Account properties...") {
            AccountDialog accountDialog = new AccountDialog(this.parentFrame);
        }
        if (source.getText() == "About MARS Explorer...") {
            AboutDialog aboutDialog = new AboutDialog(this.parentFrame);
        }
    }

    public void addFile(DataHandler dataHandler, FileUploadDTO dto) {
        if (dataHandler == null || dto == null) {
            UploadFileChooser fc = new UploadFileChooser(this.getFileUploadTypes());
            fc.setVisible(true);
            if (fc.getReturnOption() == 1) {
                File file = fc.getSelectedFile();
                dataHandler = new DataHandler(new FileDataSource(file));
                try {
                    dto = new FileUploadDTO(ServerConnection.getInstance().getUserName(), file.getName(), "", "FALSE", fc.getUploadType(), new Long(file.length()));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
            } else {
                return;
            }
        }
        final DataHandler threadDataHandler = dataHandler;
        final FileUploadDTO threadDTO = dto;
        final WaitingDialog waitingDialog = new WaitingDialog(this.parentFrame, "Submitting file ...");
        Thread thread = new Thread(){

            public void run() {
                ServerConnection.getInstance().addFile(threadDataHandler, threadDTO);
                waitingDialog.stop();
                waitingDialog.dispose();
                ((MarsConnectionListener)((Object)Explorer.this.parentFrame)).onMarsDataExportDone();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void addTransformedRawdataset(DataHandler dataHandler, final String applicationName, final String applicationVersion, final String methodLog, final String description, final Vector rawbioassayids, final Long experimentclassid) {
        if (dataHandler == null) {
            JFileChooser fc = new JFileChooser();
            fc.setPreferredSize(new Dimension(600, 500));
            int returnVal = fc.showOpenDialog(this);
            if (returnVal == 0) {
                File file = fc.getSelectedFile();
                dataHandler = new DataHandler(new FileDataSource(file));
            } else {
                return;
            }
        }
        final DataHandler threadDataHandler = dataHandler;
        final WaitingDialog waitingDialog = new WaitingDialog(this.parentFrame, "Submitting data ...");
        Thread thread = new Thread(){

            public void run() {
                ServerConnection.getInstance().addTransformedRawdataset(threadDataHandler, applicationName, applicationVersion, methodLog, description, rawbioassayids, experimentclassid);
                waitingDialog.stop();
                waitingDialog.dispose();
                ((MarsConnectionListener)((Object)Explorer.this.parentFrame)).onMarsDataExportDone();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public void connect() {
        ServerConnection.getInstance().connect();
        if (ServerConnection.getInstance().isConnected()) {
            this.connectionLabel.setEnabled(true);
            this.connectButton.setEnabled(false);
            this.disconnectButton.setEnabled(true);
            this.root.setUserObject(new TreeNodeContent("MARS", 1, null));
            this.treeModel.nodeChanged(this.root);
            this.getAllExperiments();
        }
    }

    public void createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Server");
        menu.getAccessibleContext().setAccessibleDescription("Server propperties");
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("Account properties...");
        menuItem.getAccessibleContext().setAccessibleDescription("Account properties");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem("Server connection...");
        menuItem.getAccessibleContext().setAccessibleDescription("Server connection properties");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new JMenu("Help");
        menu.getAccessibleContext().setAccessibleDescription("Server propperties");
        menuItem = new JMenuItem("About MARS Explorer...");
        menuItem.getAccessibleContext().setAccessibleDescription("About MARS database explorer");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        this.setJMenuBar(menuBar);
    }

    public void createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setMargin(new Insets(-2, -2, -2, -2));
        MatteBorder toolBarBorder1 = new MatteBorder(1, 1, 0, 0, Color.white);
        MatteBorder toolBarBorder2 = new MatteBorder(0, 0, 1, 0, new Color(172, 168, 153));
        CompoundBorder toolBarBorder = new CompoundBorder(new CompoundBorder(toolBarBorder1, toolBarBorder2), toolBar.getBorder());
        toolBar.setBorder(toolBarBorder);
        CompoundBorder buttonBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.highlightColor), BorderFactory.createMatteBorder(0, 0, 0, 1, this.shadowColor)), BorderFactory.createEmptyBorder(2, 4, 2, 2));
        this.connectButton = new JButton(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Connect24.gif")));
        this.connectButton.setDisabledIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Connect24-Disabled.gif")));
        this.connectButton.setToolTipText("Connect to database");
        this.connectButton.setFocusPainted(false);
        this.connectButton.setBorder(buttonBorder);
        this.connectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Explorer.this.connect();
            }
        });
        toolBar.add(this.connectButton);
        this.disconnectButton = new JButton(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Disconnect24.gif")));
        this.disconnectButton.setDisabledIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Disconnect24-Disabled.gif")));
        this.disconnectButton.setToolTipText("Disconnect from database");
        this.disconnectButton.setFocusPainted(false);
        this.disconnectButton.setBorder(buttonBorder);
        this.disconnectButton.setEnabled(false);
        this.disconnectButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Explorer.this.disconnect();
            }
        });
        toolBar.add(this.disconnectButton);
        this.loadDatasetButton = new JButton(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/LoadDataset24.gif")));
        this.loadDatasetButton.setDisabledIcon(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/LoadDataset24-gray.gif")));
        this.loadDatasetButton.setToolTipText("Load dataset from database");
        this.loadDatasetButton.setFocusPainted(false);
        this.loadDatasetButton.setBorder(buttonBorder);
        this.loadDatasetButton.setEnabled(false);
        this.loadDatasetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Explorer.this.getSubexperimentData();
            }
        });
        toolBar.add(this.loadDatasetButton);
        buttonBorder = BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.highlightColor), BorderFactory.createMatteBorder(0, 0, 0, 1, this.shadowColor)), BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JButton refreshButton = new JButton(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Refresh24.gif")));
        refreshButton.setToolTipText("Refresh tree");
        refreshButton.setFocusPainted(false);
        refreshButton.setBorder(buttonBorder);
        refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Explorer.this.refresh();
            }
        });
        toolBar.add(refreshButton);
        JButton aboutButton = new JButton(new ImageIcon((class$at$tugraz$genome$marsclient$Explorer == null ? (class$at$tugraz$genome$marsclient$Explorer = Explorer.class$("at.tugraz.genome.marsclient.Explorer")) : class$at$tugraz$genome$marsclient$Explorer).getResource("/at/tugraz/genome/marsclient/images/Information24.gif")));
        aboutButton.setToolTipText("About MARS explorer");
        aboutButton.setFocusPainted(false);
        aboutButton.setBorder(buttonBorder);
        aboutButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutDialog = new AboutDialog(Explorer.this.parentFrame);
            }
        });
        toolBar.add(aboutButton);
        this.getContentPane().add((Component)toolBar, "North");
    }

    public void disconnect() {
        ServerConnection.getInstance().disconnect();
        if (!ServerConnection.getInstance().isConnected()) {
            this.connectionLabel.setEnabled(false);
            this.connectButton.setEnabled(true);
            this.disconnectButton.setEnabled(false);
            this.root.removeAllChildren();
            this.root.setUserObject(new TreeNodeContent("MARS", 2, null));
            this.treeModel.nodeChanged(this.root);
        }
    }

    public void getAllExperimentClassRawbioassays(DefaultMutableTreeNode node, Long experimentClassId) {
        Vector experimentClassRawbioassays = ServerConnection.getInstance().getAllExperimentClassRawbioassays(experimentClassId);
        DefaultMutableTreeNode dummyNode = null;
        int i = 0;
        while (i < experimentClassRawbioassays.size()) {
            ExperimentClassRawbioassayDTO experimentClassRawbioassayDTO = (ExperimentClassRawbioassayDTO)experimentClassRawbioassays.get(i);
            this.log.debug("Adding experimentClassRawbioassayDTO: " + experimentClassRawbioassayDTO);
            dummyNode = new DefaultMutableTreeNode(new TreeNodeContent("[" + experimentClassRawbioassayDTO.getPairsindex().toString() + "] " + experimentClassRawbioassayDTO.getRawbioassayDTO().getName(), 40, experimentClassRawbioassayDTO.getRawbioassayDTO()));
            this.treeModel.insertNodeInto(dummyNode, node, node.getChildCount());
            ++i;
        }
    }

    public void getAllExperimentClasses(final DefaultMutableTreeNode node, final Long subexperimentId) {
        Thread thread = new Thread(){

            public void run() {
                Explorer.this.startWaiting();
                Vector experimentClasses = ServerConnection.getInstance().getAllExperimentClasses(subexperimentId);
                DefaultMutableTreeNode dummyNode = null;
                int i = 0;
                while (i < experimentClasses.size()) {
                    ExperimentClassDTO experimentClassDTO = (ExperimentClassDTO)experimentClasses.get(i);
                    Explorer.this.log.debug("Adding experimentClassDTO: " + experimentClassDTO);
                    dummyNode = new DefaultMutableTreeNode(new TreeNodeContent(experimentClassDTO.getName(), 30, experimentClassDTO));
                    Explorer.this.treeModel.insertNodeInto(dummyNode, node, node.getChildCount());
                    Explorer.this.getAllExperimentClassRawbioassays(dummyNode, experimentClassDTO.getId());
                    ++i;
                }
                if (dummyNode != null) {
                    Explorer.this.tree.scrollPathToVisible(new TreePath(dummyNode.getPath()));
                }
                Explorer.this.stopWaiting();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void getAllExperiments() {
        Thread thread = new Thread(){

            public void run() {
                Explorer.this.startWaiting();
                Vector experiments = ServerConnection.getInstance().getAllExperiments();
                Explorer.this.root.removeAllChildren();
                int i = 0;
                while (i < experiments.size()) {
                    ExperimentDTO experimentDTO = (ExperimentDTO)experiments.get(i);
                    Explorer.this.log.debug("Adding experimentDTO: " + experimentDTO);
                    DefaultMutableTreeNode dummyNode = new DefaultMutableTreeNode(new TreeNodeContent(experimentDTO.getName(), 10, experimentDTO));
                    Explorer.this.treeModel.insertNodeInto(dummyNode, Explorer.this.root, Explorer.this.root.getChildCount());
                    ++i;
                }
                Explorer.this.treeModel.reload();
                ((TreeNodeContent)Explorer.this.root.getUserObject()).setContent(experiments);
                Explorer.this.stopWaiting();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void getAllSubexperiments(final DefaultMutableTreeNode node, final Long experimentId) {
        Thread thread = new Thread(){

            public void run() {
                Explorer.this.startWaiting();
                Vector subexperiments = ServerConnection.getInstance().getAllSubexperiments(experimentId);
                DefaultMutableTreeNode dummyNode = null;
                int i = 0;
                while (i < subexperiments.size()) {
                    SubexperimentDTO subexperimentDTO = (SubexperimentDTO)subexperiments.get(i);
                    Explorer.this.log.debug("Adding subexperimentDTO: " + subexperimentDTO);
                    dummyNode = new DefaultMutableTreeNode(new TreeNodeContent(subexperimentDTO.getName(), 20, subexperimentDTO));
                    Explorer.this.treeModel.insertNodeInto(dummyNode, node, node.getChildCount());
                    ++i;
                }
                if (dummyNode != null) {
                    Explorer.this.tree.scrollPathToVisible(new TreePath(dummyNode.getPath()));
                }
                Explorer.this.stopWaiting();
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public Vector getFileUploadTypes() {
        return ServerConnection.getInstance().getFileUploadTypes();
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }

    public void getSubexperimentData() {
        Thread thread = new Thread(){

            public void run() {
                Explorer.this.startWaiting();
                Object attachment = null;
                int i = 0;
                while (i < Explorer.this.currentNode.getChildCount()) {
                    DefaultMutableTreeNode dummyNode = (DefaultMutableTreeNode)Explorer.this.currentNode.getChildAt(i);
                    TreeNodeContent subexperimentClassContent = (TreeNodeContent)dummyNode.getUserObject();
                    int j = 0;
                    while (j < dummyNode.getChildCount()) {
                        TreeNodeContent treeNodeContent = (TreeNodeContent)((DefaultMutableTreeNode)dummyNode.getChildAt(j)).getUserObject();
                        Explorer.this.statusLabel.setText("Loading dataset \"" + ((RawbioassayDTO)treeNodeContent.getContent()).getName() + "\" of Class \"" + ((ExperimentClassDTO)subexperimentClassContent.getContent()).getName() + "\" ...");
                        ServerConnection.getInstance().getAvailableSpotRawdataFields(((RawbioassayDTO)treeNodeContent.getContent()).getId());
                        attachment = ServerConnection.getInstance().getSpotRawdata(((RawbioassayDTO)treeNodeContent.getContent()).getId(), ((ExperimentClassDTO)subexperimentClassContent.getContent()).getId(), null, new Vector(), "Mean (FG) - Mean (BG)");
                        treeNodeContent.setAttachment(attachment);
                        ++j;
                    }
                    ++i;
                }
                Explorer.this.stopWaiting();
                if (attachment != null) {
                    ((MarsConnectionListener)((Object)Explorer.this.parentFrame)).onMarsDataImportDone(Explorer.this.currentNode);
                } else {
                    MessageDialog MyMessageDialog = new MessageDialog(Explorer.this.parentFrame, "Could not fetch dataset from MARS!\nResult = null", "Error", "MARS Query problem", 10);
                }
            }
        };
        thread.setPriority(1);
        thread.start();
    }

    public void onTreeEvent(DefaultMutableTreeNode node) {
        this.loadDatasetButton.setEnabled(false);
        if (node == null) {
            return;
        }
        this.currentNode = node;
        TreeNodeContent treeNodeContent = (TreeNodeContent)node.getUserObject();
        switch (treeNodeContent.getType()) {
            case 1: {
                this.mode = 1;
                if (node.getChildCount() == 0) {
                    this.getAllExperiments();
                }
                this.log.info("Displaying mars root");
                if (((Vector)treeNodeContent.getContent()).size() == 0) {
                    MessageDialog messageDialog = new MessageDialog(this.parentFrame, "Dataset is empty!", "MARS", 0);
                    return;
                }
                this.setPanel(new DatabaseTable((Vector)treeNodeContent.getContent()));
                break;
            }
            case 10: {
                this.mode = 10;
                this.log.info("Displaying experiment information");
                if (node.getChildCount() == 0) {
                    this.getAllSubexperiments(node, ((ExperimentDTO)treeNodeContent.getContent()).getId());
                }
                this.setPanel(new DatabaseTableListing(treeNodeContent.getContent()));
                break;
            }
            case 20: {
                this.mode = 10;
                this.loadDatasetButton.setEnabled(true);
                this.log.info("Displaying experiment information");
                if (node.getChildCount() == 0) {
                    this.getAllExperimentClasses(node, ((SubexperimentDTO)treeNodeContent.getContent()).getId());
                }
                this.setPanel(new DatabaseTableListing(treeNodeContent.getContent()));
                break;
            }
            case 30: {
                this.mode = 30;
                this.log.info("Displaying experiment class information");
                this.setPanel(new DatabaseTableListing(treeNodeContent.getContent()));
                break;
            }
            case 40: {
                this.mode = 40;
                this.log.info("Displaying experiment class rawbioassay information");
                this.setPanel(new DatabaseTableListing(treeNodeContent.getContent()));
                break;
            }
        }
    }

    public void refresh() {
        this.root.removeAllChildren();
        this.treeModel.reload();
        this.setPanel(this.emptyPanel);
    }

    public void setPanel(Component component) {
        this.scrollPane2.setViewportView(component);
    }

    public void startWaiting() {
        this.waitingPanel.start();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.statusLabel.setText("Retrieving data from database");
    }

    public void stopWaiting() {
        this.statusLabel.setText("");
        this.waitingPanel.stop();
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    private class MyTreeListener
    extends MouseInputAdapter {
        private MyTreeListener() {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() || SwingUtilities.isRightMouseButton(e)) {
                int x = e.getX();
                int y = e.getY();
                TreePath path = Explorer.this.tree.getPathForLocation(x, y);
                if (path != null) {
                    Explorer.this.tree.setSelectionPath(path);
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)Explorer.this.tree.getLastSelectedPathComponent();
                    TreeNodeContent treeNodeContent = (TreeNodeContent)selectedNode.getUserObject();
                }
            }
        }
    }
}

