/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsclient;

import at.tugraz.genome.marsclient.Explorer;
import at.tugraz.genome.marsejb.clientconnector.axis.ser.DTODeserializerFactory;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.FileUploadDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO;
import at.tugraz.genome.util.swing.LoginDialog;
import at.tugraz.genome.util.swing.MessageDialog;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServerConnection {
    private String authenticationID;
    private Vector availableSpotRawdataFields;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO;
    static /* synthetic */ Class class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO;
    static /* synthetic */ Class class$javax$activation$DataSource;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanDeserializerFactory;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$BeanSerializerFactory;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory;
    static /* synthetic */ Class class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory;
    private String homeDirectory = null;
    private String initialContextFactory;
    private String initialServerLoginName;
    private String initialServerPassword;
    private boolean isConnected = false;
    private Log log = LogFactory.getLog(this.getClass());
    private Explorer parent;
    private JFrame parentFrame;
    private boolean saveServerLoginName = false;
    private boolean saveServerPassword = true;
    private static ServerConnection serverConnection;
    private int serverConnectionTimeout = 1000;
    private String serverLoginName;
    private String serverPassword;
    private String serverURL;
    private int serverUpdateInterval = 1000;
    private boolean showMessageAgain_CannotFindJob = true;
    private boolean showMessageAgain_ServerConnectionRefused = true;
    private boolean showMessageAgain_ServerMessage = true;
    private String userHomeDirectory = null;

    private ServerConnection() {
        this.log.info("Initializing MARS server connection");
    }

    public void addFile(DataHandler dataHandler, FileUploadDTO dto) {
        this.log.info("Adding file " + dataHandler.getName());
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(dataHandler);
        params.add(dto);
        this.submitAddFileViaSOAP("urn:ClientConnector", "addFile", params);
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    public void addTransformedRawdataset(DataHandler dataHandler, String applicationName, String applicationVersion, String methodLog, String description, Vector rawbioassayids, Long experimentclassid) {
        this.log.info("Adding transformed raw data set " + dataHandler.getName());
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(dataHandler);
        params.add(applicationName);
        params.add(applicationVersion);
        params.add(methodLog);
        params.add(description);
        params.add(rawbioassayids);
        params.add(experimentclassid);
        this.submitTransformedRawdatasetViaSOAP("urn:ClientConnector", "addTransformedRawdataset", params);
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public boolean connect() {
        this.log.info("Connecting to database on " + this.serverURL + " ...");
        long startTime = System.currentTimeMillis();
        try {
            int counter;
            if (!this.isServerAlive()) {
                MessageDialog messageDialog = new MessageDialog((Frame)this.parentFrame, "Could not establish connection\nto server!", "Error", "Host not found", 10);
                return false;
            }
            for (counter = 0; counter < 3; ++counter) {
                this.authenticationID = this.login(this.serverLoginName, this.serverPassword);
                if (this.authenticationID != null) break;
                LoginDialog loginDialog = new LoginDialog((Frame)this.parentFrame, "Login", this.serverLoginName, this.serverPassword);
                if (loginDialog.isOk()) {
                    this.serverLoginName = loginDialog.getLoginName();
                    this.serverPassword = loginDialog.getPassword();
                    continue;
                }
                this.isConnected = false;
                this.log.error("Connecting failed (canceled by user)!");
                return false;
            }
            if (counter == 3) {
                MessageDialog messageDialog = new MessageDialog((Frame)this.parentFrame, "Login to server " + this.serverURL + " failed!", "Error", 10);
                this.isConnected = false;
                this.log.error("Connecting failed (three times wrong username or password)!");
                return false;
            }
            this.log.debug("Connected in " + (System.currentTimeMillis() - startTime) + " ms");
            this.isConnected = true;
            return true;
        }
        catch (SecurityException ex) {
            MessageDialog messageDialog = new MessageDialog((Frame)this.parentFrame, "Wrong username or password!", "Error", 10);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MessageDialog messageDialog = new MessageDialog((Frame)this.parentFrame, "Could not establish connection!", "Error", 10);
        }
        this.log.error("Connecting failed!");
        this.isConnected = false;
        return false;
    }

    public void disconnect() {
        this.authenticationID = null;
        this.isConnected = false;
        this.serverLoginName = this.initialServerLoginName;
        this.serverPassword = this.initialServerPassword;
    }

    public Vector getAllExperimentClassRawbioassays(Long experimentClassId) {
        this.log.info("Getting all experiment class rawbioassays of experiment class " + experimentClassId);
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(experimentClassId);
        Vector result = (Vector)this.getBySOAP("urn:ClientConnector", "getAllExperimentClassRawbioassays", params);
        this.log.debug(result.size() + " experiment classe rawbioassays retrieved");
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ExperimentClassRawbioassayDTO experimentClassRawbioassayDTO = (ExperimentClassRawbioassayDTO)iterator.next();
            this.log.debug("ExperimentClassRawbioassayDTO: " + experimentClassRawbioassayDTO);
        }
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    public Vector getAllExperimentClasses(Long subExperimentId) {
        this.log.info("Getting all experiment classes of subexperiment " + subExperimentId);
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(subExperimentId);
        Vector result = (Vector)this.getBySOAP("urn:ClientConnector", "getAllExperimentClasses", params);
        this.log.debug(result.size() + " experiment classes retrieved");
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ExperimentClassDTO experimentClassDTO = (ExperimentClassDTO)iterator.next();
            this.log.debug("ExperimentClassDTO: " + experimentClassDTO);
        }
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    public Vector getAllExperiments() {
        this.log.info("Getting all experiments");
        long startTime = System.currentTimeMillis();
        Vector<String> params = new Vector<String>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        Vector result = (Vector)this.getBySOAP("urn:ClientConnector", "getAllExperiments", params);
        Iterator myTest2It = result.iterator();
        while (myTest2It.hasNext()) {
            ExperimentDTO expDTO = (ExperimentDTO)myTest2It.next();
            this.log.debug("ExperimentDTO: " + expDTO);
            this.log.debug("Submitter: : " + expDTO.getSubmitterDTO().getUsername());
        }
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    public Vector getAllSubexperiments(Long experimentId) {
        this.log.info("Getting all sub experiments of experiment " + experimentId);
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(experimentId);
        Vector result = (Vector)this.getBySOAP("urn:ClientConnector", "getAllSubExperiments", params);
        this.log.debug(result.size() + " SubexperimentDTOs retrieved");
        Iterator myTest2It = result.iterator();
        while (myTest2It.hasNext()) {
            SubexperimentDTO subexperimentDTO = (SubexperimentDTO)myTest2It.next();
            this.log.debug("SubexperimentDTO: " + subexperimentDTO);
        }
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    public Vector getAvailableSpotRawdataFields() {
        return this.availableSpotRawdataFields;
    }

    public Vector getAvailableSpotRawdataFields(Long rawBioassayID) {
        this.log.info("Getting available spot raw data fields for " + rawBioassayID);
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(rawBioassayID);
        this.availableSpotRawdataFields = (Vector)this.getBySOAP("urn:ClientConnector", "getAvailableSpotRawdataFields", params);
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return this.availableSpotRawdataFields;
    }

    public Object getBySOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        try {
            this.initHttps();
            Service service = new Service();
            Call call = (Call)service.createCall();
            if (targetObjectURI.compareTo("urn:ClientConnector") == 0) {
                call.setTargetEndpointAddress(new URL(this.serverURL + "/services/ClientConnector"));
                call.setOperationName(new QName("ClientConnector", methodName));
                QName expqn = new QName("urn:ExperimentDTO", "ExperimentDTO");
                QName submitterqn = new QName("urn:SubmitterDTO", "SubmitterDTO");
                QName experimentAnnotationqn = new QName("urn:ExperimentannotationDTO", "ExperimentannotationDTO");
                QName rawbioassayqn = new QName("urn:RawbioassayDTO", "RawbioassayDTO");
                QName experimentClassqn = new QName("urn:ExperimentClassDTO", "ExperimentClassDTO");
                QName subExperimentqn = new QName("urn:SubexperimentDTO", "SubexperimentDTO");
                QName experimentClassRawbioassayqn = new QName("urn:ExperimentClassRawbioassayDTO", "ExperimentClassRawbioassayDTO");
                QName labeledExtractqn = new QName("urn:LabeledextractDTO", "LabeledextractDTO");
                QName databaseFieldQueue = new QName("urn:DatabaseField", "DatabaseField");
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO, expqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO, expqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentDTO, expqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubmitterDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO, submitterqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubmitterDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO, submitterqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubmitterDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubmitterDTO, submitterqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentannotationDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO, experimentAnnotationqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentannotationDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO, experimentAnnotationqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentannotationDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentannotationDTO, experimentAnnotationqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO, subExperimentqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO, subExperimentqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$SubexperimentDTO, subExperimentqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO, experimentClassqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO, experimentClassqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassDTO, experimentClassqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.RawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO, rawbioassayqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.RawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO, rawbioassayqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.RawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$RawbioassayDTO, rawbioassayqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO, experimentClassRawbioassayqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO, experimentClassRawbioassayqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$ExperimentClassRawbioassayDTO, experimentClassRawbioassayqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.LabeledextractDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO, labeledExtractqn, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.LabeledextractDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO, labeledExtractqn), new DTODeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.LabeledextractDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$LabeledextractDTO, labeledExtractqn));
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue), new BeanDeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue));
                call.setTimeout(new Integer(this.serverConnectionTimeout));
            }
            result = call.invoke(parameters.toArray());
        }
        catch (Exception e) {
            this.parent.stopWaiting();
            MessageDialog MyMessageDialog = new MessageDialog((Frame)this.parentFrame, "Login to server " + this.serverURL + " failed!", "Error", 10);
            e.printStackTrace();
        }
        return result;
    }

    public Object getBySOAPAttachment(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        try {
            this.initHttps();
            Service service = new Service();
            Call call = (Call)service.createCall();
            if (targetObjectURI.compareTo("urn:ClientConnector") == 0) {
                call.setTargetEndpointAddress(new URL(this.serverURL + "/services/ClientConnector"));
                call.setOperationName(new QName("ClientConnector", methodName));
                call.addParameter("username", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("authenticationid", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("rawbioassayid", XMLType.XSD_LONG, ParameterMode.IN);
                call.addParameter("subexperimentid", XMLType.XSD_LONG, ParameterMode.IN);
                call.addParameter("selectedDatabaseFields", XMLType.SOAP_VECTOR, ParameterMode.IN);
                call.addParameter("searchCriteria", XMLType.SOAP_VECTOR, ParameterMode.IN);
                call.addParameter("rawbioassaycalculationmethod", XMLType.XSD_STRING, ParameterMode.IN);
                call.setProperty("attachment_encapsulation_format", "axis.attachment.style.dime");
                QName databaseFieldQueue = new QName("urn:DatabaseField", "DatabaseField");
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue, new BeanSerializerFactory(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue), new BeanDeserializerFactory(class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField == null ? (class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.dbaccess.DatabaseField")) : class$at$tugraz$genome$marsejb$clientconnector$dbaccess$DatabaseField, databaseFieldQueue));
                QName qnameAttachment = new QName("urn:ClientConnector", "DataHandler");
                call.registerTypeMapping(class$javax$activation$DataSource == null ? (class$javax$activation$DataSource = ServerConnection.class$("javax.activation.DataSource")) : class$javax$activation$DataSource, qnameAttachment, class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory, class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory);
                call.setReturnType(qnameAttachment);
                call.setReturnType(qnameAttachment);
                call.setTimeout(new Integer(this.serverConnectionTimeout));
            }
            result = call.invoke(parameters.toArray());
        }
        catch (Exception e) {
            this.parent.stopWaiting();
            MessageDialog MyMessageDialog = new MessageDialog((Frame)this.parentFrame, "A connection problem occured!\n\n" + e.getMessage(), "Error", 10);
            e.printStackTrace();
        }
        return result;
    }

    public Vector getFileUploadTypes() {
        this.log.info("getFileUploadTypes ");
        long startTime = System.currentTimeMillis();
        Vector<String> params = new Vector<String>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        Vector fileUploadTypeStrings = (Vector)this.getBySOAP("urn:ClientConnector", "getFileUploadTypes", params);
        this.log.debug(fileUploadTypeStrings.size() + " FileUploadTypeVO retrieved");
        return fileUploadTypeStrings;
    }

    public static ServerConnection getInstance() {
        if (serverConnection == null) {
            serverConnection = new ServerConnection();
        }
        return serverConnection;
    }

    public ExperimentClassRawbioassayDTO getRawbioassayDetailed(Long rawbioassayId) {
        this.log.info("getRawbioassayDetailed rawbioassayId " + rawbioassayId);
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(rawbioassayId);
        ExperimentClassRawbioassayDTO result = (ExperimentClassRawbioassayDTO)this.getBySOAP("urn:ClientConnector", "getRawbioassayDetailed", params);
        this.log.debug("Done");
        return result;
    }

    public boolean getSaveServerLoginName() {
        return this.saveServerLoginName;
    }

    public boolean getSaveServerPassword() {
        return this.saveServerPassword;
    }

    public int getServerConnectionTimeout() {
        return this.serverConnectionTimeout;
    }

    public String getServerLoginName() {
        return this.serverLoginName;
    }

    public String getServerPassword() {
        return this.serverPassword;
    }

    public Properties getServerProperties() {
        Properties MyProperties = new Properties();
        MyProperties.put("java.naming.factory.initial", this.initialContextFactory);
        System.setProperty("java.naming.factory.initial", this.initialContextFactory);
        MyProperties.put("java.naming.provider.url", this.serverURL);
        System.setProperty("java.naming.provider.url", this.serverURL);
        MyProperties.put("java.naming.security.principal", this.serverLoginName);
        System.setProperty("java.naming.security.principal", this.serverLoginName);
        MyProperties.put("java.naming.security.credentials", this.serverPassword);
        System.setProperty("java.naming.security.credentials", this.serverPassword);
        return MyProperties;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public int getServerUpdateInterval() {
        return this.serverUpdateInterval;
    }

    public Object getSpotRawdata(Long rawbioassayID, Long subExperimentClassID, Vector selectedDatabaseFields, Vector searchCriteria, String rawDataCalculationMethod) {
        this.log.info("Getting rawbioassay " + rawbioassayID + " of subexperiment " + subExperimentClassID);
        long startTime = System.currentTimeMillis();
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(rawbioassayID);
        params.add(subExperimentClassID);
        if (selectedDatabaseFields != null) {
            params.add(selectedDatabaseFields);
        } else {
            params.add(this.availableSpotRawdataFields);
        }
        params.add(searchCriteria);
        params.add(rawDataCalculationMethod);
        Object result = this.getBySOAPAttachment("urn:ClientConnector", "getSpotRawdata", params);
        this.log.debug("Done in " + (System.currentTimeMillis() - startTime) + " ms");
        return result;
    }

    public Object getSpotRawdataDataHandler(Long rawBioassayId, Long subExperimentClassID, String rawDataCalculationMethod) {
        this.log.info("getSpotRawdataDataHandler rawbioassay " + rawBioassayId + " of subexperiment " + subExperimentClassID);
        Vector<Object> params = new Vector<Object>();
        params.add(this.serverLoginName);
        params.add(this.authenticationID);
        params.add(rawBioassayId);
        params.add(subExperimentClassID);
        params.add(subExperimentClassID);
        params.add(rawDataCalculationMethod);
        Object result = this.getBySOAPAttachment("urn:ClientConnector", "getSpotRawdataDataHandler", params);
        this.log.debug("Done");
        return result;
    }

    public String getUserHomeDirectory() {
        return this.userHomeDirectory;
    }

    public String getUserName() {
        return this.serverLoginName;
    }

    public void initHttps() {
        if (this.serverURL.startsWith("https")) {
            String truststorePath = null;
            String truststore = "mars-marsplay.clientTrust";
            URL truststoreUrl = this.getClass().getResource("../../../../Certificate/" + truststore);
            truststorePath = truststoreUrl != null ? truststoreUrl.getFile() : truststore;
            System.setProperty("javax.net.ssl.trustStore", truststorePath);
            System.setProperty("javax.net.ssl.keyStorePassword", "truststore.pwd!");
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isServerAlive() {
        this.log.info("Checking server ...");
        long startTime = System.currentTimeMillis();
        Boolean result = (Boolean)this.getBySOAP("urn:ClientConnector", "isAlive", new Vector());
        this.log.info("Server is alive: " + result + " (response time = " + (System.currentTimeMillis() - startTime) + " ms)");
        return result != null;
    }

    public String login(String userName, String password) {
        this.log.info("login");
        Vector<String> params = new Vector<String>();
        params.addElement(userName);
        params.addElement(password);
        return (String)this.getBySOAP("urn:ClientConnector", "login", params);
    }

    public void readServerPropertiesFile() {
        try {
            BufferedReader in = new BufferedReader(new FileReader(this.userHomeDirectory + "/mars.properties"));
            this.initialServerLoginName = this.serverLoginName = in.readLine();
            this.saveServerLoginName = this.serverLoginName.length() > 0;
            this.initialServerPassword = this.serverPassword = in.readLine();
            this.saveServerPassword = this.serverPassword.length() > 0;
            this.serverURL = in.readLine();
            this.initialContextFactory = in.readLine();
            this.serverUpdateInterval = Integer.parseInt(in.readLine());
            System.setProperty("java.naming.factory.initial", this.initialContextFactory);
            System.setProperty("java.naming.provider.url", this.serverURL);
            System.setProperty("java.naming.security.principal", this.serverLoginName);
            System.setProperty("java.naming.security.credentials", this.serverPassword);
            this.serverConnectionTimeout = Integer.parseInt(in.readLine());
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog MyMessageDialog = new MessageDialog((Frame)this.parentFrame, "Could not read server properies!", "Error", "mars.properties", 10);
        }
    }

    public void setAvailableSpotRawdataFields(Vector availableSpotRawdataFields) {
        this.availableSpotRawdataFields = availableSpotRawdataFields;
    }

    public void setHomeDirectory(String path) {
        this.homeDirectory = path;
    }

    public void setParent(Explorer parent) {
        this.parent = parent;
    }

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void setSaveServerLoginName(boolean saveServerLoginName) {
        this.saveServerLoginName = saveServerLoginName;
    }

    public void setSaveServerPassword(boolean saveServerPassword) {
        this.saveServerPassword = saveServerPassword;
    }

    public void setServerConnectionTimeout(int serverConnectionTimeout) {
        this.serverConnectionTimeout = serverConnectionTimeout;
    }

    public void setServerLoginName(String serverLoginName) {
        this.serverLoginName = serverLoginName;
    }

    public void setServerPassword(String serverPassword) {
        this.serverPassword = serverPassword;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public void setServerUpdateInterval(int serverUpdateInterval) {
        this.serverUpdateInterval = serverUpdateInterval;
    }

    public void setUserHomeDirectory(String userHomeDirectory) {
        this.userHomeDirectory = userHomeDirectory;
    }

    private Object submitAddFileViaSOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        try {
            this.initHttps();
            Service service = new Service();
            Call call = (Call)service.createCall();
            if (targetObjectURI.compareTo("urn:ClientConnector") == 0) {
                call.setTargetEndpointAddress(new URL(this.serverURL + "/services/ClientConnector"));
                call.setOperationName(new QName("ClientConnector", methodName));
                call.addParameter("username", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("authenticationID", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("dataHandler", XMLType.XSD_BASE64, ParameterMode.IN);
                QName qname = new QName("urn:FileUploadDTO", "FileUploadDTO");
                call.addParameter(new QName("", "in0"), qname, class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.FileUploadDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO, ParameterMode.IN);
                call.registerTypeMapping(class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO == null ? (class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO = ServerConnection.class$("at.tugraz.genome.marsejb.clientconnector.vo.FileUploadDTO")) : class$at$tugraz$genome$marsejb$clientconnector$vo$FileUploadDTO, qname, class$org$apache$axis$encoding$ser$BeanSerializerFactory == null ? (class$org$apache$axis$encoding$ser$BeanSerializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.BeanSerializerFactory")) : class$org$apache$axis$encoding$ser$BeanSerializerFactory, class$org$apache$axis$encoding$ser$BeanDeserializerFactory == null ? (class$org$apache$axis$encoding$ser$BeanDeserializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.BeanDeserializerFactory")) : class$org$apache$axis$encoding$ser$BeanDeserializerFactory);
                call.setProperty("attachment_encapsulation_format", "axis.attachment.style.dime");
                QName qnameAttachment = new QName("urn:ClientConnector", "DataHandler");
                call.registerTypeMapping(class$javax$activation$DataSource == null ? (class$javax$activation$DataSource = ServerConnection.class$("javax.activation.DataSource")) : class$javax$activation$DataSource, qnameAttachment, class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory, class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory);
                call.setReturnType(XMLType.AXIS_VOID);
                call.setTimeout(new Integer(this.serverConnectionTimeout));
            }
            result = call.invoke(parameters.toArray());
        }
        catch (Exception e) {
            this.parent.stopWaiting();
            MessageDialog MyMessageDialog = new MessageDialog((Frame)this.parentFrame, "A connection problem occured!\n\n" + e.getMessage(), "Error", 10);
            e.printStackTrace();
        }
        return result;
    }

    private Object submitTransformedRawdatasetViaSOAP(String targetObjectURI, String methodName, Vector parameters) {
        Object result = null;
        try {
            this.initHttps();
            Service service = new Service();
            Call call = (Call)service.createCall();
            if (targetObjectURI.compareTo("urn:ClientConnector") == 0) {
                call.setTargetEndpointAddress(new URL(this.serverURL + "/services/ClientConnector"));
                call.setOperationName(new QName("ClientConnector", methodName));
                call.addParameter("username", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("authenticationID", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("dataHandler", XMLType.XSD_BASE64, ParameterMode.IN);
                call.addParameter("appname", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("appversion", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("methodlog", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("description", XMLType.XSD_STRING, ParameterMode.IN);
                call.addParameter("rawbioassayids", XMLType.SOAP_VECTOR, ParameterMode.IN);
                call.addParameter("experimentclassid", XMLType.XSD_LONG, ParameterMode.IN);
                call.setProperty("attachment_encapsulation_format", "axis.attachment.style.dime");
                QName qnameAttachment = new QName("urn:ClientConnector", "DataHandler");
                call.registerTypeMapping(class$javax$activation$DataSource == null ? (class$javax$activation$DataSource = ServerConnection.class$("javax.activation.DataSource")) : class$javax$activation$DataSource, qnameAttachment, class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerSerializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerSerializerFactory, class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory == null ? (class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory = ServerConnection.class$("org.apache.axis.encoding.ser.JAFDataHandlerDeserializerFactory")) : class$org$apache$axis$encoding$ser$JAFDataHandlerDeserializerFactory);
                call.setReturnType(XMLType.AXIS_VOID);
                call.setTimeout(new Integer(this.serverConnectionTimeout));
            }
            result = call.invoke(parameters.toArray());
        }
        catch (Exception e) {
            this.parent.stopWaiting();
            MessageDialog MyMessageDialog = new MessageDialog((Frame)this.parentFrame, "A connection problem occured!\n\n" + e.getMessage(), "Error", 10);
            e.printStackTrace();
        }
        return result;
    }

    public void writeServerPropertiesFile() {
        try {
            PrintWriter out = new PrintWriter(new FileWriter(this.userHomeDirectory + "/mars.properties", false));
            if (this.saveServerLoginName) {
                out.println(this.serverLoginName);
            } else {
                out.println("");
            }
            if (this.saveServerPassword) {
                out.println(this.serverPassword);
            } else {
                out.println("");
            }
            out.println(this.serverURL);
            out.println(this.initialContextFactory);
            out.println("" + this.serverUpdateInterval);
            out.println("" + this.serverConnectionTimeout);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this.parentFrame, "Can not write file mars.properties", ex.getMessage(), 0);
        }
    }
}

