/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.clientconnector;

import at.tugraz.genome.dbutilities.EJBExceptionFactory;
import at.tugraz.genome.dbutilities.exception.EJBCreateException;
import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.dbutilities.exception.ForeignKeyException;
import at.tugraz.genome.dbutilities.exception.UniqueException;
import at.tugraz.genome.marsejb.GlobalConstants;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.FileUploadDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.SubexperimentDTO;
import at.tugraz.genome.marsejb.exception.FileUploadException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.experiment.ExperimentSB;
import at.tugraz.genome.marsejb.experiment.ExperimentSBHome;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassRawbioassayVO;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassVO;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentVO;
import at.tugraz.genome.marsejb.experiment.vo.SubexperimentVO;
import at.tugraz.genome.marsejb.rawbioassaydata.ImageAcquisitionSB;
import at.tugraz.genome.marsejb.rawbioassaydata.ImageAcquisitionSBHome;
import at.tugraz.genome.marsejb.rawbioassaydata.vo.SoftwareVO;
import at.tugraz.genome.marsejb.transformation.TransformationSB;
import at.tugraz.genome.marsejb.transformation.TransformationSBHome;
import at.tugraz.genome.marsejb.transformation.vo.TRawbioassayVO;
import at.tugraz.genome.marsejb.utils.FilesSB;
import at.tugraz.genome.marsejb.utils.FilesSBHome;
import at.tugraz.genome.marsejb.utils.vo.FileUploadTypeVO;
import at.tugraz.genome.marsejb.utils.vo.FileUploadVO;
import at.tugraz.genome.usermanagement.server.authentication.AuthenticationToken;
import at.tugraz.genome.usermanagement.server.user.VO.ExtendedUserVO;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnection;
import at.tugraz.genome.usermanagement.serverconnection.ServerConnectionManager;
import at.tugraz.genome.usermanagement.serverconnection.exception.UserSecurityException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.ejb.CreateException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.log4j.Logger;

public class ClientConnectorSBBean
implements SessionBean {
    SessionContext sessionContext;
    private ServerConnection serverConnection_ = null;
    private Logger log_ = Logger.getLogger(this.getClass());

    public void ejbCreate() throws CreateException {
        this.log_.info("ejbCreate");
    }

    public void ejbRemove() {
        this.log_.info("ejbRemove");
    }

    public void ejbActivate() {
        this.log_.info("ejbActivate");
    }

    public void ejbPassivate() {
        this.log_.info("ejbPassivate");
    }

    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    public Vector getAllExperiments(String userName, String authenticationID) throws EJBServerException, EJBFinderException {
        ServerConnection serverConnection = this.getServerConnection();
        Long userID = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
            userID = serverConnection.getUserVO(userName, authenticationID, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45").getID();
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        this.log_.info("getAllExperiments(Long userID): " + userID);
        Vector<ExperimentDTO> experimentDTOs = new Vector<ExperimentDTO>();
        try {
            InitialContext ctx = new InitialContext();
            ExperimentSBHome experimentSBHome = (ExperimentSBHome)ctx.lookup("java:comp/env/ExperimentSB");
            ExperimentSB experimentSB = experimentSBHome.create();
            Collection returnCollection = experimentSB.getAllExperiments(userID, 1);
            boolean i = false;
            this.log_.info("creating DTO");
            Iterator it = returnCollection.iterator();
            while (it.hasNext()) {
                ExperimentVO experimentVO = (ExperimentVO)it.next();
                ExperimentDTO experimentDTO = experimentVO.createExperimentDTO();
                experimentDTOs.add(experimentDTO);
            }
            this.log_.info("creating DTO ended");
            return experimentDTOs;
        }
        catch (RemoteException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
        }
        return null;
    }

    public boolean isAlive() {
        return true;
    }

    public Vector getAllSubExperiments(String userName, String authenticationID, Long experimentID) throws EJBServerException, EJBFinderException {
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        this.log_.info("getAllSubExperiments(Long experimentID): " + experimentID);
        Vector<SubexperimentDTO> subExperimentDTOs = new Vector<SubexperimentDTO>();
        try {
            InitialContext ctx = new InitialContext();
            ExperimentSBHome experimentSBHome = (ExperimentSBHome)ctx.lookup("java:comp/env/ExperimentSB");
            ExperimentSB experimentSB = experimentSBHome.create();
            Collection returnCollection = experimentSB.getAllSubExperiments(experimentID, 1);
            boolean i = false;
            this.log_.info("creating DTO");
            Iterator it = returnCollection.iterator();
            while (it.hasNext()) {
                SubexperimentVO subExperimentVO = (SubexperimentVO)it.next();
                SubexperimentDTO subExperimentDTO = subExperimentVO.createSubExperimentDTO();
                subExperimentDTOs.add(subExperimentDTO);
            }
            this.log_.info("creating DTO ended");
            return subExperimentDTOs;
        }
        catch (RemoteException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
        }
        return null;
    }

    public Vector getAllExperimentClasses(String userName, String authenticationID, Long subExperimentID) throws EJBServerException, EJBFinderException {
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        this.log_.info("getAllExperimentClasses(Long subExperimentID): " + subExperimentID);
        Vector<ExperimentClassDTO> experimentClassesDTOs = new Vector<ExperimentClassDTO>();
        try {
            InitialContext ctx = new InitialContext();
            ExperimentSBHome experimentSBHome = (ExperimentSBHome)ctx.lookup("java:comp/env/ExperimentSB");
            ExperimentSB experimentSB = experimentSBHome.create();
            Collection returnCollection = experimentSB.getAllExpClasses(subExperimentID, 9);
            boolean i = false;
            this.log_.info("creating DTO");
            Iterator it = returnCollection.iterator();
            while (it.hasNext()) {
                ExperimentClassVO experimentClassesVO = (ExperimentClassVO)it.next();
                ExperimentClassDTO experimentClassDTO = experimentClassesVO.createExperimentClassDTO();
                experimentClassesDTOs.add(experimentClassDTO);
            }
            this.log_.info("creating DTO ended");
            return experimentClassesDTOs;
        }
        catch (RemoteException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
        }
        return null;
    }

    public Vector getAllExperimentClassRawbioassays(String userName, String authenticationID, Long experimentClassID) throws EJBServerException, EJBFinderException {
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        this.log_.info("getAllExperimentClassRawbioassays(Long experimentClassID): " + experimentClassID);
        Vector<ExperimentClassRawbioassayDTO> experimentClassRawbioassayDTOs = new Vector<ExperimentClassRawbioassayDTO>();
        try {
            InitialContext ctx = new InitialContext();
            ExperimentSBHome experimentSBHome = (ExperimentSBHome)ctx.lookup("java:comp/env/ExperimentSB");
            ExperimentSB experimentSB = experimentSBHome.create();
            Collection returnCollection = experimentSB.getAllExperimentClassRawbioassays(experimentClassID);
            boolean i = false;
            this.log_.info("creating DTO");
            Iterator it = returnCollection.iterator();
            while (it.hasNext()) {
                ExperimentClassRawbioassayVO experimentClassRawbioassayVO = (ExperimentClassRawbioassayVO)it.next();
                ExperimentClassRawbioassayDTO experimentClassRawbioassayDTO = experimentClassRawbioassayVO.createExperimentClassRawbioassayDTO();
                experimentClassRawbioassayDTOs.add(experimentClassRawbioassayDTO);
            }
            this.log_.info("creating DTO ended");
            return experimentClassRawbioassayDTOs;
        }
        catch (RemoteException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
        }
        return null;
    }

    public DataHandler getSpotRawdataDataHandler(String userName, String authenticationID, Long rawBioassayID, Long subExperimentClassID, String[] channelKey, String rawDataCalculationMethod) throws EJBServerException {
        int i;
        int i2;
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex2) {
            ex2.printStackTrace();
            return null;
        }
        long rawbioassayid = rawBioassayID;
        long arraytypeid = 0L;
        int numChannels = channelKey.length;
        DataHandler fileDataHandler = null;
        StringBuffer subSelect = new StringBuffer();
        subSelect.append("(SELECT ");
        subSelect.append("commonrawbioassaydata.element, commonrawbioassaydata.x, commonrawbioassaydata.y, molecule.genbankaccnumber, molecule.genename, ");
        if ("Mean (FG) - Mean (BG)".equals(rawDataCalculationMethod)) {
            i2 = 1;
            while (i2 <= numChannels) {
                subSelect.append("Ch" + i2 + ".fmean as " + channelKey[i2 - 1].replace(' ', '_') + "_fdata");
                if (i2 < numChannels) {
                    subSelect.append(", ");
                } else {
                    subSelect.append(", ");
                }
                ++i2;
            }
            i = 1;
            while (i <= numChannels) {
                subSelect.append("Ch" + i + ".bmean as " + channelKey[i - 1].replace(' ', '_') + "_bdata");
                if (i < numChannels) {
                    subSelect.append(", ");
                } else {
                    subSelect.append(" ");
                }
                ++i;
            }
        } else {
            i2 = 1;
            while (i2 <= numChannels) {
                subSelect.append("Ch" + i2 + ".fmedian as " + channelKey[i2 - 1].replace(' ', '_') + "_fdata");
                if (i2 < numChannels) {
                    subSelect.append(", ");
                } else {
                    subSelect.append(", ");
                }
                ++i2;
            }
            i = 1;
            while (i <= numChannels) {
                subSelect.append("Ch" + i + ".bmedian as " + channelKey[i - 1].replace(' ', '_') + "_bdata");
                if (i < numChannels) {
                    subSelect.append(", ");
                } else {
                    subSelect.append(" ");
                }
                ++i;
            }
        }
        subSelect.append("FROM ");
        subSelect.append("commonrawbioassaydata, molecule, ");
        i2 = 1;
        while (i2 <= numChannels) {
            subSelect.append("rawbioassaydata Ch" + i2);
            if (i2 < numChannels) {
                subSelect.append(", ");
            } else {
                subSelect.append(" ");
            }
            ++i2;
        }
        subSelect.append("WHERE ");
        i = 1;
        while (i <= numChannels) {
            subSelect.append("(Ch" + i + ".commonrawbioassaydataid = commonrawbioassaydata.id)");
            subSelect.append(" AND ");
            subSelect.append("(Ch" + i + ".channelkey = '" + channelKey[i - 1] + "')");
            if (i < numChannels) {
                subSelect.append(" AND ");
            } else {
                subSelect.append(" ");
            }
            ++i;
        }
        subSelect.append(" AND ");
        subSelect.append("(commonrawbioassaydata.molecule = molecule.id)");
        subSelect.append(" AND ");
        subSelect.append("(commonrawbioassaydata.rawbioassayid = '" + rawbioassayid + "')) RAWDATA ");
        this.log_.info("subSelect: " + subSelect);
        StringBuffer sqlStatement = new StringBuffer();
        sqlStatement.append("SELECT ");
        sqlStatement.append("arrayblock.blocknum, element.x, element.y, RAWDATA.x, RAWDATA.y, RAWDATA.genbankaccnumber, RAWDATA.genename, ");
        int i3 = 1;
        while (i3 <= numChannels) {
            sqlStatement.append(channelKey[i3 - 1].replace(' ', '_') + "_fdata");
            if (i3 < numChannels) {
                sqlStatement.append(", ");
            } else {
                sqlStatement.append(", ");
            }
            ++i3;
        }
        int i4 = 1;
        while (i4 <= numChannels) {
            sqlStatement.append(channelKey[i4 - 1].replace(' ', '_') + "_bdata");
            if (i4 < numChannels) {
                sqlStatement.append(", ");
            } else {
                sqlStatement.append(" ");
            }
            ++i4;
        }
        sqlStatement.append("FROM ");
        sqlStatement.append("element, arrayblock, ");
        sqlStatement.append(subSelect);
        sqlStatement.append("WHERE ");
        sqlStatement.append("(element.arraytype = '" + arraytypeid + "')");
        sqlStatement.append(" AND ");
        sqlStatement.append("(element.block = arrayblock.id)");
        sqlStatement.append(" AND ");
        sqlStatement.append("(element.id = RAWDATA.element (+)) ");
        sqlStatement.append(" ORDER BY arrayblock.blocknum, element.x, element.y");
        this.log_.info("sqlStatement: " + sqlStatement);
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/DefaultDS");
            Connection con = ds.getConnection();
            this.log_.info("prepareStatement");
            PreparedStatement pStmt = con.prepareStatement(sqlStatement.toString());
            this.log_.info("+++executeQuery");
            ResultSet rs = pStmt.executeQuery();
            this.log_.info("---executeQuery");
            this.log_.info("+++ read out resultset");
            try {
                File tmpFile = File.createTempFile("rawdata", "tmp");
                this.log_.info(tmpFile.getPath());
                FileOutputStream out = new FileOutputStream(tmpFile);
                BufferedOutputStream outStream = new BufferedOutputStream(out);
                String header = "#RawbioassaydataID\tBlock\tColumn\tRow\tX\tY\tGeneID\tGeneName\t";
                int i5 = 1;
                while (i5 <= numChannels) {
                    header = header + channelKey[i5 - 1] + ".fdata" + "\t";
                    ++i5;
                }
                int i6 = 1;
                while (i6 <= numChannels) {
                    header = i6 < numChannels ? header + channelKey[i6 - 1] + ".bdata" + "\t" : header + channelKey[i6 - 1] + ".bdata" + "\n";
                    ++i6;
                }
                outStream.write(header.getBytes());
                while (rs.next()) {
                    int i7;
                    int i8;
                    String toWrite;
                    if (rs.getString(6) == null && rs.getString(7) == null) {
                        toWrite = rs.getLong(1) + "\t" + rs.getLong(2) + "\t" + rs.getLong(3) + "\t" + null + "\t" + null + "\t" + null + "\t" + null + "\t";
                        i8 = 1;
                        while (i8 <= numChannels) {
                            toWrite = toWrite + null + "\t";
                            ++i8;
                        }
                        i7 = 1;
                        while (i7 <= numChannels) {
                            toWrite = i7 < numChannels ? toWrite + null + "\t" : toWrite + null + "\n";
                            ++i7;
                        }
                        outStream.write(toWrite.getBytes());
                        continue;
                    }
                    toWrite = rs.getLong(1) + "\t" + rs.getLong(2) + "\t" + rs.getLong(3) + "\t" + rs.getDouble(4) + "\t" + rs.getDouble(5) + "\t" + rs.getString(6) + "\t" + rs.getString(7) + "\t";
                    i8 = 1;
                    while (i8 <= numChannels) {
                        toWrite = toWrite + rs.getDouble(7 + i8) + "\t";
                        ++i8;
                    }
                    i7 = 1;
                    while (i7 <= numChannels) {
                        toWrite = i7 < numChannels ? toWrite + rs.getDouble(7 + numChannels + i7) + "\t" : toWrite + rs.getDouble(7 + numChannels + i7) + "\n";
                        ++i7;
                    }
                    outStream.write(toWrite.getBytes());
                }
                outStream.close();
                out.close();
                fileDataHandler = new DataHandler(new FileDataSource(tmpFile));
            }
            catch (IOException ex1) {
                this.log_.error(ex1);
            }
            this.log_.info("--- read out resultset");
            rs.close();
            pStmt.close();
            con.close();
        }
        catch (SQLException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
            this.log_.error(ex);
        }
        return fileDataHandler;
    }

    public String[] getRawdataCalculationMethods(String userName, String authenticationID) {
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        return new String[]{"Mean (FG) - Mean (BG)", "Median (FG) - Median (BG)"};
    }

    public boolean addTransformedRawdataset(String userName, String authenticationID, DataHandler dataHandler, String applicationName, String applicationVersion, String methodLog, String description, Vector rawbioassayIDs, Long experimentClassID) throws EJBServerException {
        InitialContext ctx;
        this.log_.info("addTransformedRawdataset");
        ServerConnection serverConnection = this.getServerConnection();
        ExtendedUserVO userVO = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return false;
            }
            userVO = serverConnection.getUserVOExtended(userName, authenticationID, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45");
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return false;
        }
        SoftwareVO softwareVO = null;
        if (applicationName == null || applicationName.trim().length() < 1 || applicationVersion == null || applicationVersion.trim().length() < 1) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), "Applicationname and version must be defined!");
            return false;
        }
        try {
            ctx = new InitialContext();
            ImageAcquisitionSBHome home = (ImageAcquisitionSBHome)ctx.lookup("java:comp/env/ImageAcquisitionSB");
            ImageAcquisitionSB sb = home.create();
            try {
                softwareVO = sb.getSoftware(applicationName, applicationVersion);
            }
            catch (EJBFinderException ex) {
                this.log_.info("Software not found .... will create Software");
                softwareVO = sb.addSoftware(new SoftwareVO(applicationName, "", userVO.getID(), new Date(System.currentTimeMillis()), applicationVersion, new Boolean(true), new BigDecimal(0.0)));
            }
        }
        catch (RemoteException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            this.log_.error((Object)ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (EJBCreateException ejbCex) {
            this.log_.error(ejbCex);
            throw new EJBServerException(ejbCex.getMessage());
        }
        catch (UniqueException uex) {
            this.log_.error(uex);
            throw new EJBServerException(uex.getMessage());
        }
        catch (ForeignKeyException fex) {
            this.log_.error(fex);
            throw new EJBServerException(fex.getMessage());
        }
        catch (ValidationException vex) {
            this.log_.error(vex);
            throw new EJBServerException(vex.getMessage());
        }
        try {
            ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/jdbc/DefaultDS");
            TransformationSBHome sbHome = (TransformationSBHome)ctx.lookup("java:comp/env/TransformationSB");
            TRawbioassayVO tRawbioassayVO = new TRawbioassayVO();
            tRawbioassayVO.setDescription(description);
            tRawbioassayVO.setInstituteid(userVO.getInstitut().getId());
            tRawbioassayVO.setMethodlog(methodLog);
            tRawbioassayVO.setName(dataHandler.getName());
            tRawbioassayVO.setSubmitterid(userVO.getID());
            tRawbioassayVO.setUserid(userVO.getID());
            tRawbioassayVO.setTransformationdate(new Date(System.currentTimeMillis()));
            tRawbioassayVO.setTransformationsoftware(softwareVO.getId());
            TransformationSB sb = sbHome.create();
            sb.uploadTransformedRawbioassay(tRawbioassayVO, rawbioassayIDs, experimentClassID, dataHandler.getName());
        }
        catch (ValidationException ex1) {
            this.log_.error(ex1);
        }
        catch (RemoteException ex1) {
            this.log_.error(ex1);
        }
        catch (CreateException ex1) {
            this.log_.error((Object)ex1);
        }
        catch (NamingException ex1) {
            this.log_.error(ex1);
        }
        catch (IOException ex1) {
            this.log_.error(ex1);
        }
        catch (EJBServerException ex1) {
            this.log_.error(ex1);
        }
        return true;
    }

    public DataHandler getTransformedRawdataset(String userName, String authenticationID, Long experimentClassID) {
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        return null;
    }

    public String login(String userName, String password) {
        AuthenticationToken authToken;
        block4: {
            authToken = null;
            ServerConnection serverConnection = this.getServerConnection();
            if (serverConnection == null) break block4;
            try {
                authToken = serverConnection.authenticateUser("mars", userName, password, "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45");
                if (authToken.isError()) {
                    return null;
                }
            }
            catch (RemoteException ex) {
                ex.printStackTrace();
            }
            catch (UserSecurityException ex) {
                ex.printStackTrace();
            }
        }
        return authToken.getAuthenticationID();
    }

    private ServerConnection getServerConnection() {
        block2: {
            if (this.serverConnection_ != null) break block2;
            try {
                this.serverConnection_ = ServerConnectionManager.getInstance().getConnection();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.serverConnection_;
    }

    public Vector getAvailableSpotRawdataFields(String userName, String authenticationID, Long rawBioassayID) {
        this.log_.info("getAvailableSpotRawdataFields");
        ServerConnection serverConnection = this.getServerConnection();
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        String[] channels = new String[]{};
        try {
            InitialContext ctx = new InitialContext();
            ImageAcquisitionSBHome home = (ImageAcquisitionSBHome)ctx.lookup("java:comp/env/ImageAcquisitionSB");
            ImageAcquisitionSB sb = home.create();
            return sb.getAvailableSpotRawdataFields(rawBioassayID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Vector();
        }
    }

    public DataHandler getSpotRawdata(String userName, String authenticationID, Long rawbioassayID, Long subExperimentClassID, Vector selectedDatabaseFields, Vector searchCriteria, String rawDataCalculationMethod) throws EJBServerException {
        ServerConnection serverConnection = this.getServerConnection();
        Long userID = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
            userID = serverConnection.getUserIDFromName(userName, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45");
        }
        catch (UserSecurityException ex2) {
            ex2.printStackTrace();
            return null;
        }
        DataHandler fileDataHandler = null;
        try {
            InitialContext ctx = new InitialContext();
            ImageAcquisitionSBHome home = (ImageAcquisitionSBHome)ctx.lookup("java:comp/env/ImageAcquisitionSB");
            ImageAcquisitionSB sb = home.create();
            File file = sb.getSpotRawdata(userID, rawbioassayID, selectedDatabaseFields, searchCriteria, rawDataCalculationMethod);
            fileDataHandler = new DataHandler(new FileDataSource(file));
        }
        catch (RemoteException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            this.log_.error((Object)ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        return fileDataHandler;
    }

    public ExperimentClassRawbioassayDTO getRawbioassayDetailed(String userName, String authenticationID, Long rawbioassayId) throws EJBServerException, EJBFinderException {
        ServerConnection serverConnection = this.getServerConnection();
        Long userID = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
            userID = serverConnection.getUserVO(userName, authenticationID, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45").getID();
        }
        catch (UserSecurityException ex1) {
            ex1.printStackTrace();
            return null;
        }
        this.log_.info("getRawbioassayDetailed(Long userID, rawbioassayid): " + userID + " " + rawbioassayId);
        Vector experimentDTOs = new Vector();
        try {
            InitialContext ctx = new InitialContext();
            ExperimentSBHome experimentSBHome = (ExperimentSBHome)ctx.lookup("java:comp/env/ExperimentSB");
            ExperimentSB experimentSB = experimentSBHome.create();
            ExperimentClassRawbioassayVO experimentClassRawBioassayVO = experimentSB.getExpClassRawBioassayDetailed(rawbioassayId);
            ExperimentClassRawbioassayDTO experimentClassRawBioassayDTO = experimentClassRawBioassayVO.createExperimentClassRawbioassayDTO();
            experimentClassRawBioassayDTO.getRawbioassayDTO().setDyeswap(new Boolean(experimentClassRawBioassayVO.getDyeswap()));
            return experimentClassRawBioassayDTO;
        }
        catch (RemoteException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex);
        }
        return null;
    }

    public Vector getFileUploadTypes(String userName, String authenticationID) throws EJBServerException {
        ServerConnection serverConnection = this.getServerConnection();
        Long userID = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return null;
            }
            userID = serverConnection.getUserIDFromName(userName, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45");
        }
        catch (UserSecurityException ex2) {
            ex2.printStackTrace();
            return null;
        }
        try {
            InitialContext ctx = new InitialContext();
            FilesSBHome home = (FilesSBHome)ctx.lookup("java:comp/env/FilesSB");
            FilesSB sb = home.create();
            FileUploadTypeVO[] types = sb.getFileUploadTypeVOs();
            Vector<String> v = new Vector<String>();
            int i = 0;
            while (i < types.length) {
                v.add(types[i].getDisplayname());
                ++i;
            }
            return v;
        }
        catch (RemoteException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            this.log_.error((Object)ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        return null;
    }

    public boolean addFile(String userName, String authenticationID, DataHandler datahandler, FileUploadDTO uploadDTO) throws EJBServerException, FileUploadException {
        ServerConnection serverConnection = this.getServerConnection();
        Long userID = null;
        try {
            if (!serverConnection.checkLogin(userName, authenticationID, "mars")) {
                return false;
            }
            userID = serverConnection.getUserIDFromName(userName, "mars", "T6so1Sf9hVHSB7s6uTfAiivaXFy6P02gx2Bxrg1PvqYO2244Jhv5MjBJwsBHQ787hgMzB3prvxamAKhvPQVBSQ45");
        }
        catch (UserSecurityException ex2) {
            ex2.printStackTrace();
            return false;
        }
        try {
            InitialContext ctx = new InitialContext();
            FilesSBHome home = (FilesSBHome)ctx.lookup("java:comp/env/FilesSB");
            FilesSB sb = home.create();
            BufferedInputStream din = new BufferedInputStream(datahandler.getInputStream());
            byte[] filedata = new byte[uploadDTO.getFilesize().intValue()];
            din.read(filedata);
            System.out.println("datahandler.getName()" + datahandler.getName());
            System.out.println("uploadDTO.getUploadname()" + uploadDTO.getUploadname());
            uploadDTO.setMimetype(datahandler.getContentType());
            sb.setFile(uploadDTO.getUploadname(), filedata, new FileUploadVO(uploadDTO, userID));
            return true;
        }
        catch (IOException ioEx) {
            this.log_.error(ioEx);
            throw new EJBServerException(ioEx.getMessage());
        }
        catch (EJBCreateException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (ForeignKeyException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (UniqueException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (CreateException ex) {
            this.log_.error((Object)ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        catch (NamingException ex) {
            this.log_.error(ex);
            EJBExceptionFactory.throwEJBServerException(GlobalConstants.getDatabase(), ex.getMessage());
        }
        return false;
    }
}

