/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.experiment.vo;

import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassDTO;
import at.tugraz.genome.marsejb.clientconnector.vo.ExperimentClassRawbioassayDTO;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.experiment.ejb.Experimentclass;
import at.tugraz.genome.marsejb.experiment.vo.ExperimentClassRawbioassayVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class ExperimentClassVO
implements Serializable {
    private Long id;
    private String name;
    private String description;
    private Collection rawBioAssayVOs;

    public ExperimentClassVO(String name, String description) throws ValidationException {
        if (name == null || name.length() == 0) {
            throw new ValidationException("name was null or empty ", this.getClass());
        }
        this.name = name;
        this.description = description;
    }

    public ExperimentClassVO(Experimentclass entity, boolean reantrant) {
        System.out.println("ExperimentClassVO: " + reantrant);
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescription(entity.getDescription());
        if (!reantrant) {
            this.rawBioAssayVOs = entity.getExperimentClassRawbioassayVOs(!reantrant);
        }
    }

    public ExperimentClassVO(Experimentclass entity, boolean reantrant, int level) {
        System.out.println("ExperimentClassVO: " + level + " " + reantrant);
        this.id = entity.getId();
        this.setName(entity.getName());
        this.setDescription(entity.getDescription());
        if (level > 0 && !reantrant) {
            this.rawBioAssayVOs = entity.getExperimentClassRawbioassayVOs(!reantrant, level);
        }
    }

    public Collection getRawbioassayVOs() {
        System.out.println("getRawbioassayVOs");
        return this.rawBioAssayVOs;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(Long id) throws ValidationException {
        if (this.id != null) {
            throw new ValidationException("Id is already set !", this.getClass());
        }
        if (id == null) {
            throw new ValidationException("null not allowed !", this.getClass());
        }
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ExperimentClassDTO createExperimentClassDTO() {
        ExperimentClassDTO experimentClassDTO = new ExperimentClassDTO();
        experimentClassDTO.setDescription(this.getDescription());
        experimentClassDTO.setId(this.getId());
        experimentClassDTO.setName(this.getName());
        if (this.getRawbioassayVOs() != null) {
            Iterator experimentClassRawBioassayVOs = this.getRawbioassayVOs().iterator();
            Vector<ExperimentClassRawbioassayDTO> experimentClassRawBioassayDTOs = new Vector<ExperimentClassRawbioassayDTO>();
            while (experimentClassRawBioassayVOs.hasNext()) {
                ExperimentClassRawbioassayVO experimentClassRawBioassayVO = (ExperimentClassRawbioassayVO)experimentClassRawBioassayVOs.next();
                ExperimentClassRawbioassayDTO experimentClassRawBioassayDTO = experimentClassRawBioassayVO.createExperimentClassRawbioassayDTO();
                experimentClassRawBioassayDTOs.add(experimentClassRawBioassayDTO);
            }
            experimentClassDTO.setExperimentClassRawbioassayDTOs(experimentClassRawBioassayDTOs);
        }
        return experimentClassDTO;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer("at.tugraz.genome.marsejb.experiment.vo.ExperimentClassVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id=");
        _ret.append(this.id);
        _ret.append(",\n");
        _ret.append("java.lang.String name=");
        _ret.append(this.name);
        _ret.append(",\n");
        _ret.append("java.lang.String description=");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ExperimentClassVO) {
            ExperimentClassVO obj = (ExperimentClassVO)o;
            boolean res = true;
            boolean bl = res = this.getId() == obj.getId() || this.getId() != null && obj.getId() != null && this.getId().equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.getName() == obj.getName() || this.getName() != null && obj.getName() != null && this.getName().equals(obj.getName());
                if (res) {
                    boolean bl3 = res = this.getDescription() == obj.getDescription() || this.getDescription() != null && obj.getDescription() != null && this.getDescription().equals(obj.getDescription());
                    if (!res) {
                        // empty if block
                    }
                }
            }
            return res;
        }
        return false;
    }
}

