/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.marsejb.molecule.vo;

import at.tugraz.genome.dbutilities.exception.EJBFinderException;
import at.tugraz.genome.dbutilities.exception.EJBServerException;
import at.tugraz.genome.marsejb.exception.ValidationException;
import at.tugraz.genome.marsejb.molecule.ejb.Molecule;
import at.tugraz.genome.marsejb.molecule.vo.LibraryVO;
import at.tugraz.genome.marsejb.utils.vo.ProviderVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;

public class MoleculeVO
implements Serializable {
    private Long id;
    private BigDecimal moleculelength;
    private String cloneid;
    private String genbankaccnumber;
    private String chromosome;
    private String cytoband;
    private String genename;
    private String markers;
    private String locuslink;
    private BigDecimal omim;
    private Date lastupdate;
    private String clonename;
    private Long provider;
    private String sequencegenomic;
    private String sequenceorf;
    private String sequenceest;
    private String sequencetc;
    private String tcnumber;
    private String unigenenumber;
    private String swissprotid;
    private String geneontology;
    private String geneannotation;
    private String probectrlqualendogenous;
    private String probectrlqualexogenous;
    private String description;
    private String meltingtemperature;
    private String oligoctrlqualologoconcentratio;
    private String oligoctrlqualmsverified;
    private BigDecimal block;
    private LibraryVO library;
    private ProviderVO providerVO;
    private String controltype;
    private String controltypevalue;

    public MoleculeVO(Molecule entity, int level) {
        try {
            this.setId(entity.getId());
            this.setMoleculelength(entity.getMoleculelength());
            this.setCloneid(entity.getCloneid());
            this.setGenbankaccnumber(entity.getGenbankaccnumber());
            this.setChromosome(entity.getChromosome());
            this.setCytoband(entity.getCytoband());
            this.setGenename(entity.getGenename());
            this.setMarkers(entity.getMarkers());
            this.setLocuslink(entity.getLocuslink());
            this.setOmim(entity.getOmim());
            this.setLastupdate(entity.getLastupdate());
            this.setClonename(entity.getClonename());
            this.setProvider(entity.getProvider());
            this.setSequencegenomic(entity.getSequencegenomic());
            this.setSequenceorf(entity.getSequenceorf());
            this.setSequenceest(entity.getSequenceest());
            this.setSequencetc(entity.getSequencetc());
            this.setTcnumber(entity.getTcnumber());
            this.setUnigenenumber(entity.getUnigenenumber());
            this.setSwissprotid(entity.getSwissprotid());
            this.setGeneontology(entity.getGeneontology());
            this.setGeneannotation(entity.getGeneannotation());
            this.setProbectrlqualendogenous(entity.getProbectrlqualendogenous());
            this.setProbectrlqualexogenous(entity.getProbectrlqualexogenous());
            this.setDescription(entity.getDescription());
            this.setMeltingtemperature(entity.getMeltingtemperature());
            this.setOligoctrlqualologoconcentratio(entity.getOligoctrlqualologoconcentratio());
            this.setOligoctrlqualmsverified(entity.getOligoctrlqualmsverified());
            this.setBlock(entity.getBlock());
            if (level > 0) {
                if (entity.getLibrary() != null) {
                    this.library = new LibraryVO(entity.getLibrary(), level - 1);
                }
                this.providerVO = entity.getProviderVO();
            }
            this.setControltype(entity.getControltype());
            this.setControltypevalue(entity.getControltypevalue());
        }
        catch (ValidationException validationExc) {
            validationExc.printStackTrace();
        }
        catch (EJBServerException serverExc) {
            serverExc.printStackTrace();
        }
        catch (EJBFinderException finderExc) {
            finderExc.printStackTrace();
        }
    }

    public MoleculeVO(BigDecimal moleculeLength, String cloneid, String genbankaccnumber, String chromosome, String cytoband, String genename, String markers, String locuslink, BigDecimal omim, Date lastupdate, String clonename, Long provider, String sequencegenomic, String sequenceorf, String sequenceest, String sequencetc, String tcnumber, String unigenenumber, String swissprotid, String geneontology, String geneannotation, String probectrlqualendogenous, String probectrlqualexogenous, String description, String meltingtemperature, String oligoctrlqualologoconcentration, String oligoctrlqualmsverified, BigDecimal block, LibraryVO libraryVO, String controltype, String controltypevalue) throws ValidationException {
        this.setMoleculelength(moleculeLength);
        this.setCloneid(cloneid);
        this.setGenbankaccnumber(genbankaccnumber);
        if (chromosome != null && chromosome.length() > 3) {
            throw new ValidationException("chromosome in MoleculeVO is longer than 3 characters", this.getClass());
        }
        this.setChromosome(chromosome);
        this.setCytoband(cytoband);
        this.setGenename(genename);
        this.setMarkers(markers);
        if (locuslink != null && locuslink.length() > 13) {
            throw new ValidationException("locuslink in MoleculeVO is longer than 13 characters", this.getClass());
        }
        this.setLocuslink(locuslink);
        this.setOmim(omim);
        if (lastupdate == null) {
            throw new ValidationException("lastupdate in MoleculeVO is NULL", this.getClass());
        }
        this.setLastupdate(lastupdate);
        if (clonename == null) {
            clonename = "unknown";
        }
        if (clonename.trim().length() == 0) {
            clonename = "unknown";
        }
        this.setClonename(clonename);
        this.setProvider(provider);
        this.setSequencegenomic(sequencegenomic);
        this.setSequenceorf(sequenceorf);
        this.setSequenceest(sequenceest);
        this.setSequencetc(sequencetc);
        this.setTcnumber(tcnumber);
        this.setUnigenenumber(unigenenumber);
        this.setSwissprotid(swissprotid);
        this.setGeneontology(geneontology);
        this.setGeneannotation(geneannotation);
        this.setProbectrlqualendogenous(probectrlqualendogenous);
        this.setProbectrlqualexogenous(probectrlqualexogenous);
        this.setDescription(description);
        this.setMeltingtemperature(meltingtemperature);
        this.setOligoctrlqualologoconcentratio(oligoctrlqualologoconcentration);
        this.setOligoctrlqualmsverified(oligoctrlqualmsverified);
        this.setBlock(block);
        this.setLibrary(libraryVO);
        this.setControltype(controltype);
        this.setControltypevalue(controltypevalue);
    }

    public Long getId() {
        return this.id;
    }

    public BigDecimal getMoleculelength() {
        return this.moleculelength;
    }

    public String getCloneid() {
        return this.cloneid;
    }

    public String getGenbankaccnumber() {
        return this.genbankaccnumber;
    }

    public String getChromosome() {
        return this.chromosome;
    }

    public String getCytoband() {
        return this.cytoband;
    }

    public String getGenename() {
        return this.genename;
    }

    public String getMarkers() {
        return this.markers;
    }

    public String getLocuslink() {
        return this.locuslink;
    }

    public BigDecimal getOmim() {
        return this.omim;
    }

    public Date getLastupdate() {
        return this.lastupdate;
    }

    public String getClonename() {
        return this.clonename;
    }

    public Long getProvider() {
        return this.provider;
    }

    public ProviderVO getProviderVO() {
        return this.providerVO;
    }

    public String getSequencegenomic() {
        return this.sequencegenomic;
    }

    public String getSequenceorf() {
        return this.sequenceorf;
    }

    public String getSequenceest() {
        return this.sequenceest;
    }

    public String getSequencetc() {
        return this.sequencetc;
    }

    public String getTcnumber() {
        return this.tcnumber;
    }

    public String getUnigenenumber() {
        return this.unigenenumber;
    }

    public String getSwissprotid() {
        return this.swissprotid;
    }

    public String getGeneontology() {
        return this.geneontology;
    }

    public String getGeneannotation() {
        return this.geneannotation;
    }

    public String getProbectrlqualendogenous() {
        return this.probectrlqualendogenous;
    }

    public String getProbectrlqualexogenous() {
        return this.probectrlqualexogenous;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMeltingtemperature() {
        return this.meltingtemperature;
    }

    public String getOligoctrlqualologoconcentratio() {
        return this.oligoctrlqualologoconcentratio;
    }

    public String getOligoctrlqualmsverified() {
        return this.oligoctrlqualmsverified;
    }

    public BigDecimal getBlock() {
        return this.block;
    }

    public LibraryVO getLibrary() {
        return this.library;
    }

    public void setId(Long id) throws ValidationException {
        if (id == null) {
            throw new ValidationException("id in MoleculeVO is NULL", this.getClass());
        }
        if (this.id != null) {
            throw new ValidationException("is in MoleculeVO was already set", this.getClass());
        }
        this.id = id;
    }

    public void setMoleculelength(BigDecimal moleculelength) {
        this.moleculelength = moleculelength;
    }

    public void setCloneid(String cloneid) {
        this.cloneid = cloneid;
    }

    public void setGenbankaccnumber(String genbankaccnumber) {
        this.genbankaccnumber = genbankaccnumber;
    }

    public void setChromosome(String chromosome) {
        this.chromosome = chromosome;
    }

    public void setCytoband(String cytoband) {
        this.cytoband = cytoband;
    }

    public void setGenename(String genename) {
        this.genename = genename;
    }

    public void setMarkers(String markers) {
        this.markers = markers;
    }

    public void setLocuslink(String locuslink) {
        this.locuslink = locuslink;
    }

    public void setOmim(BigDecimal omim) {
        this.omim = omim;
    }

    public void setLastupdate(Date lastupdate) {
        this.lastupdate = lastupdate;
    }

    public void setClonename(String clonename) {
        this.clonename = clonename;
    }

    public void setProvider(Long provider) {
        this.provider = provider;
    }

    public void setSequencegenomic(String sequencegenomic) {
        this.sequencegenomic = sequencegenomic;
    }

    public void setSequenceorf(String sequenceorf) {
        this.sequenceorf = sequenceorf;
    }

    public void setSequenceest(String sequenceest) {
        this.sequenceest = sequenceest;
    }

    public void setSequencetc(String sequencetc) {
        this.sequencetc = sequencetc;
    }

    public void setTcnumber(String tcnumber) {
        this.tcnumber = tcnumber;
    }

    public void setUnigenenumber(String unigenenumber) {
        this.unigenenumber = unigenenumber;
    }

    public void setSwissprotid(String swissprotid) {
        this.swissprotid = swissprotid;
    }

    public void setGeneontology(String geneontology) {
        this.geneontology = geneontology;
    }

    public void setGeneannotation(String geneannotation) {
        this.geneannotation = geneannotation;
    }

    public void setProbectrlqualendogenous(String probectrlqualendogenous) {
        this.probectrlqualendogenous = probectrlqualendogenous;
    }

    public void setProbectrlqualexogenous(String probectrlqualexogenous) {
        this.probectrlqualexogenous = probectrlqualexogenous;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setMeltingtemperature(String meltingtemperature) {
        this.meltingtemperature = meltingtemperature;
    }

    public void setOligoctrlqualologoconcentratio(String oligoctrlqualologoconcentratio) {
        this.oligoctrlqualologoconcentratio = oligoctrlqualologoconcentratio;
    }

    public void setOligoctrlqualmsverified(String oligoctrlqualmsverified) {
        this.oligoctrlqualmsverified = oligoctrlqualmsverified;
    }

    public void setBlock(BigDecimal block) {
        this.block = block;
    }

    private void setLibrary(LibraryVO library) {
        this.library = library;
    }

    public void setControltype(String controltype) {
        this.controltype = controltype;
    }

    public String getControltype() {
        return this.controltype;
    }

    public void setControltypevalue(String controltypevalue) {
        this.controltypevalue = controltypevalue;
    }

    public String getControltypevalue() {
        return this.controltypevalue;
    }

    public String toString() {
        StringBuffer _ret = new StringBuffer();
        _ret.append("at.tugraz.genome.marsejb.molecule.vo.MoleculeVO {");
        _ret.append("\n");
        _ret.append("java.lang.Long id = ");
        _ret.append(this.id);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal moleculelength = ");
        _ret.append(this.moleculelength);
        _ret.append("\n");
        _ret.append("java.lang.String cloneid = ");
        _ret.append(this.cloneid);
        _ret.append("\n");
        _ret.append("java.lang.String genbankaccnumber = ");
        _ret.append(this.genbankaccnumber);
        _ret.append("\n");
        _ret.append("java.lang.String chromosome = ");
        _ret.append(this.chromosome);
        _ret.append("\n");
        _ret.append("java.lang.String cytoband = ");
        _ret.append(this.cytoband);
        _ret.append("\n");
        _ret.append("java.lang.String genename = ");
        _ret.append(this.genename);
        _ret.append("\n");
        _ret.append("java.lang.String markers = ");
        _ret.append(this.markers);
        _ret.append("\n");
        _ret.append("java.lang.String locuslink = ");
        _ret.append(this.locuslink);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal omim = ");
        _ret.append(this.omim);
        _ret.append("\n");
        _ret.append("java.sql.Date lastupdate = ");
        _ret.append(this.lastupdate);
        _ret.append("\n");
        _ret.append("java.lang.String clonename = ");
        _ret.append(this.clonename);
        _ret.append("\n");
        _ret.append("java.lang.String provider = ");
        _ret.append(this.provider);
        _ret.append("\n");
        _ret.append("java.sql.Clob sequencegenomic = ");
        _ret.append(this.sequencegenomic);
        _ret.append("\n");
        _ret.append("java.sql.Clob sequenceorf = ");
        _ret.append(this.sequenceorf);
        _ret.append("\n");
        _ret.append("java.sql.Clob sequenceest = ");
        _ret.append(this.sequenceest);
        _ret.append("\n");
        _ret.append("java.sql.Clob sequencetc = ");
        _ret.append(this.sequencetc);
        _ret.append("\n");
        _ret.append("java.lang.String tcnumber = ");
        _ret.append(this.tcnumber);
        _ret.append("\n");
        _ret.append("java.lang.String unigenenumber = ");
        _ret.append(this.unigenenumber);
        _ret.append("\n");
        _ret.append("java.lang.String swissprotid = ");
        _ret.append(this.swissprotid);
        _ret.append("\n");
        _ret.append("java.lang.String geneontology = ");
        _ret.append(this.geneontology);
        _ret.append("\n");
        _ret.append("java.lang.String geneannotation = ");
        _ret.append(this.geneannotation);
        _ret.append("\n");
        _ret.append("java.lang.String probectrlqualendogenous = ");
        _ret.append(this.probectrlqualendogenous);
        _ret.append("\n");
        _ret.append("java.lang.String probectrlqualexogenous = ");
        _ret.append(this.probectrlqualexogenous);
        _ret.append("\n");
        _ret.append("java.lang.String description = ");
        _ret.append(this.description);
        _ret.append("\n");
        _ret.append("java.lang.String meltingtemperature = ");
        _ret.append(this.meltingtemperature);
        _ret.append("\n");
        _ret.append("java.lang.String oligoctrlqualologoconcentratio = ");
        _ret.append(this.oligoctrlqualologoconcentratio);
        _ret.append("\n");
        _ret.append("java.lang.String oligoctrlqualmsverified = ");
        _ret.append(this.oligoctrlqualmsverified);
        _ret.append("\n");
        _ret.append("java.math.BigDecimal block = ");
        _ret.append(this.block);
        _ret.append("\n");
        _ret.append("at.tugraz.genome.marsejb.molecule.ejb.Library library = ");
        _ret.append(this.library);
        _ret.append("\n");
        _ret.append("}");
        return _ret.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof MoleculeVO) {
            MoleculeVO obj = (MoleculeVO)o;
            boolean res = true;
            boolean bl = res = this.id == obj.getId() || this.id != null && obj.getId() != null && this.id.equals(obj.getId());
            if (res) {
                boolean bl2 = res = this.moleculelength == obj.getMoleculelength() || this.moleculelength != null && obj.getMoleculelength() != null && this.moleculelength.equals(obj.getMoleculelength());
                if (res) {
                    boolean bl3 = res = this.cloneid == obj.getCloneid() || this.cloneid != null && obj.getCloneid() != null && this.cloneid.equals(obj.getCloneid());
                    if (res) {
                        boolean bl4 = res = this.genbankaccnumber == obj.getGenbankaccnumber() || this.genbankaccnumber != null && obj.getGenbankaccnumber() != null && this.genbankaccnumber.equals(obj.getGenbankaccnumber());
                        if (res) {
                            boolean bl5 = res = this.chromosome == obj.getChromosome() || this.chromosome != null && obj.getChromosome() != null && this.chromosome.equals(obj.getChromosome());
                            if (res) {
                                boolean bl6 = res = this.cytoband == obj.getCytoband() || this.cytoband != null && obj.getCytoband() != null && this.cytoband.equals(obj.getCytoband());
                                if (res) {
                                    boolean bl7 = res = this.genename == obj.getGenename() || this.genename != null && obj.getGenename() != null && this.genename.equals(obj.getGenename());
                                    if (res) {
                                        boolean bl8 = res = this.markers == obj.getMarkers() || this.markers != null && obj.getMarkers() != null && this.markers.equals(obj.getMarkers());
                                        if (res) {
                                            boolean bl9 = res = this.locuslink == obj.getLocuslink() || this.locuslink != null && obj.getLocuslink() != null && this.locuslink.equals(obj.getLocuslink());
                                            if (res) {
                                                boolean bl10 = res = this.omim == obj.getOmim() || this.omim != null && obj.getOmim() != null && this.omim.equals(obj.getOmim());
                                                if (res) {
                                                    boolean bl11 = res = this.lastupdate == obj.getLastupdate() || this.lastupdate != null && obj.getLastupdate() != null && this.lastupdate.equals(obj.getLastupdate());
                                                    if (res) {
                                                        boolean bl12 = res = this.clonename == obj.getClonename() || this.clonename != null && obj.getClonename() != null && this.clonename.equals(obj.getClonename());
                                                        if (res) {
                                                            boolean bl13 = res = this.provider == obj.getProvider() || this.provider != null && obj.getProvider() != null && this.provider.equals(obj.getProvider());
                                                            if (res) {
                                                                boolean bl14 = res = this.sequencegenomic == obj.getSequencegenomic() || this.sequencegenomic != null && obj.getSequencegenomic() != null && this.sequencegenomic.equals(obj.getSequencegenomic());
                                                                if (res) {
                                                                    boolean bl15 = res = this.sequenceorf == obj.getSequenceorf() || this.sequenceorf != null && obj.getSequenceorf() != null && this.sequenceorf.equals(obj.getSequenceorf());
                                                                    if (res) {
                                                                        boolean bl16 = res = this.sequenceest == obj.getSequenceest() || this.sequenceest != null && obj.getSequenceest() != null && this.sequenceest.equals(obj.getSequenceest());
                                                                        if (res) {
                                                                            boolean bl17 = res = this.sequencetc == obj.getSequencetc() || this.sequencetc != null && obj.getSequencetc() != null && this.sequencetc.equals(obj.getSequencetc());
                                                                            if (res) {
                                                                                boolean bl18 = res = this.tcnumber == obj.getTcnumber() || this.tcnumber != null && obj.getTcnumber() != null && this.tcnumber.equals(obj.getTcnumber());
                                                                                if (res) {
                                                                                    boolean bl19 = res = this.unigenenumber == obj.getUnigenenumber() || this.unigenenumber != null && obj.getUnigenenumber() != null && this.unigenenumber.equals(obj.getUnigenenumber());
                                                                                    if (res) {
                                                                                        boolean bl20 = res = this.swissprotid == obj.getSwissprotid() || this.swissprotid != null && obj.getSwissprotid() != null && this.swissprotid.equals(obj.getSwissprotid());
                                                                                        if (res) {
                                                                                            boolean bl21 = res = this.geneontology == obj.getGeneontology() || this.geneontology != null && obj.getGeneontology() != null && this.geneontology.equals(obj.getGeneontology());
                                                                                            if (res) {
                                                                                                boolean bl22 = res = this.geneannotation == obj.getGeneannotation() || this.geneannotation != null && obj.getGeneannotation() != null && this.geneannotation.equals(obj.getGeneannotation());
                                                                                                if (res) {
                                                                                                    boolean bl23 = res = this.probectrlqualendogenous == obj.getProbectrlqualendogenous() || this.probectrlqualendogenous != null && obj.getProbectrlqualendogenous() != null && this.probectrlqualendogenous.equals(obj.getProbectrlqualendogenous());
                                                                                                    if (res) {
                                                                                                        boolean bl24 = res = this.probectrlqualexogenous == obj.getProbectrlqualexogenous() || this.probectrlqualexogenous != null && obj.getProbectrlqualexogenous() != null && this.probectrlqualexogenous.equals(obj.getProbectrlqualexogenous());
                                                                                                        if (res) {
                                                                                                            boolean bl25 = res = this.description == obj.getDescription() || this.description != null && obj.getDescription() != null && this.description.equals(obj.getDescription());
                                                                                                            if (res) {
                                                                                                                boolean bl26 = res = this.meltingtemperature == obj.getMeltingtemperature() || this.meltingtemperature != null && obj.getMeltingtemperature() != null && this.meltingtemperature.equals(obj.getMeltingtemperature());
                                                                                                                if (res) {
                                                                                                                    boolean bl27 = res = this.oligoctrlqualologoconcentratio == obj.getOligoctrlqualologoconcentratio() || this.oligoctrlqualologoconcentratio != null && obj.getOligoctrlqualologoconcentratio() != null && this.oligoctrlqualologoconcentratio.equals(obj.getOligoctrlqualologoconcentratio());
                                                                                                                    if (res) {
                                                                                                                        boolean bl28 = res = this.oligoctrlqualmsverified == obj.getOligoctrlqualmsverified() || this.oligoctrlqualmsverified != null && obj.getOligoctrlqualmsverified() != null && this.oligoctrlqualmsverified.equals(obj.getOligoctrlqualmsverified());
                                                                                                                        if (res) {
                                                                                                                            boolean bl29 = res = this.block == obj.getBlock() || this.block != null && obj.getBlock() != null && this.block.equals(obj.getBlock());
                                                                                                                            if (res) {
                                                                                                                                boolean bl30 = res = this.library == obj.getLibrary() || this.library != null && obj.getLibrary() != null && this.library.equals(obj.getLibrary());
                                                                                                                                if (!res) {
                                                                                                                                    // empty if block
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return res;
        }
        return false;
    }
}

