/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.Function;

public class LineFunction
extends Function {
    public LineFunction() {
        this.setParameterNames(new String[]{"a", "b"});
    }

    public String getFunctionDefinition() {
        return "y = a + b * x";
    }

    public String getFunctionName() {
        return "Line";
    }

    double getGradient(double[] parm, int pk, double x) {
        double gradient = 0.0;
        switch (pk) {
            case 0: {
                gradient = 1.0;
                break;
            }
            case 1: {
                gradient = x;
                break;
            }
            default: {
                System.err.println("getGradient: Hit default case in parameter switch");
            }
        }
        return gradient;
    }

    double getHessian(double[] parm, int pk, int l, double x) {
        double hessian = 0.0;
        block0 : switch (pk) {
            case 0: {
                switch (l) {
                    case 0: {
                        hessian = 0.0;
                        break;
                    }
                    case 1: {
                        hessian = 0.0;
                    }
                }
                break;
            }
            case 1: {
                switch (l) {
                    case 0: {
                        hessian = 0.0;
                        break block0;
                    }
                    case 1: {
                        hessian = 0.0;
                    }
                }
            }
        }
        return hessian;
    }

    public int getNumberOfParameters() {
        return 2;
    }

    double[] getStartParameters(double[] x, double[] y) {
        double[] start_values = new double[this.getNumberOfParameters()];
        int last_point = x.length - 1;
        start_values[1] = (y[last_point] - y[0]) / (x[last_point] - x[0]);
        start_values[0] = y[last_point] - start_values[1] * x[last_point];
        return start_values;
    }

    public double getValue(double[] param, double x) {
        double y = param[0] + param[1] * x;
        return y;
    }

    public double getXValue(double[] param, double y) {
        double x = (y - param[0]) / param[1];
        return x;
    }
}

