/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.Function;

public class PolynomFunction
extends Function {
    int pol_order_;

    public PolynomFunction(int order) {
        this.pol_order_ = order;
        String[] par_nam = new String[this.pol_order_ + 1];
        int i = 0;
        while (i < this.pol_order_ + 1) {
            par_nam[i] = "p" + i;
            ++i;
        }
        this.setParameterNames(par_nam);
    }

    public String getFunctionDefinition() {
        return "y = p0 + p1*x + p2*x^2 + .... pn*x^n";
    }

    public String getFunctionName() {
        return "Polynomial";
    }

    double getGradient(double[] parm, int pk, double x) {
        double gradient = 0.0;
        gradient = pk == 0 ? 1.0 : Math.pow(x, pk);
        return gradient;
    }

    double getHessian(double[] parm, int pk, int l, double x) {
        double hessian = 0.0;
        return hessian;
    }

    public int getNumberOfParameters() {
        return this.pol_order_ + 1;
    }

    double[] getStartParameters(double[] x, double[] y) {
        double[] start_values = new double[this.getNumberOfParameters()];
        int last_point = x.length - 1;
        start_values[1] = (y[last_point] - y[0]) / (x[last_point] - x[0]);
        start_values[0] = y[last_point] - start_values[1] * x[last_point];
        return start_values;
    }

    public double getValue(double[] param, double x) {
        double y = param[0];
        if (param.length == this.pol_order_ + 1) {
            int i = 1;
            while (i < this.pol_order_ + 1) {
                y += param[i] * Math.pow(x, i);
                ++i;
            }
            return y;
        }
        System.out.println("something wrong with parameters");
        return Double.NaN;
    }

    public double getXValue(double[] param, double y) {
        return 0.0;
    }
}

