/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class SimpleMatrix {
    public static double[][] invert(double[][] a) throws IllegalArgumentException, ArithmeticException {
        int j;
        if (a == null) {
            throw new IllegalArgumentException("Matrix parameter must not be null");
        }
        if (a[0].length != a.length) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        int n = a.length;
        double[][] D = new double[n + 1][2 * n + 1];
        int n2 = 2 * n;
        int i = 1;
        while (i <= n) {
            j = 1;
            while (j <= n) {
                D[i][j] = a[i - 1][j - 1];
                D[i][j + n] = 0.0;
                ++j;
            }
            D[i][i + n] = 1.0;
            ++i;
        }
        i = 1;
        while (i <= n) {
            double alpha = D[i][i];
            if (alpha == 0.0) {
                SimpleMatrix.print(a, 8);
                throw new ArithmeticException("Singular matrix - unable to invert");
            }
            j = 1;
            while (j <= n2) {
                D[i][j] = D[i][j] / alpha;
                ++j;
            }
            int k = 1;
            while (k <= n) {
                if (k - i != 0) {
                    double beta = D[k][i];
                    j = 1;
                    while (j <= n2) {
                        D[k][j] = D[k][j] - beta * D[i][j];
                        ++j;
                    }
                }
                ++k;
            }
            ++i;
        }
        double[][] a_invert = new double[n][n];
        i = 0;
        while (i < n) {
            j = 0;
            while (j < n) {
                a_invert[i][j] = D[i + 1][j + n + 1];
                ++j;
            }
            ++i;
        }
        return a_invert;
    }

    public static void main(String[] args) {
        double[][] unity = new double[][]{{2.0, 0.0, 0.0}, {0.0, 2.0, 0.0}, {0.0, 0.0, 2.0}};
        SimpleMatrix.print(unity, 8);
        double[][] ui = SimpleMatrix.invert(unity);
        SimpleMatrix.print(ui, 8);
        SimpleMatrix.print(SimpleMatrix.multiply(unity, ui), 8);
        double[][] col = new double[][]{{1.0}, {2.0}, {3.0}};
        double[][] row = new double[][]{{1.0, 2.0, 3.0}};
        SimpleMatrix.print(col, 8);
        SimpleMatrix.print(SimpleMatrix.multiply(unity, col), 8);
        try {
            SimpleMatrix.print(SimpleMatrix.multiply(col, col), 8);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        SimpleMatrix.print(SimpleMatrix.multiply(col, row), 8);
        SimpleMatrix.print(SimpleMatrix.solve(unity, col), 8);
    }

    public static double[][] multiply(double[][] a, double[][] b) {
        if (a == null || b == null) {
            throw new IllegalArgumentException("Matrix parameters must not be null");
        }
        if (a[0].length != b.length) {
            throw new IllegalArgumentException("Matrix inner dimensions must agree.");
        }
        int m = a.length;
        int n = a[0].length;
        int b_n = b[0].length;
        double[][] c = new double[m][b_n];
        double[] Bcolj = new double[n];
        int j = 0;
        while (j < b_n) {
            int k = 0;
            while (k < n) {
                Bcolj[k] = b[k][j];
                ++k;
            }
            int i = 0;
            while (i < m) {
                double s = 0.0;
                int k2 = 0;
                while (k2 < n) {
                    s += a[i][k2] * Bcolj[k2];
                    ++k2;
                }
                c[i][j] = s;
                ++i;
            }
            ++j;
        }
        return c;
    }

    public static void print(double[][] a, int width) {
        DecimalFormat format = new DecimalFormat();
        format.setMinimumIntegerDigits(1);
        format.setMaximumFractionDigits(4);
        format.setMinimumFractionDigits(4);
        ((NumberFormat)format).setGroupingUsed(false);
        System.out.println();
        String spaces = "                      ";
        int i = 0;
        while (i < a.length) {
            int j = 0;
            while (j < a[0].length) {
                String s = format.format(a[i][j]);
                int padding = Math.max(1, width - s.length());
                System.out.print(spaces.substring(0, padding) + s);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }

    public static double[][] solve(double[][] a, double[][] b) {
        return SimpleMatrix.multiply(SimpleMatrix.invert(a), b);
    }
}

