/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math;

import at.tugraz.genome.math.ArrayOp;
import at.tugraz.genome.math.HillFunction;
import at.tugraz.genome.math.LineFunction;
import at.tugraz.genome.math.PolynomFunction;
import at.tugraz.genome.math.QuadraticFunction;
import junit.framework.TestCase;

public class TestFunction
extends TestCase {
    public TestFunction(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testHillFunction() {
        HillFunction f = new HillFunction();
        double[] hill_parameter = new double[]{20.0, 8.0, 4.0, 0.5};
        int num_values = 25;
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        double[] x_values = new double[]{2.0, 1.0, 0.3, 0.1, 0.03, 0.0};
        double[] y_values = new double[]{0.11478, 0.060618, 0.02888, 0.020065, 0.018462, 0.013647};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double tolerance = 1.0E-9;
        double[] fit = f.fit(x_values, y_values, sigma, tolerance);
        ArrayOp.dumpArray("Org:   ", hill_parameter, 11, 4);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        fit = f.fit(x_values, y_values, null, tolerance);
        ArrayOp.dumpArray("Org:   ", hill_parameter, 11, 4);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        System.out.println("log(Double.MIN_VALUE): " + Math.log(Double.MIN_VALUE));
        System.out.println("Double.MIN_VALUE ^ 10): " + Math.pow(Double.MIN_VALUE, 10.0));
        double y = f.getValue(fit, 0.5);
        System.out.println("X: 0.5   Y: " + y);
        y = 2.0;
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        y = 1.0;
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
    }

    public void testLineFunction() {
        LineFunction f = new LineFunction();
        double[] line_parameter = new double[]{2.1, 1.5};
        int num_values = 25;
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 0.7, 1.2, 1.6, 1.8, 2.0, 1.8, 1.6, 1.2, 0.7, 0.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Org:   ", line_parameter, 11, 4);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 0.5);
        System.out.println("X: 0.5   Y: " + y);
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        f.setParameters(fit);
        System.out.println("Y: " + y + "  X: " + f.getXValue(y));
    }

    public void testPolyFunction() {
        PolynomFunction f = new PolynomFunction(6);
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 3.3, 6.7, 12.5, 25.0, 50.0, 75.0, 87.5, 93.5, 97.0, 100.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 1.5);
        System.out.println("X: 1.5   Y: " + y);
        y = f.getValue(fit, 4.5);
        System.out.println("X: 4.5   Y: " + y);
        y = f.getValue(fit, 5.5);
        System.out.println("X: 5.5   Y: " + y);
        y = f.getValue(fit, 8.5);
        System.out.println("X: 8.5   Y: " + y);
        y = f.getValue(fit, 9.5);
        System.out.println("X: 9.5   Y: " + y);
        System.out.println("parname0 = " + f.getParameterName(0));
        System.out.println("parname6 = " + f.getParameterName(6));
    }

    public void testQuadraticFunction() {
        QuadraticFunction f = new QuadraticFunction();
        double[] x_values = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0};
        double[] y_values = new double[]{0.0, 0.7, 1.2, 1.6, 1.8, 2.0, 1.8, 1.6, 1.2, 0.7, 0.0};
        double[] sigma = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
        ArrayOp.dumpArray("X:   ", x_values, 11, 4);
        ArrayOp.dumpArray("Y:   ", y_values, 11, 4);
        double[] fit = f.fit(x_values, y_values, sigma, 1.0E-8);
        ArrayOp.dumpArray("Start: ", f.getStartParameters(x_values, y_values), 11, 4);
        ArrayOp.dumpArray("Fit:   ", fit, 11, 4);
        System.out.println("Iterations: " + f.getIterations() + "   R^2: " + f.getCorrelationOfDetermination());
        double y = f.getValue(fit, 4.5);
        System.out.println("X: 4.5   Y: " + y);
        y = f.getValue(fit, 9.5);
        System.out.println("X: 9.5   Y: " + y);
        System.out.println("Y: " + y + "  X: " + f.getXValue(fit, y));
        f.setParameters(fit);
        System.out.println("Y: " + y + "  X: " + f.getXValue(y));
    }
}

