/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.math.stattests;

import JSci.maths.statistics.FDistribution;
import at.tugraz.genome.math.MathFunctions;
import at.tugraz.genome.math.stattests.AnovaOutcomeData;
import java.util.Vector;

public class OneWayAnova {
    public static void main(String[] args) {
        float[] x_in1 = new float[]{3.0f, 5.0f, 3.0f, 5.0f};
        float[] y_in1 = new float[]{2.0f, 2.0f, 4.0f, 4.0f};
        float[] z_in1 = new float[]{2.0f, 1.0f, 3.0f, 2.0f};
        float[] x_in2 = new float[]{3.0f, 5.0f, 3.0f, 5.0f};
        float[] y_in2 = new float[]{2.0f, 2.0f, 4.0f, 4.0f};
        float[] z_in2 = new float[]{2.0f, 1.0f, 3.0f, 2.0f};
        float[] x_in3 = new float[]{3.0f, 5.0f, 3.0f, 5.0f};
        float[] y_in3 = new float[]{2.0f, 2.0f, 4.0f, 4.0f};
        float[] z_in3 = new float[]{2.0f, 1.0f, 3.0f, 2.0f};
        float[][] x_a = new float[3][4];
        x_a[0] = x_in1;
        x_a[1] = x_in2;
        x_a[2] = x_in3;
        float[][] x_b = new float[3][4];
        x_b[0] = y_in1;
        x_b[1] = y_in2;
        x_b[2] = y_in3;
        float[][] x_c = new float[3][4];
        x_c[0] = z_in1;
        x_c[1] = z_in2;
        x_c[2] = z_in3;
        Vector<float[][]> sepp_in = new Vector<float[][]>();
        sepp_in.add(x_a);
        sepp_in.add(x_b);
        sepp_in.add(x_c);
        AnovaOutcomeData[] results = OneWayAnova.multipleOneWayAnova(sepp_in, 0.05);
        System.out.println("how many anovas:: " + results.length);
        int i = 0;
        while (i < results.length) {
            results[i].printOutcomeData();
            ++i;
        }
    }

    public static AnovaOutcomeData[] multipleOneWayAnova(Vector data, double alpha) {
        Vector<float[]> give_it_to_anova = new Vector<float[]>();
        int num_groups = data.size();
        int num_anovas = ((float[][])data.get(0)).length;
        double[] p_values = new double[num_anovas];
        AnovaOutcomeData[] anova_results = new AnovaOutcomeData[num_anovas];
        int i_ = 0;
        while (i_ < num_anovas) {
            int j_ = 0;
            while (j_ < num_groups) {
                give_it_to_anova.add(((float[][])data.get(j_))[i_]);
                ++j_;
            }
            anova_results[i_] = OneWayAnova.oneWayAnova(give_it_to_anova, alpha);
            give_it_to_anova.clear();
            ++i_;
        }
        return anova_results;
    }

    public static AnovaOutcomeData oneWayAnova(Vector data_in, double alpha) {
        double p_value;
        boolean signific = false;
        int num_of_groups = data_in.size();
        int[] sampsize_group = new int[num_of_groups];
        int i = 0;
        while (i < num_of_groups) {
            sampsize_group[i] = MathFunctions.countReliableValues((float[])data_in.get(0));
            ++i;
        }
        int samplesize_total = MathFunctions.sum(sampsize_group);
        float dummy_sum = 0.0f;
        int i2 = 0;
        while (i2 < num_of_groups) {
            dummy_sum += MathFunctions.sum((float[])data_in.get(i2));
            ++i2;
        }
        float general_mean = dummy_sum / (float)samplesize_total;
        dummy_sum = 0.0f;
        int i3 = 0;
        while (i3 < num_of_groups) {
            float[] temp1 = MathFunctions.subtractFromArray((float[])data_in.get(i3), general_mean);
            temp1 = MathFunctions.powerArray(temp1, 2);
            dummy_sum += MathFunctions.sum(temp1);
            ++i3;
        }
        float sst = dummy_sum;
        float[] mean_group = new float[num_of_groups];
        dummy_sum = 0.0f;
        int i4 = 0;
        while (i4 < num_of_groups) {
            mean_group[i4] = MathFunctions.mean((float[])data_in.get(i4));
            ++i4;
        }
        double ssb = 0.0;
        int i5 = 0;
        while (i5 < num_of_groups) {
            double temp2 = Math.pow(mean_group[i5] - general_mean, 2.0);
            ssb += (double)sampsize_group[i5] * temp2;
            ++i5;
        }
        double msb = ssb / (double)(num_of_groups - 1);
        float sse = 0.0f;
        int i6 = 0;
        while (i6 < num_of_groups) {
            float[] temp3 = MathFunctions.powerArray(MathFunctions.subtractFromArray((float[])data_in.get(i6), mean_group[i6]), 2);
            sse += MathFunctions.sum(temp3);
            ++i6;
        }
        float mse = sse / (float)(samplesize_total - num_of_groups);
        double f_stat = msb / (double)mse;
        int df_groups = num_of_groups - 1;
        int df_error = samplesize_total - num_of_groups;
        if (df_groups > 0 && df_error > 0) {
            FDistribution f_distribution = new FDistribution(df_groups, df_error);
            p_value = 1.0f - (float)f_distribution.cumulative(f_stat);
        } else {
            p_value = Double.NaN;
        }
        if (p_value < alpha) {
            signific = true;
        }
        AnovaOutcomeData outcome = new AnovaOutcomeData();
        outcome.setDf_error_(df_error);
        outcome.setDf_groups_(df_groups);
        outcome.setF_stat_(f_stat);
        outcome.setMsa_(msb);
        outcome.setMse_(mse);
        outcome.setP_value_(p_value);
        outcome.setSsa_(ssb);
        outcome.setSse_(sse);
        outcome.setSst_(sst);
        outcome.setSignificant_(signific);
        outcome.setGroup_means_(mean_group);
        return outcome;
    }
}

