/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class AboutDialogSettings {
    private static final String FROMADDR = "From_Address";
    private static final String MAILSRV = "Outgoing_Mail_Server";
    private static final String TOADDR = "Destination_Address";
    private static final String TUGSETTINGS = "TUGUtilities_Settings";
    private Properties TUGSettings = new Properties();
    private String TUGSettingsHeader = "TUGUtilities_Settings *!!! DO NOT EDIT THIS FILE !!!* ";
    private File fileName = new File(System.getProperty("user.home") + System.getProperty("file.separator") + "TUGUtilies_settings");
    private String fromAddress = "";
    private String outgoingMailServer = "";
    private String toAddress = "";

    public String getFromAddress() {
        return this.fromAddress;
    }

    public String getOutgoingMailServer() {
        return this.outgoingMailServer;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void loadSettings() {
        try {
            if (this.fileName.exists()) {
                FileInputStream in = new FileInputStream(this.fileName);
                this.TUGSettings.load(in);
                in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fromAddress = this.TUGSettings.getProperty(FROMADDR);
        this.outgoingMailServer = this.TUGSettings.getProperty(MAILSRV);
        this.toAddress = this.TUGSettings.getProperty(TOADDR);
    }

    public static void main(String[] arg) {
        AboutDialogSettings email = new AboutDialogSettings();
        email.setEmailSettings("slave@proba.com", "mail.slave.com", "support@proba.com");
        email.saveSettings();
        System.out.println("Finished!\n" + email.getFromAddress() + "\n" + email.getOutgoingMailServer() + "\n" + email.getToAddress());
    }

    public boolean saveSettings() {
        try {
            FileOutputStream out = new FileOutputStream(this.fileName);
            this.TUGSettings.setProperty(FROMADDR, this.fromAddress);
            this.TUGSettings.setProperty(MAILSRV, this.outgoingMailServer);
            this.TUGSettings.setProperty(TOADDR, this.toAddress);
            this.TUGSettings.store(out, this.TUGSettingsHeader);
            out.close();
            return true;
        }
        catch (IOException e) {
            System.err.println(e);
            e.printStackTrace();
            return false;
        }
    }

    public void setEmailSettings(String fromAddress, String outgoingMailServer, String toAddress) {
        this.fromAddress = fromAddress;
        this.outgoingMailServer = outgoingMailServer;
        this.toAddress = toAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setOutgoingMailServer(String outgoingMailServer) {
        this.outgoingMailServer = outgoingMailServer;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }
}

