/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class PrintPreviewImagePanel
extends JComponent {
    private double imageableHeight_ = 100.0;
    private double imageableWidth_ = 100.0;
    private double imageableX_ = 0.0;
    private double imageableY_ = 0.0;
    private int orientation_ = 0;
    private double pageHeight_ = 100.0;
    private double pageWidth_ = 100.0;
    private BufferedImage previewImage_ = null;

    public PrintPreviewImagePanel(BufferedImage previewImage, double imageableX, double imageableY, double imageableWidth, double imageableHeight, double pageWidth, double pageHeight) {
        this.previewImage_ = previewImage;
        this.imageableX_ = imageableX;
        this.imageableY_ = imageableY;
        this.imageableWidth_ = imageableWidth;
        this.imageableHeight_ = imageableHeight;
        this.pageWidth_ = pageWidth;
        this.pageHeight_ = pageHeight;
    }

    private PrintPreviewImagePanel() {
    }

    public Dimension getPreferredSize() {
        return new Dimension((int)Math.round(this.pageWidth_), (int)Math.round(this.pageHeight_));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setBackground(Color.darkGray);
            g2.setColor(Color.white);
            Rectangle rect = new Rectangle(0, 0, (int)this.pageWidth_, (int)this.pageHeight_);
            g2.fill(rect);
            AffineTransform af = new AffineTransform();
            double scaleX = this.imageableWidth_ / (double)this.previewImage_.getWidth();
            double scaleY = this.imageableHeight_ / (double)this.previewImage_.getHeight();
            double scale = Math.min(scaleX, scaleY);
            double dummyX = (double)this.previewImage_.getWidth() * scale;
            double dummyY = (double)this.previewImage_.getHeight() * scale;
            if (dummyX < this.imageableWidth_) {
                dummyX = this.imageableWidth_ - dummyX;
                dummyX /= 2.0;
            } else {
                dummyX = 0.0;
            }
            if (dummyY < this.imageableHeight_) {
                dummyY = this.imageableHeight_ - dummyY;
                dummyY /= 2.0;
            } else {
                dummyY = 0.0;
            }
            af.translate(this.imageableX_ + dummyX, this.imageableY_ + dummyY);
            af.scale(scale, scale);
            if (this.orientation_ == 2) {
                af.rotate(Math.toRadians(180.0));
                af.translate(-((double)this.previewImage_.getWidth()) * scale, -((double)this.previewImage_.getHeight()) * scale);
            }
            g2.drawImage(this.previewImage_, af, null);
        }
    }

    public void setImageableHeight(double imageableHeight) {
        this.imageableHeight_ = imageableHeight;
    }

    public void setImageableWidth(double imageableWidth) {
        this.imageableWidth_ = imageableWidth;
    }

    public void setImageableX(double imageableX) {
        this.imageableX_ = imageableX;
    }

    public void setImageableY(double imageableY) {
        this.imageableY_ = imageableY;
    }

    public void setOrientation(int orientation) {
        this.orientation_ = orientation;
    }

    public void setPageHeight(double pageHeight) {
        this.pageHeight_ = pageHeight;
    }

    public void setPageWidth(double pageWidth) {
        this.pageWidth_ = pageWidth;
    }
}

