/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils;

import at.tugraz.genome.utils.PrintPreviewImagePanel;
import at.tugraz.genome.utils.PrintPreviewPanel_closeButton_actionAdapter;
import at.tugraz.genome.utils.PrintPreviewPanel_printButton_actionAdapter;
import at.tugraz.genome.utils.PrintPreviewPanel_printDialogButton_actionAdapter;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.ImageEncoder;
import com.sun.media.jai.codec.PNGEncodeParam;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.SimpleDoc;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PrintPreviewPanel
extends JPanel {
    private PrintRequestAttributeSet aSet_;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel buttonPanel;
    private JButton closeButton;
    private JScrollPane imageScrollPane = new JScrollPane();
    private BufferedImage image_ = null;
    private double imageableHeight_ = 100.0;
    private double imageableWidth_ = 100.0;
    private double imageableX_ = 0.0;
    private double imageableY_ = 0.0;
    private JDialog invoker_ = null;
    private double pageHeight_ = 100.0;
    private double pageWidth_ = 100.0;
    private PageFormat pf_ = null;
    private PrintPreviewImagePanel previewImagePanel_ = null;
    private JButton printButton;
    private JButton printDialogButton;

    private PrintPreviewPanel() {
        this.buttonPanel = new JPanel();
        this.printButton = new JButton();
        this.printDialogButton = new JButton();
        this.closeButton = new JButton();
        this.aSet_ = new HashPrintRequestAttributeSet();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public PrintPreviewPanel(JDialog invoker, PageFormat pf, BufferedImage image, double imageableX, double imageableY, double imageableWidth, double imageableHeight, double pageWidth, double pageHeight) {
        this.buttonPanel = new JPanel();
        this.printButton = new JButton();
        this.printDialogButton = new JButton();
        this.closeButton = new JButton();
        this.aSet_ = new HashPrintRequestAttributeSet();
        try {
            this.invoker_ = invoker;
            this.pf_ = pf;
            this.image_ = image;
            this.imageableX_ = imageableX;
            this.imageableY_ = imageableY;
            this.imageableWidth_ = imageableWidth;
            this.imageableHeight_ = imageableHeight;
            this.pageWidth_ = pageWidth;
            this.pageHeight_ = pageHeight;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void closeButton_actionPerformed(ActionEvent e) {
        this.invoker_.dispose();
    }

    void jbInit() throws Exception {
        this.previewImagePanel_ = new PrintPreviewImagePanel(this.image_, this.imageableX_, this.imageableY_, this.imageableWidth_, this.imageableHeight_, this.pageWidth_, this.pageHeight_);
        this.setLayout(this.borderLayout1);
        this.printButton.setText("Print");
        this.printButton.addActionListener(new PrintPreviewPanel_printButton_actionAdapter(this));
        this.printDialogButton.setText("Page Format");
        this.printDialogButton.addActionListener(new PrintPreviewPanel_printDialogButton_actionAdapter(this));
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new PrintPreviewPanel_closeButton_actionAdapter(this));
        this.add((Component)this.buttonPanel, "North");
        this.buttonPanel.add((Component)this.printButton, null);
        this.buttonPanel.add((Component)this.printDialogButton, null);
        this.buttonPanel.add((Component)this.closeButton, null);
        this.add((Component)this.imageScrollPane, "Center");
        this.imageScrollPane.getViewport().add((Component)this.previewImagePanel_, null);
    }

    void printButton_actionPerformed(ActionEvent aEvt) {
        boolean errorOccured = false;
        ByteArrayOutputStream out = null;
        try {
            out = new ByteArrayOutputStream();
            PNGEncodeParam encodeParam = PNGEncodeParam.getDefaultEncodeParam((RenderedImage)this.image_);
            ImageEncoder encoder = ImageCodec.createImageEncoder((String)"PNG", (OutputStream)out, (ImageEncodeParam)encodeParam);
            encoder.encode((RenderedImage)this.image_);
        }
        catch (Exception e) {
            errorOccured = true;
        }
        if (out != null && !errorOccured) {
            PrintService service;
            DocFlavor.BYTE_ARRAY flavor = DocFlavor.BYTE_ARRAY.PNG;
            SimpleDoc doc = new SimpleDoc(out.toByteArray(), flavor, null);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            if (printerJob.printDialog(this.aSet_) && (service = printerJob.getPrintService()) != null) {
                DocPrintJob printJob = service.createPrintJob();
                try {
                    printJob.print(doc, this.aSet_);
                }
                catch (PrintException pExc) {
                    errorOccured = true;
                }
            }
        } else {
            errorOccured = true;
        }
        if (errorOccured) {
            errorOccured = false;
            JOptionPane.showConfirmDialog(this, "Error occured during printing", "Error", 0, 0);
        }
    }

    void printDialogButton_actionPerformed(ActionEvent e) {
        this.pf_ = PrinterJob.getPrinterJob().pageDialog(this.aSet_);
        if (this.pf_ != null) {
            this.previewImagePanel_.setPageHeight(this.pf_.getHeight());
            this.previewImagePanel_.setPageWidth(this.pf_.getWidth());
            this.previewImagePanel_.setImageableHeight(this.pf_.getImageableHeight());
            this.previewImagePanel_.setImageableWidth(this.pf_.getImageableWidth());
            this.previewImagePanel_.setImageableX(this.pf_.getImageableX());
            this.previewImagePanel_.setImageableY(this.pf_.getImageableY());
            this.previewImagePanel_.revalidate();
            this.previewImagePanel_.repaint();
            this.previewImagePanel_.setOrientation(this.pf_.getOrientation());
        }
    }
}

