/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.Gammq;

class Fit {
    Fit() {
    }

    public static void fit(DoubleRef[] x, DoubleRef[] y, int ndata, DoubleRef[] sig, int mwt, DoubleRef a, DoubleRef b, DoubleRef siga, DoubleRef sigb, DoubleRef chi2, DoubleRef q) {
        double t;
        int i;
        double ss;
        double sx = 0.0;
        double sy = 0.0;
        double st2 = 0.0;
        b.value = 0.0;
        if (mwt != 0) {
            ss = 0.0;
            i = 0;
            while (i < ndata) {
                double wt = 1.0 / Math.pow(sig[i].value, 2.0);
                ss += wt;
                sx += x[i].value * wt;
                sy += y[i].value * wt;
                ++i;
            }
        } else {
            i = 0;
            while (i < ndata) {
                sx += x[i].value;
                sy += y[i].value;
                ++i;
            }
            ss = ndata;
        }
        double sxoss = sx / ss;
        if (mwt != 0) {
            i = 0;
            while (i < ndata) {
                t = (x[i].value - sxoss) / sig[i].value;
                st2 += Math.pow(t, 2.0);
                b.value += t * y[i].value / sig[i].value;
                ++i;
            }
        } else {
            i = 0;
            while (i < ndata) {
                t = x[i].value - sxoss;
                st2 += Math.pow(t, 2.0);
                b.value += t * y[i].value;
                ++i;
            }
        }
        b.value /= st2;
        a.value = (sy - sx * b.value) / ss;
        siga.value = Math.sqrt((1.0 + sx * sx / (ss * st2)) / ss);
        sigb.value = Math.sqrt(1.0 / st2);
        chi2.value = 0.0;
        q.value = 1.0;
        if (mwt == 0) {
            i = 0;
            while (i < ndata) {
                chi2.value += Math.pow(y[i].value - a.value - b.value * x[i].value, 2.0);
                ++i;
            }
            double sigdat = Math.sqrt(chi2.value / (double)(ndata - 2));
            siga.value *= sigdat;
            sigb.value *= sigdat;
        } else {
            i = 0;
            while (i < ndata) {
                chi2.value += Math.pow((y[i].value - a.value - b.value * x[i].value) / sig[i].value, 2.0);
                ++i;
            }
            if (ndata > 2) {
                q.value = Gammq.gammq(0.5 * (double)(ndata - 2), 0.5 * chi2.value);
            }
        }
    }
}

