/*
 * Decompiled with CFR 0.152.
 */
package at.tugraz.genome.utils.straightlinedata;

import at.tugraz.genome.utils.straightlinedata.Constants;
import at.tugraz.genome.utils.straightlinedata.DoubleRef;
import at.tugraz.genome.utils.straightlinedata.MnbrakPararmeterFunction;

class Mnbrak {
    Mnbrak() {
    }

    public static void mnbrak(DoubleRef ax, DoubleRef bx, DoubleRef cx, DoubleRef fa, DoubleRef fb, DoubleRef fc, MnbrakPararmeterFunction func) {
        DoubleRef dum = new DoubleRef();
        fa.value = func.execute(ax.value);
        fb.value = func.execute(bx.value);
        if (fb.value > fa.value) {
            Constants.shft(dum, ax, bx, dum);
            Constants.shft(dum, fb, fa, dum);
        }
        cx.value = bx.value + 1.618034 * (bx.value - ax.value);
        fc.value = func.execute(cx.value);
        while (fb.value > fc.value) {
            double fu;
            double r = (bx.value - ax.value) * (fb.value - fc.value);
            double q = (bx.value - cx.value) * (fb.value - fa.value);
            double u = bx.value - ((bx.value - cx.value) * q - (bx.value - ax.value) * r) / (2.0 * Constants.sign(Math.max(Math.abs(q - r), 1.0E-20), q - r));
            double ulim = bx.value + 100.0 * (cx.value - bx.value);
            if ((bx.value - u) * (u - cx.value) > 0.0) {
                fu = func.execute(u);
                if (fu < fc.value) {
                    ax.value = bx.value;
                    bx.value = u;
                    fa.value = fb.value;
                    fb.value = fu;
                    return;
                }
                if (fu > fb.value) {
                    cx.value = u;
                    fc.value = fu;
                    return;
                }
                u = cx.value + 1.618034 * (cx.value - bx.value);
                fu = func.execute(u);
            } else if ((cx.value - u) * (u - ulim) > 0.0) {
                fu = func.execute(u);
                if (fu < fc.value) {
                    DoubleRef uRef = new DoubleRef(u);
                    Constants.shft(bx, cx, uRef, new DoubleRef(cx.value + 1.618034 * (cx.value - bx.value)));
                    u = uRef.value;
                    DoubleRef fuRef = new DoubleRef(fu);
                    Constants.shft(fb, fc, fuRef, new DoubleRef(func.execute(u)));
                    fu = fuRef.value;
                }
            } else if ((u - ulim) * (ulim - cx.value) >= 0.0) {
                u = ulim;
                fu = func.execute(u);
            } else {
                u = cx.value + 1.618034 * (cx.value - bx.value);
                fu = func.execute(u);
            }
            Constants.shft(ax, bx, cx, new DoubleRef(u));
            Constants.shft(fa, fb, fc, new DoubleRef(fu));
        }
    }
}

