/*
 * Decompiled with CFR 0.152.
 */
package com.borland.jbcl.editors;

import com.borland.jb.util.FastStringBuffer;
import com.borland.jbcl.control.TreeItems;
import com.borland.jbcl.editors.StringEditor;
import com.borland.jbcl.editors.TreeItemsEditorPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;

public class TreeItemsEditor
implements PropertyEditor {
    static final String NULLSTRING = "null";
    TreeItemsEditorPanel editorPanel = new TreeItemsEditorPanel();
    PropertyChangeListener listener;
    String[] value;

    public void setValue(Object o) {
        String[] sa = (String[])o;
        this.value = sa;
        if (sa != null && this.editorPanel != null) {
            this.editorPanel.tree.setItems(this.value);
            this.editorPanel.checkButtons();
        }
    }

    public Object getValue() {
        if (this.editorPanel != null) {
            TreeItems ti = new TreeItems(this.editorPanel.tree.getModel());
            this.value = ti.getItems();
        }
        return this.value;
    }

    public boolean isPaintable() {
        return false;
    }

    public void paintValue(Graphics g, Rectangle box) {
    }

    public String getAsText() {
        return TreeItemsEditor.stringArrayToText(this.value);
    }

    public String getJavaInitializationString() {
        return TreeItemsEditor.javaInitializationForArrayOfStrings(this.value);
    }

    public static final String javaInitializationForArrayOfStrings(String[] strings) {
        if (strings == null || strings.length == 0) {
            return NULLSTRING;
        }
        int lineLength = 0;
        FastStringBuffer fsb = new FastStringBuffer("new String[] {");
        for (int i = 0; i < strings.length; ++i) {
            fsb.append(StringEditor.textToSource(strings[i]));
            if (i + 1 < strings.length) {
                fsb.append(", ");
            }
            if (strings[i] == null || (lineLength += strings[i].length()) <= 92) continue;
            lineLength = 0;
            fsb.append("\n        ");
        }
        fsb.append("}");
        return fsb.toString();
    }

    public void setAsText(String text) throws IllegalArgumentException {
        this.value = TreeItemsEditor.textToStringArray(text);
        this.editorPanel.tree.setItems(this.value);
        this.editorPanel.checkButtons();
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        if (this.editorPanel == null) {
            this.editorPanel = new TreeItemsEditorPanel();
        }
        this.editorPanel.checkButtons();
        return this.editorPanel;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listener = l;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listener = null;
    }

    private void fire() {
        if (this.listener != null) {
            this.listener.propertyChange(new PropertyChangeEvent(this, "TreeItemsEditor???", null, this.value));
        }
    }

    private static final String stringArrayToText(String[] array) {
        FastStringBuffer fsb = new FastStringBuffer("");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                fsb.append(String.valueOf(String.valueOf(array[i])).concat("\n"));
            }
        }
        return fsb.toString();
    }

    private static final String[] textToStringArray(String text) {
        int end;
        int textLength = text.length();
        int e = 0;
        int start = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            start = end + 1;
            ++e;
        }
        if (start < text.length()) {
            ++e;
        }
        String[] array = new String[e];
        start = 0;
        e = 0;
        while ((end = text.indexOf(10, start)) != -1) {
            array[e] = text.substring(start, end);
            start = end + 1;
            ++e;
        }
        if (start < text.length()) {
            array[e] = text.substring(start);
        }
        return array;
    }

    static {
        NULLSTRING = NULLSTRING;
    }
}

