/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.JCFieldComponent;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.util.JCDebug;
import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class JCFormUtil {
    private static void addFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCFieldComponent) {
                set.add(componentArray[n]);
            } else if (componentArray[n] instanceof Container) {
                JCFormUtil.addFieldChildrenToSet((Container)componentArray[n], set);
            }
            ++n;
        }
    }

    private static void addInvalidRequiredFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCFieldComponent) {
                JCFieldComponent jCFieldComponent = (JCFieldComponent)((Object)componentArray[n]);
                if (jCFieldComponent.isRequired()) {
                    if (jCFieldComponent.getState() == 2) {
                        jCFieldComponent.commitEdit();
                    }
                    if (jCFieldComponent.getState() != 1) {
                        set.add(componentArray[n]);
                    }
                }
            } else if (componentArray[n] instanceof Container) {
                JCFormUtil.addInvalidRequiredFieldChildrenToSet((Container)componentArray[n], set);
            }
            ++n;
        }
    }

    private static void addRequiredFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JCFieldComponent) {
                JCFieldComponent jCFieldComponent = (JCFieldComponent)((Object)componentArray[n]);
                if (jCFieldComponent.isRequired()) {
                    set.add(componentArray[n]);
                }
            } else if (componentArray[n] instanceof Container) {
                JCFormUtil.addRequiredFieldChildrenToSet((Container)componentArray[n], set);
            }
            ++n;
        }
    }

    public static void clearFieldComponents(Container container) {
        Set set = JCFormUtil.getFieldComponents(container);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JCFieldComponent jCFieldComponent = (JCFieldComponent)iterator.next();
            Object object = jCFieldComponent.getValue();
            JCInvalidInfo jCInvalidInfo = jCFieldComponent.getInvalidInfo();
            jCInvalidInfo.setBeepOnInvalid(false);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
            JCDebug.println("field", "Clearing Field \"" + ((Component)((Object)jCFieldComponent)).getName() + "\"");
            jCFieldComponent.setValue(null);
            jCInvalidInfo.setBeepOnInvalid(true);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
        }
    }

    public static Set getFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    public static Set getInvalidRequiredFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addInvalidRequiredFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    public static Set getRequiredFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addRequiredFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    public static boolean isFieldComponentContainerComplete(Container container) {
        Set set = JCFormUtil.getInvalidRequiredFieldComponents(container);
        return set == null || set.size() == 0;
    }

    public static void resetFieldComponents(Container container) {
        Set set = JCFormUtil.getFieldComponents(container);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            JCFieldComponent jCFieldComponent = (JCFieldComponent)iterator.next();
            Object object = jCFieldComponent.getValue();
            JCInvalidInfo jCInvalidInfo = jCFieldComponent.getInvalidInfo();
            jCInvalidInfo.setBeepOnInvalid(false);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
            JCDebug.println("field", "Clearing Field \"" + ((Component)((Object)jCFieldComponent)).getName() + "\"");
            jCFieldComponent.setValue(jCFieldComponent.getValidator().getDefaultValue());
            jCInvalidInfo.setBeepOnInvalid(true);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
        }
    }
}

