/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.JCCircularGauge;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCenter
extends JComponent
implements Serializable {
    static final long serialVersionUID = -6109621100945071720L;
    protected JCCircularGauge gauge;
    protected Image image;
    protected Color foreground = Color.black;
    protected boolean scaleImage = true;
    protected double radius = 0.1;

    public JCCenter(JCCircularGauge jCCircularGauge) {
        this.gauge = jCCircularGauge;
        this.setForeground(this.foreground);
    }

    public JCCenter(JCCircularGauge jCCircularGauge, Color color, double d) {
        this.gauge = jCCircularGauge;
        this.radius = d;
        this.setForeground(color);
    }

    public JCCenter(JCCircularGauge jCCircularGauge, Color color, Image image) {
        this.gauge = jCCircularGauge;
        this.image = image;
        this.setForeground(color);
    }

    protected void drawDisc(Graphics graphics) {
        int n = 0;
        int n2 = 360;
        graphics.fillArc(0, 0, this.getWidth(), this.getHeight(), n, n2);
    }

    protected void drawImage(Graphics graphics) {
        JLabel jLabel = new JLabel();
        int n = this.image.getWidth(jLabel);
        int n2 = this.image.getHeight(jLabel);
        if (this.scaleImage) {
            graphics.drawImage(this.image, 0, 0, this.getWidth(), this.getHeight(), this.foreground, jLabel);
        } else {
            graphics.drawImage(this.image, 0, 0, this.foreground, jLabel);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public Dimension getPreferredSize() {
        int n = (int)(this.gauge.getScale().getRadius() * this.radius) * 2;
        return new Dimension(n, n);
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean getScaleImage() {
        return this.scaleImage;
    }

    public void paintComponent(Graphics graphics) {
        if (this.radius != 0.0 || this.image != null) {
            if (this.image != null) {
                this.drawImage(graphics);
            } else {
                this.drawDisc(graphics);
            }
        }
    }

    public void redraw() {
        if (this.gauge.getRepaintEnabled()) {
            this.repaint();
        }
    }

    public void setImage(Image image) {
        this.image = image;
        this.redraw();
    }

    public void setRadius(double d) {
        this.radius = d;
        this.revalidate();
    }

    public void setScaleImage(boolean bl) {
        this.scaleImage = bl;
        this.redraw();
    }
}

