/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.JCTick;
import com.klg.jclass.swing.gauge.JCTickStyle;
import com.klg.jclass.swing.gauge.RadialConstraint;
import com.klg.jclass.swing.gauge.RadialLayout;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Polygon;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class JCCircularTick
extends JCTick
implements Serializable {
    static final long serialVersionUID = 8728930458871001670L;

    public JCCircularTick(JCCircularScale jCCircularScale) {
        super(jCCircularScale, jCCircularScale.getMin(), jCCircularScale.getMax());
        this.setLayout(new RadialLayout());
    }

    public JCCircularTick(JCCircularScale jCCircularScale, boolean bl, double d, double d2, double d3, boolean bl2, int n, double d4, boolean bl3, boolean bl4, double d5, double d6, double d7, Color color, JCTickStyle jCTickStyle, Font font, Color color2) {
        super(jCCircularScale, bl, d, d2, d3, bl2, n, d4, bl3, bl4, d5, d6, d7, color, jCTickStyle, font, color2);
        this.setLayout(new RadialLayout());
    }

    protected void drawTick(Graphics graphics, double d, double d2, double d3) {
        double d4 = (double)this.scale.getGauge().getArcBounds().x + this.scale.getRadius();
        double d5 = (double)this.scale.getGauge().getArcBounds().y + this.scale.getRadius();
        double d6 = d3 - d2;
        double d7 = d6 / 2.0;
        double d8 = d2 + d7;
        int n = (int)d4 + (int)(d8 * Math.cos(GaugeUtil.toRadians(d)));
        int n2 = (int)d5 - (int)(d8 * Math.sin(GaugeUtil.toRadians(d)));
        Graphics graphics2 = graphics.create();
        graphics2.setColor(this.tickColor);
        if (this.tickStyle == JCTickStyle.CIRCLE) {
            graphics2.fillArc(n -= (int)d7, n2 -= (int)d7, (int)d6, (int)d6, 0, 360);
        } else {
            double d9 = d6 / (double)(this.tickStyle.getExtrema().x - this.tickStyle.getExtrema().width);
            double d10 = this.getTickWidth() / (double)(this.tickStyle.getExtrema().y - this.tickStyle.getExtrema().height);
            Polygon polygon = GaugeUtil.scale(this.tickStyle, Math.abs(d9), Math.abs(d10));
            Polygon polygon2 = GaugeUtil.rotate(polygon, d);
            graphics2.translate(n, n2);
            graphics2.fillPolygon(polygon2);
        }
        graphics2.dispose();
    }

    public Dimension getPreferredSize() {
        return this.scale.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = false;
        super.paintComponent(graphics);
        if (this.automatic) {
            this.calcTicks(graphics);
        }
        double d = this.scale.getMin();
        double d2 = this.scale.getMax();
        double d3 = (double)this.scale.getGauge().getArcBounds().x + this.scale.getRadius();
        double d4 = (double)this.scale.getGauge().getArcBounds().y + this.scale.getRadius();
        double d5 = this.scale.getRadius();
        double d6 = this.scale.getStartAngle();
        double d7 = this.scale.getStopAngle();
        JCScale.Direction direction = this.scale.getDirection();
        double d8 = Math.max(0.0, this.innerExtent);
        double d9 = Math.max(0.0, this.outerExtent);
        double d10 = Math.max(0.0, this.labelExtent);
        if (d8 > d9) {
            double d11 = d8;
            d8 = d9;
            d9 = d11;
        }
        d8 *= d5;
        d9 *= d5;
        double d12 = this.startValue;
        while (d12 <= this.stopValue && d12 <= d2 && this.incrementValue != 0.0) {
            if (d12 < d) {
                d12 += this.incrementValue;
                continue;
            }
            if (bl && this.automatic && (d12 == this.stopValue || 1.0 + Math.abs(this.stopValue - d12) == 1.0)) break;
            double d13 = direction == JCScale.Direction.COUNTERCLOCKWISE ? d12 : d2 - d12 + d;
            double d14 = GaugeUtil.valueToAngle(d13, d, d2, d6, d7);
            double d15 = GaugeUtil.toRadians(d14);
            if (this.drawTicks && d8 != d9) {
                if (this.tickStyle == JCTickStyle.LINE) {
                    Graphics graphics2 = graphics.create();
                    graphics2.setColor(this.tickColor);
                    int n = (int)d3 + (int)(d8 * Math.cos(d15));
                    int n2 = (int)d4 - (int)(d8 * Math.sin(d15));
                    int n3 = (int)d3 + (int)(d9 * Math.cos(d15));
                    int n4 = (int)d4 - (int)(d9 * Math.sin(d15));
                    graphics2.drawLine(n, n2, n3, n4);
                    graphics2.dispose();
                } else {
                    this.drawTick(graphics, d14, d8, d9);
                }
            }
            d12 += this.incrementValue;
        }
    }

    public void redraw(boolean bl) {
        if (this.scale.getGauge().getRepaintEnabled()) {
            if (bl) {
                this.redrawLabels();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void redrawLabels() {
        if (this.drawLabels) {
            Graphics graphics;
            this.removeAll();
            double d = this.scale.getMin();
            double d2 = this.scale.getMax();
            double d3 = (double)this.scale.getGauge().getArcBounds().x + this.scale.getRadius();
            double d4 = (double)this.scale.getGauge().getArcBounds().y + this.scale.getRadius();
            double d5 = this.scale.getRadius();
            double d6 = this.scale.getStartAngle();
            double d7 = this.scale.getStopAngle();
            if (this.automatic && (graphics = this.getGraphics()) != null) {
                this.calcTicks(graphics);
            }
            if (d6 >= d7) {
                d7 += 360.0;
            }
            boolean bl = d6 == d7;
            double d8 = Math.max(0.0, this.labelExtent);
            double d9 = this.startValue;
            while (d9 <= this.stopValue && d9 <= d2 && this.incrementValue != 0.0) {
                if (d9 < d) {
                    d9 += this.incrementValue;
                    continue;
                }
                if (bl && this.automatic && (d9 == this.stopValue || 1.0 + Math.abs(this.stopValue - d9) == 1.0)) break;
                double d10 = d9;
                if (this.scale.getDirection() == JCScale.Direction.CLOCKWISE) {
                    d10 = d2 - d9 + d;
                }
                double d11 = GaugeUtil.valueToAngle(d10, d, d2, 0.0, GaugeUtil.arcAngle(d6, d7));
                JComponent jComponent = null;
                RadialConstraint radialConstraint = new RadialConstraint(this.scale.getGauge(), d8, d11);
                if (this.labelGenerator != null) {
                    jComponent = this.labelGenerator.makeLabel(this, d9, radialConstraint);
                } else {
                    String string = JCNumberUtil.format(d9, this.precision);
                    jComponent = new JLabel(string);
                    jComponent.setFont(this.getFont());
                    jComponent.setForeground(this.fontColor);
                }
                jComponent.setSize(jComponent.getPreferredSize());
                this.add((Component)jComponent, radialConstraint);
                d9 += this.incrementValue;
            }
        }
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.redrawLabels();
    }
}

