/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.swing.gauge;

import com.klg.jclass.swing.gauge.GaugeUtil;
import com.klg.jclass.swing.gauge.JCCircularGauge;
import com.klg.jclass.swing.gauge.JCCircularScale;
import com.klg.jclass.swing.gauge.JCCircularTick;
import com.klg.jclass.swing.gauge.JCScale;
import com.klg.jclass.swing.gauge.RadialConstraint;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.Vector;

public class RadialLayout
implements LayoutManager2,
Serializable {
    static final long serialVersionUID = 8772258211616976492L;
    protected Vector constraints = new Vector();
    protected Vector components = new Vector();

    public void addLayoutComponent(Component component, Object object) {
        if (object == null) {
            throw new RuntimeException("RadialConstraint cannot be null");
        }
        this.constraints.addElement(object);
        this.components.addElement(component);
    }

    public void addLayoutComponent(String string, Component component) {
        this.addLayoutComponent(component, null);
    }

    public float getLayoutAlignmentX(Container container) {
        return 1.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 1.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        if (this.components.size() > 0) {
            Insets insets = container.getInsets();
            int n = container.getComponentCount();
            Dimension dimension = container.getSize();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            JCCircularScale jCCircularScale = ((RadialConstraint)this.constraints.elementAt(0)).getGauge().getScale();
            JCScale.Direction direction = jCCircularScale.getDirection();
            double d = jCCircularScale.getRadius();
            int n2 = 0;
            while (n2 < n) {
                Component component = container.getComponent(n2);
                RadialConstraint radialConstraint = (RadialConstraint)this.constraints.elementAt(this.components.indexOf(component));
                double d2 = d * radialConstraint.getExtent();
                int n3 = 0;
                int n4 = 0;
                int n5 = component.getPreferredSize().width;
                int n6 = component.getPreferredSize().height;
                if (radialConstraint.getExtent() != Double.MAX_VALUE) {
                    double d3 = radialConstraint.getAngle();
                    if (container instanceof JCCircularTick) {
                        d3 += jCCircularScale.getStartAngle();
                    }
                    double d4 = GaugeUtil.toRadians(d3);
                    n3 = (int)d + (int)(d2 * Math.cos(d4));
                    n4 = (int)d - (int)(d2 * Math.sin(d4));
                    n3 += ((JCCircularGauge)radialConstraint.getGauge()).getArcBounds().x;
                    n4 += ((JCCircularGauge)radialConstraint.getGauge()).getArcBounds().y;
                    n3 -= component.getSize().width / 2;
                    n4 -= component.getSize().height / 2;
                }
                component.setBounds(n3, n4, n5, n6);
                ++n2;
            }
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return null;
    }

    public Dimension minimumLayoutSize(Container container) {
        return container.getSize();
    }

    public Dimension preferredLayoutSize(Container container) {
        return container.getSize();
    }

    public void removeLayoutComponent(Component component) {
        int n = this.components.indexOf(component);
        if (n != -1) {
            this.constraints.removeElementAt(n);
            this.components.removeElementAt(n);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

