/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.MathValue;

public class MathVector
extends MathValue {
    protected Number[] realValues = null;
    protected int size = 0;

    public MathVector() {
        int n;
        this.size = n = 3;
        this.realValues = new Number[n];
        int n2 = 0;
        while (n2 < n) {
            this.realValues[n2] = new Double(0.0);
            ++n2;
        }
    }

    public MathVector(double[] dArray) {
        this.size = dArray.length;
        this.realValues = new Number[this.size];
        int n = 0;
        while (n < this.size) {
            this.realValues[n] = new Double(dArray[n]);
            ++n;
        }
    }

    public MathVector(int[] nArray) {
        this.size = nArray.length;
        this.realValues = new Number[this.size];
        int n = 0;
        while (n < this.size) {
            this.realValues[n] = new Integer(nArray[n]);
            ++n;
        }
    }

    public MathVector(Number[] numberArray) {
        this.size = numberArray.length;
        this.realValues = new Number[this.size];
        int n = 0;
        while (n < this.size) {
            this.realValues[n] = this.cloneNumber(numberArray[n]);
            ++n;
        }
    }

    private Number cloneNumber(Number number) {
        if (number instanceof Integer) {
            return new Integer(number.intValue());
        }
        return new Double(number.doubleValue());
    }

    public Expression getValueAt(int n) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("MathVector index " + n + " is out of range [0.." + (this.size - 1) + "]");
        }
        return new MathScalar(this.realValues[n]);
    }

    public Number[][] matrixValue() {
        throw new UnsupportedOperationException("Can't return a vector as a matrix");
    }

    public Number numberValue() {
        throw new UnsupportedOperationException("Can't return a vector as a scalar");
    }

    public void setValueAt(int n, Number number) {
        if (n < 0 || n >= this.size) {
            throw new ArrayIndexOutOfBoundsException("MathVector index " + n + " is out of range [0.." + (this.size - 1) + "]");
        }
        this.realValues[n] = this.cloneNumber(number);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("( ");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append(this.realValues[n].toString());
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public Number[] vectorValue() {
        return this.realValues;
    }
}

