/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.treetable;

import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.treetable.JCTreeTableModel;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;

public class NodeChildrenTable
implements TableModel,
Serializable {
    protected JCListenerList listeners = null;
    protected TreePath path = null;
    protected JCTreeTableModel treetable;

    public NodeChildrenTable(JCTreeTableModel jCTreeTableModel) {
        this.treetable = jCTreeTableModel;
    }

    public NodeChildrenTable(JCTreeTableModel jCTreeTableModel, TreePath treePath) {
        this(jCTreeTableModel);
        this.setParentPath(treePath);
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners = JCListenerList.add(this.listeners, tableModelListener);
    }

    public Class getColumnClass(int n) {
        return this.treetable.getColumnClass(n);
    }

    public int getColumnCount() {
        return this.treetable.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.treetable.getColumnName(n);
    }

    public TreePath getParentPath() {
        return this.path;
    }

    public int getRowCount() {
        if (this.path == null) {
            return 0;
        }
        return this.treetable.getChildCount(this.path.getLastPathComponent());
    }

    public Object getValueAt(int n, int n2) {
        return this.treetable.getValueAt(this.treetable.getChild(this.path.getLastPathComponent(), n), n2);
    }

    public boolean isCellEditable(int n, int n2) {
        return this.treetable.isCellEditable(this.treetable.getChild(this.path.getLastPathComponent(), n), n2);
    }

    public boolean isLeaf(int n) {
        return this.treetable.isLeaf(this.treetable.getChild(this.path.getLastPathComponent(), n));
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners = JCListenerList.remove(this.listeners, tableModelListener);
    }

    public void setParentPath(TreePath treePath) {
        if (this.path == treePath) {
            return;
        }
        if (this.path != null && this.path.equals(treePath)) {
            return;
        }
        this.path = treePath;
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            TableModelListener tableModelListener = (TableModelListener)enumeration.nextElement();
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    public void setValueAt(Object object, int n, int n2) {
        this.treetable.setValueAt(object, this.treetable.getChild(this.path.getLastPathComponent(), n), n2);
    }
}

