/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.GridBagLayout;
import java.io.File;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.MadamFileFilter;
import org.tigr.util.io.IOUtil;

public class ArrayVersionPanel
extends ConvertPanel {
    JPanel gOutputPL;
    JScrollPane gInputSP;
    private JList inputFileList;
    private JScrollPane gFilesSP;
    private String info = new String("");

    public ArrayVersionPanel(ExpressConverter convt) {
        super(convt);
        this.createGUI();
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        if (this.outputType == 0) {
            this.gOutputFileLB.setText("TAV Files:");
        } else {
            this.gOutputFileLB.setText("MEV Files:");
        }
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector inFiles, Vector outFiles) {
        this.selectedFiles = inFiles;
        this.outputFileNames = outFiles;
        this.inputFileList.setListData(inFiles);
        this.gOutputFileList.setListData(outFiles);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public void removeFileFromList() {
        int[] addrs = this.gOutputFileList.getSelectedIndices();
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedFiles.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                ++i;
            }
            this.inputFileList.setListData(this.selectedFiles);
            this.gOutputFileList.setListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.gOutputFileList.setSelectedIndex(0);
            }
            this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
        }
    }

    public void reset() {
        this.selectedFiles.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.gFileNumLB.setText("  Number of Files:  ");
        this.inputFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.wantSort = true;
        this.outputReady = false;
        this.sortCB.setSelected(this.wantSort);
        this.parent.activateButton(this.outputReady, this.outputReady);
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        int i = 0;
        while (i < num) {
            if (!this.selectedFiles.contains(newFiles[i])) {
                this.selectedFiles.add(newFiles[i]);
                this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
            }
            ++i;
        }
        this.inputFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.gOutputFileList.setSelectedIndex(0);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    private File getFile(String ext, String fileType, String path) {
        JFileChooser fileChooser = new JFileChooser(path);
        MadamFileFilter wanted = new MadamFileFilter(ext, fileType);
        fileChooser.setFileFilter(wanted);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Save Output As");
        fileChooser.setMultiSelectionEnabled(false);
        int result = fileChooser.showSaveDialog(this);
        if (result == 1) {
            return null;
        }
        File temp = fileChooser.getSelectedFile();
        return temp;
    }

    protected void createGUI() {
        this.setLayout(new GridBagLayout());
        this.gInputFileLB = new JLabel("ArrayVersion Files:");
        this.inputFileList = new JList();
        this.inputFileList.setBorder(this.gLow);
        this.actionHandler(this.inputFileList);
        this.actionHandler(this.gOutputFileList);
        this.gFilesSP = new JScrollPane(this.inputFileList);
        this.sortCB.setEnabled(false);
        this.gba.add(this, this.gFileSplitPane, 0, 0, 2, 1, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 1, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.gIntenPanel, 1, 1, 1, 2, 1, 0, 2, 17, 10, 0, 3, 5);
        this.gba.add(this.gInputPL, this.gInputFileLB, 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.gInputPL, this.gFilesSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
    }
}

