/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.swing.JFrame;
import org.tigr.microarray.MevAttributes;
import org.tigr.microarray.converter.Converter;
import org.tigr.microarray.converter.MevConverter;
import org.tigr.util.FileReading;
import org.tigr.util.MyStringTokenizer;
import org.tigr.util.MyTimer;
import org.tigr.util.formula.MathExpression;
import org.tigr.util.formula.Variant;
import org.tigr.util.formula.node.EvaluateException;
import org.tigr.util.io.IOUtil;

public class CustomerMev
extends MevConverter
implements MevAttributes,
Variant {
    private final int TOTAL = 0;
    private final int MEAN = 1;
    private final int MODE = 2;
    private final int MEDIAN = 3;
    private final String DESC = "Description";
    private int gAnnType;
    private int gNumMevCols;
    private int gInHeaderAddr;
    private int[] gSelCols;
    private int[] gSelAnnHd;
    private JFrame parent;
    private MathExpression[] gFormulas;
    private String inFileNamePath;
    private String gMevFileName;
    private String barTitle;
    private String[] gMevHeaders;
    private String[] gConvEquation;
    private String[] gInputHeader;

    public CustomerMev(String cfName, String mfName, String title) {
        this.inFileNames = new Vector(1);
        this.outFileNames = new Vector(1);
        this.inFileNames.add(cfName);
        this.outFileNames.add(mfName);
        this.barTitle = title;
    }

    public CustomerMev(JFrame p, Vector cfNames, Vector mfNames, String title, int annNum) {
        this.parent = p;
        this.inFileNames = cfNames;
        this.outFileNames = mfNames;
        this.barTitle = title;
        this.gAnnType = annNum;
        this.gInHeaderAddr = -1;
    }

    public void run() {
        boolean consqId = false;
        BufferedWriter annoWriter = null;
        BufferedWriter mevWriter = null;
        FileOutputStream mevFileOut = null;
        String aLine = new String("");
        String unid = new String("");
        String[] annoFile = null;
        StringBuffer mevLine = new StringBuffer(200);
        StringBuffer extraInfo = new StringBuffer(200);
        int slideRow = 0;
        int slideCol = 0;
        this.taskEnd = this.determineTaskEnd();
        if (this.taskEnd == 1) {
            return;
        }
        this.taskEnd <<= 1;
        this.counter = 0;
        int numOfFiles = this.inFileNames.size();
        this.gNumMevCols = this.getMevValidColumns();
        this.gFormulas = new MathExpression[this.gConvEquation.length];
        int i = 0;
        while (i < this.gConvEquation.length) {
            this.gFormulas[i] = new MathExpression(this.gConvEquation[i]);
            this.gFormulas[i].IntegerResult(true);
            ++i;
        }
        i = 0;
        while (i < numOfFiles) {
            String[] custFile;
            block32: {
                boolean noError = true;
                this.inFileNamePath = (String)this.inFileNames.elementAt(i);
                this.gMevFileName = (String)this.outFileNames.elementAt(i);
                try {
                    FileReading fileReader = new FileReading(this.inFileNamePath, 1);
                    if (fileReader.done) {
                        custFile = fileReader.getFileContentAsArray();
                        break block32;
                    }
                    this.setErrorMessage(fileReader.getProcessMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
                catch (IOException e) {
                    this.setErrorMessage(e.getMessage());
                    this.taskEnd = 1;
                    this.counter = 1;
                    return;
                }
            }
            int lastLine = custFile.length - 1;
            int numSpot = lastLine - this.gInHeaderAddr;
            aLine = custFile[this.gInHeaderAddr];
            String[] colNames = this.separateLine(aLine);
            String annoFileNamePath = IOUtil.dropExtension(this.gMevFileName);
            annoFileNamePath = annoFileNamePath + ".ann";
            try {
                mevFileOut = new FileOutputStream(this.gMevFileName);
                mevWriter = new BufferedWriter(new OutputStreamWriter(mevFileOut));
                this.sortKeys = new int[3][numSpot];
                this.outFile = new String[numSpot];
                String inputFileName = IOUtil.extractFileNameFromPath(this.inFileNamePath);
                String[] mevFileHeader = this.generateHeader(colNames, inputFileName, numSpot, true);
                int j = 0;
                while (j < mevFileHeader.length) {
                    mevWriter.write(mevFileHeader[j]);
                    mevWriter.newLine();
                    mevWriter.flush();
                    ++j;
                }
                if (this.gAnnType == 1) {
                    annoFile = new String[numSpot];
                    annoWriter = this.createAnnoWriter(colNames, annoFileNamePath, inputFileName, numSpot);
                } else if (i < 1) {
                    annoFile = new String[numSpot];
                    annoWriter = this.createAnnoWriter(colNames, annoFileNamePath, inputFileName, numSpot);
                }
                this.counter += this.gInHeaderAddr;
                if (this.gConvEquation[0].length() <= 0) {
                    consqId = true;
                }
                j = this.gInHeaderAddr + 1;
                int k = 0;
                while (j <= lastLine) {
                    aLine = custFile[j];
                    String[] colValues = this.separateLine(aLine);
                    unid = consqId ? "" + (k + 1) : this.convertCell(colValues, this.gFormulas[0]);
                    if (this.wantSort) {
                        slideRow = Integer.parseInt(this.convertCell(colValues, this.gFormulas[this.gSelCols[3]]));
                        slideCol = Integer.parseInt(this.convertCell(colValues, this.gFormulas[this.gSelCols[4]]));
                    }
                    mevLine.append(unid);
                    int l = 1;
                    while (l < this.gSelCols.length) {
                        mevLine.append("\t");
                        mevLine.append(this.convertCell(colValues, this.gFormulas[this.gSelCols[l]]));
                        ++l;
                    }
                    this.outFile[k] = new String(mevLine.toString());
                    mevLine.delete(0, mevLine.length());
                    if (this.gAnnType == 1) {
                        extraInfo = this.setAnnRow(extraInfo, unid, slideRow, slideCol, colValues);
                        annoFile[k] = extraInfo.toString();
                        extraInfo.delete(0, extraInfo.length());
                    } else if (i < 1) {
                        extraInfo = this.setAnnRow(extraInfo, unid, slideRow, slideCol, colValues);
                        annoFile[k] = extraInfo.toString();
                        extraInfo.delete(0, extraInfo.length());
                    }
                    this.sortKeys[0][k] = k;
                    this.sortKeys[1][k] = slideRow;
                    this.sortKeys[2][k] = slideCol;
                    ++this.counter;
                    ++j;
                    ++k;
                }
                if (this.wantSort) {
                    this.sorted = this.sortUnbalancedRowCol();
                    j = 0;
                    while (j < this.outFile.length) {
                        mevWriter.write(this.outFile[this.sorted[j]]);
                        mevWriter.newLine();
                        mevWriter.flush();
                        if (this.gAnnType == 1) {
                            annoWriter.write(annoFile[this.sorted[j]]);
                            annoWriter.newLine();
                            annoWriter.flush();
                        } else if (i < 1) {
                            annoWriter.write(annoFile[this.sorted[j]]);
                            annoWriter.newLine();
                            annoWriter.flush();
                        }
                        ++this.counter;
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < this.outFile.length) {
                        mevWriter.write(this.outFile[j]);
                        mevWriter.newLine();
                        mevWriter.flush();
                        if (this.gAnnType == 1) {
                            annoWriter.write(annoFile[j]);
                            annoWriter.newLine();
                            annoWriter.flush();
                        } else if (i < 1) {
                            annoWriter.write(annoFile[j]);
                            annoWriter.newLine();
                            annoWriter.flush();
                        }
                        ++this.counter;
                        ++j;
                    }
                }
                mevFileOut.close();
                if (this.gAnnType == 1) {
                    annoWriter.close();
                } else if (i < 1) {
                    annoWriter.close();
                }
            }
            catch (IOException ie) {
                this.setErrorMessage("Error in writing file: " + ie.getMessage() + "\n");
            }
            ++i;
        }
        Converter.ready = true;
        this.counter = this.taskEnd;
    }

    public void setCustomerEquation(String[] eq) {
        this.gConvEquation = eq;
    }

    public void setInputHeader(String[] h) {
        this.gInputHeader = h;
    }

    public void setInputHeaderOffset(int offset) {
        this.gInHeaderAddr = offset;
    }

    public void setSelectedColumnsForAnn(int[] cols) {
        this.gSelAnnHd = cols;
    }

    public void setMevHeaders(String[] header) {
        this.gMevHeaders = header;
    }

    private String convertCell(String[] aRow, MathExpression equation) {
        String val = new String("0");
        try {
            val = equation.evaluate(aRow);
        }
        catch (EvaluateException ee) {
            val = "0";
        }
        return val;
    }

    private String[] generateHeader(String[] cNames, String fName, int numRow, boolean mev) {
        String[] tempHeader = mev ? new String[7 + this.gNumMevCols] : new String[7];
        tempHeader[0] = new String("# version: V1.0");
        tempHeader[1] = new String("# format_version:V4.0");
        tempHeader[2] = new String("# date: " + MyTimer.getCurrentDateAndTime('.'));
        tempHeader[3] = new String("# created by: " + this.barTitle);
        tempHeader[4] = new String("# row_count:" + numRow);
        tempHeader[5] = new String("# converted from the file: " + fName);
        int indx = 6;
        if (mev) {
            int j;
            int count = 0;
            int i = 0;
            while (i < this.gConvEquation.length) {
                if (this.gConvEquation[i].length() > 0) {
                    if (i != 0 && i != 1 && i != 2 && i != this.gMevHeaders.length - 2 && i != this.gMevHeaders.length - 1) {
                        ++count;
                    }
                    String[] formula = this.parseEquation(this.gConvEquation[i]);
                    tempHeader[indx] = new String("# " + this.gMevHeaders[i] + " = ");
                    j = 0;
                    while (j < formula.length) {
                        int inAddr = this.getInputFileHeaderOffset(formula[j]);
                        if (inAddr < 0) {
                            int n = indx;
                            tempHeader[n] = tempHeader[n] + formula[j];
                        } else {
                            int n = indx;
                            tempHeader[n] = tempHeader[n] + cNames[inAddr];
                        }
                        ++j;
                    }
                    ++indx;
                }
                ++i;
            }
            int[] cols = new int[count];
            int k = 0;
            j = 0;
            while (j < this.gConvEquation.length) {
                if (j != 0 && j != 1 && j != 2 && j != this.gMevHeaders.length - 2 && j != this.gMevHeaders.length - 1 && this.gConvEquation[j].length() > 0) {
                    cols[k++] = j;
                }
                ++j;
            }
            this.gSelCols = new int[cols.length + 5];
            this.gSelCols[0] = 0;
            k = 1;
            if (this.gUseMedian) {
                j = this.gMevHeaders.length - 2;
                while (j < this.gMevHeaders.length) {
                    this.gSelCols[k++] = j++;
                }
                j = 0;
                while (j < cols.length) {
                    this.gSelCols[k++] = cols[j];
                    ++j;
                }
                j = 1;
                while (j < 3) {
                    this.gSelCols[k++] = j++;
                }
            } else {
                j = 1;
                while (j < 3) {
                    this.gSelCols[k++] = j++;
                }
                j = 0;
                while (j < cols.length) {
                    this.gSelCols[k++] = cols[j];
                    ++j;
                }
                j = this.gMevHeaders.length - 2;
                while (j < this.gMevHeaders.length) {
                    this.gSelCols[k++] = j++;
                }
            }
            tempHeader[indx] = this.gMevHeaders[0];
            j = 1;
            while (j < this.gSelCols.length) {
                int n = indx;
                tempHeader[n] = tempHeader[n] + "\t" + this.gMevHeaders[this.gSelCols[j]];
                ++j;
            }
        } else {
            tempHeader[indx] = this.wantSort ? this.gMevHeaders[0] + "\t" + this.gMevHeaders[3] + "\t" + this.gMevHeaders[4] : this.gMevHeaders[0];
            int i = 0;
            while (i < this.gSelAnnHd.length) {
                int n = indx;
                tempHeader[n] = tempHeader[n] + "\t" + this.gInputHeader[this.gSelAnnHd[i]];
                ++i;
            }
        }
        return tempHeader;
    }

    private int getInputFileHeaderOffset(String item) {
        int num;
        try {
            num = Integer.parseInt(item);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
        return num;
    }

    private BufferedWriter createAnnoWriter(String[] cNames, String fName, String inName, int numSpots) {
        BufferedWriter out;
        try {
            FileOutputStream fOut = new FileOutputStream(fName);
            out = new BufferedWriter(new OutputStreamWriter(fOut));
            String[] annoFileHeader = this.generateHeader(cNames, inName, numSpots, false);
            int i = 0;
            while (i < annoFileHeader.length) {
                out.write(annoFileHeader[i]);
                out.newLine();
                out.flush();
                ++i;
            }
        }
        catch (IOException ie) {
            Converter.fetalError = true;
            Converter.ready = false;
            System.out.println("Error in creating ann file: " + ie.getMessage());
            this.msg = this.msg + "**********\n";
            this.msg = this.msg + "Error in creating ann file: " + ie.getMessage() + "\n";
            return null;
        }
        return out;
    }

    private int getMevValidColumns() {
        int num = 0;
        int i = 0;
        while (i < this.gConvEquation.length) {
            if (this.gConvEquation[i].length() > 0) {
                ++num;
            }
            ++i;
        }
        return num;
    }

    private String[] parseEquation(String eq) {
        int count = 0;
        MyStringTokenizer token = new MyStringTokenizer(eq, Variant.OPERATORS, true);
        String[] temp = new String[token.countTokens()];
        while (token.hasMoreTokens()) {
            temp[count++] = token.nextToken();
        }
        return temp;
    }

    private StringBuffer setAnnRow(StringBuffer sb, String id, int r, int c, String[] vals) {
        sb.append(id);
        if (this.wantSort) {
            sb.append("\t").append(r).append("\t").append(c);
        }
        int i = 0;
        while (i < this.gSelAnnHd.length) {
            sb.append("\t").append(vals[this.gSelAnnHd[i]]);
            ++i;
        }
        return sb;
    }
}

