/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.microarray.converter;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.tigr.microarray.converter.ConvertPanel;
import org.tigr.microarray.converter.ExpressConverter;
import org.tigr.util.io.IOUtil;

public class GenePixPanel
extends ConvertPanel {
    private JScrollPane gFilesSP;
    private JCheckBox keepAllCB;
    private boolean keepAll = false;
    private JList gFileList;

    public GenePixPanel(ExpressConverter ec) {
        super(ec);
        this.createGUI();
    }

    public void removeFileFromList() {
        int[] addrs = this.gFileList.getSelectedIndices();
        if (addrs.length > 0) {
            int i = 0;
            while (i < addrs.length) {
                this.selectedFiles.remove(addrs[i]);
                this.outputFileNames.remove(addrs[i]);
                ++i;
            }
            this.gFileList.setListData(this.selectedFiles);
            this.gOutputFileList.setListData(this.outputFileNames);
            if (this.outputFileNames.size() > 0) {
                this.gOutputFileList.setSelectedIndex(0);
            }
            this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
        }
    }

    public void reset() {
        this.selectedFiles.removeAllElements();
        this.outputFileNames.removeAllElements();
        this.gFileNumLB.setText("  Number of Files:  ");
        this.gFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.wantSort = true;
        this.keepAll = false;
        this.outputReady = false;
        this.sortCB.setSelected(this.wantSort);
        this.keepAllCB.setSelected(this.keepAll);
        this.parent.activateButton(this.outputReady, this.outputReady);
    }

    public void setSelectedFiles(String[] newFiles) {
        String temp = new String("");
        int num = newFiles.length;
        int i = 0;
        while (i < num) {
            if (!this.selectedFiles.contains(newFiles[i])) {
                this.selectedFiles.add(newFiles[i]);
                this.outputFileNames.add(IOUtil.dropExtension(newFiles[i]) + "." + this.FILE_TYPE[this.outputType]);
            }
            ++i;
        }
        this.gFileList.setListData(this.selectedFiles);
        this.gOutputFileList.setListData(this.outputFileNames);
        this.gOutputFileList.setSelectedIndex(0);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    public void adjustGUI(int index) {
        String tmpName = new String("");
        this.outputType = index;
        if (this.outputType == 0) {
            this.gOutputFileLB.setText("TAV Files:");
            this.keepAllCB.setEnabled(true);
            this.activeIntensityWay(false);
        } else {
            this.gOutputFileLB.setText("MEV Files:");
            this.keepAllCB.setEnabled(false);
            this.activeIntensityWay(true);
        }
        int numFiles = this.outputFileNames.size();
        int i = 0;
        while (i < numFiles) {
            tmpName = (String)this.outputFileNames.elementAt(i);
            tmpName = IOUtil.dropExtension(tmpName);
            tmpName = tmpName + "." + this.FILE_TYPE[this.outputType];
            this.outputFileNames.setElementAt(tmpName, i);
            ++i;
        }
        this.validate();
    }

    public void changeFileList(Vector inFiles, Vector outFiles) {
        this.selectedFiles = inFiles;
        this.outputFileNames = outFiles;
        this.gFileList.setListData(inFiles);
        this.gOutputFileList.setListData(outFiles);
        this.gFileNumLB.setText("  Number of Files:  " + this.selectedFiles.size());
    }

    public Vector getOutputFileNames() {
        return this.outputFileNames;
    }

    public Vector getSelectedFiles() {
        return this.selectedFiles;
    }

    public boolean isOutputReady() {
        return this.outputReady;
    }

    public boolean keepAllInformation() {
        return this.keepAll;
    }

    protected void createGUI() {
        this.setLayout(new GridBagLayout());
        this.gInputFileLB = new JLabel("GenePix Files:");
        this.gFileList = new JList();
        this.gFileList.setBorder(this.gLow);
        this.actionHandler(this.gFileList);
        this.actionHandler(this.gOutputFileList);
        this.gFilesSP = new JScrollPane(this.gFileList);
        this.keepAllCB = new JCheckBox("Keep All Information in the GenePix Files.");
        this.keepAllCB.setToolTipText("Attach all anotation info at the end.");
        this.keepAllCB.setSelected(this.keepAll);
        this.keepAllCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ce) {
                if (GenePixPanel.this.keepAllCB.isSelected()) {
                    GenePixPanel.this.keepAll = true;
                } else {
                    GenePixPanel.this.keepAll = false;
                }
            }
        });
        this.gba.add(this, this.gFileSplitPane, 0, 0, 2, 1, 1, 1, 1, 10, 5, 5, 10, 5);
        this.gba.add(this, this.sortCB, 0, 1, 1, 1, 1, 0, 2, 10, 10, 15, 3, 5);
        this.gba.add(this, this.keepAllCB, 0, 2, 1, 1, 1, 0, 2, 10, 3, 15, 3, 5);
        this.gba.add(this, this.gIntenPanel, 1, 1, 1, 2, 1, 0, 2, 17, 10, 0, 3, 5);
        this.gba.add(this.gInputPL, this.gInputFileLB, 0, 0, 1, 1, 1, 0, 2, 10, 5, 10, 5, 2);
        this.gba.add(this.gInputPL, this.gFilesSP, 0, 1, 1, 1, 1, 1, 1, 10, 1, 2, 5, 2);
    }
}

