/*
 * Decompiled with CFR 0.152.
 */
package org.tigr.util.swing;

import java.awt.Color;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.border.BevelBorder;
import javax.swing.border.LineBorder;

public class MessageDropper
extends JLabel
implements DragGestureListener,
DragSourceListener,
MouseListener {
    private boolean gActiveBorder;
    private BevelBorder gHigh;
    private BevelBorder gFlat;
    private DragSource dragSource;
    private LineBorder gLine;
    private String msg;

    public MessageDropper() {
        this(new String(""));
    }

    public MessageDropper(String label) {
        this(label, new String(""));
    }

    public MessageDropper(Icon label) {
        this(label, new String(""));
    }

    public MessageDropper(String label, Icon icon) {
        this(label, icon, new String(""));
    }

    public MessageDropper(String label, String message) {
        super(label);
        this.msg = message;
        this.initDrag();
    }

    public MessageDropper(Icon label, String message) {
        super(label);
        this.msg = message;
        this.initDrag();
    }

    public MessageDropper(String label, Icon icon, String message) {
        super(label, icon, 0);
        this.msg = message;
        this.initDrag();
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        e.startDrag(DragSource.DefaultCopyDrop, new StringSelection(this.msg), this);
    }

    public void dragDropEnd(DragSourceDropEvent e) {
        this.setEnabled(true);
        if (this.gActiveBorder) {
            this.setBorder(this.gFlat);
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    public void mouseClicked(MouseEvent me) {
        this.firePropertyChange(this.getName(), false, true);
        this.setEnabled(true);
    }

    public void mouseEntered(MouseEvent me) {
        if (this.gActiveBorder) {
            this.setBorder(this.gHigh);
        }
    }

    public void mouseExited(MouseEvent me) {
        if (this.gActiveBorder) {
            this.setBorder(this.gFlat);
        }
    }

    public void mousePressed(MouseEvent me) {
        this.setEnabled(false);
    }

    public void mouseReleased(MouseEvent me) {
    }

    public void needBorder(boolean yes) {
        if (yes) {
            this.setBorder(this.gLine);
        }
    }

    public void setBorderActive(boolean active) {
        this.gActiveBorder = active;
    }

    public void setMessage(String message) {
        this.msg = message;
    }

    private void initDrag() {
        this.gHigh = new BevelBorder(0);
        this.gFlat = new BevelBorder(2);
        this.gLine = new LineBorder(Color.gray, 1);
        this.gActiveBorder = true;
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.addMouseListener(this);
    }
}

