/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client;

import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.session.StateCollection;
import java.awt.Point;

public class TargetAppearance {
    public static final int STRAIGHT = 111;
    public static final int CIRCULAR = 112;
    public static final int VERTLINEAR = 118;
    public static final int HORI_TEXT = 119;
    public static final int VERTI_TEXT = 120;
    private int shape;
    private int defaultShape;
    private int maxPosition;
    private int minPosition;
    private int topPosition;
    private boolean reverseComplement;
    private boolean shifted;
    private int shift = 0;
    private int targetNumber;
    private Point topLeftAnchor;
    private LinearTarget linearTarget;
    private String targetDeiLocalName;
    private String targetDeiXPtr;
    private StateCollection collection;
    private boolean isMasterSeq;

    private TargetAppearance() {
    }

    public TargetAppearance(int n, int n2, int n3, boolean bl, String string, String string2, boolean bl2) {
        this.collection = new StateCollection();
        this.targetDeiLocalName = string;
        this.targetDeiXPtr = string2;
        this.reverseComplement = bl;
        switch (n) {
            case 111: 
            case 112: {
                this.defaultShape = this.shape = n;
                break;
            }
            case 118: {
                this.defaultShape = this.shape = n;
                break;
            }
            case 119: 
            case 120: {
                this.defaultShape = this.shape = n;
                break;
            }
            default: {
                System.err.println("Attempt to set an invalid linearTarget shape in linearTargetAppearance(int,int)");
            }
        }
        this.minPosition = n2;
        this.maxPosition = n3;
        this.topPosition = this.minPosition;
        if (this.minPosition < 1) {
            System.err.println("Attempt to set a non-positive minPosition=" + this.minPosition + " in linearTargetAppearance(int,int)");
        }
        if (this.maxPosition < 1) {
            System.err.println("Attempt to set a non-positive maxPosition=" + this.maxPosition + " in linearTargetAppearance(int,int)");
        }
        if (this.minPosition > this.maxPosition) {
            System.err.println("Attempt to set minPosition=" + this.minPosition + " > maxPosition=" + this.maxPosition + " in linearTargetAppearance(int,int)");
        }
        this.topLeftAnchor = new Point(0, 0);
        this.targetNumber = -1;
        this.isMasterSeq = bl2;
    }

    public static TargetAppearance create(TargetAppearance targetAppearance) {
        TargetAppearance targetAppearance2 = new TargetAppearance(targetAppearance.defaultShape, targetAppearance.minPosition, targetAppearance.maxPosition, false, targetAppearance.targetDeiLocalName, targetAppearance.targetDeiXPtr, targetAppearance.isMasterSeq);
        targetAppearance2.shape = targetAppearance.shape;
        targetAppearance2.topPosition = targetAppearance.topPosition;
        return targetAppearance2;
    }

    public int getTargetNumber() {
        return this.targetNumber;
    }

    public void setTargetNumber(int n) {
        this.targetNumber = n;
    }

    public boolean isReverseComplement() {
        return this.reverseComplement;
    }

    public void setReverseComplement(boolean bl) {
        this.reverseComplement = bl;
        this.collection.setReverse(this.reverseComplement);
        this.collection.setTarget(this.getTargetNumber());
    }

    public boolean isShifted() {
        return this.shifted;
    }

    public void setShift(int n) {
        this.shift = n;
        this.shifted = this.shift != 0;
        this.collection.setCut(this.shift);
        this.collection.setTarget(this.getTargetNumber());
    }

    public int getShift() {
        return this.shift;
    }

    public int getShape() {
        return this.shape;
    }

    public void setShape(int n) {
        this.collection.setShape(n);
        this.collection.setTarget(this.getTargetNumber());
        switch (n) {
            case 111: 
            case 112: {
                this.shape = n;
                break;
            }
            case 118: {
                this.shape = n;
                break;
            }
            case 119: 
            case 120: {
                this.shape = n;
                break;
            }
            default: {
                System.err.println("Attempt to set an invalid linearTarget shape in linearTargetAppearance.setShape(int)");
            }
        }
    }

    public int getMinPosition() {
        return this.minPosition;
    }

    public int getMaxPosition() {
        return this.maxPosition;
    }

    public int getTopPosition() {
        return this.topPosition;
    }

    public void setTopPosition(int n) {
        if (n < 1) {
            System.err.println("Attempt to set a non-positive topPosition=" + n + " in linearTargetAppearance(int,int)");
        } else if (n < this.minPosition) {
            System.err.println("Attempt to set topPosition=" + n + " < minPosition=" + this.minPosition + " in linearTargetAppearance(int,int)");
        } else if (n > this.maxPosition) {
            System.err.println("Attempt to set topPosition=" + n + " > maxPosition=" + this.maxPosition + " in linearTargetAppearance(int,int)");
        } else {
            this.topPosition = n;
            this.collection.setRotation(this.topPosition);
            this.collection.setTarget(this.getTargetNumber());
        }
    }

    public void reset() {
        this.resetDefaultShape();
        this.topPosition = this.minPosition;
    }

    public void resetDefaultShape() {
        this.shape = this.defaultShape;
    }

    public void setTopLeftAnchor(int n, int n2) {
        this.topLeftAnchor.x = n;
        this.topLeftAnchor.y = n2;
    }

    public Point getTopLeftAnchor() {
        return this.topLeftAnchor;
    }

    public void setLinearTarget(LinearTarget linearTarget) {
        this.linearTarget = linearTarget;
    }

    public LinearTarget getLinearTarget() {
        return this.linearTarget;
    }

    public String getLocalName() {
        return this.targetDeiLocalName;
    }

    public String getXPointer() {
        return this.targetDeiXPtr;
    }

    public int getLeftEdgePosition() {
        if (this.reverseComplement) {
            return (this.maxPosition + this.shift - 1) % this.maxPosition + 1;
        }
        return this.minPosition + this.shift;
    }

    public int getRightEdgePosition() {
        if (this.reverseComplement) {
            return this.minPosition + this.shift;
        }
        return (this.maxPosition + this.shift - 1) % this.maxPosition + 1;
    }

    public void setMasterSequence(boolean bl) {
        this.isMasterSeq = bl;
    }

    public boolean isMasterSequence() {
        return this.isMasterSeq;
    }

    public void setMaxPosition(int n) {
        this.maxPosition = n;
    }

    public void setMinPosition(int n) {
        this.minPosition = n;
    }

    public void setCurrentCollection(StateCollection stateCollection) {
        this.collection = stateCollection;
    }
}

