/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.impl;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.DTDMarkupSpecifier;
import ca.ucalgary.bluejay.client.impl.BluejayContentHandler;
import ca.ucalgary.bluejay.client.impl.BluejayEntityResolver;
import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayIOController;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.util.BluejayCheckTree;
import ca.ucalgary.bluejay.gui.util.CheckNode;
import ca.ucalgary.bluejay.gui.util.DataObject;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.util.OSCacheUtil;
import com.opensymphony.oscache.base.NeedsRefreshException;
import com.simonstl.sax.xlink.LinkSet;
import com.simonstl.sax.xlink.XLinkFilter;
import java.io.IOException;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URL;
import javax.swing.tree.DefaultTreeModel;
import org.apache.log4j.Logger;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class BluejayParser {
    private static Logger logger = Logger.getLogger(BluejayParser.class);
    protected static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    protected static final String XERCES_DYNAMIC_VALIDATION_FEATURE = "http://apache.org/xml/features/validation/dynamic";
    protected static final String NAMESPACES_FEATURE = "http://xml.org/sax/features/namespaces";
    protected static final String NS_PREFIXES_FEATURE = "http://xml.org/sax/features/namespace-prefixes";
    protected static final int MAX_CHAR_CONTENT_LENGTH_FOR_NON_TEXT = 6000000;
    protected static BluejayCheckTree checkTree = null;
    protected static BluejayContentHandler mainContentHandler;
    protected BluejayIOController io;
    protected static String[] mimetypes;
    protected BluejayEventCoordinator bec;
    protected URL currentParsing_CacheUrl;
    protected URL currentParsing_ActualUrl;
    protected boolean currentParsing_CatchErrors;
    protected boolean isCollectingLinksOnly;
    protected boolean usingXLinkFilter;
    protected DTDElementInstance contextDEI;
    protected BluejayEntityResolver entityResolver;
    protected static SAXParser saxParser;
    protected static XMLReader mainParser;
    protected static XMLReader initialParser;
    protected static XLinkFilter linkFilter;
    protected static LinkSet mainLinkSet;
    protected BluejayDObjectList dlist;
    protected DTDMarkupSpecifier[] languages;
    protected String extractFragment;
    protected Node extractedNode;

    public BluejayParser(BluejayDObjectList bluejayDObjectList, DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this.dlist = bluejayDObjectList;
        this.languages = dTDMarkupSpecifierArray;
        this.entityResolver = new BluejayEntityResolver(dTDMarkupSpecifierArray);
    }

    public void setDTDMarkupSpecifiers(DTDMarkupSpecifier[] dTDMarkupSpecifierArray) {
        this.languages = dTDMarkupSpecifierArray;
        this.entityResolver.setDTDMarkupSpecifiers(dTDMarkupSpecifierArray);
    }

    public BluejayCheckTree getCheckTree() {
        Object object = checkTree.getModel().getRoot();
        logger.debug("### BParser.getCheckTree() rootNode = " + object);
        if (object != null && object instanceof CheckNode) {
            CheckNode checkNode = (CheckNode)checkTree.getModel().getRoot();
            logger.debug("### BParser.getCheckTree() checkNode = " + checkNode);
            if (checkNode != null) {
                Object object2 = checkNode.getUserObject();
                logger.debug("### BParser.getCheckTree() obj = " + object2);
                if (object2 != null && object2 instanceof DataObject) {
                    DataObject dataObject = (DataObject)object2;
                    logger.debug("### BParser.getCheckTree() root name = " + dataObject.getLocalName());
                }
            }
        }
        return checkTree;
    }

    public void setCheckTree(BluejayCheckTree bluejayCheckTree) {
        checkTree = bluejayCheckTree;
    }

    public LinkSet getLinkSet() {
        return mainLinkSet;
    }

    public void setLinkSet(LinkSet linkSet) {
        mainLinkSet = linkSet;
    }

    public void setCollectingLinksOnly(boolean bl) {
        this.isCollectingLinksOnly = bl;
    }

    public void setParsingTools(BluejayIOController bluejayIOController, String[] stringArray, BluejayEventCoordinator bluejayEventCoordinator, boolean bl) {
        this.io = bluejayIOController;
        mimetypes = stringArray;
        this.bec = bluejayEventCoordinator;
        this.usingXLinkFilter = bl;
    }

    public void setContextDTDElementInstance(DTDElementInstance dTDElementInstance) {
        this.contextDEI = dTDElementInstance;
        if (mainContentHandler != null) {
            mainContentHandler.setContextDTDElementInstance(this.contextDEI);
        }
    }

    public DTDElementInstance getContextDTDElementInstance() {
        return this.contextDEI;
    }

    protected void initializeContentHandler(boolean bl) {
        logger.debug("### BParser.initializeContentHandler( isNewDataFile=" + bl + ")");
        mainContentHandler = new BluejayContentHandler(this.dlist, this.bec, this.languages, checkTree == null ? new DefaultTreeModel(null) : (DefaultTreeModel)checkTree.getModel(), bl);
        if (this.extractFragment != null && !"".equals(this.extractFragment)) {
            mainContentHandler.setExtractionFragment(this.extractFragment);
            mainContentHandler.setExtractionParser(this);
        }
        mainContentHandler.preserveWhitespace(false);
        mainContentHandler.setMaxCharContentLength(6000000);
    }

    protected void initializeParsers() {
        logger.debug("### BParser.initializeParsers()");
        saxParser = new SAXParser();
        initialParser = saxParser;
        if (this.usingXLinkFilter) {
            linkFilter = new XLinkFilter(initialParser);
            if (mainLinkSet == null) {
                mainLinkSet = new LinkSet();
            }
            linkFilter.setLinkSet(mainLinkSet);
            linkFilter.setCollectingLinksOnly(this.isCollectingLinksOnly);
            mainParser = linkFilter;
        } else {
            mainParser = initialParser;
        }
        logger.debug("### BParser.initializeParsers() mainParser=" + mainParser);
        mainParser.setContentHandler(mainContentHandler);
        mainParser.setErrorHandler(mainContentHandler);
        mainParser.setEntityResolver(this.entityResolver);
        boolean bl = false;
        try {
            mainParser.setFeature(VALIDATION_FEATURE, true);
            bl = mainParser.getFeature(VALIDATION_FEATURE);
            logger.debug("Parser is set to be " + (bl ? "" : "non-") + "validating.");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            logger.warn("Unrecognized feature http://xml.org/sax/features/validation");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            logger.warn("Unsupported or unmodifiable feature http://xml.org/sax/features/validation");
        }
        try {
            mainParser.setFeature(XERCES_DYNAMIC_VALIDATION_FEATURE, true);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            logger.warn("Unrecognized feature http://apache.org/xml/features/validation/dynamic");
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            logger.warn("Unsupported or unmodifiable feature http://apache.org/xml/features/validation/dynamic");
        }
        try {
            mainParser.setFeature(NS_PREFIXES_FEATURE, false);
            mainParser.setFeature(NAMESPACES_FEATURE, true);
            logger.debug("Namespace features settings:\n   namespaces  == " + mainParser.getFeature(NAMESPACES_FEATURE) + "\n   ns-prefixes == " + mainParser.getFeature(NS_PREFIXES_FEATURE) + "\n(Note that SAX default is: ns=true, prefixes=false)");
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            logger.warn("Unrecognized feature " + sAXNotRecognizedException);
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            logger.warn("Unsupported or unmodifiable feature " + sAXNotSupportedException);
        }
        logger.debug("### BParser.initializeParsers() DONE");
    }

    public void releaseParsers() {
        mainContentHandler = null;
        try {
            if (saxParser != null) {
                saxParser.reset();
            }
        }
        catch (Exception exception) {
            logger.warn(exception.getMessage());
            exception.printStackTrace();
        }
        saxParser = null;
        initialParser = null;
        linkFilter = null;
        mainParser = null;
        logger.debug("### BParser.releaseParsers() RELEASED ");
    }

    public void reparse() {
        this.parse(this.currentParsing_CacheUrl, this.currentParsing_ActualUrl, this.currentParsing_CatchErrors, false, true);
    }

    public void parse(URL uRL, boolean bl, boolean bl2) {
        this.parse(uRL, uRL, bl, bl2, true);
    }

    public void parse(URL uRL, boolean bl, boolean bl2, boolean bl3) {
        this.parse(uRL, uRL, bl, bl2, bl3);
    }

    public void parse(URL uRL, URL uRL2, boolean bl, boolean bl2) {
        this.parse(uRL, uRL2, bl, bl2, true);
    }

    public void parse(URL uRL, URL uRL2, boolean bl, boolean bl2, boolean bl3) {
        block18: {
            logger.debug("### BParser.parse( cacheUrl=" + uRL + "\n                 actualUrl=" + uRL2 + "\n                 catchErrors=" + bl + "\n                 isNewDataFile=" + bl2 + ")");
            if (bl3) {
                this.dlist.getDataManager().clearAllBeforeParsing(bl2);
            }
            try {
                logger.debug("### BParser.parse() START InputSource source = new InputSource(io.getCharContents(" + uRL + ", mimetypes))");
                InputSource inputSource = null;
                try {
                    inputSource = Debug.localCache && this.io.isDiskCaching() && uRL.toString().startsWith("http") ? new InputSource(new StringReader((String)this.io.getCacheAdmin().getFromCache(uRL.toString()))) : new InputSource(this.io.getCharContents(uRL, mimetypes));
                }
                catch (NeedsRefreshException needsRefreshException) {
                    logger.warn("Caching file: " + Runtime.getRuntime().maxMemory() + " " + uRL.toString());
                    OSCacheUtil oSCacheUtil = new OSCacheUtil(uRL.toString(), this.io.getCacheAdmin());
                    try {
                        oSCacheUtil.start();
                        inputSource = new InputSource(this.io.getCharContents(uRL, mimetypes));
                    }
                    catch (NullPointerException nullPointerException) {
                        logger.warn(nullPointerException.getMessage());
                        nullPointerException.printStackTrace();
                    }
                    catch (Exception exception) {
                        logger.warn(exception.getMessage());
                        exception.printStackTrace();
                    }
                }
                inputSource.setSystemId(uRL2.toString());
                logger.debug("Parsing " + (bl ? "" : "linkbase ") + uRL2);
                this.dlist.getEventCoordinator().notify(8, "Parsing " + (bl ? "" : "linkbase ") + uRL2);
                if (this.dlist.getProgressBar() != null) {
                    this.dlist.getProgressBar().setMinimum(0);
                    this.dlist.getProgressBar().setMaximum((int)this.io.getFileSize());
                    this.dlist.getProgressBar().setValue(0);
                }
                this.extractFragment = uRL.getRef();
                if (this.extractFragment == null || "".equals(this.extractFragment)) {
                    this.currentParsing_CacheUrl = uRL;
                    this.currentParsing_ActualUrl = uRL2;
                    this.currentParsing_CatchErrors = bl;
                }
                this.initializeContentHandler(bl2);
                mainContentHandler.setContextDTDElementInstance(this.contextDEI);
                this.initializeParsers();
                mainParser.parse(inputSource);
                this.setContextDTDElementInstance(null);
            }
            catch (ConnectException connectException) {
                logger.warn("Data or DTD connection Exception: " + connectException);
                if (bl) {
                    if (this.bec != null) {
                        this.bec.notify(6, "Data or DTD connection Exception: " + connectException);
                    }
                    connectException.printStackTrace();
                    this.bec.notify(6, "Connection Error in Parsing");
                }
            }
            catch (IOException iOException) {
                logger.warn("I/O Exception: " + iOException);
                if (bl) {
                    if (this.bec != null) {
                        this.bec.notify(6, "File not found");
                    }
                    iOException.printStackTrace();
                }
            }
            catch (SAXException sAXException) {
                logger.warn("Parsing exception: " + sAXException);
                if (!bl) break block18;
                if (this.bec != null) {
                    this.bec.notify(6, "Parsing exception: " + sAXException);
                }
                sAXException.printStackTrace();
                this.bec.notify(6, "Parsing exception: " + sAXException.toString());
            }
        }
    }

    public void setExtractedNode(Node node) {
        this.extractedNode = node;
    }

    public Node getExtractedNode() {
        return this.extractedNode;
    }
}

