/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.impl;

import ca.ucalgary.bluejay.client.ParseTask;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.gui.menu.HistoryMenuManager;
import ca.ucalgary.bluejay.session.History;
import ca.ucalgary.bluejay.session.HistoryTable;
import ca.ucalgary.bluejay.session.SessionManager;
import ca.ucalgary.bluejay.session.StateCollection;
import java.io.Serializable;
import java.net.URL;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class BluejayURLLoader
implements URLLoader {
    private static BluejayEventCoordinator bec;
    private static boolean haveConnection;
    private static URL u;
    private static URL actualURLName;
    private static ca.ucalgary.bluejay.gui.util.History localHistory;
    private static History sessionHistory;
    private static SessionManager sessionManager;
    private static HistoryMenuManager hmm;
    private static JComboBox tf;
    private static ParseTask task;
    private static JButton back;
    private static JButton forward;
    private static JMenuItem mBack;
    private static JMenuItem mForward;
    private static JMenuItem menuUndo;
    private static JButton buttonUndo;
    private static HistoryTable history;
    private static Logger logger;
    private static Integer dummyID;

    public void gotoURL(URL uRL, boolean bl) {
        logger.debug("gotoURL:  URL " + uRL + "   " + "add to history? " + bl);
        Integer n = new Integer(0);
        if (bec != null) {
            bec.notify(4, "Loading data from " + uRL);
        }
        actualURLName = uRL;
        if (bl) {
            this.addToHistory(actualURLName);
            Vector vector = localHistory.getComparisonURLs(BluejayURLLoader.localHistory.cur_pos);
            if (vector != null) {
                vector.clear();
            }
        } else {
            this.ignoreAddToHistory(actualURLName);
        }
        if (localHistory != null) {
            logger.debug("The cur_pos in localHistory is: " + BluejayURLLoader.localHistory.cur_pos);
        }
        if (history.get(uRL) != null) {
            logger.debug("The cur_pos in StateCollection is: " + history.get(uRL).getCur_Pos());
        }
        if (back != null) {
            back.setEnabled(BluejayURLLoader.localHistory.cur_pos > 0);
            mBack.setEnabled(BluejayURLLoader.localHistory.cur_pos > 0);
        }
        if (forward != null) {
            forward.setEnabled(BluejayURLLoader.localHistory.cur_pos < localHistory.historySize() - 1);
            mForward.setEnabled(BluejayURLLoader.localHistory.cur_pos < localHistory.historySize() - 1);
        }
        if (menuUndo != null && history.get(uRL) != null) {
            menuUndo.setEnabled(history.get(uRL).getUndoSize() > 2);
        }
        if (buttonUndo != null && history.get(uRL) != null) {
            buttonUndo.setEnabled(history.get(uRL).getRedoSize() > 0);
        }
    }

    private void addToHistory(URL uRL) {
        logger.debug("Never been here before, adding URL to history");
        logger.debug("Passed in URL: " + uRL.toString());
        URL uRL2 = null;
        try {
            Object object;
            URL uRL3 = sessionManager.sessionRequestURL(uRL);
            if (uRL3 == null) {
                uRL3 = uRL;
            }
            uRL2 = new URL(uRL3.toString());
            logger.debug("addToHistory: actualURLName " + actualURLName.toString() + " u " + uRL.toString());
            localHistory.addLocation(actualURLName, uRL, new Integer(sessionManager.sessionRequestVisitID()));
            sessionHistory.addHistoryElement(actualURLName.toString(), uRL.toString(), new Integer(sessionManager.sessionRequestVisitID()));
            if (!(uRL.getProtocol() == null || !uRL.getProtocol().equals("http") && !uRL.getProtocol().equals("https") || uRL.toString().endsWith(".xml") || uRL.toString().endsWith(".xml.gz") || uRL.getQuery() != null && uRL.getQuery().length() > 0)) {
                object = uRL.toString() + ".xml";
                uRL = new URL((String)object);
            }
            this.addComboBoxItem(this.makeObj(localHistory.getRealURL().toString()));
            if (history.get(uRL) != null) {
                object = history.get(uRL);
                history.ignore(true);
            } else {
                object = new StateCollection(uRL.toString(), actualURLName.toString());
                history.ignore(false);
            }
            history.put(uRL, (StateCollection)object);
            history.setCurrentURL(uRL);
            task.setActualURLName(actualURLName);
            task.go(uRL);
            BluejayURLLoader.setNavigationButtons();
        }
        catch (Exception exception) {
            logger.warn("EEP! " + exception.getClass().getName() + " in AddtoHistory");
            exception.printStackTrace();
            localHistory.addLocation(actualURLName, uRL, dummyID);
            this.addComboBoxItem(this.makeObj(localHistory.getRealURL().toString()));
            StateCollection stateCollection = history.get(uRL) != null ? history.get(uRL) : new StateCollection(uRL.toString(), actualURLName.toString());
            history.ignore(false);
            history.put(uRL, stateCollection);
            history.setCurrentURL(uRL);
            task.setActualURLName(actualURLName);
            task.go(uRL);
            BluejayURLLoader.setNavigationButtons();
        }
    }

    private void ignoreAddToHistory(URL uRL) {
        logger.debug("Request for a previously visited URL");
        if (haveConnection) {
            logger.debug("ignoreAddToHistory: no add to History, request page: " + uRL);
            try {
                StateCollection stateCollection;
                Serializable serializable;
                URL uRL2 = uRL;
                String string = uRL2 == null ? null : uRL2.toString();
                logger.debug("ignoreAddToHistory: tryCachedString is " + string);
                logger.debug("ignoreAddToHistory: tryCachedURL is : " + uRL2);
                if (uRL2 == null) {
                    serializable = new URL(localHistory.getRealURL());
                    logger.debug("ignoreAddToHistory: Original URL was: " + serializable);
                    actualURLName = new URL(((URL)serializable).toString());
                }
                serializable = new Integer(sessionManager.sessionRevisitURL(localHistory.getCurrentVId()));
                localHistory.setCurrentVId((Integer)serializable);
                task.setActualURLName(actualURLName);
                task.go(uRL);
                System.err.println("Setting Text field to " + localHistory.getRealURL());
                this.addComboBoxItem(this.makeObj(localHistory.getRealURL().toString()));
                if (history.get(uRL) != null) {
                    stateCollection = history.get(uRL);
                    history.ignore(true);
                } else {
                    stateCollection = new StateCollection(uRL.toString(), actualURLName.toString());
                }
                history.ignore(true);
                history.put(uRL, stateCollection);
                history.setCurrentURL(uRL);
            }
            catch (Exception exception) {
                logger.error("EEP! NewBrowser.gotoURL NO ADD Session Management: " + exception.getMessage());
            }
        } else {
            logger.warn("No login version visiting previous URL");
            task.setActualURLName(actualURLName);
            task.go(uRL);
            if (localHistory != null) {
                StateCollection stateCollection;
                this.addComboBoxItem(this.makeObj(localHistory.getRealURL().toString()));
                if (history.get(uRL) != null) {
                    stateCollection = history.get(uRL);
                    history.ignore(true);
                } else {
                    stateCollection = new StateCollection(uRL.toString(), actualURLName.toString());
                }
                history.ignore(true);
                history.put(uRL, stateCollection);
                history.setCurrentURL(uRL);
            }
        }
    }

    public void leavingPage() {
    }

    public Object makeObj(final String string) {
        return new Object(){

            public String toString() {
                return string;
            }
        };
    }

    public void addComboBoxItem(Object object) {
        boolean bl = false;
        for (int i = 0; i < tf.getItemCount(); ++i) {
            if (tf.getItemAt(i) == null || !object.toString().equals(tf.getItemAt(i).toString())) continue;
            String string = tf.getActionCommand();
            tf.setActionCommand("");
            tf.setSelectedIndex(i);
            tf.setActionCommand(string);
            return;
        }
        String string = tf.getActionCommand();
        tf.setActionCommand("");
        tf.insertItemAt(object, 0);
        tf.setSelectedIndex(0);
        tf.setActionCommand(string);
        hmm.addURLtoHisMenu(object.toString());
    }

    private static void setNavigationButtons() {
        back.setEnabled(BluejayURLLoader.localHistory.cur_pos > 0);
        forward.setEnabled(BluejayURLLoader.localHistory.cur_pos < localHistory.historySize() - 1);
    }

    public void setHistoryMenuManager(HistoryMenuManager historyMenuManager) {
        hmm = historyMenuManager;
    }

    public void setEventCoordinator(BluejayEventCoordinator bluejayEventCoordinator) {
        bec = bluejayEventCoordinator;
    }

    public void setHaveConnection(boolean bl) {
        haveConnection = bl;
    }

    public void setActualURLName(URL uRL) {
        actualURLName = uRL;
    }

    public URL getActualURLName() {
        return actualURLName;
    }

    public void setTf(JComboBox jComboBox) {
        tf = jComboBox;
    }

    public void setLocalHistory(ca.ucalgary.bluejay.gui.util.History history) {
        localHistory = history;
    }

    public void setSessionHistory(History history) {
        sessionHistory = history;
    }

    public void setSessionManager(SessionManager sessionManager) {
        BluejayURLLoader.sessionManager = sessionManager;
    }

    public void setBackFunction(JButton jButton, JMenuItem jMenuItem) {
        back = jButton;
        mBack = jMenuItem;
    }

    public void setForwardFunction(JButton jButton, JMenuItem jMenuItem) {
        forward = jButton;
        mForward = jMenuItem;
    }

    public void setTask(ParseTask parseTask) {
        task = parseTask;
    }

    public void setHistoryTable(HistoryTable historyTable) {
        history = historyTable;
    }

    public ParseTask getTask() {
        return task;
    }

    public void setMenuUndo(JMenuItem jMenuItem) {
        menuUndo = jMenuItem;
    }

    public void setButtonUndo(JButton jButton) {
        buttonUndo = jButton;
    }

    public void appendComparisonGenome(URL uRL) {
        localHistory.appendComparison(uRL);
    }

    public Vector getComparisons(int n) {
        return localHistory.getComparisonURLs(n);
    }

    public int getCurrentPositionInHistory() {
        return BluejayURLLoader.localHistory.cur_pos;
    }

    public URL getHistoryURL(int n) {
        return (URL)localHistory.getinternetURLVector().elementAt(n);
    }

    public void removeComparisonGenome(int n) {
        localHistory.getComparisonURLs(BluejayURLLoader.localHistory.cur_pos).removeElementAt(n);
    }

    public URL getCurrentURL() {
        URL uRL = null;
        try {
            uRL = new URL(tf.getSelectedItem().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uRL;
    }

    public HistoryTable getHistoryTable() {
        return history;
    }

    public StateCollection getCurrentCollection() {
        return history.getCurrentCollection();
    }

    public JComboBox getURLList() {
        return tf;
    }

    static {
        logger = Logger.getLogger(BluejayURLLoader.class);
        dummyID = new Integer(0);
    }
}

