/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.lineartarget;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;

public class CircularArea
extends Area {
    private int areaType;
    private double cx;
    private double cy;
    private double outerRadius;
    private double innerRadius;
    private double startAngle;
    private double extentAngle;
    public static final int ARC = 1001;
    public static final int CIRCLE = 1002;
    public static final int SEGMENT = 1003;

    public CircularArea() {
    }

    public CircularArea(Shape shape) {
        super(shape);
        if (shape instanceof Arc2D.Double) {
            this.areaType = 1001;
            Arc2D.Double double_ = (Arc2D.Double)shape;
            this.outerRadius = this.innerRadius = double_.width / 2.0;
            this.cx = double_.x + double_.width / 2.0;
            this.cy = double_.y + double_.height / 2.0;
            this.startAngle = double_.start;
            this.extentAngle = double_.extent;
        } else if (shape instanceof Ellipse2D.Double) {
            this.areaType = 1002;
            Ellipse2D.Double double_ = (Ellipse2D.Double)shape;
            this.outerRadius = this.innerRadius = double_.width / 2.0;
            this.cx = double_.x + double_.width / 2.0;
            this.cy = double_.y + double_.height / 2.0;
            this.startAngle = 0.0;
            this.extentAngle = 360.0;
        } else {
            Exception exception = new Exception("CircularRectangleArea(Shape s) for this Shape is not implemented");
            exception.printStackTrace();
        }
    }

    public void subtract(Area area) {
        if (area instanceof CircularArea) {
            CircularArea circularArea = (CircularArea)area;
            if (1002 == circularArea.areaType) {
                super.subtract(circularArea);
                this.areaType = 1003;
                this.innerRadius = circularArea.innerRadius;
            } else {
                Exception exception = new Exception("CircularRectangleArea.subtract(CircularArea a) is only implemented for a.areaType==CIRCLE_TYPE");
                exception.printStackTrace();
            }
        } else {
            Exception exception = new Exception("CircularRectangleArea.subtract(Area a) for non-CircularArea is not implemented");
            exception.printStackTrace();
        }
    }

    public int getAreaType() {
        return this.areaType;
    }

    public double getCenterX() {
        return this.cx;
    }

    public double getCenterY() {
        return this.cy;
    }

    public double getOuterRadius() {
        return this.outerRadius;
    }

    public double getInnerRadius() {
        return this.innerRadius;
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public double getExtentAngle() {
        return this.extentAngle;
    }
}

