/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.client.lineartarget;

import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.lineartarget.CircularArea;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.painter.BasicPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.log4j.Logger;

public class CircularLinearTarget
implements LinearTarget {
    private double pixelsPerPosScale;
    private int min_pos;
    private int max_pos;
    private double main_start_angle;
    private double center;
    private double radius;
    private double width;
    private double height;
    private int above_pixels;
    private int below_pixels;
    private int shift = 0;
    private AbstractLinearGraphics alg;
    private int mode = 0;
    private double lastInnerOffset;
    private CircularArea lastInnerEllipseArea;
    private static final double RAD_PER_DEGREE = Math.PI / 180;
    private static final Stroke defaultStroke = new BasicStroke(1.0f);
    private boolean ignoreMode = false;
    private Vector visibleRangeSegments = new Vector();
    private double ratioBump;
    private MaskPainter maskPainter;
    private Shape[] arrowShape = new Shape[2];
    private boolean shouldSplit;
    private static Logger logger = Logger.getLogger(CircularLinearTarget.class);

    public CircularLinearTarget(AbstractLinearGraphics abstractLinearGraphics, int n, int n2, int n3, int n4, double d, double d2) {
        this.alg = abstractLinearGraphics;
        this.min_pos = n;
        this.max_pos = n2;
        this.above_pixels = n3;
        this.below_pixels = n4;
        this.main_start_angle = d2;
        this.setScale(d);
        this.shouldSplit = false;
    }

    public void setMaskPainter(MaskPainter maskPainter) {
        this.maskPainter = maskPainter;
    }

    public MaskPainter getMaskPainter() {
        return this.maskPainter;
    }

    public int getMinPosition() {
        return this.min_pos;
    }

    public int getMaxPosition() {
        return this.max_pos;
    }

    public void setRatioBump(double d) {
        this.ratioBump = d;
    }

    public double calculateIdealScale(int n, Dimension dimension, LaneManager laneManager, int n2) {
        int n3 = dimension.width < dimension.height ? dimension.width : dimension.height;
        int n4 = 60;
        int n5 = 0;
        try {
            n5 = n3 - 2 * (laneManager.getAboveHeight(n4) + n2);
            if (n5 < 10) {
                logger.warn("Ideal scale is too small to be useful:" + n5);
                return -5.898;
            }
        }
        catch (Exception exception) {
            logger.warn("Failed to calculate ideal scale due to LaneManager error:" + exception);
            return -5.898;
        }
        logger.debug("###\n\n\n static CLT.calculateIdealScale() d.width=" + dimension.width + ",d.height=" + dimension.height + ",diameter=" + n5);
        double d = (double)n5 * Math.PI / (double)n;
        if (d < 1.0E-5) {
            d = 1.0;
        }
        return 1.0 / d;
    }

    public double calculateIdealScale(Dimension dimension) {
        int n = dimension.width < dimension.height ? dimension.width : dimension.height;
        double d = this.ratioBump > 0.0 && this.ratioBump < 1.0 ? 1.0 - this.ratioBump : 1.0;
        int n2 = n - (int)(2.0 * d * (double)(d > 0.0 ? this.above_pixels : this.below_pixels));
        logger.debug("###\n\n\n CLT.calculateIdealScale() d.width=" + dimension.width + ",d.height=" + dimension.height + ",diameter=" + n2);
        double d2 = (double)n2 * Math.PI / (double)(this.max_pos - this.min_pos + 1);
        if (d2 < 1.0E-5) {
            d2 = 1.0;
        }
        this.setScale(d2);
        return 1.0 / d2;
    }

    private void recalculateWidthHeight() {
        this.radius = this.pixelsPerPosScale * (double)(this.max_pos - this.min_pos + 1) / (Math.PI * 2);
        this.height = this.width = 2.0 * (this.radius + (double)this.above_pixels);
        this.center = this.width / 2.0;
        logger.debug("CircularLT.recalculateWidthHeight() Bounding square has side length of " + this.width);
        this.lastInnerOffset = -77777.77777;
        this.lastInnerEllipseArea = null;
    }

    public int getReversedPosition(int n) {
        int n2;
        if (Math.abs(this.main_start_angle) < 1.0E-5) {
            n2 = this.max_pos - n + 1;
        } else {
            int n3 = this.max_pos - this.min_pos + 1;
            double d = (270.0 - this.main_start_angle + 360.0) % 360.0;
            int n4 = this.min_pos + (int)((double)n3 * d / 360.0);
            for (n2 = n4 - (this.max_pos - n4 + 1) - (n - this.min_pos + 1); n2 < this.min_pos; n2 += n3) {
            }
        }
        return n2;
    }

    private Point getPositionPoint(int n) throws IllegalArgumentException {
        return this.getPositionPoint(n, 0.0);
    }

    private Point getPositionPoint(int n, double d) throws IllegalArgumentException {
        if (n > this.max_pos || n < this.min_pos) {
            throw new IllegalArgumentException("In CircularLinearTarget, request for location of position " + n + " which is outside legal position range of [" + this.min_pos + "," + this.max_pos + "]");
        }
        double d2 = this.getPositionAngle(n) * (Math.PI / 180);
        return new Point((int)(this.center + Math.cos(d2) * (this.radius + d)), (int)(this.center + Math.sin(d2) * (this.radius + d)));
    }

    private double getPositionAngle(int n) throws IllegalArgumentException {
        if (n > this.max_pos) {
            n = this.max_pos;
        } else if (n < this.min_pos) {
            n = this.min_pos;
        }
        return (this.main_start_angle + 360.0 * (double)(n - this.min_pos) / (double)(this.max_pos - this.min_pos)) % 360.0;
    }

    public void setScale(double d) {
        this.pixelsPerPosScale = d;
        this.recalculateWidthHeight();
    }

    public int getAbovePixels() {
        return this.above_pixels;
    }

    public int getBelowPixels() {
        return this.below_pixels;
    }

    public void setAbovePixels(int n) {
        this.above_pixels = n;
        this.recalculateWidthHeight();
    }

    public void setBelowPixels(int n) {
        this.below_pixels = n;
        this.recalculateWidthHeight();
    }

    public int getWidth() {
        return (int)(0.5 + this.width);
    }

    public int getHeight() {
        return (int)(0.5 + this.height);
    }

    public double getScale() {
        return this.pixelsPerPosScale;
    }

    public void drawString(Graphics graphics, String string, int n, double d, double d2, int n2) {
        this.drawAngledString(graphics, string, n, d, d2, n2, 0.0);
    }

    public void drawAngledString(Graphics graphics, String string, int n, double d, double d2, int n2, double d3) {
        String string2;
        double d4;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.getReversedPosition(n);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getAscent();
        int n4 = fontMetrics.stringWidth(string);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d5 = d * (double)((d += this.ratioBump) >= 0.0 ? this.above_pixels : this.below_pixels);
        double d6 = d2 * (double)((d2 += this.ratioBump) >= 0.0 ? this.above_pixels : this.below_pixels);
        if (d5 < -this.radius) {
            d5 = -this.radius + (double)n3;
        }
        if (d6 < -this.radius) {
            d6 = -this.radius + (double)n3;
        }
        if ((d4 = d5 - d6) >= (double)n4) {
            string2 = string;
        } else {
            int n5 = (int)(0.5 + (double)string.length() * d4 / (double)n4) - 3;
            if (n5 < 0) {
                n5 = 0;
            }
            string2 = string.substring(0, n5) + "...";
            n4 = fontMetrics.stringWidth(string2);
        }
        double d7 = this.getPositionAngle(n);
        double d8 = d7 * (Math.PI / 180);
        double d9 = (d7 + d3) % 360.0;
        double d10 = this.center;
        double d11 = this.center;
        double d12 = this.center;
        if (d9 > 90.0 && d9 < 270.0) {
            d8 -= Math.PI;
            switch (n2) {
                case 30: {
                    d10 -= this.radius + d6 + (double)n4;
                    d12 -= this.radius + d6;
                    break;
                }
                case 40: {
                    d10 -= this.radius + d5;
                    d12 -= this.radius + d5;
                    break;
                }
                case 0: {
                    d10 -= this.radius + (d6 + d5 + (double)n4) / 2.0;
                    d12 -= this.radius + (d6 + d5) / 2.0;
                }
            }
            if (d3 < 0.0 && d3 > -90.0 && n2 == 40) {
                d11 += (double)fontMetrics.getAscent();
            }
        } else {
            switch (n2) {
                case 30: {
                    d10 += this.radius + d6;
                    d12 += this.radius + d6;
                    break;
                }
                case 40: {
                    d10 += this.radius + d5 - (double)n4;
                    d12 += this.radius + d5;
                    break;
                }
                case 0: {
                    d10 += this.radius + (d6 + d5 - (double)n4) / 2.0;
                    d12 += this.radius + (d6 + d5) / 2.0;
                }
            }
            if (d3 < 0.0 && d3 > -90.0 && n2 == 30) {
                d11 += (double)fontMetrics.getAscent();
            }
        }
        if (graphics2D instanceof SVGGraphics2D) {
            graphics2D.drawString(" ", 0, 0);
        }
        graphics2D.rotate(d8, this.center, this.center);
        if (d3 != 0.0) {
            graphics2D.rotate(d3 * (Math.PI / 180), d12, this.center);
        }
        graphics2D.drawString(string2, (int)(0.5 + d10), (int)(0.5 + d11));
        if (d3 != 0.0) {
            graphics2D.rotate(-d3 * (Math.PI / 180), d12, this.center);
        }
        graphics2D.rotate(-d8, this.center, this.center);
    }

    public void drawString(Graphics graphics, String string, int n, double d, int n2) {
        this.drawAngledString(graphics, string, n, d, n2, 0.0);
    }

    public void drawAngledString(Graphics graphics, String string, int n, double d, int n2, double d2) {
        double d3;
        double d4;
        boolean bl;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.getReversedPosition(n);
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d5 = this.getPositionAngle(n);
        double d6 = (d5 + d2) % 360.0;
        double d7 = d5 * (Math.PI / 180);
        double d8 = d * (double)((d += this.ratioBump) >= 0.0 ? this.above_pixels : this.below_pixels);
        double d9 = this.center;
        boolean bl2 = bl = d6 > 90.0 && d6 < 270.0;
        if (bl) {
            d7 -= Math.PI;
            d3 = d4 = this.center - this.radius - d8;
            if (n2 == 30) {
                d4 -= (double)fontMetrics.stringWidth(string);
            } else if (n2 == 0) {
                d4 -= (double)(fontMetrics.stringWidth(string) / 2);
            }
            if (d2 < 0.0 && d2 > -90.0 && n2 == 40) {
                d9 += (double)fontMetrics.getAscent();
            }
        } else {
            d3 = d4 = this.center + this.radius + d8;
            if (n2 == 40) {
                d4 -= (double)fontMetrics.stringWidth(string);
            } else if (n2 == 0) {
                d4 -= (double)(fontMetrics.stringWidth(string) / 2);
            }
            if (d2 < 0.0 && d2 > -90.0 && n2 == 30) {
                d9 += (double)fontMetrics.getAscent();
            }
        }
        if (graphics2D instanceof SVGGraphics2D) {
            graphics2D.drawString(" ", 0, 0);
        }
        graphics2D.rotate(d7, this.center, this.center);
        if (d2 != 0.0) {
            graphics2D.rotate(d2 * (Math.PI / 180), d3, this.center);
        }
        graphics2D.drawString(string, (int)(0.5 + d4), (int)(0.5 + d9));
        if (d2 != 0.0) {
            graphics2D.rotate(-d2 * (Math.PI / 180), d3, this.center);
        }
        graphics2D.rotate(-d7, this.center, this.center);
    }

    public void drawVerticalString(Graphics graphics, String string, int n, double d, int n2) {
    }

    public void drawLine(Graphics graphics, int n, int n2, double d, double d2) {
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n3 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n3);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if ((d += this.ratioBump) == (d2 += this.ratioBump)) {
            double d3 = (double)this.above_pixels - d * (double)(d > 0.0 ? this.above_pixels : this.below_pixels);
            logger.debug("###CLT.drawLine(starty=" + d + ",stopy=" + d2 + ",offset=" + d3 + ",(width-2*offset)=" + (this.width - 2.0 * d3));
            if (n == this.min_pos && n2 == this.max_pos) {
                Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d3, this.width - 2.0 * d3, this.width - 2.0 * d3);
                graphics2D.draw(double_);
            } else {
                double d4;
                double d5 = -this.getPositionAngle(n2);
                if (d5 > (d4 = -this.getPositionAngle(n))) {
                    d5 -= 360.0;
                }
                double d6 = d4 - d5;
                Arc2D.Double double_ = new Arc2D.Double(d3, d3, this.width - 2.0 * d3, this.width - 2.0 * d3, d5, d6, 0);
                graphics2D.draw(double_);
            }
        } else if (n == n2) {
            double d7 = this.radius + d * (double)(d > 0.0 ? this.above_pixels : this.below_pixels);
            double d8 = this.radius + d2 * (double)(d2 > 0.0 ? this.above_pixels : this.below_pixels);
            double d9 = d7 > d8 ? 0.5 : -0.5;
            double d10 = this.getPositionAngle(n) * (Math.PI / 180);
            Line2D.Double double_ = new Line2D.Double(this.center + Math.cos(d10) * (d7 -= d9), this.center + Math.sin(d10) * d7, this.center + Math.cos(d10) * (d8 += d9), this.center + Math.sin(d10) * d8);
            graphics2D.draw(double_);
        }
    }

    public void drawLinkingLine(Graphics graphics, int n, int n2, double d, double d2, double d3, int n3, int n4, double d4, double d5, double d6) {
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n5 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n5);
            n5 = n3;
            n3 = this.getReversedPosition(n4);
            n4 = this.getReversedPosition(n5);
        }
        d += this.ratioBump;
        d2 += this.ratioBump;
        d4 += this.ratioBump;
        d5 += this.ratioBump;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d7 = this.radius + d * (double)(d > 0.0 ? this.above_pixels : this.below_pixels);
        double d8 = this.radius + d2 * (double)(d2 > 0.0 ? this.above_pixels : this.below_pixels);
        double d9 = (d7 + d8) / 2.0;
        double d10 = this.radius + d4 * (double)(d4 > 0.0 ? this.above_pixels : this.below_pixels);
        double d11 = this.radius + d5 * (double)(d5 > 0.0 ? this.above_pixels : this.below_pixels);
        double d12 = (d10 + d11) / 2.0;
        double d13 = d7 > d8 ? 0.5 : -0.5;
        double d14 = d3 * (Math.PI / 180);
        double d15 = d6 * (Math.PI / 180);
        Line2D.Double double_ = new Line2D.Double(this.center + Math.cos(d14) * (d9 += d13), this.center + Math.sin(d14) * d9, this.center + Math.cos(d15) * (d12 += d13), this.center + Math.sin(d15) * d12);
        graphics2D.draw(double_);
    }

    public void drawRect(Graphics graphics, int n, int n2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n3 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n3);
        }
        d += this.ratioBump;
        d2 += this.ratioBump;
        double d6 = -this.getPositionAngle(n2);
        if (d6 > (d5 = -this.getPositionAngle(n))) {
            d6 -= 360.0;
        }
        double d7 = d5 - d6;
        double d8 = (double)this.above_pixels - d * (double)(d > 0.0 ? this.above_pixels : this.below_pixels);
        if (d8 > (d4 = (double)this.above_pixels - d2 * (double)(d2 > 0.0 ? this.above_pixels : this.below_pixels))) {
            d3 = d8;
            d8 = d4;
            d4 = d3;
        }
        if (2.0 * d8 > this.width) {
            d8 = this.width / 2.0;
        }
        if (2.0 * d4 > this.width) {
            d4 = this.width / 2.0;
        }
        d3 = d8 < d4 ? 0.5 : -0.5;
        d8 += d3;
        d4 -= d3;
        if (this.isShouldSplit()) {
            double d9 = d4 - d8;
            double d10 = Math.sqrt(Math.pow(d9, 2.0) + Math.pow(d9, 2.0)) * 5.0 / 12.0;
            double d11 = Math.sqrt(Math.pow(2.0 * d10, 2.0) / 2.0);
            d8 = d4 - d11;
        }
        Arc2D.Double double_ = new Arc2D.Double(d8, d8, this.width - 2.0 * d8, this.width - 2.0 * d8, d6, d7, 0);
        Arc2D.Double double_2 = new Arc2D.Double(d4, d4, this.width - 2.0 * d4, this.width - 2.0 * d4, d6, d7, 0);
        Line2D.Double double_3 = new Line2D.Double(double_.getStartPoint(), double_2.getStartPoint());
        Line2D.Double double_4 = new Line2D.Double(double_.getEndPoint(), double_2.getEndPoint());
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
        if (!this.isShouldSplit()) {
            graphics2D.draw(double_3);
        }
        graphics2D.draw(double_4);
    }

    public void drawArrowShape(Graphics graphics, int n, int n2, double d, double d2) {
        if (n > n2) {
            this.setShouldSplit(true);
            this.drawSplitArrow(graphics, n, n2, d, d2);
        } else {
            this.setShouldSplit(false);
            this.drawNormalArrow(graphics, n, n2, d, d2);
        }
    }

    public void drawNormalArrow(Graphics graphics, int n, int n2, double d, double d2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Point2D.Double double_3;
        Point2D.Double double_4;
        Point2D.Double double_5;
        Point2D.Double double_6;
        Point2D.Double double_7;
        Arc2D.Double double_8;
        Arc2D.Double double_9;
        double d3;
        double d4;
        int n3;
        int n4;
        int n5;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n5 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n5);
        }
        d += this.ratioBump;
        d2 += this.ratioBump;
        n5 = new Double(10.0 / this.pixelsPerPosScale).intValue();
        int n6 = new Double(1.0 / this.pixelsPerPosScale).intValue();
        int n7 = n2 - n;
        if (n7 >= n5) {
            n4 = n2 - n5;
            n3 = n2 - n5 - n6;
        } else {
            n4 = n;
            n3 = n;
        }
        double d5 = -this.getPositionAngle(n2);
        double d6 = -this.getPositionAngle(n);
        double d7 = -this.getPositionAngle(n4);
        double d8 = -this.getPositionAngle(n3);
        if (d5 > d6) {
            d5 -= 360.0;
        }
        if (d7 > d6) {
            d7 -= 360.0;
        }
        if (d8 > d6) {
            d8 -= 360.0;
        }
        double d9 = d6 - d5;
        double d10 = d6 - d7;
        double d11 = d6 - d8;
        double d12 = (double)this.above_pixels - d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        if (d12 > (d4 = (double)this.above_pixels - d2 * (double)(d2 > 0.0 ? this.above_pixels : this.below_pixels))) {
            d3 = d12;
            d12 = d4;
            d4 = d3;
        }
        if (2.0 * d12 > this.width) {
            d12 = this.width / 2.0;
        }
        if (2.0 * d4 > this.width) {
            d4 = this.width / 2.0;
        }
        d3 = d12 < d4 ? 0.5 : -0.5;
        double d13 = (d4 -= d3) - (d12 += d3);
        double d14 = Math.sqrt(Math.pow(d13, 2.0) + Math.pow(d13, 2.0)) * 5.0 / 12.0;
        double d15 = Math.sqrt(Math.pow(d14, 2.0) / 2.0);
        double d16 = Math.sqrt(Math.pow(2.0 * d14, 2.0) / 2.0);
        double d17 = Math.sqrt(Math.pow(3.0 * d14, 2.0) / 2.0);
        double d18 = Math.sqrt(Math.pow(4.0 * d14, 2.0) / 2.0);
        double d19 = d4 + d15;
        double d20 = this.width - 2.0 * d19;
        double d21 = d4;
        double d22 = this.width - 2.0 * d21;
        double d23 = d4 - d15;
        double d24 = this.width - 2.0 * d23;
        double d25 = d4 - d16;
        double d26 = this.width - 2.0 * d25;
        double d27 = d4 - d17;
        double d28 = this.width - 2.0 * d27;
        if (BasicPainter.APPEARFRAME < 0) {
            Arc2D.Double double_10 = new Arc2D.Double(d19, d19, d20, d20, d5, d11, 0);
            double_9 = new Arc2D.Double(d21, d21, d22, d22, d5, d10, 0);
            Arc2D.Double double_11 = new Arc2D.Double(d23, d23, d24, d24, d5, d9, 0);
            double_8 = new Arc2D.Double(d25, d25, d26, d26, d5, d10, 0);
            Arc2D.Double double_12 = new Arc2D.Double(d27, d27, d28, d28, d5, d11, 0);
            double_7 = new Point2D.Double(double_9.getStartPoint().getX(), double_9.getStartPoint().getY());
            double_6 = new Point2D.Double(double_8.getStartPoint().getX(), double_8.getStartPoint().getY());
            double_5 = new Point2D.Double(double_8.getEndPoint().getX(), double_8.getEndPoint().getY());
            double_4 = new Point2D.Double(double_12.getEndPoint().getX(), double_12.getEndPoint().getY());
            double_3 = new Point2D.Double(double_11.getEndPoint().getX(), double_11.getEndPoint().getY());
            double_2 = new Point2D.Double(double_10.getEndPoint().getX(), double_10.getEndPoint().getY());
            double_ = new Point2D.Double(double_9.getEndPoint().getX(), double_9.getEndPoint().getY());
        } else {
            Arc2D.Double double_13 = new Arc2D.Double(d19, d19, d20, d20, d8, d10, 0);
            double_9 = new Arc2D.Double(d21, d21, d22, d22, d7, d10, 0);
            Arc2D.Double double_14 = new Arc2D.Double(d23, d23, d24, d24, d5, d9, 0);
            double_8 = new Arc2D.Double(d25, d25, d26, d26, d7, d10, 0);
            Arc2D.Double double_15 = new Arc2D.Double(d27, d27, d28, d28, d8, d10, 0);
            double_7 = new Point2D.Double(double_9.getEndPoint().getX(), double_9.getEndPoint().getY());
            double_6 = new Point2D.Double(double_8.getEndPoint().getX(), double_8.getEndPoint().getY());
            double_5 = new Point2D.Double(double_8.getStartPoint().getX(), double_8.getStartPoint().getY());
            double_4 = new Point2D.Double(double_15.getStartPoint().getX(), double_15.getStartPoint().getY());
            double_3 = new Point2D.Double(double_14.getStartPoint().getX(), double_14.getStartPoint().getY());
            double_2 = new Point2D.Double(double_13.getStartPoint().getX(), double_13.getStartPoint().getY());
            double_ = new Point2D.Double(double_9.getStartPoint().getX(), double_9.getStartPoint().getY());
        }
        int[] nArray = new int[5];
        int[] nArray2 = new int[5];
        Line2D.Double double_16 = new Line2D.Double(double_7, double_6);
        Line2D.Double double_17 = new Line2D.Double(double_5, double_4);
        Line2D.Double double_18 = new Line2D.Double(double_4, double_3);
        Line2D.Double double_19 = new Line2D.Double(double_3, double_2);
        Line2D.Double double_20 = new Line2D.Double(double_2, double_);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.draw(double_8);
        graphics2D.draw(double_9);
        if (!this.isShouldSplit()) {
            graphics2D.draw(double_16);
        }
        graphics2D.draw(double_17);
        graphics2D.draw(double_18);
        graphics2D.draw(double_19);
        graphics2D.draw(double_20);
    }

    public void drawSplitArrow(Graphics graphics, int n, int n2, double d, double d2) {
        if (BasicPainter.APPEARFRAME < 0) {
            this.drawNormalArrow(graphics, n, this.getMaxPosition(), d, d2);
            this.drawRect(graphics, this.getMinPosition(), n2, d, d2);
        } else {
            this.drawNormalArrow(graphics, this.getMinPosition(), n2, d, d2);
            this.drawRect(graphics, n, this.getMaxPosition(), d, d2);
        }
    }

    public void fillRect(Graphics graphics, int n, int n2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            int n3 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n3);
        }
        if ((d5 = (double)this.above_pixels - d * (double)((d += this.ratioBump) > 0.0 ? this.above_pixels : this.below_pixels)) > (d4 = (double)this.above_pixels - d2 * (double)((d2 += this.ratioBump) > 0.0 ? this.above_pixels : this.below_pixels))) {
            d3 = d5;
            d5 = d4;
            d4 = d3;
        }
        if (2.0 * d5 > this.width) {
            d5 = this.width / 2.0;
        }
        if (2.0 * d4 > this.width) {
            d4 = this.width / 2.0;
        }
        d3 = (d5 + d4) / 2.0;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (n == this.min_pos && n2 == this.max_pos) {
            float f = (float)(d5 > d4 ? d5 - d4 : d4 - d5);
            graphics2D.setStroke(new BasicStroke(f, 0, 2));
            Ellipse2D.Double double_ = new Ellipse2D.Double(d3, d3, this.width - 2.0 * d3, this.width - 2.0 * d3);
            graphics2D.draw(double_);
            graphics2D.setStroke(new BasicStroke());
        } else {
            CircularArea circularArea;
            double d6;
            double d7 = -this.getPositionAngle(n2);
            if (d7 > (d6 = -this.getPositionAngle(n))) {
                d7 -= 360.0;
            }
            double d8 = d6 - d7;
            CircularArea circularArea2 = new CircularArea(new Arc2D.Double(d5, d5, this.width - 2.0 * d5, this.width - 2.0 * d5, d7, d8, 2));
            double d9 = this.lastInnerOffset - d4;
            if (d9 < 0.001 && d9 > -0.001) {
                circularArea = this.lastInnerEllipseArea;
            } else {
                circularArea = new CircularArea(new Ellipse2D.Double(d4, d4, this.width - 2.0 * d4, this.width - 2.0 * d4));
                this.lastInnerOffset = d4;
                this.lastInnerEllipseArea = circularArea;
            }
            circularArea2.subtract(circularArea);
            graphics2D.fill(circularArea2);
        }
    }

    public void fillArrowShape(Graphics graphics, int n, int n2, double d, double d2) {
        this.arrowShape = this.createArrowShape(n, n2, d, d2);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        BasicStroke basicStroke = new BasicStroke(2.0f);
        graphics2D.fill(this.arrowShape[0]);
        graphics2D.fill(this.arrowShape[1]);
    }

    public Shape[] createArrowShape(int n, int n2, double d, double d2) {
        Point2D.Double double_;
        Point2D.Double double_2;
        Point2D.Double double_3;
        Arc2D.Double double_4;
        Arc2D.Double double_5;
        double d3;
        double d4;
        int n3;
        int n4;
        int n5;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n5 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n5);
        }
        d += this.ratioBump;
        d2 += this.ratioBump;
        n5 = new Double(10.0 / this.pixelsPerPosScale).intValue();
        int n6 = new Double(1.0 / this.pixelsPerPosScale).intValue();
        int n7 = n2 - n;
        if (n7 >= n5) {
            n4 = n2 - n5;
            n3 = n2 - n5 - n6;
        } else {
            n4 = n;
            n3 = n;
        }
        double d5 = -this.getPositionAngle(n2);
        double d6 = -this.getPositionAngle(n);
        double d7 = -this.getPositionAngle(n4);
        double d8 = -this.getPositionAngle(n3);
        if (d5 > d6) {
            d5 -= 360.0;
        }
        if (d7 > d6) {
            d7 -= 360.0;
        }
        if (d8 > d6) {
            d8 -= 360.0;
        }
        double d9 = d6 - d5;
        double d10 = d6 - d7;
        double d11 = d6 - d8;
        double d12 = (double)this.above_pixels - d * (double)(d >= 0.0 ? this.above_pixels : this.below_pixels);
        if (d12 > (d4 = (double)this.above_pixels - d2 * (double)(d2 > 0.0 ? this.above_pixels : this.below_pixels))) {
            d3 = d12;
            d12 = d4;
            d4 = d3;
        }
        if (2.0 * d12 > this.width) {
            d12 = this.width / 2.0;
        }
        if (2.0 * d4 > this.width) {
            d4 = this.width / 2.0;
        }
        d3 = d12 < d4 ? 0.5 : -0.5;
        double d13 = (d4 -= d3) - (d12 += d3);
        double d14 = Math.sqrt(Math.pow(d13, 2.0) + Math.pow(d13, 2.0)) * 5.0 / 12.0;
        double d15 = Math.sqrt(Math.pow(d14, 2.0) / 2.0);
        double d16 = Math.sqrt(Math.pow(2.0 * d14, 2.0) / 2.0);
        double d17 = Math.sqrt(Math.pow(3.0 * d14, 2.0) / 2.0);
        double d18 = Math.sqrt(Math.pow(4.0 * d14, 2.0) / 2.0);
        double d19 = d4 + d15;
        double d20 = this.width - 2.0 * d19;
        double d21 = d4;
        double d22 = this.width - 2.0 * d21;
        double d23 = d4 - d15;
        double d24 = this.width - 2.0 * d23;
        double d25 = d4 - d16;
        double d26 = this.width - 2.0 * d25;
        double d27 = d4 - d17;
        double d28 = this.width - 2.0 * d27;
        if (BasicPainter.APPEARFRAME < 0) {
            Arc2D.Double double_6 = new Arc2D.Double(d19, d19, d20, d20, d5, d11, 2);
            double_5 = new Arc2D.Double(d21, d21, d22, d22, d5, d10, 2);
            Arc2D.Double double_7 = new Arc2D.Double(d23, d23, d24, d24, d5, d9, 0);
            double_4 = new Arc2D.Double(d25, d25, d26, d26, d5, d10, 2);
            Arc2D.Double double_8 = new Arc2D.Double(d27, d27, d28, d28, d5, d11, 2);
            Point2D.Double double_9 = new Point2D.Double(double_5.getStartPoint().getX(), double_5.getStartPoint().getY());
            Point2D.Double double_10 = new Point2D.Double(double_4.getStartPoint().getX(), double_4.getStartPoint().getY());
            Point2D.Double double_11 = new Point2D.Double(double_4.getEndPoint().getX(), double_4.getEndPoint().getY());
            double_3 = new Point2D.Double(double_8.getEndPoint().getX(), double_8.getEndPoint().getY());
            double_2 = new Point2D.Double(double_7.getEndPoint().getX(), double_7.getEndPoint().getY());
            double_ = new Point2D.Double(double_6.getEndPoint().getX(), double_6.getEndPoint().getY());
            Point2D.Double double_12 = new Point2D.Double(double_5.getEndPoint().getX(), double_5.getEndPoint().getY());
        } else {
            Arc2D.Double double_13 = new Arc2D.Double(d19, d19, d20, d20, d8, d10, 0);
            double_5 = new Arc2D.Double(d21, d21, d22, d22, d7, d10, 2);
            Arc2D.Double double_14 = new Arc2D.Double(d23, d23, d24, d24, d5, d9, 0);
            double_4 = new Arc2D.Double(d25, d25, d26, d26, d7, d10, 2);
            Arc2D.Double double_15 = new Arc2D.Double(d27, d27, d28, d28, d8, d10, 0);
            Point2D.Double double_16 = new Point2D.Double(double_5.getEndPoint().getX(), double_5.getEndPoint().getY());
            Point2D.Double double_17 = new Point2D.Double(double_4.getEndPoint().getX(), double_4.getEndPoint().getY());
            Point2D.Double double_18 = new Point2D.Double(double_4.getStartPoint().getX(), double_4.getStartPoint().getY());
            double_3 = new Point2D.Double(double_15.getStartPoint().getX(), double_15.getStartPoint().getY());
            double_2 = new Point2D.Double(double_14.getStartPoint().getX(), double_14.getStartPoint().getY());
            double_ = new Point2D.Double(double_13.getStartPoint().getX(), double_13.getStartPoint().getY());
            Point2D.Double double_19 = new Point2D.Double(double_5.getStartPoint().getX(), double_5.getStartPoint().getY());
        }
        Area area = new Area(double_4);
        Area area2 = new Area(double_5);
        area.subtract(area2);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        nArray[0] = new Double(double_3.getX()).intValue();
        nArray[1] = new Double(double_2.getX()).intValue();
        nArray[2] = new Double(double_.getX()).intValue();
        nArray2[0] = new Double(double_3.getY()).intValue();
        nArray2[1] = new Double(double_2.getY()).intValue();
        nArray2[2] = new Double(double_.getY()).intValue();
        Polygon polygon = new Polygon(nArray, nArray2, 3);
        this.arrowShape[0] = area;
        this.arrowShape[1] = polygon;
        return this.arrowShape;
    }

    public void drawWaypointIcon(Graphics graphics, String string, Image image, int n, int n2, int n3, int n4, double d) {
        double d2;
        double d3;
        boolean bl;
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double d4 = this.getPositionAngle(n4);
        Point point = this.getPointLocally(n4, d);
        int n5 = (int)point.getX();
        int n6 = (int)point.getY();
        if (d4 < 360.0 && d4 > 270.0) {
            n6 -= n2 - n3;
            --n5;
        } else if (d4 < 270.0 && d4 > 90.0) {
            n5 -= n;
            n6 -= n2 - n3;
        } else if (d4 < 90.0 && d4 > 0.0) {
            --n5;
            n6 -= n3 / 2;
        }
        ++n;
        Rectangle rectangle = new Rectangle(n5, n6, n2, n2);
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.white);
        graphics2D.fill(rectangle);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle);
        if (image != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.setToTranslation(n5, n6);
            BluejayDObjectList bluejayDObjectList = this.maskPainter.getDList();
            graphics2D.drawImage(image, affineTransform, bluejayDObjectList);
        }
        rectangle = new Rectangle(n5 + n2, n6, n, n2);
        graphics2D.setColor(Color.yellow);
        graphics2D.fill(rectangle);
        graphics2D.setColor(color);
        graphics2D.draw(rectangle);
        int n7 = 30;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n4 = this.getReversedPosition(n4);
        }
        double d5 = 90.0;
        d4 = this.getPositionAngle(n4);
        if (d4 < 360.0 && d4 > 270.0) {
            d5 = 90.0 - (d4 - 270.0);
        } else if (d4 < 270.0 && d4 > 180.0) {
            d5 = -(d4 - 180.0);
        } else if (d4 < 180.0 && d4 > 90.0) {
            d5 = 180.0 - d4;
        } else if (d4 < 90.0 && d4 > 0.0) {
            d5 = -d4;
        } else if (d4 == 180.0 || d4 == 0.0) {
            d5 = 0.0;
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        double d6 = this.getPositionAngle(n4);
        double d7 = (d6 + d5) % 360.0;
        double d8 = d6 * (Math.PI / 180);
        double d9 = d * (double)((d += this.ratioBump) >= 0.0 ? this.above_pixels : this.below_pixels);
        double d10 = this.center;
        boolean bl2 = bl = d7 > 90.0 && d7 < 270.0;
        if (bl) {
            d8 -= Math.PI;
            d2 = d3 = this.center - this.radius - d9;
            if (n7 == 30) {
                d3 -= (double)fontMetrics.stringWidth(string);
            }
        } else {
            d2 = d3 = this.center + this.radius + d9;
            if (d5 < 0.0 && d5 > -90.0 && n7 == 30) {
                d10 += (double)fontMetrics.getAscent();
            }
        }
        if (graphics2D instanceof SVGGraphics2D) {
            graphics2D.drawString(" ", 0, 0);
        }
        graphics2D.rotate(d8, this.center, this.center);
        if (d5 != 0.0) {
            graphics2D.rotate(d5 * (Math.PI / 180), d2, this.center);
        }
        graphics2D.drawString(string, (int)(0.5 + d3) + n2, (int)(0.5 + d10));
        if (d5 != 0.0) {
            graphics2D.rotate(-d5 * (Math.PI / 180), d2, this.center);
        }
        graphics2D.rotate(-d8, this.center, this.center);
    }

    public Point getPointLocally(int n, double d) {
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.getReversedPosition(n);
        }
        double d2 = (double)this.above_pixels - d * (double)((d += this.ratioBump) > 0.0 ? this.above_pixels : this.below_pixels);
        double d3 = this.width / 2.0 - d2;
        double d4 = this.getPositionAngle(n) * Math.PI / 180.0;
        Point point = new Point((int)(0.5 + d2 + d3 + d3 * Math.cos(d4)), (int)(0.5 + d2 + d3 + d3 * Math.sin(d4)));
        return point;
    }

    public int getPositionLocally(Point point) {
        double d = Math.sqrt(((double)point.x - this.center) * ((double)point.x - this.center) + ((double)point.y - this.center) * ((double)point.y - this.center));
        double d2 = (double)point.y - this.center >= 0.0 ? Math.acos(((double)point.x - this.center) / d) * 180.0 / Math.PI : 360.0 - Math.acos(((double)point.x - this.center) / d) * 180.0 / Math.PI;
        double d3 = (d2 - this.main_start_angle + 360.0) % 360.0 / 360.0;
        int n = this.min_pos + (int)((double)(this.max_pos - this.min_pos + 1) * d3);
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.getReversedPosition(n);
        }
        return n;
    }

    public double getHeightRatioLocally(Point point) {
        double d = Math.sqrt(((double)point.x - this.center) * ((double)point.x - this.center) + ((double)point.y - this.center) * ((double)point.y - this.center));
        double d2 = d > this.radius ? (d - this.radius) / (double)this.above_pixels : (d - this.radius) / (double)this.below_pixels;
        return d2 - this.ratioBump;
    }

    public boolean isWithinTargetAreaLocally(Point point) {
        return point.x >= 0 && (double)point.x <= this.width && point.y >= 0 && (double)point.y <= this.height;
    }

    public List getPositionAndHeightRatioLocally(Point point) {
        boolean bl;
        double d = Math.sqrt(((double)point.x - this.center) * ((double)point.x - this.center) + ((double)point.y - this.center) * ((double)point.y - this.center));
        double d2 = (double)point.y - this.center >= 0.0 ? Math.acos(((double)point.x - this.center) / d) * 180.0 / Math.PI : 360.0 - Math.acos(((double)point.x - this.center) / d) * 180.0 / Math.PI;
        double d3 = (d2 - this.main_start_angle + 360.0) % 360.0 / 360.0;
        int n = this.min_pos + (int)((double)(this.max_pos - this.min_pos + 1) * d3);
        double d4 = d > this.radius ? (d - this.radius) / (double)this.above_pixels : (d - this.radius) / (double)this.below_pixels;
        boolean bl2 = bl = point.x >= 0 && (double)point.x <= this.width && point.y >= 0 && (double)point.y <= this.height;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n = this.getReversedPosition(n);
        }
        Vector<Serializable> vector = new Vector<Serializable>();
        vector.add(new Integer(n));
        vector.add(new Double(d4 -= this.ratioBump));
        vector.add(new Boolean(bl));
        return vector;
    }

    public void drawPolygon(Graphics graphics, Polygon polygon, Rectangle rectangle, int n, int n2, double d, double d2) {
        int n3;
        if ((this.mode & 1) == 1 && !this.ignoreMode) {
            n3 = n;
            n = this.getReversedPosition(n2);
            n2 = this.getReversedPosition(n3);
        }
        d += this.ratioBump;
        d2 += this.ratioBump;
        if (polygon.npoints < 2) {
            return;
        }
        n3 = n2 - n;
        double d3 = d - d2;
        this.ignoreMode = true;
        for (int i = 0; i < polygon.npoints - 1; ++i) {
            this.drawLine(graphics, n + (int)((double)polygon.xpoints[i] / (double)rectangle.width * (double)n3), n + (int)((double)polygon.xpoints[i + 1] / (double)rectangle.width * (double)n3), d + (double)((int)((double)polygon.ypoints[i] / (double)rectangle.height * d3)), d + (double)((int)((double)polygon.ypoints[i + 1] / (double)rectangle.height * d3)));
        }
        this.drawLine(graphics, n + (int)((double)polygon.xpoints[polygon.npoints - 1] / (double)rectangle.width * (double)n3), n + (int)((double)polygon.xpoints[0] / (double)rectangle.width * (double)n3), d + (double)((int)((double)polygon.ypoints[polygon.npoints - 1] / (double)rectangle.height * d3)), d + (double)((int)((double)polygon.ypoints[0] / (double)rectangle.height * d3)));
        this.ignoreMode = false;
    }

    public void fillPolygon(Graphics graphics, Polygon polygon, Rectangle rectangle, int n, int n2, double d, double d2) {
    }

    public void drawArc(Graphics graphics, int n, int n2, double d, double d2, int n3, int n4) {
    }

    public void fillArc(Graphics graphics, int n, int n2, double d, double d2, int n3, int n4) {
    }

    public void drawImage(Graphics graphics, Image image, int n, int n2, double d, double d2) {
        if (image == null) {
            return;
        }
        BluejayDObjectList bluejayDObjectList = this.maskPainter.getDList();
        boolean bl = false;
        Graphics2D graphics2D = (Graphics2D)graphics;
        double d3 = this.getPositionAngle(n);
        Point point = this.getPointLocally(n, d2);
        int n3 = (int)point.getX();
        int n4 = (int)point.getY();
        System.err.println("height = " + this.height);
        System.err.println("x=" + n3 + " y = " + n4);
        this.width += 1.0;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(n3, n4);
        System.err.println("Obs = " + bluejayDObjectList);
        graphics2D.drawImage(image, affineTransform, bluejayDObjectList);
    }

    public Object drawObject(Object object) {
        return null;
    }

    public void addMode(int n) {
        int n2 = this.mode;
        this.mode |= n;
        logger.debug("### CircularLT.addMode(" + n + ") -- mode changed from " + n2 + " to " + this.mode);
    }

    public int getModeFlags() {
        return this.mode;
    }

    public void removeMode(int n) {
        int n2 = this.mode;
        this.mode &= ~n;
    }

    public void setShift(int n) {
        this.shift = n;
    }

    public List getVisiblePositionRange() {
        if (this.visibleRangeSegments.isEmpty()) {
            this.clearVisiblePositionRange();
        }
        return this.visibleRangeSegments;
    }

    public void clearVisiblePositionRange() {
        this.visibleRangeSegments.removeAllElements();
        int[] nArray = new int[]{this.min_pos, this.max_pos};
        this.visibleRangeSegments.add(nArray);
    }

    public void calculateVisiblePositionRange(Rectangle rectangle) {
        Point point = new Point(rectangle.x, rectangle.y);
        Point point2 = new Point(rectangle.x + rectangle.width, rectangle.y);
        Point point3 = new Point(rectangle.x, rectangle.y + rectangle.height);
        Point point4 = new Point(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        Point point5 = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.calculateRangeCutOffBySemiplane(point, point2, point5);
        this.calculateRangeCutOffBySemiplane(point2, point4, point5);
        this.calculateRangeCutOffBySemiplane(point4, point3, point5);
        this.calculateRangeCutOffBySemiplane(point3, point, point5);
    }

    private void makeRangeSegmentInvisible(int n, int n2) {
        if (this.visibleRangeSegments.isEmpty()) {
            this.clearVisiblePositionRange();
        }
        if (n >= n2 || n2 < ((int[])this.visibleRangeSegments.firstElement())[0] || n > ((int[])this.visibleRangeSegments.lastElement())[1]) {
            return;
        }
        for (int i = 0; i < this.visibleRangeSegments.size(); ++i) {
            int[] nArray = (int[])this.visibleRangeSegments.elementAt(i);
            if (n2 < nArray[0] || n > nArray[1]) continue;
            if (n <= nArray[0] && n2 < nArray[1]) {
                nArray[0] = n2 + 1;
                continue;
            }
            if (n > nArray[0] && n2 >= nArray[1]) {
                nArray[1] = n - 1;
                continue;
            }
            if (n <= nArray[0] && n2 >= nArray[1]) {
                this.visibleRangeSegments.removeElement(nArray);
                --i;
                continue;
            }
            if (n <= nArray[0] || n2 >= nArray[1]) continue;
            int n3 = nArray[1];
            nArray[1] = n - 1;
            int[] nArray2 = new int[]{n2 + 1, n3};
            this.visibleRangeSegments.insertElementAt(nArray2, i + 1);
        }
    }

    private void calculateRangeCutOffBySemiplane(Point point, Point point2, Point point3) {
        boolean bl;
        boolean bl2 = bl = point.x == point2.x;
        boolean bl3 = bl ? point.x < point3.x && (double)point.x < this.center || point.x > point3.x && (double)point.x > this.center : point.y < point3.y && (double)point.y < this.center || point.y > point3.y && (double)point.y > this.center;
        double d = this.radius + (double)(bl3 ? -this.below_pixels : this.above_pixels);
        double d2 = this.center - (double)(bl ? point.x : point.y);
        if (d2 > d) {
            if (!bl3) {
                this.makeRangeSegmentInvisible(this.min_pos, this.max_pos);
            }
        } else {
            boolean bl4;
            int n;
            int n2 = (int)this.center;
            int n3 = (int)Math.sqrt(d * d - d2 * d2);
            Point point4 = bl ? new Point(point.x, n2 - n3) : new Point(n2 - n3, point.y);
            Point point5 = bl ? new Point(point.x, n2 + n3) : new Point(n2 + n3, point.y);
            int n4 = this.getPositionLocally(point4);
            if (n4 > (n = this.getPositionLocally(point5))) {
                int n5 = n4;
                n4 = n;
                n = n5;
            }
            Point point6 = this.getPointLocally((n4 + n) / 2, 0.0);
            boolean bl5 = bl4 = bl && ((double)point6.x - this.center) * ((double)point.x - this.center) > 0.0 || !bl && ((double)point6.y - this.center) * ((double)point.y - this.center) > 0.0;
            if (bl3 == bl4) {
                this.makeRangeSegmentInvisible(n4, n);
            } else {
                this.makeRangeSegmentInvisible(this.min_pos, n4 - 1);
                this.makeRangeSegmentInvisible(n + 1, this.max_pos);
            }
        }
    }

    public int getShape() {
        return 112;
    }

    public void setMainStartAngle(double d) {
        this.main_start_angle = d;
    }

    public double getMainStartAngle() {
        return this.main_start_angle;
    }

    public void setShouldSplit(boolean bl) {
        this.shouldSplit = bl;
    }

    public boolean isShouldSplit() {
        return this.shouldSplit;
    }

    public void setMaxPosition(int n) {
        this.max_pos = n;
    }

    public void setMinPosition(int n) {
        this.min_pos = n;
    }
}

