/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.ParseTask;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.URLLoader;
import ca.ucalgary.bluejay.client.XPointerResolver;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.CanvasPopupItemGenerator;
import ca.ucalgary.bluejay.gui.DataNavigator;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.Zoom;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.util.SVGEventMasker;
import ca.ucalgary.seahawk.util.DynamicJPopupMenu;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.batik.swing.gvt.JGVTComponentListener;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CanvasMouseListener
extends ComponentAdapter
implements JGVTComponentListener,
MouseListener,
MouseMotionListener,
ActionListener {
    private static final int SOME_ABSURD_NEGATIVE_NUMBER = -777557;
    private Point prevTranslate = new Point(-777557, -777557);
    private int scaledStartPosition;
    private int selectedStartPosition;
    private int selectedEndPosition;
    private Point selectedStartPoint;
    private Point trueStartPoint;
    private Point trueEndPoint;
    private boolean isTextSelected = false;
    private final int REGION_OFF = 0;
    private final int POINT_SELECTED = 1;
    private final int REGION_SELECTED = 2;
    private int regionSelectionStatus = 0;
    private static boolean isSelectable = false;
    private static boolean isOnSelectable = false;
    private static boolean isDraggedOnSelectable = false;
    private static boolean isBorderCrossed = false;
    public static final boolean ADD_TO_HISTORY = true;
    private BluejayDObjectList canvas;
    private AbstractLinearGraphics alg;
    private URLLoader url_loader;
    private SVGEventMasker svgEventMasker;
    private static Logger logger = Logger.getLogger(CanvasMouseListener.class);
    private static final Color LIGHT_BLUE = new Color(100, 100, 255, 100);
    private static final Color LIGHT_MAGENTA = new Color(255, 100, 255, 100);
    public static final String CHECKING_LINKS_POPUP_MSG = "Checking for links...";
    private JMenuItem checkingLinksPopupItem;

    public CanvasMouseListener(BluejayDObjectList bluejayDObjectList, URLLoader uRLLoader, SVGEventMasker sVGEventMasker) {
        this.canvas = bluejayDObjectList;
        this.alg = this.canvas.getAbstractLinearGraphics();
        this.svgEventMasker = sVGEventMasker;
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
        this.url_loader = uRLLoader;
        XPointerResolver.setBluejayParser(this.canvas.getBluejayParser());
        JPopupMenu.setDefaultLightWeightPopupEnabled(true);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.alg.isInChartMode()) {
            return;
        }
        int n = mouseEvent.getModifiers();
        if (mouseEvent.isControlDown()) {
            if ((n & 0x10) != 0) {
                if (this.alg.isInTextMode() && (!isDraggedOnSelectable || isBorderCrossed)) {
                    return;
                }
                this.regionSelectionToolTip(mouseEvent);
            }
        }
        if (mouseEvent.isShiftDown()) {
            if (this.alg.isInTextMode()) {
                return;
            }
            if ((n & 4) != 0) {
                this.regionScalingToolTip(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!isOnSelectable && this.alg.isInTextMode()) {
            if (this.canvas.getToolTipText() != null) {
                this.canvas.setToolTipText(null);
            }
            return;
        }
        String string = null;
        Point point = mouseEvent.getPoint();
        DataNavigator dataNavigator = this.canvas.getDataNavigator();
        Point2D point2D = dataNavigator.getCanvasToTrueCoords(point.x, point.y);
        String string2 = dataNavigator.getHitGraphicsNodeXPointer(point2D.getX(), point2D.getY());
        Document document = this.canvas.getDocument();
        Node node = null;
        if (string2 != null && !string2.equals("")) {
            this.canvas.getCompMenuMan();
            if (!ComparisonMenuManager.isComparison) {
                if (document != null && document.getDocumentElement() != null) {
                    node = XPointerResolver.getNodeFromXPointer(document, string2);
                    if (node == null) {
                        this.canvas.setToolTipText(string);
                        return;
                    }
                } else {
                    node = XPointerResolver.getNodeFromXPointer(this.url_loader.getActualURLName(), string2, this.canvas.getBluejayParser());
                    if (node == null) {
                        this.canvas.setToolTipText(string);
                        return;
                    }
                }
            } else {
                int n = dataNavigator.getHitGraphicsNodeGenomeNum(point2D.getX(), point2D.getY());
                Genome genome = this.canvas.getComparisonPool().getSeqsFromPool().elementAt(n);
                node = XPointerResolver.getNodeFromXPointer(genome, string2);
                if (node == null) {
                    this.canvas.setToolTipText(string);
                    return;
                }
            }
        }
        if (node != null && node instanceof DTDElementInstance) {
            DTDElementInstance dTDElementInstance = (DTDElementInstance)node;
            string = string2.equals(dTDElementInstance.getXPointer()) ? dTDElementInstance.getPainter().getToolTip(dTDElementInstance) : (this.canvas.getAbstractLinearGraphics().getArrayViewer().isComparisonSelected() ? this.canvas.getAbstractLinearGraphics().getArrayComparisonPainter().getToolTip(dTDElementInstance) : this.canvas.getAbstractLinearGraphics().getArrayPainter().getToolTip(dTDElementInstance));
        }
        this.canvas.setToolTipText(string);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (this.alg.isInTextMode()) {
            if (mouseEvent.isShiftDown()) {
                if ((n & 0x10) != 0) {
                    this.canvas.getEventCoordinator().notify(8, "Mouse off-canvas, panning cancelled");
                }
            }
        } else {
            this.scaledStartPosition = 0;
            this.selectedStartPosition = 0;
            if (mouseEvent.isControlDown()) {
                if ((n & 0x10) != 0) {
                    this.canvas.getEventCoordinator().notify(8, "Mouse off-canvas, range selection cancelled");
                }
                if ((n & 4) != 0) {
                    this.canvas.getEventCoordinator().notify(8, "Mouse off-canvas, rotation cancelled");
                }
            }
            if (mouseEvent.isShiftDown()) {
                if ((n & 0x10) != 0) {
                    this.canvas.getEventCoordinator().notify(8, "Mouse off-canvas, panning cancelled");
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.alg.isInChartMode()) {
            return;
        }
        if (mouseEvent.isShiftDown() || mouseEvent.isControlDown()) {
            this.selectedStartPosition = 0;
            this.scaledStartPosition = 0;
            this.pointSelectionToolTip(mouseEvent);
            isBorderCrossed = false;
            return;
        }
        if (this.isTextSelected) {
            if (mouseEvent.getButton() == 1) {
                this.isTextSelected = false;
                this.regionSelectionStatus = 0;
                this.canvas.getEventCoordinator().notify(8, "Text selection cancelled");
                return;
            }
        }
        Point point = mouseEvent.getPoint();
        if (this.checkingLinksPopupItem == null) {
            this.checkingLinksPopupItem = new JMenuItem(CHECKING_LINKS_POPUP_MSG);
        }
        DynamicJPopupMenu dynamicJPopupMenu = new DynamicJPopupMenu();
        dynamicJPopupMenu.add(this.checkingLinksPopupItem);
        dynamicJPopupMenu.show(this.canvas, point.x, point.y);
        int n = this.canvas.getDataNavigator().getCanvasPointPosition(mouseEvent.getX(), mouseEvent.getY(), this.canvas.getVisibilityManager().getFocusTarget());
        CanvasPopupItemGenerator canvasPopupItemGenerator = new CanvasPopupItemGenerator((JPopupMenu)dynamicJPopupMenu, this.checkingLinksPopupItem, this.url_loader, mouseEvent, n, this.isTextSelected, this.trueStartPoint, this.trueEndPoint, this.selectedStartPosition, this.selectedEndPosition, this.canvas, this);
        canvasPopupItemGenerator.start();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.alg.isInChartMode()) {
            return;
        }
        if (this.alg.isInTextMode()) {
            if (!isSelectable) {
                return;
            }
            if (this.isTextSelected) {
                this.canvas.getEventCoordinator().notify(8, "Selected range [" + this.selectedStartPosition + ", " + this.selectedEndPosition + "]");
            } else {
                this.canvas.getEventCoordinator().notify(8, "Text not selected");
            }
            this.canvas.getTextSelectionManager().setSelectionOverlayColor(LIGHT_BLUE);
        } else {
            if (this.regionSelectionStatus == 1) {
                this.canvas.getEventCoordinator().notify(8, "Region not selected");
            }
            this.regionSelectionStatus = 0;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (actionEvent.getActionCommand().startsWith("gotoLink_")) {
                URL uRL = new URL(actionEvent.getActionCommand().substring("gotoLink_".length()));
                if (!uRL.toString().endsWith(".xml") && !uRL.toString().endsWith(".bioml")) {
                    try {
                        BrowserLauncher.openURL(uRL.toString());
                    }
                    catch (IOException iOException) {
                        logger.error("Cannot make BrowserLauncher to launch url " + uRL + ", " + iOException.getMessage());
                        iOException.printStackTrace();
                    }
                } else {
                    this.replaceURL(uRL);
                }
            } else if (actionEvent.getActionCommand().startsWith("embedLink_")) {
                String string = actionEvent.getActionCommand();
                int n = 1 + string.indexOf(95);
                int n2 = 1 + string.indexOf(95, n + 1);
                String string2 = string.substring(n, n2 - 1);
                URL uRL = new URL(actionEvent.getActionCommand().substring(n2));
                if (!uRL.getFile().endsWith(".xml") && !uRL.getFile().endsWith(".bioml")) {
                    logger.warn("Invalid file extension for embedded link, can only support .xml or .bioml");
                } else {
                    this.embedURL(uRL, true, string2);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("ERROR: URL to link to was not well formed: " + malformedURLException);
        }
    }

    public void embedURL(URL uRL, boolean bl, String string) {
        ParseTask parseTask = this.url_loader.getTask();
        parseTask.setActualURLName(this.url_loader.getActualURLName());
        parseTask.go(uRL, string);
    }

    public void replaceURL(URL uRL) {
        ParseTask parseTask = this.url_loader.getTask();
        parseTask.setActualURLName(this.url_loader.getActualURLName());
        parseTask.go(uRL);
    }

    /*
     * Unable to fully structure code
     */
    private void pointSelectionToolTip(MouseEvent var1_1) {
        block10: {
            block12: {
                block11: {
                    block9: {
                        var2_2 = this.canvas.getDataNavigator().getCanvasPointPosition(var1_1.getX(), var1_1.getY(), this.canvas.getVisibilityManager().getFocusTarget());
                        if (var2_2 == 0) {
                            return;
                        }
                        this.selectedStartPosition = this.scaledStartPosition = var2_2;
                        this.selectedEndPosition = this.scaledStartPosition;
                        this.selectedStartPoint = var1_1.getPoint();
                        this.trueStartPoint = new Point();
                        this.trueEndPoint = new Point();
                        var3_3 = "Selected position " + var2_2;
                        if (!this.alg.isInTextMode()) break block9;
                        if (!var1_1.isControlDown()) ** GOTO lbl18
                        if (var1_1.getButton() != 1) ** GOTO lbl18
                        if (CanvasMouseListener.isSelectable) {
                            var3_3 = var3_3 + ", move mouse to select text";
                        } else {
                            return;
lbl18:
                            // 2 sources

                            if (var1_1.isShiftDown()) {
                                if (var1_1.getButton() == 1) {
                                    var3_3 = "Move mouse to pan";
                                }
                            }
                        }
                        this.canvas.getTextSelectionManager().setSelectionOverlayColor(CanvasMouseListener.LIGHT_MAGENTA);
                        break block10;
                    }
                    if (!var1_1.isControlDown()) break block11;
                    if (var1_1.getButton() != 1) break block11;
                    this.regionSelectionStatus = 1;
                    var3_3 = var3_3 + ", move mouse to select region";
                    break block10;
                }
                if (!var1_1.isControlDown()) break block12;
                if (var1_1.getButton() != 3) break block12;
                var3_3 = var3_3 + ", move mouse to rotate around it";
                break block10;
            }
            if (!var1_1.isShiftDown()) ** GOTO lbl-1000
            if (var1_1.getButton() == 1) {
                var3_3 = "Move mouse to pan";
            } else if (var1_1.isShiftDown()) {
                if (var1_1.getButton() == 3) {
                    var3_3 = "Move mouse down to zoom in, up to zoom out";
                }
            }
        }
        this.canvas.getEventCoordinator().notify(8, var3_3);
    }

    private void regionScalingToolTip(MouseEvent mouseEvent) {
        if (this.scaledStartPosition == 0) {
            return;
        }
        double d = 1.0 / Math.sqrt(this.canvas.getPaintingTransform().getDeterminant());
        int[] nArray = this.canvas.getRectRange(d, this.canvas.getVisibilityManager().getFocusTarget(), this.scaledStartPosition);
        this.selectedStartPosition = nArray[0];
        this.selectedEndPosition = nArray[1];
        this.canvas.getEventCoordinator().notify(8, "Mouse button release zooms " + (d > 1.0 ? "in" : "out") + " to display [" + nArray[0] + ", " + nArray[1] + "], centered on " + this.scaledStartPosition + " with zoom " + d);
    }

    private void regionSelectionToolTip(MouseEvent mouseEvent) {
        Hashtable hashtable;
        TargetAppearance targetAppearance;
        int n;
        int n2;
        int n3;
        int n4;
        if (this.selectedStartPosition == 0) {
            return;
        }
        if (!this.isTextSelected && this.alg.isInTextMode()) {
            this.isTextSelected = true;
        }
        if (this.regionSelectionStatus == 1 && !this.alg.isInTextMode()) {
            this.regionSelectionStatus = 2;
        }
        if ((n4 = this.selectedStartPoint.x) > (n3 = mouseEvent.getX())) {
            n2 = n4;
            n4 = n3;
            n3 = n2;
        }
        if ((n2 = this.selectedStartPoint.y) > (n = mouseEvent.getY())) {
            int n5 = n2;
            n2 = n;
            n = n5;
        }
        if (this.alg.isTextHMode()) {
            this.trueStartPoint.x = n4;
            this.trueEndPoint.x = n3;
            this.trueStartPoint.y = this.trueEndPoint.y = this.selectedStartPoint.y;
        } else if (this.alg.isTextVMode()) {
            this.trueStartPoint.y = n2;
            this.trueEndPoint.y = n;
            this.trueStartPoint.x = this.trueEndPoint.x = this.selectedStartPoint.x;
        } else {
            this.trueStartPoint.x = n4;
            this.trueStartPoint.y = n2;
            this.trueEndPoint.x = n3;
            this.trueEndPoint.y = n;
        }
        double d = 0.0;
        DataNavigator dataNavigator = this.canvas.getDataNavigator();
        int n6 = this.canvas.getVisibilityManager().getFocusTarget();
        int n7 = dataNavigator.getCanvasPointPosition(n4, n2, n6);
        int n8 = dataNavigator.getCanvasPointPosition(n4, n, n6);
        int n9 = dataNavigator.getCanvasPointPosition(n3, n2, n6);
        int n10 = dataNavigator.getCanvasPointPosition(n3, n, n6);
        if (!(n7 <= n9 || (targetAppearance = (TargetAppearance)(hashtable = this.canvas.getCircularTargets()).get(new Integer(this.canvas.getVisibilityManager().getFocusTarget()))) != null && (double)n7 > (double)targetAppearance.getMaxPosition() * 0.75 && (double)n9 < (double)targetAppearance.getMaxPosition() * 0.25)) {
            int n11 = n7;
            n7 = n9;
            n9 = n11;
            n11 = n8;
            n8 = n10;
            n10 = n11;
        }
        if (n8 < n7) {
            n7 = n8;
        }
        if (n10 > n9) {
            n9 = n10;
        }
        this.selectedStartPosition = n7;
        this.selectedEndPosition = n9;
        if (this.alg.isInTextMode()) {
            this.canvas.getEventCoordinator().notify(8, "Mouse button release selects range [" + n7 + ", " + n9 + "]");
        } else {
            this.canvas.getEventCoordinator().notify(8, "Mouse button release displays selected range [" + n7 + ", " + n9 + "]");
        }
    }

    private void finalizeRangeSelection() {
        if (this.selectedEndPosition == 0 || this.selectedStartPosition == 0) {
            return;
        }
        int n = (this.selectedStartPosition + this.selectedEndPosition) / 2;
        if (this.selectedStartPosition > this.selectedEndPosition) {
            Hashtable hashtable = this.canvas.getCircularTargets();
            TargetAppearance targetAppearance = (TargetAppearance)hashtable.get(new Integer(this.canvas.getVisibilityManager().getFocusTarget()));
            int n2 = targetAppearance.getMaxPosition();
            if (targetAppearance != null) {
                n = (n + n2 / 2) % n2;
            }
        }
        logger.debug("Final zoom in range is [" + this.selectedStartPosition + ", " + this.selectedEndPosition + "], with focus at " + n);
        this.canvas.getVisibilityManager().setVisibleRange(this.canvas.getVisibilityManager().getFocusTarget(), this.selectedStartPosition, this.selectedEndPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void componentTransformChanged(ComponentEvent componentEvent) {
        if (componentEvent.getComponent() != this.canvas) {
            return;
        }
        double d = 100.0 * Math.sqrt(this.canvas.getRenderingTransform().getDeterminant());
        Zoom zoom = this.canvas.getBatikZoom();
        if (d != 100.0) {
            if (Math.abs(d - zoom.getCurrentZoom()) > 1.0E-6) {
                if (this.svgEventMasker.isZoomIgnoring()) {
                    return;
                }
                double d2 = this.canvas.getAbstractLinearGraphics().getScale();
                double d3 = d2 / (d / 100.0);
                logger.info("### CanvasMouseListener componentTransformChanged() ZOOM  " + d + " effective scale is now " + d3 + "bases/pixel");
                VisibilityManager visibilityManager = this.canvas.getVisibilityManager();
                boolean bl = this.svgEventMasker.isZoomIgnoring();
                this.svgEventMasker.setZoomIgnoring(true);
                try {
                    visibilityManager.setScale(d3);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error(illegalArgumentException.getMessage());
                    this.canvas.resetRenderingTransform();
                    this.svgEventMasker.setZoomIgnoring(bl);
                    this.canvas.getEventCoordinator().notify(8, "Cannot zoom in that much, zoom cancelled");
                    return;
                }
                this.svgEventMasker.setZoomIgnoring(bl);
                this.finalizeRangeSelection();
                return;
            }
        }
        if (this.svgEventMasker.isTranslationIgnoring()) {
            return;
        }
        int n = (int)this.canvas.getRenderingTransform().getTranslateX();
        int n2 = (int)this.canvas.getRenderingTransform().getTranslateY();
        if (this.prevTranslate.x == n && this.prevTranslate.y == n2) return;
        boolean bl = this.prevTranslate.x != 0 || this.prevTranslate.y != 0;
        boolean bl2 = n != 0 || n2 != 0;
        boolean bl3 = Math.abs(d - 100.0) < 1.0E-6;
        boolean bl4 = true;
        if (this.prevTranslate.x == n) {
            try {
                int n3 = ((TargetAppearance)this.canvas.getAbstractLinearGraphics().getTargetAppearances().elementAt(0)).getShape();
                bl4 = n3 != 111;
            }
            catch (Exception exception) {
                logger.error(exception.getMessage());
            }
        }
        this.prevTranslate.x = n;
        this.prevTranslate.y = n2;
    }

    public static void setIsSelectable(boolean bl) {
        isSelectable = bl;
    }

    public static boolean getIsSelectable() {
        return isSelectable;
    }

    public static void setIsOnSelectable(boolean bl) {
        isOnSelectable = bl;
    }

    public static boolean getIsOnSelectable() {
        return isOnSelectable;
    }

    public static void setIsDraggedOnSelectable(boolean bl) {
        isDraggedOnSelectable = bl;
    }

    public static boolean getIsDraggedOnSelectable() {
        return isDraggedOnSelectable;
    }

    public static void setIsBorderCrossed(boolean bl) {
        isBorderCrossed = bl;
    }

    public static boolean getIsBorderCrossed() {
        return isBorderCrossed;
    }
}

