/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ColorGradientPreview
extends JPanel {
    private BufferedImage currentPosGradient;
    private BufferedImage currentNegGradient;
    private Color posColor;
    private Color negColor;
    private static Logger logger = Logger.getLogger(ColorGradientPreview.class);

    public ColorGradientPreview(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        this.currentNegGradient = bufferedImage;
        this.currentPosGradient = bufferedImage2;
        this.posColor = new Color(bufferedImage2.getRGB(bufferedImage2.getWidth() - 1, 0));
        this.negColor = new Color(bufferedImage.getRGB(0, 0));
        super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
        this.setSize(200, 70);
        this.setPreferredSize(new Dimension(200, 70));
        this.setVisible(true);
    }

    public ColorGradientPreview() {
        super.setBorder(new TitledBorder(new EtchedBorder(1), "Gradient Preview"));
        this.setSize(200, 70);
        this.setPreferredSize(new Dimension(200, 70));
        this.setVisible(true);
    }

    public void paint(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.drawImage(this.currentNegGradient, 0, 0, this.getWidth() / 2, this.getHeight(), null);
        graphics.drawImage(this.currentPosGradient, this.getWidth() / 2, 0, this.getWidth() / 2, this.getHeight(), null);
    }

    public BufferedImage createGradientImage(Color color, Color color2) {
        BufferedImage bufferedImage = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(256, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, color, 255.0f, 0.0f, color2);
        graphics2D.setPaint(gradientPaint);
        graphics2D.drawRect(0, 0, 255, 1);
        return bufferedImage;
    }

    public BufferedImage getPositiveGradient() {
        return this.currentPosGradient;
    }

    public BufferedImage getNegativeGradient() {
        return this.currentNegGradient;
    }

    public void setPositiveGradient(BufferedImage bufferedImage) {
        this.currentPosGradient = bufferedImage;
    }

    public void setNegativeGradient(BufferedImage bufferedImage) {
        this.currentNegGradient = bufferedImage;
    }
}

