/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.CanvasScrollListener;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.util.SVGEventMasker;
import ca.ucalgary.bluejay.session.StateCollection;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JScrollBar;
import javax.swing.JSplitPane;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.log4j.Logger;

public class DataNavigator
extends ComponentAdapter
implements PropertyChangeListener {
    private BluejayDObjectList dlist;
    private StateCollection collection;
    private VisibilityManager vizMgr;
    private JScrollBar horScroll;
    private JScrollBar verScroll;
    private JSplitPane horScrollSplitPane;
    private JSplitPane verScrollSplitPane;
    private CanvasScrollListener horScrollListener;
    private CanvasScrollListener verScrollListener;
    private Dimension2D previousDocSize = null;
    private int previousTargetInFocus;
    private int previousPositionInFocus;
    private SVGEventMasker svgEventMasker;
    private boolean ignorePreviousPositionOnceFlag = false;
    private boolean enforcePositionFocusing = false;
    private boolean alreadySavedPreviousPositionOnceFlag = false;
    private static final int NEGLIGIBLE_PIXEL_SCROLL = 20;
    private static final int SLEEP_INTERVAL = 200;
    private static final int SOME_ABSURD_NEGATIVE_NUMBER = -777777;
    private static final double NOT_ZOOMED_IN_MUCH = 300.0;
    private static final double ALMOST_ZERO = 1.0E-6;
    private static final double ALMOST_HALF = 0.45;
    private static Logger logger = Logger.getLogger(DataNavigator.class);

    private DataNavigator() {
    }

    public DataNavigator(BluejayDObjectList bluejayDObjectList, SVGEventMasker sVGEventMasker) {
        this.dlist = bluejayDObjectList;
        this.collection = new StateCollection();
        this.svgEventMasker = sVGEventMasker;
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
        this.vizMgr.addPropertyChangeListener("target focus", this);
    }

    public int getCanvasPointPosition(int n, int n2, int n3) {
        AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
        Point2D point2D = this.getCanvasToTrueCoords(n, n2);
        Point point = new Point((int)point2D.getX(), (int)point2D.getY());
        if (abstractLinearGraphics.getTargetAppearances().size() <= n3) {
            return 0;
        }
        TargetAppearance targetAppearance = (TargetAppearance)abstractLinearGraphics.getTargetAppearances().elementAt(n3);
        return abstractLinearGraphics.getPosition(targetAppearance, point);
    }

    public int getTruePointPosition(int n, int n2, int n3) {
        AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
        Point point = new Point(n, n2);
        Vector vector = abstractLinearGraphics.getTargetAppearances();
        if (vector == null || vector.size() == 0) {
            return 1;
        }
        TargetAppearance targetAppearance = (TargetAppearance)vector.elementAt(n3);
        return abstractLinearGraphics.getPosition(targetAppearance, point);
    }

    public Point2D getCanvasToTrueCoords(float f, float f2) {
        float f3 = f;
        float f4 = f2;
        AffineTransform affineTransform = this.dlist.getViewBoxTransform();
        if (affineTransform != null) {
            try {
                affineTransform = affineTransform.createInverse();
                Point2D point2D = affineTransform.transform(new Point2D.Float(f, f2), null);
                return point2D;
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                logger.error("MATRIX IS NOT INVERTABLE!!! " + noninvertibleTransformException.getMessage());
            }
        }
        return new Point2D.Float(f3, f4);
    }

    public int getTargetInFocus() {
        int[] nArray = this.getTargetPositionInFocus();
        return nArray[0];
    }

    public int getPositionInFocus() {
        int[] nArray = this.getTargetPositionInFocus();
        return nArray[1];
    }

    public int getPositionInFocus(int n) {
        return this.getPositionInFocus();
    }

    public void setTextModePosition() {
        if (this.previousTargetInFocus >= 0 && this.previousPositionInFocus > 0) {
            this.dlist.getAbstractLinearGraphics().setTextModePosition(this.previousPositionInFocus);
        }
    }

    private int[] getTargetPositionInFocus() {
        if (this.vizMgr == null) {
            logger.warn("Warning: attempted to get target focus before VisibilityManager set, returning null focus");
            return null;
        }
        int[] nArray = new int[]{this.vizMgr.getFocusTarget(), this.vizMgr.getFocusPosition()};
        return nArray;
    }

    public void setIgnorePreviousPositionOnceFlag(boolean bl) {
        this.ignorePreviousPositionOnceFlag = bl;
    }

    public void doSmartPositioning() {
        this.dlist.getAbstractLinearGraphics().setPreserveTargetAppearances(true);
    }

    public void clearPositionSettings() {
        this.previousPositionInFocus = -777777;
        this.previousTargetInFocus = -777777;
        this.dlist.getAbstractLinearGraphics().clearVisiblePositionRange();
    }

    public String getHitGraphicsNodeXPointer(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        GraphicsNode graphicsNode = this.dlist.getGraphicsNode();
        if (graphicsNode != null && graphicsNode.contains(double_)) {
            GraphicsNode graphicsNode2 = graphicsNode.nodeHitAt(double_);
            String string = graphicsNode2 != null && graphicsNode2.isVisible() ? graphicsNode2.getDataXPointer() : null;
            return string;
        }
        return null;
    }

    public int getHitGraphicsNodeGenomeNum(double d, double d2) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        GraphicsNode graphicsNode = this.dlist.getGraphicsNode();
        if (graphicsNode != null && graphicsNode.contains(double_)) {
            GraphicsNode graphicsNode2 = graphicsNode.nodeHitAt(double_);
            int n = graphicsNode2 != null && graphicsNode2.isVisible() ? graphicsNode2.getDataGenomeNum() : 0;
            return n;
        }
        return 0;
    }

    public void setHorizontalScrollBar(JScrollBar jScrollBar) {
        this.horScroll = jScrollBar;
        if (this.horScroll != null) {
            this.horScrollSplitPane = (JSplitPane)this.horScroll.getParent();
            this.horScrollListener = new CanvasScrollListener(this.horScroll, this.dlist);
        }
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.horScroll;
    }

    public void setVerticalScrollBar(JScrollBar jScrollBar) {
        this.verScroll = jScrollBar;
        if (this.verScroll != null) {
            this.verScrollSplitPane = (JSplitPane)this.verScroll.getParent();
            this.verScrollListener = new CanvasScrollListener(this.verScroll, this.dlist);
        }
    }

    public JScrollBar getVerticalScrollBar() {
        return this.verScroll;
    }

    private boolean showOrHideScrollBar(JScrollBar jScrollBar, JSplitPane jSplitPane) {
        AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
        if (jSplitPane == null && jScrollBar != null) {
            jSplitPane = (JSplitPane)jScrollBar.getParent();
        }
        if (jSplitPane != null) {
            if (jScrollBar.getVisibleAmount() + 20 > jScrollBar.getMaximum()) {
                if (jSplitPane.getBottomComponent() != null) {
                    jSplitPane.remove(jScrollBar);
                    jSplitPane.setBottomComponent(null);
                    logger.debug("### DList.showOrHideScrollBar() REMOVE " + (jScrollBar == this.horScroll ? "HOR" : "VER") + ", scrollBar.getVisibleAmount()=" + jScrollBar.getVisibleAmount() + " + " + 20 + " > scrollBar.getMaximum()=" + jScrollBar.getMaximum());
                    return true;
                }
            } else if (jSplitPane.getBottomComponent() == null) {
                jSplitPane.setBottomComponent(jScrollBar);
                logger.debug("### DList.showOrHideScrollBar() ADD " + (jScrollBar == this.horScroll ? "HOR" : "VER") + ", scrollBar.getVisibleAmount()=" + jScrollBar.getVisibleAmount() + " + " + 20 + " <= scrollBar.getMaximum()=" + jScrollBar.getMaximum());
                return true;
            }
        }
        return false;
    }

    public void repaintScrollBars() {
        boolean bl = this.showOrHideScrollBar(this.horScroll, this.horScrollSplitPane);
        boolean bl2 = this.showOrHideScrollBar(this.verScroll, this.verScrollSplitPane);
        logger.debug("###  repaintScrollBars  changedHorVisibility=" + bl + ", changedVerVisibility=" + bl2);
        if (bl || bl2) {
            Container container = this.dlist.getParent();
            if (this.verScrollSplitPane != null) {
                this.verScrollSplitPane.resetToPreferredSizes();
            }
            if (this.horScrollSplitPane != null) {
                this.horScrollSplitPane.resetToPreferredSizes();
            }
            if (container != null) {
                container.validate();
            }
            this.dlist.validate();
            if (this.verScrollSplitPane != null) {
                this.verScrollSplitPane.repaint();
            }
            if (this.horScrollSplitPane != null) {
                this.horScrollSplitPane.repaint();
            }
            if (container != null) {
                container.repaint();
            }
            this.dlist.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != this.vizMgr) {
            logger.warn("Programmer error: DataNavigator received property change notification from unexpected source (" + propertyChangeEvent.getSource() + ", ignoring");
            return;
        }
        this.scrollToFocus();
    }

    private void scrollToFocus() {
        int n = this.vizMgr.getFocusPosition();
        if (n == Integer.MIN_VALUE || n == 0) {
            return;
        }
        if (this.dlist.getAbstractLinearGraphics().isInChartMode()) {
            return;
        }
        if (this.vizMgr.getScale() == -5.898) {
            return;
        }
        Point point = this.dlist.getAbstractLinearGraphics().getPoint(this.vizMgr.getFocusTarget(), n, 0.0);
        boolean bl = this.svgEventMasker.isTranslationIgnoring();
        this.svgEventMasker.setTranslationIgnoring(true);
        boolean bl2 = this.svgEventMasker.isZoomIgnoring();
        this.svgEventMasker.setZoomIgnoring(true);
        while (point == null) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("    -> DataNavigator.scrollToFocus(): Sleep interrupted");
                return;
            }
            point = this.dlist.getAbstractLinearGraphics().getPoint(this.vizMgr.getFocusTarget(), n, 0.0);
        }
        int n2 = point.x;
        if (this.horScroll != null) {
            if ((n2 -= this.horScroll.getVisibleAmount() / 2) < 0) {
                n2 = 0;
            }
            if (n2 < this.horScroll.getMaximum() && n2 > this.horScroll.getMaximum() - this.horScroll.getVisibleAmount()) {
                n2 = this.horScroll.getMaximum() - this.horScroll.getVisibleAmount();
            }
            if (this.horScroll.getValue() != n2) {
                this.horScroll.setValue(n2);
            }
        }
        int n3 = point.y;
        if (this.verScroll != null) {
            if ((n3 -= this.verScroll.getVisibleAmount() / 2) < 1) {
                n3 = 1;
            }
            if (n3 < this.verScroll.getMaximum() && n3 > this.verScroll.getMaximum() - this.verScroll.getVisibleAmount()) {
                n3 = this.verScroll.getMaximum() - this.verScroll.getVisibleAmount();
            }
            if (this.verScroll.getValue() != n3) {
                this.verScroll.setValue(n3);
            }
        }
        this.dlist.setRenderingTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, (double)(-1 * n2), (double)(-1 * n3)));
        this.dlist.setTranslation(-1 * n2, -1 * n3);
        this.svgEventMasker.setTranslationIgnoring(bl);
        this.svgEventMasker.setZoomIgnoring(bl2);
    }

    public void recalculateScrollBars(Dimension dimension) {
        boolean bl;
        boolean bl2 = this.svgEventMasker.isTranslationIgnoring();
        this.svgEventMasker.setTranslationIgnoring(true);
        boolean bl3 = this.svgEventMasker.isZoomIgnoring();
        this.svgEventMasker.setZoomIgnoring(true);
        AbstractLinearGraphics abstractLinearGraphics = this.dlist.getAbstractLinearGraphics();
        int n = (double)abstractLinearGraphics.getPageWidth() > dimension.getWidth() ? abstractLinearGraphics.getPageWidth() : (int)dimension.getWidth();
        int n2 = (double)abstractLinearGraphics.getPageHeight() > dimension.getHeight() ? abstractLinearGraphics.getPageHeight() : (int)dimension.getHeight();
        int n3 = (int)dimension.getWidth() - 1;
        int n4 = (int)dimension.getHeight() - 1;
        boolean bl4 = this.horScrollListener == null ? true : this.horScrollListener.isIgnoringAdjustment();
        boolean bl5 = bl = this.verScrollListener == null ? true : this.verScrollListener.isIgnoringAdjustment();
        if (this.horScrollListener != null) {
            this.horScrollListener.setIgnoreAdjustment(true);
        }
        if (this.verScrollListener != null) {
            this.verScrollListener.setIgnoreAdjustment(true);
        }
        if (this.horScroll != null) {
            this.horScroll.setVisibleAmount(n3);
            this.horScroll.setMinimum(0);
            this.horScroll.setMaximum(n);
            this.horScroll.setBlockIncrement(n3 / 2);
        }
        if (this.verScroll != null) {
            this.verScroll.setVisibleAmount(n4);
            this.verScroll.setMinimum(0);
            this.verScroll.setMaximum(n2);
            this.verScroll.setBlockIncrement(n4 / 2);
        }
        if (this.horScrollListener != null) {
            this.horScrollListener.setIgnoreAdjustment(false);
        }
        if (this.verScrollListener != null) {
            this.verScrollListener.setIgnoreAdjustment(false);
        }
        this.scrollToFocus();
        this.repaintScrollBars();
        logger.debug("###  recalculateScrollBars alg.getPageWidth()=" + abstractLinearGraphics.getPageWidth() + ", newSize.getWidth()=" + dimension.getWidth() + "\n                        alg.getPageHeight()=" + abstractLinearGraphics.getPageHeight() + ", newSize.getHeight()=" + dimension.getHeight() + "\n                        pageWidth=" + n + ", pageHeight=" + n2 + "\n                         (" + (this.horScroll == null ? "N/A" : "" + this.horScroll.getValue()) + ", " + (this.verScroll == null ? "N/A" : "" + this.verScroll.getValue()) + ")");
        this.svgEventMasker.setTranslationIgnoring(false);
        this.svgEventMasker.setZoomIgnoring(false);
    }
}

