/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;

public class FeatureRangeTableModel
extends DefaultTableModel {
    protected Vector deis;
    private BluejayDObjectList dlist;
    private static Logger logger = Logger.getLogger(FeatureRangeTableModel.class);

    public FeatureRangeTableModel(BluejayDObjectList bluejayDObjectList, Vector vector) {
        this.deis = vector;
        this.dlist = bluejayDObjectList;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 1 || n2 == 2) {
            return new Integer("" + super.getValueAt(n, n2));
        }
        return super.getValueAt(n, n2);
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Feature Label";
        }
        if (n == 1) {
            return "Feature Start";
        }
        if (n == 2) {
            return "Feature End";
        }
        return "?";
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        if (n == 1 || n == 2) {
            return new Integer(0).getClass();
        }
        return "".getClass();
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 != 0) {
            return true;
        }
        DTDElementInstance dTDElementInstance = (DTDElementInstance)this.deis.elementAt(0);
        if (dTDElementInstance == null) {
            return false;
        }
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            return false;
        }
        return abstractLinearPainter.isDescriptionEditable(dTDElementInstance);
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n >= this.deis.size()) {
            System.err.println("Cell edit row (" + n + ") is out of acceptable range provided [0, " + this.deis.size() + "]. Contact the program's developers.");
            return;
        }
        super.setValueAt(object, n, n2);
        DTDElementInstance dTDElementInstance = (DTDElementInstance)this.deis.elementAt(n);
        try {
            if (n2 == 0) {
                dTDElementInstance.getPainter().setDescription(dTDElementInstance, object.toString());
            } else {
                dTDElementInstance.getPainter().setFeatureRange(dTDElementInstance, new Integer(this.getValueAt(n, 1).toString()), new Integer(this.getValueAt(n, 2).toString()));
            }
            this.dlist.repaint(true);
        }
        catch (Exception exception) {
            logger.error("Could not update document based on cell edit: " + exception);
            exception.printStackTrace();
        }
    }
}

