/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.NavigateWidget;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.apache.log4j.Logger;

public class NavigationManager
extends ComponentAdapter {
    private BluejayDObjectList dlist;
    private NavigateWidget navigationPanel;
    private JToolBar navigationBar;
    private VisibilityManager vizMgr;
    static final int BAR_MARGINS = 20;
    private static Logger logger = Logger.getLogger(NavigationManager.class);

    public NavigationManager(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        if (Debug.navigation) {
            this.setNavigationBar();
        }
    }

    private void setNavigationBar() {
        this.navigationPanel = new NavigateWidget();
        this.navigationPanel.setEnabledAll(false);
        this.navigationBar = new JToolBar("Navigation");
        this.navigationBar.setLayout(new BoxLayout(this.navigationBar, 1));
        ((BasicToolBarUI)this.navigationBar.getUI()).setDockingColor(Color.darkGray);
        if (this.dlist.getInTab()) {
            this.navigationBar.setPreferredSize(new Dimension(200, 200));
        } else {
            this.navigationBar.setPreferredSize(new Dimension(200, 400));
        }
        this.navigationBar.setMinimumSize(new Dimension(200, 200));
        this.navigationBar.setMaximumSize(new Dimension(800, 800));
        this.navigationBar.setPreferredSize(new Dimension(200, 168));
        this.navigationBar.add(this.navigationPanel);
        this.navigationBar.setMargin(new Insets(0, 0, 0, 0));
        this.navigationBar.addComponentListener(this);
    }

    public void switchNavigationBarLayout() {
        Dimension dimension = this.navigationBar.getPreferredSize();
        if (dimension.equals(new Dimension(200, 200))) {
            this.navigationBar.setPreferredSize(new Dimension(300, 300));
            logger.debug("DList.switchNavigationBarLayout() -- in tab ya ya");
        } else {
            this.navigationBar.setPreferredSize(new Dimension(200, 200));
            logger.debug("DList.switchNavigationBarLayout() -- outside we are we area are");
        }
        this.navigationBar.repaint();
    }

    public void setEnabledAll(boolean bl) {
        this.navigationPanel.setEnabledAll(bl);
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel, Vector vector, Vector vector2) {
        this.navigationPanel.updateModel(defaultComboBoxModel, vector, vector2);
    }

    public JToolBar getNavigationBar() {
        return this.navigationBar;
    }

    public void setNavigationBar(JToolBar jToolBar) {
        this.navigationBar = jToolBar;
    }

    public NavigateWidget getNavigationPanel() {
        return this.navigationPanel;
    }

    public void setNavigationPanel(NavigateWidget navigateWidget) {
        this.navigationPanel = navigateWidget;
    }

    public VisibilityManager getVisibilityManager() {
        return this.vizMgr;
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
        this.navigationPanel.setVisibilityManager(visibilityManager);
    }

    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = this.navigationBar.getPreferredSize();
        Dimension dimension2 = this.navigationBar.getMinimumSize();
        Dimension dimension3 = this.navigationBar.getMaximumSize();
        this.navigationPanel.setPreferredSize(new Dimension(dimension.width - 20, dimension.height - 20));
        this.navigationPanel.setMinimumSize(new Dimension(dimension2.width - 20, dimension2.height - 20));
        this.navigationPanel.setMaximumSize(new Dimension(dimension3.width - 20, dimension3.height - 20));
        this.navigationPanel.revalidate();
        this.navigationBar.repaint();
        logger.debug("###NavigationManager.navigationBar.componentResized() navigationPanel.getSize()=" + this.navigationPanel.getSize());
    }
}

