/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.session.WaypointsGUI;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class Selector {
    DTDElementInstance currentSelection;
    BluejayDObjectList canvas;
    public static final int SELECTION_WAYPOINT_ID = 992872;
    private static Logger logger = Logger.getLogger(Selector.class);

    public Selector(BluejayDObjectList bluejayDObjectList) {
        this.canvas = bluejayDObjectList;
    }

    public DTDElementInstance getSelection() {
        return this.currentSelection;
    }

    public void setSelection(DTDElementInstance dTDElementInstance) {
        this.setSelection(dTDElementInstance, true);
    }

    public void setSelection(DTDElementInstance dTDElementInstance, boolean bl) {
        int n;
        if (this.canvas.getWaypointsWidget() == null) {
            logger.warn("No waypoints tab has been set, could not draw selection");
            return;
        }
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        if (abstractLinearPainter == null) {
            logger.warn("Feature has no painter, could not draw selection");
            return;
        }
        int[] nArray = abstractLinearPainter.getFeatureRange(dTDElementInstance);
        if (nArray == null) {
            logger.warn("Feature has no position range, could not draw selection");
            return;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        if (n2 > n3) {
            n = n2;
            n2 = n3;
            n3 = n;
        }
        this.currentSelection = dTDElementInstance;
        n = JOptionPane.showConfirmDialog(null, "Do you want to create a waypoint at \"" + abstractLinearPainter.getDescription(dTDElementInstance) + "\"?", "Create Waypoint", 0);
        if (n == 0) {
            WaypointsGUI waypointsGUI = new WaypointsGUI(this.canvas, this.canvas.getWaypointsWidget(), this.canvas.getViewMenu(), dTDElementInstance, n2);
            waypointsGUI.createWaypoint();
        }
    }
}

