/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import com.jhlabs.awt.ParagraphLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.apache.log4j.Logger;

public class ShiftWidget
extends JPanel
implements DocumentListener,
ItemListener,
ChangeListener,
PropertyChangeListener {
    private DefaultComboBoxModel model;
    private JComboBox backbones;
    private JButton apply;
    private JSlider slide;
    private JFormattedTextField textField;
    private JTextField editor;
    private Vector shifts = new Vector();
    private Vector shift_maxs = new Vector();
    private Integer current_max;
    private static Logger logger = Logger.getLogger(ShiftWidget.class);

    public ShiftWidget() {
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(200, 60));
        jPanel.setLayout(new ParagraphLayout(1, 1));
        jPanel.add((Component)new JLabel("Cut:"), ParagraphLayout.NEW_PARAGRAPH);
        this.model = new DefaultComboBoxModel();
        this.backbones = new JComboBox(this.model);
        this.backbones.addItemListener(this);
        jPanel.add(this.backbones);
        jPanel.add((Component)new JLabel("at position:"), ParagraphLayout.NEW_PARAGRAPH);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        NumberFormatter numberFormatter = new NumberFormatter(numberFormat);
        numberFormatter.setMinimum(new Integer(1));
        numberFormatter.setMaximum(new Integer(Integer.MAX_VALUE));
        this.textField = new JFormattedTextField(numberFormatter);
        this.textField.setValue(new Integer(15));
        this.textField.setColumns(10);
        this.textField.addPropertyChangeListener(this);
        this.editor = this.textField;
        this.slide = new JSlider(0, 1, Integer.MAX_VALUE, 15);
        this.slide.setPreferredSize(new Dimension(200, 20));
        this.slide.setBorder(null);
        this.slide.addChangeListener(this);
        jPanel.add(this.textField);
        this.editor.getDocument().addDocumentListener(this);
        this.add(jPanel);
        this.add(this.slide);
        this.apply = new JButton("Apply");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("value".equals(propertyChangeEvent.getPropertyName())) {
            Number number = (Number)propertyChangeEvent.getNewValue();
            if (this.slide != null && number != null) {
                this.slide.setValue(number.intValue());
            }
        }
    }

    public void setEnabledAll(boolean bl) {
        this.textField.setEnabled(bl);
        this.slide.setEnabled(bl);
        this.apply.setEnabled(bl);
        this.backbones.setEnabled(bl);
    }

    public void setSliderValue(int n) {
        this.slide.setValue(n);
    }

    public JButton getApplyButton() {
        return this.apply;
    }

    public void updateModel(DefaultComboBoxModel defaultComboBoxModel, Vector vector, Vector vector2) {
        this.shifts = (Vector)vector.clone();
        this.shift_maxs = (Vector)vector2.clone();
        this.model = defaultComboBoxModel;
        this.shift_maxs.trimToSize();
        if (this.shift_maxs.size() > 0) {
            Integer n = (Integer)this.shift_maxs.elementAt(0);
            this.current_max = new Integer(n);
            this.slide.setMaximum(this.current_max);
            this.slide.setValue((Integer)vector.elementAt(0));
        }
        this.backbones.setModel(this.model);
        this.backbones.repaint();
    }

    public DefaultComboBoxModel getModel() {
        return this.model;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refreshButton();
    }

    private void refreshButton() {
        if (!this.editor.getText().equals("")) {
            this.apply.setEnabled(this.isOkay(this.editor.getText()));
        }
    }

    private boolean isOkay(String string) {
        boolean bl = false;
        if (string.matches("\\d+(,\\d\\d\\d)*")) {
            String string2 = string.replaceAll(",", "");
            bl = true;
        }
        return bl;
    }

    public int getCurrentShift() {
        try {
            String string = this.editor.getText();
            string = string.replaceAll(",", "");
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("odd number format exception in getcurrentshift" + numberFormatException.getMessage());
            return -1;
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            logger.debug("selected index is" + ((JComboBox)itemEvent.getSource()).getSelectedIndex());
            Integer n = (Integer)this.shifts.elementAt(((JComboBox)itemEvent.getSource()).getSelectedIndex());
            this.slide.setValue(n);
            logger.debug("in item state changed setting current value to :" + n);
            Integer n2 = (Integer)this.shift_maxs.elementAt(((JComboBox)itemEvent.getSource()).getSelectedIndex());
            this.current_max = new Integer(n2);
            this.slide.setMaximum(this.current_max);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        this.textField.setText(String.valueOf(n));
    }
}

