/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.util.Rounding;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class Zoom
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private JButton zoomInButton;
    private JButton zoomOutButton;
    private JComboBox zoomChoice;
    private Double currentZoom;
    private Double oldZoom;
    private double max;
    private double min;
    private boolean setSelection_ignoreResultingAction;
    private boolean isZoomerang = false;
    private int lastNumericalItemIndex;
    private double hundredPosPerPixelScale = 100.0;
    public static final double DEFAULT_MAGNIFY_ZOOM = 100.0;
    public static final double ALMOST_ZERO = 0.01;
    public static final String fitToScreen = "Fit to Screen";
    public static final String scaleUnavailable = "N/A";
    private VisibilityManager vizMgr;
    private AbstractLinearGraphics alg;
    private boolean isMainBluejayZoom;
    private boolean propagateChanges;
    private static Logger logger = Logger.getLogger(Zoom.class);
    public static final String[] RESCALE_CHOICES = new String[]{"0.01 %", "1.0 %", "8.33 %", "12.5 %", "25.0 %", "50.0 %", "100.0 %", "125.0 %", "200.0 %", "400.0 %", "800.0 %", "1200.0 %", "1600.0 %", "5000.0 %", "10000.0 %", "Fit to Screen"};

    public Zoom(String[] stringArray) {
        this.setLayout(new BoxLayout(this, 2));
        this.propagateChanges = true;
        this.setSelection_ignoreResultingAction = false;
        this.zoomChoice = new JComboBox<String>(stringArray);
        this.isMainBluejayZoom = stringArray != null && stringArray.equals(RESCALE_CHOICES);
        this.currentZoom = new Double(-5.898);
        this.oldZoom = new Double(-5.898);
        Dimension dimension = new Dimension(140, 30);
        Dimension dimension2 = new Dimension(30, 30);
        Dimension dimension3 = new Dimension(200, 30);
        this.zoomChoice.setMinimumSize(dimension);
        this.zoomChoice.setMaximumSize(dimension);
        this.zoomChoice.setPreferredSize(dimension);
        this.lastNumericalItemIndex = this.zoomChoice.getItemCount() - 1;
        String string = (String)this.zoomChoice.getItemAt(this.lastNumericalItemIndex);
        if (fitToScreen.equals(string)) {
            this.isZoomerang = true;
            --this.lastNumericalItemIndex;
            string = (String)this.zoomChoice.getItemAt(this.lastNumericalItemIndex);
        }
        this.max = this.getDouble(string);
        String string2 = (String)this.zoomChoice.getItemAt(0);
        this.min = this.getDouble(string2);
        this.zoomChoice.setEditable(true);
        this.zoomChoice.setSelectedItem(scaleUnavailable);
        this.zoomInButton = new JButton("+");
        this.zoomInButton.setToolTipText("Zoom In");
        this.zoomInButton.setMnemonic(73);
        this.zoomInButton.setMinimumSize(dimension2);
        this.zoomInButton.setMaximumSize(dimension2);
        this.zoomInButton.setPreferredSize(dimension2);
        this.zoomInButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomOutButton = new JButton("-");
        this.zoomOutButton.setToolTipText("Zoom Out");
        this.zoomOutButton.setMnemonic(79);
        this.zoomOutButton.setMinimumSize(dimension2);
        this.zoomOutButton.setMaximumSize(dimension2);
        this.zoomOutButton.setPreferredSize(dimension2);
        this.zoomOutButton.setMargin(new Insets(0, 0, 0, 0));
        this.zoomChoice.addActionListener(this);
        this.zoomInButton.addActionListener(this);
        this.zoomOutButton.addActionListener(this);
        this.add(this.zoomOutButton);
        this.add(this.zoomChoice);
        this.add(this.zoomInButton);
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
        this.vizMgr.addPropertyChangeListener("scale in bases per pixel", this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() != this.vizMgr) {
            System.err.println("PropertyChangeEvent callback for Zoom object did not have the registered visibility manager as its source, found " + propertyChangeEvent.getSource() + ", ignoring");
        }
        double d = this.vizMgr.getScale();
        double d2 = this.getHundredScale();
        double d3 = d2 / d * 100.0;
        if (d == -5.898 || d == -3.73) {
            d3 = d;
        }
        if (this.currentZoom == d3) {
            return;
        }
        this.setZoomFactor(d3);
    }

    public void setEnabledAll(boolean bl) {
        this.zoomInButton.setEnabled(bl);
        this.zoomOutButton.setEnabled(bl);
        this.zoomChoice.setEnabled(bl);
    }

    public void setZoomFactor(double d) {
        this.oldZoom = this.currentZoom;
        this.currentZoom = new Double(d);
        this.setSelection_ignoreResultingAction = true;
        logger.debug("New programmatic zoom, from " + this.oldZoom + " to " + this.currentZoom);
        if (d == -3.73) {
            this.zoomChoice.setSelectedItem(fitToScreen);
        } else if (d == -5.898) {
            this.zoomChoice.setSelectedItem(scaleUnavailable);
        } else {
            this.zoomChoice.setSelectedItem(Rounding.toString(d, 2) + " %");
            this.zoomChoice.hidePopup();
        }
        this.zoomInButton.setEnabled(d < this.max);
        this.zoomOutButton.setEnabled(d > this.min);
    }

    public void setPropagationEnabled(boolean bl) {
        this.propagateChanges = bl;
    }

    public double getOldZoom() {
        return this.oldZoom;
    }

    public double getCurrentZoom() {
        return this.currentZoom;
    }

    private Double getDouble(String string) {
        if (!string.matches("\\s*\\d+.\\d+\\s*%*\\s*") && !string.matches("\\s*\\d+\\s*%*\\s*")) {
            return new Double(-1.0);
        }
        string = string.replaceAll("%", "");
        string = string.replaceAll("\\s*", "");
        Double d = new Double(string);
        if (d < 0.0) {
            return new Double(-1.0);
        }
        return d;
    }

    public void performZoomAction(Object object) {
        this.actionPerformed(new ActionEvent(object, -77777, "NO_MESSAGE"));
    }

    public void performZoomAction(Object object, String string) {
        this.actionPerformed(new ActionEvent(object, -77777, string));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.setSelection_ignoreResultingAction && actionEvent.getSource() instanceof JComboBox) {
            this.setSelection_ignoreResultingAction = false;
            return;
        }
        if (actionEvent.getSource() instanceof JComboBox || actionEvent.getSource() instanceof BluejayDObjectList) {
            String string = (String)this.zoomChoice.getSelectedItem();
            if (fitToScreen.equals(string) || fitToScreen.equals(actionEvent.getActionCommand())) {
                this.oldZoom = this.currentZoom;
                this.currentZoom = new Double(-3.73);
                this.zoomChoice.hidePopup();
                logger.debug("### FITSCREEN Zoom.actionPerformed() " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " 2 firePropertyChange(\"currentZoom\"," + this.oldZoom + "," + this.currentZoom + ")");
                if (this.vizMgr != null) {
                    try {
                        this.vizMgr.setScale(-3.73);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        logger.error(illegalArgumentException.getMessage());
                        this.currentZoom = this.oldZoom;
                        return;
                    }
                }
                return;
            }
            Double d = this.getDouble(string);
            Double d2 = Rounding.toDouble(d, 2);
            boolean bl = Math.abs(d - d2) > 0.01;
            this.processSelectedZoomValue(bl ? d2 : d);
        } else if (actionEvent.getSource() == this.zoomInButton || actionEvent.getSource() == this.zoomOutButton) {
            boolean bl = actionEvent.getSource() == this.zoomInButton;
            int n = this.getSelectedIndex(bl);
            this.zoomInButton.setEnabled(n < this.lastNumericalItemIndex);
            this.zoomOutButton.setEnabled(n > 0);
            this.setSelection_ignoreResultingAction = true;
            this.zoomChoice.setSelectedItem(this.zoomChoice.getItemAt(n));
            this.oldZoom = this.currentZoom;
            this.currentZoom = this.getDouble((String)this.zoomChoice.getItemAt(n));
            logger.debug("### Zoom.actionPerformed() " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " 3 firePropertyChange(\"currentZoom\"," + this.oldZoom + "," + this.currentZoom + ")");
            if (this.vizMgr != null) {
                try {
                    this.vizMgr.setScale(this.zoomPctToPixelScale(this.currentZoom));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error(illegalArgumentException.getMessage());
                    this.currentZoom = this.oldZoom;
                    return;
                }
            }
        } else {
            logger.debug(">>>>>>>>>>>>AHHAA!  " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " Crappy  Source was " + actionEvent.getSource().getClass().getName() + ", zoom is " + this.currentZoom);
            logger.debug("### Zoom.actionPerformed() " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " 4 firePropertyChange(\"currentZoom\"," + this.oldZoom + "," + this.currentZoom + ")");
            if (this.vizMgr != null) {
                try {
                    this.vizMgr.setScale(this.zoomPctToPixelScale(this.currentZoom));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error(illegalArgumentException.getMessage());
                    return;
                }
            }
        }
    }

    public double zoomPctToPixelScale(Double d) {
        return this.zoomPctToPixelScale((double)d);
    }

    public double zoomPctToPixelScale(double d) {
        return this.getHundredScale() / (d / 100.0);
    }

    public double getHundredScale() {
        return this.hundredPosPerPixelScale;
    }

    public void setHundredScale(double d) {
        this.hundredPosPerPixelScale = d;
    }

    private void processSelectedZoomValue(Double d) {
        Double d2 = this.currentZoom;
        this.currentZoom = d;
        String string = this.currentZoom.toString() + " %";
        int n = ((DefaultComboBoxModel)this.zoomChoice.getModel()).getIndexOf(string);
        if (n >= 0) {
            this.zoomInButton.setEnabled(n < this.lastNumericalItemIndex);
            this.zoomOutButton.setEnabled(n > 0);
            this.oldZoom = d2;
            this.zoomChoice.repaint();
            this.zoomChoice.hidePopup();
            logger.debug("### Zoom.processSelectedZoomValue() " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " 1 firePropertyChange(\"currentZoom\"," + this.oldZoom + "," + this.currentZoom + ")");
            if (this.vizMgr != null) {
                try {
                    this.vizMgr.setScale(this.zoomPctToPixelScale(this.currentZoom));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error(illegalArgumentException.getMessage());
                    d2 = this.oldZoom;
                    return;
                }
            }
            return;
        }
        double d3 = this.currentZoom;
        if (d3 > this.min - 0.01 && Math.abs(d3 - -1.0) > 0.01) {
            logger.debug("\n\n\n### Zoom(#" + this.hashCode() + ").actionPerformed() not listed, valid value=" + this.currentZoom);
            this.zoomInButton.setEnabled(d3 < this.max - 0.01);
            this.zoomOutButton.setEnabled(d3 > this.min + 0.01);
            this.oldZoom = d2;
            this.setSelection_ignoreResultingAction = true;
            this.zoomChoice.setSelectedItem(string);
            this.zoomChoice.hidePopup();
            logger.debug("### Zoom.processSelectedZoomValue() " + (this.isMainBluejayZoom ? "MAIN" : "BATIK") + " 2 firePropertyChange(\"currentZoom\"," + this.oldZoom + "," + this.currentZoom + ")");
            if (this.vizMgr != null) {
                try {
                    this.vizMgr.setScale(this.zoomPctToPixelScale(this.currentZoom));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    logger.error("zoom choices are out of sync with VizMgr limits " + illegalArgumentException.getMessage());
                    d2 = this.oldZoom;
                    this.zoomChoice.setSelectedItem(Rounding.toString(d2, 2) + " %");
                    return;
                }
            }
            return;
        }
        logger.debug("\n\n\n### Zoom(#" + this.hashCode() + ", invalid value=" + this.currentZoom);
        this.setSelection_ignoreResultingAction = true;
        this.zoomChoice.setSelectedItem(Rounding.toString(d2, 2) + " %");
        this.currentZoom = d2;
    }

    private int getSelectedIndex(boolean bl) {
        double d = this.currentZoom;
        int n = ((DefaultComboBoxModel)this.zoomChoice.getModel()).getIndexOf(this.zoomChoice.getSelectedItem());
        if (n < 0) {
            for (int i = 0; i <= this.lastNumericalItemIndex; ++i) {
                double d2 = this.getDouble((String)this.zoomChoice.getItemAt(i));
                if (Math.abs(d2 - d) < 0.01) {
                    n = i;
                    break;
                }
                if (d2 > d) {
                    n = bl ? i - 1 : i;
                    break;
                }
                if (i != this.lastNumericalItemIndex) continue;
                n = this.lastNumericalItemIndex + 1;
            }
        }
        if ((n += bl ? 1 : -1) > this.lastNumericalItemIndex) {
            n = this.lastNumericalItemIndex;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }
}

