/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.client.LinearTarget;
import ca.ucalgary.bluejay.client.TargetAppearance;
import ca.ucalgary.bluejay.client.impl.BluejayDTDElementInstance;
import ca.ucalgary.bluejay.client.impl.BluejayParser;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayAbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.MaskPainter;
import ca.ucalgary.bluejay.gui.XbelBookmarksGUI;
import ca.ucalgary.bluejay.gui.comparison.ComparisonPool;
import ca.ucalgary.bluejay.gui.comparison.Genome;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.painter.AGAVEContigPainter;
import ca.ucalgary.bluejay.gui.painter.AGAVEPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractLinearPainter;
import ca.ucalgary.bluejay.gui.painter.AbstractTargetPainter;
import ca.ucalgary.bluejay.gui.painter.LaneManager;
import ca.ucalgary.bluejay.gui.painter.LinkingLinePainter;
import ca.ucalgary.bluejay.gui.util.Debug;
import com.simonstl.sax.xlink.LinkSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ComparisonMenuManager
implements BluejayMenuManager,
ActionListener {
    private JMenu comparison;
    private JMenu addSeq;
    private JMenu addFromBM;
    private JMenu unloadSeqs;
    private JMenu specifyMasterSeq;
    private JMenuItem unloadAll;
    private JMenuItem addFromFile;
    private JMenuItem minDistAlign;
    private JMenuItem basePosAlign;
    private JMenuItem changeAngleRes;
    private JRadioButtonMenuItem linkOut;
    private JRadioButtonMenuItem linkIn;
    private JRadioButtonMenuItem linkBoth;
    private JRadioButtonMenuItem linkAll;
    private JRadioButtonMenuItem linkSame;
    private JRadioButtonMenuItem linkClose;
    private JMenuItem changeMaxLinkDist;
    private JFileChooser xmlFileChooser;
    private BluejayURLLoader urlLoader;
    private BluejayParser bjParser;
    private BluejayDObjectList dlist;
    private AbstractLinearGraphics alg;
    private XbelBookmarksGUI xbelBM;
    private URL urlBM;
    private URL masterURL;
    private URL slaveURL;
    private ComparisonPool comparisonPool;
    private MaskPainter maskPainter;
    private int targetNum;
    private DocumentBuilder docBld;
    private String minDistAlignedCmpPoolName;
    private int[] minDistStartAngles;
    public static boolean isComparison;
    public static boolean isReshuffle;

    public ComparisonMenuManager() {
        isComparison = false;
        isReshuffle = false;
        this.masterURL = null;
        this.slaveURL = null;
    }

    public JMenu createMenu() {
        this.comparison = new JMenu("Comparison");
        this.comparison.setMnemonic(67);
        this.addSeq = new JMenu("Add Sequence");
        this.addSeq.setMnemonic(65);
        this.addSeq.setEnabled(false);
        this.comparison.add(this.addSeq);
        this.addFromBM = this.createMagpieMenu("From BookMarks", this.addFromBM);
        this.addFromBM.setMnemonic(66);
        this.addFromBM.setActionCommand("Add_From_Bookmarks");
        this.addFromBM.addActionListener(this);
        this.addFromBM.setEnabled(false);
        this.addSeq.add(this.addFromBM);
        this.addFromFile = new JMenuItem("From File");
        this.addFromFile.setMnemonic(70);
        this.addFromFile.addActionListener(this);
        this.addFromFile.setActionCommand("Add_From_File");
        this.addFromFile.setEnabled(false);
        this.addSeq.add(this.addFromFile);
        this.unloadSeqs = new JMenu("Unload Sequence(s)");
        this.unloadSeqs.setMnemonic(85);
        this.unloadSeqs.setEnabled(false);
        this.unloadAll = new JMenuItem("All");
        this.unloadAll.setMnemonic(65);
        this.unloadAll.addActionListener(this);
        this.unloadAll.setActionCommand("Unload_all");
        this.unloadAll.setEnabled(false);
        this.unloadSeqs.add(this.unloadAll);
        this.comparison.add(this.unloadSeqs);
        this.specifyMasterSeq = new JMenu("Specify New Master Sequence");
        this.specifyMasterSeq.setMnemonic(83);
        this.specifyMasterSeq.setEnabled(false);
        this.comparison.add(this.specifyMasterSeq);
        this.comparison.addSeparator();
        this.minDistAlign = new JMenuItem("Minimum Distance Alignment");
        this.minDistAlign.setMnemonic(77);
        this.minDistAlign.setAccelerator(KeyStroke.getKeyStroke("control A"));
        this.minDistAlign.addActionListener(this);
        this.minDistAlign.setActionCommand("Minimum Distance Align");
        this.minDistAlign.setEnabled(false);
        this.comparison.add(this.minDistAlign);
        this.basePosAlign = new JMenuItem("Base Position Alignment");
        this.basePosAlign.setMnemonic(66);
        this.basePosAlign.setAccelerator(KeyStroke.getKeyStroke("control B"));
        this.basePosAlign.addActionListener(this);
        this.basePosAlign.setActionCommand("Base Position Align");
        this.basePosAlign.setEnabled(false);
        this.comparison.add(this.basePosAlign);
        this.changeAngleRes = new JMenuItem("Change Angle Resolution");
        this.changeAngleRes.setMnemonic(67);
        this.changeAngleRes.setAccelerator(KeyStroke.getKeyStroke("control C"));
        this.changeAngleRes.addActionListener(this);
        this.changeAngleRes.setActionCommand("Change Angle Res");
        this.changeAngleRes.setEnabled(false);
        this.comparison.add(this.changeAngleRes);
        this.comparison.addSeparator();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.linkOut = new JRadioButtonMenuItem("Link Out or Up");
        this.linkOut.setActionCommand("Link Out/Up");
        this.linkOut.setMnemonic(79);
        this.linkOut.addActionListener(this);
        this.linkOut.setSelected(true);
        this.linkOut.setEnabled(false);
        buttonGroup.add(this.linkOut);
        this.comparison.add(this.linkOut);
        this.linkIn = new JRadioButtonMenuItem("Link In or Down");
        this.linkIn.setActionCommand("Link In/Down");
        this.linkIn.setMnemonic(73);
        this.linkIn.addActionListener(this);
        this.linkIn.setEnabled(false);
        buttonGroup.add(this.linkIn);
        this.comparison.add(this.linkIn);
        this.linkBoth = new JRadioButtonMenuItem("Link Both Ways");
        this.linkBoth.setActionCommand("Link Both Ways");
        this.linkBoth.setMnemonic(84);
        this.linkBoth.addActionListener(this);
        this.linkBoth.setEnabled(false);
        buttonGroup.add(this.linkBoth);
        this.comparison.add(this.linkBoth);
        this.comparison.addSeparator();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.linkAll = new JRadioButtonMenuItem("Show All Links");
        this.linkAll.setActionCommand("Link All");
        this.linkAll.addActionListener(this);
        this.linkAll.setSelected(true);
        this.linkAll.setEnabled(false);
        buttonGroup2.add(this.linkAll);
        this.comparison.add(this.linkAll);
        this.linkSame = new JRadioButtonMenuItem("Show Links to Same Positions Only");
        this.linkSame.setActionCommand("Link Same");
        this.linkSame.addActionListener(this);
        this.linkSame.setEnabled(false);
        buttonGroup2.add(this.linkSame);
        this.comparison.add(this.linkSame);
        this.linkClose = new JRadioButtonMenuItem("Show Links to Close Positions Only");
        this.linkClose.setActionCommand("Link Close");
        this.linkClose.addActionListener(this);
        this.linkClose.setEnabled(false);
        buttonGroup2.add(this.linkClose);
        this.comparison.add(this.linkClose);
        this.changeMaxLinkDist = new JMenuItem("Change Maximum Link Distance");
        this.changeMaxLinkDist.addActionListener(this);
        this.changeMaxLinkDist.setActionCommand("Change Max Link Dist");
        this.changeMaxLinkDist.setEnabled(false);
        this.comparison.add(this.changeMaxLinkDist);
        return this.comparison;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block35: {
            try {
                if (actionEvent.getActionCommand().equals("Add_From_File")) {
                    int n = this.xmlFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        isComparison = true;
                        this.slaveURL = this.xmlFileChooser.getSelectedFile().toURL();
                        Genome genome = this.addToComparisonPool();
                        this.dlist.getURLLoader().appendComparisonGenome(this.slaveURL);
                        this.paintTargetGenome(this.slaveURL, genome);
                    }
                    break block35;
                }
                if (actionEvent.getActionCommand().equals("Add_From_Bookmarks")) {
                    isComparison = true;
                    JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                    String string = jMenuItem.getText();
                    this.slaveURL = new URL(this.xbelBM.getURL(string));
                    Genome genome = this.addToComparisonPool();
                    this.dlist.getURLLoader().appendComparisonGenome(this.slaveURL);
                    this.paintTargetGenome(this.slaveURL, genome);
                    break block35;
                }
                if (actionEvent.getActionCommand().equals("Unload_all")) {
                    int n = this.comparisonPool.getPoolSize();
                    Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
                    for (int i = 1; i < n; ++i) {
                        this.removeGenome(vector.lastElement());
                    }
                    if (this.comparisonPool.getPoolSize() > 1) {
                        System.err.printf(">ComparisonMenuManager.actionPerformed(): Unload All performed, but not all slaves were unloaded.\n", new Object[0]);
                    }
                    this.dlist.repaint(true);
                    break block35;
                }
                if (actionEvent.getActionCommand().equals("Minimum Distance Align")) {
                    int n;
                    int n2 = this.comparisonPool.getPoolSize();
                    Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
                    String string = "";
                    for (n = 0; n < n2; ++n) {
                        string = string + vector.elementAt(n).getGenomeName();
                    }
                    if (!string.equals(this.minDistAlignedCmpPoolName)) {
                        this.minDistStartAngles = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().findMinDistAngles();
                        this.minDistAlignedCmpPoolName = "";
                        for (n = 0; n < n2; ++n) {
                            this.minDistAlignedCmpPoolName = this.minDistAlignedCmpPoolName + vector.elementAt(n).getGenomeName();
                        }
                    }
                    for (n = 0; n < n2; ++n) {
                        vector.elementAt(n).setStartAngle(this.minDistStartAngles[n]);
                    }
                    try {
                        this.dlist.repaintSynchronous();
                    }
                    catch (Exception exception) {
                        System.err.println("ComparisonMenuManager.actionPerformed():repaintSynchronous interrupted");
                    }
                    for (int i = 0; i < n2; ++i) {
                        vector.elementAt(i).resetStartAngle();
                    }
                    break block35;
                }
                if (actionEvent.getActionCommand().equals("Base Position Align")) {
                    int n = this.comparisonPool.getPoolSize();
                    Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
                    for (int i = 0; i < n; ++i) {
                        vector.elementAt(i).resetStartAngle();
                    }
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Change Angle Res")) {
                    this.changeAngleResolution();
                } else if (actionEvent.getActionCommand().equals("Link Out/Up")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingOut(true);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingIn(false);
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Link In/Down")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingOut(false);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingIn(true);
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Link Both Ways")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingOut(true);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingIn(true);
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Link All")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingAll(true);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingSame(false);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingClose(false);
                    this.changeMaxLinkDist.setEnabled(false);
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Link Same")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingAll(false);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingSame(true);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingClose(false);
                    this.changeMaxLinkDist.setEnabled(false);
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Link Close")) {
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingAll(false);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingSame(false);
                    ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().setLinkingClose(true);
                    this.changeMaxLinkDist.setEnabled(true);
                    if (!this.changeMaxLinkDistance()) {
                        // empty if block
                    }
                    this.dlist.repaint(true);
                } else if (actionEvent.getActionCommand().equals("Change Max Link Dist") && this.changeMaxLinkDistance()) {
                    this.dlist.repaint(true);
                }
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
    }

    private boolean changeMaxLinkDistance() {
        int n;
        LinkingLinePainter linkingLinePainter = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter();
        double d = linkingLinePainter.getMaxLinkDistPercent();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Maximum Link Distance (%):");
        jLabel.setAlignmentX(0.0f);
        JTextField jTextField = new JTextField(Double.toString(d), 3);
        jTextField.setAlignmentX(1.0f);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setAlignmentX(0.0f);
        jLabel2.setForeground(Color.RED);
        jPanel.add(jLabel2);
        while ((n = JOptionPane.showOptionDialog(this.dlist.getFrame(), jPanel, "Change Maximum Link Distance", 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay")) == 0) {
            double d2;
            try {
                d2 = Double.parseDouble(jTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                jLabel2.setText("Maximum link distance must be a % value.");
                continue;
            }
            if (d2 < 0.0 || d2 > 100.0) {
                jLabel2.setText("Maximum link distance % must be between 0 and 100 inclusive.");
                continue;
            }
            linkingLinePainter.setMaxLinkDistPercent(d2);
            return d2 != d;
        }
        return false;
    }

    private void changeAngleResolution() {
        int n;
        LinkingLinePainter linkingLinePainter = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter();
        int n2 = linkingLinePainter.getAngleResolution();
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("Angle resolution (degrees):");
        jLabel.setAlignmentX(0.0f);
        JTextField jTextField = new JTextField(Integer.toString(n2), 3);
        jTextField.setAlignmentX(1.0f);
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        JLabel jLabel2 = new JLabel("");
        jLabel2.setAlignmentX(0.0f);
        jLabel2.setForeground(Color.RED);
        jPanel.add(jLabel2);
        while ((n = JOptionPane.showOptionDialog(this.dlist.getFrame(), jPanel, "Change Angle Resolution", 2, -1, null, new String[]{"Okay", "Cancel"}, "Okay")) == 0) {
            int n3;
            int n4;
            try {
                n4 = Integer.parseInt(jTextField.getText());
            }
            catch (NumberFormatException numberFormatException) {
                jLabel2.setText("Angle resoultion must be an integer.");
                continue;
            }
            if (n4 < 1 || n4 > 180) {
                jLabel2.setText("Angle resolution must be between 1 and 180.");
                continue;
            }
            linkingLinePainter.setAngleResolution(n4);
            if (n4 == n2) break;
            int n5 = this.comparisonPool.getPoolSize();
            Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
            String string = "";
            for (n3 = 0; n3 < n5; ++n3) {
                string = string + vector.elementAt(n3).getGenomeName();
            }
            this.minDistStartAngles = ((BluejayAbstractLinearGraphics)this.alg).getLLPainter().findMinDistAngles();
            if (!string.equals(this.minDistAlignedCmpPoolName)) {
                this.minDistAlignedCmpPoolName = "";
                for (n3 = 0; n3 < n5; ++n3) {
                    this.minDistAlignedCmpPoolName = this.minDistAlignedCmpPoolName + vector.elementAt(n3).getGenomeName();
                }
            }
            for (n3 = 0; n3 < n5; ++n3) {
                vector.elementAt(n3).setStartAngle(this.minDistStartAngles[n3]);
            }
            try {
                this.dlist.repaintSynchronous();
            }
            catch (Exception exception) {
                System.err.println("ComparisonMenuManager.actionPerformed():repaintSynchronous interrupted");
            }
            for (int i = 0; i < n5; ++i) {
                vector.elementAt(i).resetStartAngle();
            }
        }
    }

    public JMenu createMagpieMenu(String string, JMenu jMenu) {
        if (Debug.DEBUG) {
            System.err.println("BookmarksMenuManager.createMagpieMenu(string, jmenu)");
        }
        if (jMenu != null) {
            jMenu.removeAll();
        } else {
            jMenu = new JMenu(string);
        }
        jMenu.setText(string);
        try {
            this.urlBM = this.getClass().getClassLoader().getResource("docs/bookmarks.xml");
            this.readFile(this.urlBM, jMenu);
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.getMessage());
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        return jMenu;
    }

    public void createUnloadSeqMenu(final Genome genome) {
        String string = genome.getGenomeName();
        String string2 = string + genome.getGenomeNum();
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setName(string2);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComparisonMenuManager.this.removeGenome(genome);
                ComparisonMenuManager.this.dlist.repaint(true);
            }
        });
        this.unloadSeqs.add(jMenuItem);
    }

    public void createSpecifyMenu(Genome genome) {
        String string = genome.getGenomeName();
        final int n = genome.getGenomeNum();
        String string2 = string + n;
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setName(string2);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComparisonPool comparisonPool = new ComparisonPool();
                int n2 = ComparisonMenuManager.this.comparisonPool.getPoolSize();
                Vector<Genome> vector = ComparisonMenuManager.this.comparisonPool.getSeqsFromPool();
                for (int i = 0; i < n2; ++i) {
                    Genome genome = vector.elementAt(i);
                    comparisonPool.addSeqToPool(genome);
                }
                isReshuffle = true;
                ComparisonMenuManager.this.clearGenomePool(false);
                ComparisonMenuManager.this.reshuffleGenomePool(comparisonPool, n);
                ComparisonMenuManager.this.adjustDeiInMaskPainter(n);
                ComparisonMenuManager.this.comparisonPool.updateGenomeColor();
                ComparisonMenuManager.this.dlist.repaint(true);
                isReshuffle = false;
            }
        });
        this.specifyMasterSeq.add(jMenuItem);
    }

    public void clearGenomePool(boolean bl) {
        this.comparisonPool.emptyPool();
        this.setMaskPainter(null);
        this.comparisonPool.setTargetNum(-1);
        if (bl) {
            this.disableUnloadAndSpecifyMenus();
            isComparison = false;
        }
        this.getXbelBMGUI().getURLLoader().leavingPage();
    }

    public void reshuffleGenomePool(ComparisonPool comparisonPool, int n) {
        int n2 = comparisonPool.getPoolSize();
        Vector<Genome> vector = comparisonPool.getSeqsFromPool();
        Genome genome = null;
        Genome genome2 = vector.elementAt(n);
        genome = new Genome(genome2.getUrlLocation(), 0);
        genome.setLenRatio(1.0);
        genome.setGenomeName(genome2.getGenomeName());
        genome.setGenomeLen(genome2.getGenomeLen());
        genome.setRotateAngle(genome2.getRotateAngle());
        genome.resetStartAngle();
        genome.setRootNode(genome2.getRootNode());
        genome.setOutXLinks(genome2.getOutXLinks());
        this.comparisonPool.addSeqToPool(genome);
        this.setMasterURL(genome.getUrlLocation());
        this.enableAddMenu();
        this.urlLoader.getComparisons(this.urlLoader.getCurrentPositionInHistory()).clear();
        this.urlLoader.appendComparisonGenome(genome.getUrlLocation());
        this.getXbelBMGUI().getURLLoader().addComboBoxItem(genome.getUrlLocation());
        int n3 = genome2.getGenomeLen();
        for (int i = 0; i < n2; ++i) {
            if (i == n) continue;
            genome2 = vector.elementAt(i);
            if (i < n) {
                genome = new Genome(genome2.getUrlLocation(), i + 1);
            } else if (i > n) {
                genome = new Genome(genome2.getUrlLocation(), i);
            }
            int n4 = genome2.getGenomeLen();
            genome.setGenomeLen(n4);
            double d = (double)n4 / (double)n3;
            genome.setLenRatio(d);
            genome.setGenomeName(genome2.getGenomeName());
            genome.setRotateAngle(genome2.getRotateAngle());
            genome.resetStartAngle();
            genome.setRootNode(genome2.getRootNode());
            genome.setOutXLinks(genome2.getOutXLinks());
            this.comparisonPool.addSeqToPool(genome);
            this.urlLoader.appendComparisonGenome(genome.getUrlLocation());
        }
        this.updateMenu();
        this.unloadAll.setEnabled(true);
    }

    public void adjustDeiInMaskPainter(int n) {
        int n2;
        Object object;
        int n3;
        MaskPainter maskPainter = this.getMaskPainter();
        DTDElementInstance[] dTDElementInstanceArray = maskPainter.getDrawableElements();
        DTDElementInstance[] dTDElementInstanceArray2 = maskPainter.getAlwaysDrawnElements();
        int[] nArray = maskPainter.getNumElements();
        int n4 = nArray[0];
        int n5 = nArray[1];
        int[] nArray2 = maskPainter.getStartIndex();
        int[] nArray3 = maskPainter.getEndIndex();
        Genome genome = null;
        Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
        for (n3 = 0; n3 < n5; ++n3) {
            if (dTDElementInstanceArray[n3] == null) continue;
            object = (LinearTarget[])dTDElementInstanceArray[n3];
            n2 = object.getSlaveNum();
            genome = n2 < n ? vector.elementAt(n2 + 1) : (n2 > n ? vector.elementAt(n2) : vector.firstElement());
            this.updateDeiInfo((BluejayDTDElementInstance)object, genome);
            nArray2[n3] = object.getStart();
            nArray3[n3] = object.getEnd();
        }
        for (n3 = 0; n3 < n4; ++n3) {
            if (dTDElementInstanceArray2[n3] == null) continue;
            object = (BluejayDTDElementInstance)dTDElementInstanceArray2[n3];
            n2 = object.getSlaveNum();
            genome = n2 < n ? vector.elementAt(n2 + 1) : (n2 > n ? vector.elementAt(n2) : vector.firstElement());
            this.updateDeiInfo((BluejayDTDElementInstance)object, genome);
        }
        maskPainter.setElements(dTDElementInstanceArray, dTDElementInstanceArray2);
        maskPainter.setIndex(nArray2, nArray3);
        n3 = vector.firstElement().getGenomeLen();
        object = this.dlist.getVisibilityManager().getVisibleTargets();
        this.updateScale(n3, object[this.getTargetNum()]);
    }

    public void updateScale(int n, LinearTarget linearTarget) {
        DTDElementInstance dTDElementInstance = this.getMaskPainter().getRootNode();
        AbstractLinearPainter abstractLinearPainter = dTDElementInstance.getPainter();
        AbstractTargetPainter abstractTargetPainter = (AbstractTargetPainter)abstractLinearPainter;
        ((TargetAppearance)this.getGraphics().getTargetAppearances().elementAt(0)).setMaxPosition(n);
        ((TargetAppearance)this.getGraphics().getTargetAppearances().elementAt(0)).setMinPosition(1);
        this.getGraphics().getTarget(this.getTargetNum()).setMaxPosition(n);
        this.getGraphics().getTarget(this.getTargetNum()).clearVisiblePositionRange();
        Dimension dimension = this.getGraphics().getVisibleSize();
        LaneManager laneManager = abstractTargetPainter.getLaneManager();
        int n2 = 10;
        double d = linearTarget.calculateIdealScale(n, dimension, laneManager, n2);
        this.dlist.getVisibilityManager().setScale(d);
        this.dlist.getVisibilityManager().setVisibleRange(0, 1, n);
    }

    public void updateDeiInfo(BluejayDTDElementInstance bluejayDTDElementInstance, Genome genome) {
        bluejayDTDElementInstance.setSlaveNum(genome.getGenomeNum());
        this.updateDeiRange(bluejayDTDElementInstance, genome.getLenRatio());
        bluejayDTDElementInstance.setLenRatio(genome.getLenRatio());
        bluejayDTDElementInstance.setLinkingLineInfo(null);
        bluejayDTDElementInstance.setLane(null);
        bluejayDTDElementInstance.setGoClass(null);
        bluejayDTDElementInstance.setLinkDei(null);
    }

    public void updateDeiRange(BluejayDTDElementInstance bluejayDTDElementInstance, double d) {
        int n;
        int n2;
        int n3;
        int[] nArray;
        int n4 = this.comparisonPool.getSeqsFromPool().elementAt(0).getGenomeLen();
        if (bluejayDTDElementInstance.getNodeName().equals("contig") && bluejayDTDElementInstance instanceof Element) {
            bluejayDTDElementInstance.setAttribute("length", new Integer(n4).toString());
            bluejayDTDElementInstance.setSlaveNum(0);
        }
        if ((nArray = bluejayDTDElementInstance.getPainter().getOrigFeatureRange(bluejayDTDElementInstance)) == null) {
            return;
        }
        boolean bl = nArray[0] > nArray[1];
        int n5 = bl ? nArray[1] : nArray[0];
        int n6 = n3 = bl ? nArray[0] : nArray[1];
        if (n5 > 1) {
            n2 = (int)((double)n5 / d);
            n2 = n2 < 1 ? 1 : n2;
            n2 = n2 > n4 ? n4 : n2;
        } else {
            n2 = n5;
        }
        if (n3 > 1) {
            n = (int)((double)n3 / d);
            n = n < 1 ? 1 : n;
            n = n > n4 ? n4 : n;
        } else {
            n = n3;
        }
        bluejayDTDElementInstance.setStart(n2);
        bluejayDTDElementInstance.setEnd(n);
    }

    public void removeGenome(Genome genome) {
        int n;
        int n2;
        int n3 = genome.getGenomeNum();
        MaskPainter maskPainter = this.getMaskPainter();
        DTDElementInstance[] dTDElementInstanceArray = maskPainter.getDrawableElements();
        DTDElementInstance[] dTDElementInstanceArray2 = maskPainter.getAlwaysDrawnElements();
        int[] nArray = maskPainter.getNumElements();
        int n4 = nArray[0];
        int n5 = nArray[1];
        int n6 = nArray[0];
        int n7 = nArray[1];
        int[] nArray2 = maskPainter.getStartIndex();
        int[] nArray3 = maskPainter.getEndIndex();
        int n8 = Integer.MAX_VALUE;
        int n9 = 0;
        for (n2 = n5 - 1; n2 >= 0; --n2) {
            if (dTDElementInstanceArray[n2] == null) continue;
            ((BluejayDTDElementInstance)dTDElementInstanceArray[n2]).setLinkingLineInfo(null);
            if (dTDElementInstanceArray[n2].getSlaveNum() != n3) continue;
            n8 = n2 < n8 ? n2 : n8;
            n9 = n2 > n9 ? n2 : n9;
            Array.set(dTDElementInstanceArray, n2, null);
            Array.set(nArray2, n2, new Integer(Integer.MAX_VALUE));
            Array.set(nArray3, n2, new Integer(Integer.MAX_VALUE));
            --n5;
        }
        if (dTDElementInstanceArray[n9 + 1] != null && n8 != Integer.MAX_VALUE) {
            n2 = 0;
            for (n = n9 + 1; n < n7; ++n) {
                dTDElementInstanceArray[n8 + n2] = dTDElementInstanceArray[n];
                nArray2[n8 + n2] = nArray2[n];
                nArray3[n8 + n2] = nArray3[n];
                ++n2;
            }
            for (n = 0; n <= n9 - n8; ++n) {
                Array.set(dTDElementInstanceArray, n7 - 1 - n, null);
                Array.set(nArray2, n7 - 1 - n, new Integer(Integer.MAX_VALUE));
                Array.set(nArray3, n7 - 1 - n, new Integer(Integer.MAX_VALUE));
            }
        }
        n8 = Integer.MAX_VALUE;
        n9 = 0;
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            if (dTDElementInstanceArray2[n2] == null) continue;
            ((BluejayDTDElementInstance)dTDElementInstanceArray2[n2]).setLinkingLineInfo(null);
            if (dTDElementInstanceArray2[n2].getSlaveNum() != n3) continue;
            n8 = n2 < n8 ? n2 : n8;
            n9 = n2 > n9 ? n2 : n9;
            Array.set(dTDElementInstanceArray2, n2, null);
            --n4;
        }
        if (dTDElementInstanceArray2[n9 + 1] != null && n8 != Integer.MAX_VALUE) {
            n2 = 0;
            for (n = n9 + 1; n < n6; ++n) {
                dTDElementInstanceArray2[n8 + n2] = dTDElementInstanceArray2[n];
                ++n2;
            }
            for (n = 0; n <= n9 - n8; ++n) {
                Array.set(dTDElementInstanceArray2, n6 - 1 - n, null);
            }
        }
        if (n3 < (n2 = this.comparisonPool.getPoolSize() - 1)) {
            int n10;
            int n11;
            Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
            vector.lastElement().setGenomeNum(n3);
            vector.set(n3, vector.lastElement());
            for (n11 = 0; n11 < n5; ++n11) {
                n10 = dTDElementInstanceArray[n11].getSlaveNum();
                if (n10 != n2) continue;
                dTDElementInstanceArray[n11].setSlaveNum(n3);
            }
            for (n11 = 0; n11 < n4; ++n11) {
                n10 = dTDElementInstanceArray2[n11].getSlaveNum();
                if (n10 != n2) continue;
                dTDElementInstanceArray2[n11].setSlaveNum(n3);
            }
        }
        nArray[0] = n4;
        nArray[1] = n5;
        maskPainter.setNumElements(nArray);
        maskPainter.setElements(dTDElementInstanceArray, dTDElementInstanceArray2);
        maskPainter.setIndex(nArray2, nArray3);
        this.comparisonPool.removeSeqFromPool(n2);
        this.dlist.getURLLoader().removeComparisonGenome(n3);
        this.updateMenu();
        this.comparisonPool.updateGenomeColor();
    }

    public String createGenomeName(Genome genome) {
        URL uRL = genome.getUrlLocation();
        String string = uRL.toString();
        int n = string.lastIndexOf("/");
        string = string.substring(n + 1);
        int n2 = string.indexOf(".");
        string = string.substring(0, n2);
        return string;
    }

    public JMenu readFile(Object object, JMenu jMenu) throws SAXException, IOException {
        Document document = this.xbelBM.getDocument(object);
        if (document != null) {
            Element element = document.getDocumentElement();
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                jMenu = this.createMenuItems((Element)node, jMenu);
            }
        }
        return jMenu;
    }

    private JMenu createMenuItems(Element element, JMenu jMenu) {
        if (element.getTagName().equals("folder")) {
            Node node;
            String string = new String();
            JMenu jMenu2 = new JMenu();
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node.getFirstChild() instanceof Text)) continue;
                string = ((Text)node.getFirstChild()).getData();
                jMenu2.setText(string);
                jMenu.add(jMenu2);
                break;
            }
            for (node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                jMenu2 = this.createMenuItems((Element)node, jMenu2);
            }
        } else if (element.getTagName().equals("bookmark")) {
            Object object;
            String string = new String();
            String string2 = new String();
            string2 = element.getAttribute("href");
            for (object = element.getFirstChild(); object != null; object = object.getNextSibling()) {
                if (!(object.getFirstChild() instanceof Text)) continue;
                string = ((Text)object.getFirstChild()).getData();
            }
            object = new JMenuItem(string);
            ((AbstractButton)object).setActionCommand("Add_From_Bookmarks");
            ((AbstractButton)object).addActionListener(this);
            jMenu.add((JMenuItem)object);
        }
        return jMenu;
    }

    public void paintTargetGenome(URL uRL, Genome genome) {
        int n = this.comparisonPool.getPoolSize() - 1;
        AGAVEPainter.allocateSlaveLane(n);
        Node node = null;
        try {
            URL uRL2 = new URL(uRL.toString() + "#/1");
            this.dlist.getBluejayParser().getLinkSet().removeAllLinks();
            this.dlist.getBluejayParser().parse(uRL2, true, false, false);
            LinkSet linkSet = this.dlist.getBluejayParser().getLinkSet();
            node = this.dlist.getBluejayParser().getExtractedNode();
            genome.setOutXLinks(linkSet);
            genome.setRootNode(node);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        DTDElementInstance dTDElementInstance = (DTDElementInstance)node;
        DTDElementInstance dTDElementInstance2 = (DTDElementInstance)node.getFirstChild().getFirstChild();
        dTDElementInstance.setTarget(this.getTargetNum());
        dTDElementInstance.getPainter().preProcess(this.getGraphics(), this.getMaskPainter(), dTDElementInstance2);
        this.dlist.repaint(true);
    }

    public Genome addToComparisonPool() {
        Object[] objectArray;
        if (this.comparisonPool.isPoolEmpty()) {
            Genome genome = new Genome(this.masterURL, 0);
            genome.setGenomeName(this.createGenomeName(genome));
            genome.setGenomeColor(Color.red);
            this.comparisonPool.addSeqToPool(genome);
            objectArray = this.dlist.getVisibilityManager().getVisibleTargets();
            int n = objectArray[0].getMaxPosition();
            genome.setGenomeLen(n);
            genome.setLenRatio(1.0);
            Document document = this.dlist.getDocument();
            if (document != null) {
                genome.setRootNode(document.getDocumentElement().getFirstChild());
            } else {
                System.err.printf(">ComparisonMenuManager.addToComparisonPool(): Couldn't set DOM in Genome\n", new Object[0]);
            }
            LinkSet linkSet = this.dlist.getAbstractLinearGraphics().getLinkSet();
            if (linkSet != null) {
                genome.setOutXLinks(linkSet);
            } else {
                System.err.printf(">ComparisonMenuManager.addToComparisonPool(): Couldn't set XLinks in Genome\n", new Object[0]);
            }
        }
        int n = this.comparisonPool.getPoolSize();
        objectArray = this.comparisonPool.getColorPool();
        Genome genome = new Genome(this.slaveURL, n);
        this.comparisonPool.addSeqToPool(genome);
        genome.setGenomeName(this.createGenomeName(genome));
        genome.setGenomeColor((Color)objectArray[(n - 1) % objectArray.length]);
        this.createUnloadSeqMenu(genome);
        this.createSpecifyMenu(genome);
        if (!this.comparisonPool.isPoolEmpty()) {
            this.unloadAll.setEnabled(true);
            this.unloadSeqs.setEnabled(true);
            this.specifyMasterSeq.setEnabled(true);
            if (this.alg.getTarget(0).getShape() == 112) {
                this.minDistAlign.setEnabled(true);
                this.basePosAlign.setEnabled(true);
                this.changeAngleRes.setEnabled(true);
            }
            this.linkOut.setEnabled(true);
            this.linkIn.setEnabled(true);
            this.linkBoth.setEnabled(true);
            this.linkAll.setEnabled(true);
            this.linkSame.setEnabled(true);
            this.linkClose.setEnabled(true);
        }
        return genome;
    }

    public void setXmlFileChooser(JFileChooser jFileChooser) {
        this.xmlFileChooser = jFileChooser;
    }

    public void setComparison(boolean bl) {
        isComparison = bl;
    }

    public boolean getComparison() {
        return isComparison;
    }

    public JMenuItem getMinDistAlign() {
        return this.minDistAlign;
    }

    public JMenuItem getBasePosAlign() {
        return this.basePosAlign;
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        this.urlLoader = bluejayURLLoader;
    }

    public void setXbelBMGUI(XbelBookmarksGUI xbelBookmarksGUI) {
        this.xbelBM = xbelBookmarksGUI;
    }

    public XbelBookmarksGUI getXbelBMGUI() {
        return this.xbelBM;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
        bluejayDObjectList.setCompMenuMan(this);
    }

    public BluejayDObjectList getDList() {
        return this.dlist;
    }

    public void setParser(BluejayParser bluejayParser) {
        this.bjParser = bluejayParser;
    }

    public BluejayParser getParser() {
        return this.bjParser;
    }

    public void setGraphics(AbstractLinearGraphics abstractLinearGraphics) {
        this.alg = abstractLinearGraphics;
    }

    public AbstractLinearGraphics getGraphics() {
        return this.alg;
    }

    public void setMasterURL(URL uRL) {
        this.masterURL = uRL;
    }

    public URL getMasterURL() {
        return this.masterURL;
    }

    public void setComparisonPool(ComparisonPool comparisonPool) {
        this.comparisonPool = comparisonPool;
    }

    public ComparisonPool getComparisonPool() {
        return this.comparisonPool;
    }

    public void setMaskPainter(MaskPainter maskPainter) {
        this.maskPainter = maskPainter;
    }

    public MaskPainter getMaskPainter() {
        if (this.maskPainter == null) {
            DTDElementInstance dTDElementInstance = this.dlist.getDTDElementInstance("/1/1/1");
            MaskPainter maskPainter = ((AGAVEContigPainter)dTDElementInstance.getPainter()).getMaskPainter();
            this.setMaskPainter(maskPainter);
        }
        return this.maskPainter;
    }

    public int getTargetNum() {
        if (this.comparisonPool.getTargetNum() == -1) {
            this.comparisonPool.setTargetNum(this.getMaskPainter().getRootNode().getTarget());
        }
        return this.comparisonPool.getTargetNum();
    }

    public void updateMenu() {
        this.unloadSeqs.removeAll();
        this.unloadSeqs.add(this.unloadAll);
        this.specifyMasterSeq.removeAll();
        int n = this.comparisonPool.getPoolSize();
        if (n <= 1) {
            this.unloadSeqs.setEnabled(false);
            this.specifyMasterSeq.setEnabled(false);
            this.minDistAlign.setEnabled(false);
            this.basePosAlign.setEnabled(false);
            this.changeAngleRes.setEnabled(false);
            this.linkOut.setEnabled(false);
            this.linkIn.setEnabled(false);
            this.linkBoth.setEnabled(false);
            this.linkAll.setEnabled(false);
            this.linkSame.setEnabled(false);
            this.linkClose.setEnabled(false);
            this.changeMaxLinkDist.setEnabled(false);
        } else {
            Vector<Genome> vector = this.comparisonPool.getSeqsFromPool();
            for (int i = 1; i < n; ++i) {
                Genome genome = vector.elementAt(i);
                this.createUnloadSeqMenu(genome);
                this.createSpecifyMenu(genome);
            }
        }
    }

    public void enableAddMenu() {
        this.addSeq.setEnabled(true);
        this.addFromFile.setEnabled(true);
        this.addFromBM.setEnabled(true);
    }

    public void disableUnloadAndSpecifyMenus() {
        this.unloadSeqs.removeAll();
        this.unloadSeqs.add(this.unloadAll);
        this.specifyMasterSeq.removeAll();
        this.unloadSeqs.setEnabled(false);
        this.specifyMasterSeq.setEnabled(false);
        if (this.alg.getTarget(0).getShape() == 112) {
            this.minDistAlign.setEnabled(false);
            this.basePosAlign.setEnabled(false);
            this.changeAngleRes.setEnabled(false);
        }
        this.linkOut.setEnabled(false);
        this.linkIn.setEnabled(false);
        this.linkBoth.setEnabled(false);
        this.linkAll.setEnabled(false);
        this.linkSame.setEnabled(false);
        this.linkClose.setEnabled(false);
        this.changeMaxLinkDist.setEnabled(false);
    }

    public void setSlaveURL(URL uRL) {
        this.slaveURL = uRL;
    }

    static {
        isReshuffle = false;
    }
}

