/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.impl.BluejayEventCoordinator;
import ca.ucalgary.bluejay.client.impl.BluejayIOController;
import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.BluejayUObjectWindow;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.menu.ComparisonMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.gui.util.Debug;
import ca.ucalgary.bluejay.gui.util.History;
import ca.ucalgary.bluejay.gui.util.JSVGExportUtility;
import ca.ucalgary.bluejay.gui.util.JSVGPrintUtility;
import ca.ucalgary.bluejay.util.XMLSerializer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import org.apache.batik.apps.svgbrowser.ThumbnailDialog;

public class DocumentMenuManager
implements BluejayMenuManager,
ActionListener {
    private boolean notSigned;
    public static final boolean ADD_TO_HISTORY = true;
    private Hashtable alreadySavedURL;
    private Hashtable failedSaveURL;
    private ComparisonMenuManager comparisonMenuMgr;
    private ViewMenuManager viewMenuMgr;
    private static JFrame main_frame;
    private static BluejayURLLoader urlLoader;
    private static BluejayEventCoordinator bec;
    private static BluejayDObjectList dlist;
    private static JFileChooser xmlFC;
    private static JFileChooser svgFC;
    private static JButton openButton;
    private static BluejayIOController io;
    private static ThumbnailDialog thumbnailDialog;
    private static History localHistory;
    private static String[] mimetypes;

    public JMenu createMenu() {
        Component component;
        this.alreadySavedURL = new Hashtable();
        this.failedSaveURL = new Hashtable();
        JMenu jMenu = new JMenu("Document");
        jMenu.setMnemonic(68);
        JMenuItem jMenuItem = new JMenuItem("New");
        jMenuItem.setEnabled(false);
        JMenuItem jMenuItem2 = new JMenuItem("Open");
        jMenuItem2.setMnemonic(79);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke("control O"));
        jMenuItem2.addActionListener(this);
        jMenuItem2.setActionCommand("Open");
        openButton.addActionListener(this);
        jMenu.add(jMenuItem2);
        if (this.notSigned) {
            jMenuItem2.setEnabled(false);
        }
        JMenuItem jMenuItem3 = new JMenuItem("Save");
        jMenuItem3.setMnemonic(83);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke("control S"));
        jMenuItem3.addActionListener(this);
        jMenu.add(jMenuItem3);
        jMenu.add(new JSeparator());
        for (int i = 3; i < jMenu.getItemCount(); ++i) {
            component = jMenu.getMenuComponent(i);
            if (component instanceof JSeparator) continue;
            component.setEnabled(false);
        }
        JMenuItem jMenuItem4 = new JMenuItem("Print Screen");
        jMenuItem4.setMnemonic(80);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke("control P"));
        jMenuItem4.setActionCommand("Print");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setEnabled(true);
        jMenu.add(jMenuItem4);
        component = new JMenuItem("Export Image");
        ((AbstractButton)component).setMnemonic(69);
        ((AbstractButton)component).setActionCommand("ExportImage");
        ((AbstractButton)component).addActionListener(this);
        ((JMenuItem)component).setEnabled(true);
        jMenu.add((JMenuItem)component);
        JMenu jMenu2 = new JMenu("Convert Image to SVG");
        jMenu2.setMnemonic(67);
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Full Document");
        jRadioButtonMenuItem.setMnemonic(68);
        jRadioButtonMenuItem.setActionCommand("convertToSVG_fullDocument");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem = new JRadioButtonMenuItem("Current Screen");
        jRadioButtonMenuItem.setMnemonic(83);
        jRadioButtonMenuItem.setActionCommand("convertToSVG_currentScreenOnly");
        jRadioButtonMenuItem.addActionListener(this);
        jRadioButtonMenuItem.setSelected(false);
        buttonGroup.add(jRadioButtonMenuItem);
        jMenu2.add(jRadioButtonMenuItem);
        jMenu.add(jMenu2);
        JMenuItem jMenuItem5 = new JMenuItem("View Raw Data");
        jMenuItem5.setMnemonic(82);
        jMenuItem5.addActionListener(this);
        jMenuItem5.setActionCommand("raw");
        jMenu.add(jMenuItem5);
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block45: {
            if (Debug.DEBUG) {
                System.out.println("action performed " + actionEvent.getSource().toString());
            }
            try {
                URL uRL = null;
                if (actionEvent.getActionCommand().equals("Open")) {
                    int n;
                    if (Debug.DEBUG) {
                        System.out.println("Opening");
                    }
                    if ((n = xmlFC.showOpenDialog(null)) == 0) {
                        if (Debug.DEBUG) {
                            System.out.println("a file was selected");
                        }
                        URL uRL2 = xmlFC.getSelectedFile().toURL();
                        if (dlist.getWaypointsWidget().getNumWaypoints() > 0) {
                            dlist.getWaypointsWidget().selectAllWaypoints(true);
                            dlist.getWaypointsWidget().removeSelectedWaypoints(false);
                            if (dlist.getWaypointsTab() != null) {
                                this.viewMenuMgr.getTabbedPane().remove(dlist.getWaypointsTab());
                            }
                            dlist.setWaypointsTab(null);
                        }
                        if (dlist.getAbstractLinearGraphics().isInTextMode()) {
                            this.viewMenuMgr.setDefaultView();
                        }
                        this.viewMenuMgr.enableInitiallyDisabledViewMenus();
                        if (ComparisonMenuManager.isComparison) {
                            this.comparisonMenuMgr.clearGenomePool(true);
                        }
                        this.comparisonMenuMgr.setMasterURL(uRL2);
                        this.comparisonMenuMgr.enableAddMenu();
                        if (!this.comparisonMenuMgr.getComparisonPool().isPoolEmpty()) {
                            this.comparisonMenuMgr.getComparisonPool().emptyPool();
                            this.comparisonMenuMgr.disableUnloadAndSpecifyMenus();
                        }
                        urlLoader.leavingPage();
                        urlLoader.gotoURL(uRL2, true);
                    }
                    break block45;
                }
                if (actionEvent.getActionCommand().startsWith("convertToSVG")) {
                    uRL = localHistory.currentLocation();
                    if (uRL != null) {
                        Object object;
                        Object object2;
                        if (Debug.DEBUG) {
                            System.out.println("URL IS: " + uRL.toString());
                        }
                        if (Debug.DEBUG) {
                            System.out.println("Convert SVG to a window");
                        }
                        Rectangle rectangle = null;
                        boolean bl = actionEvent.getActionCommand().equals("convertToSVG_currentScreenOnly");
                        if (bl) {
                            object2 = dlist.getDataNavigator().getCanvasToTrueCoords(0.0f, 0.0f);
                            object = dlist.getDataNavigator().getCanvasToTrueCoords(dlist.getWidth(), dlist.getHeight());
                            rectangle = new Rectangle((int)((Point2D)object2).getX(), (int)((Point2D)object2).getY(), (int)(((Point2D)object).getX() - ((Point2D)object2).getX()), (int)(((Point2D)object).getY() - ((Point2D)object2).getY()));
                        }
                        if (this.notSigned) {
                            try {
                                object2 = new BluejayUObjectWindow("Current Image in SVG Format");
                                ((BluejayUObjectWindow)object2).flush();
                                dlist.getAbstractLinearGraphics().setSVGExportGraphicsMode((BluejayUObjectWindow)object2, rectangle);
                                dlist.repaint(true);
                            }
                            catch (Exception exception) {
                                System.err.println("Error requesting SVG: " + exception.getMessage());
                                System.err.println("The class of general exception is " + exception.getClass().getName());
                                exception.printStackTrace();
                            }
                        } else {
                            int n = svgFC.showSaveDialog(null);
                            if (n == 0) {
                                object = svgFC.getSelectedFile().toString().trim();
                                if (!((String)object).toLowerCase().endsWith(".svg")) {
                                    object = (String)object + ".svg";
                                }
                                if (Debug.DEBUG) {
                                    System.out.println("SVG file was selected: " + (String)object);
                                }
                                dlist.getAbstractLinearGraphics().setSVGExportGraphicsMode((String)object, rectangle);
                                dlist.repaint(true);
                            }
                        }
                    } else {
                        bec.notify(8, " You must load a document before you can see the SVG version");
                    }
                    break block45;
                }
                if (actionEvent.getActionCommand().equals("Print")) {
                    if (dlist.getSVGDocument() != null) {
                        JSVGPrintUtility.printDocument(dlist.getSVGDocument(), dlist.getRenderingTransform(), ((JViewport)dlist.getParent()).getExtentSize());
                    } else {
                        bec.notify(8, " You must load a document before you can print its image");
                    }
                    break block45;
                }
                if (actionEvent.getActionCommand().equals("ExportImage")) {
                    if (dlist.getSVGDocument() != null) {
                        JSVGExportUtility.exportDocument(dlist.getSVGDocument(), dlist.getRenderingTransform(), ((JViewport)dlist.getParent()).getExtentSize());
                    } else {
                        bec.notify(8, "You must load a document before you can export its image");
                    }
                    break block45;
                }
                if (actionEvent.getActionCommand().equals("showThumbnail")) {
                    uRL = localHistory.currentLocation();
                    if (uRL != null) {
                        if (thumbnailDialog == null) {
                            thumbnailDialog = new ThumbnailDialog(null, dlist);
                            thumbnailDialog.pack();
                            Rectangle rectangle = main_frame.getBounds();
                            Dimension dimension = thumbnailDialog.getSize();
                            thumbnailDialog.setLocation(rectangle.x + rectangle.width - dimension.width / 3, rectangle.y + (rectangle.height - dimension.height) / 2);
                        }
                        thumbnailDialog.setVisible(true);
                    } else {
                        bec.notify(8, " You must load a document before you can see the Thumbnail");
                    }
                    break block45;
                }
                if (actionEvent.getActionCommand().equals("raw")) {
                    uRL = localHistory.currentLocation();
                    if (uRL != null) {
                        if (Debug.DEBUG) {
                            System.out.println("URL IS: " + uRL.toString());
                        }
                        try {
                            Reader reader = io.getCharContents(uRL, mimetypes);
                            Font font = new Font("Courier", 0, 14);
                            JTextArea jTextArea = new JTextArea();
                            jTextArea.setFont(font);
                            jTextArea.setEditable(false);
                            jTextArea.read(reader, null);
                            jTextArea.setFont(font);
                            try {
                                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                                jScrollPane.setMinimumSize(new Dimension(200, 50));
                                jScrollPane.setPreferredSize(new Dimension(600, 550));
                                Border border = BorderFactory.createEtchedBorder();
                                jScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), border));
                                Frame frame = JOptionPane.getFrameForComponent(null);
                                if (frame == null) {
                                    frame = new Frame();
                                }
                                Object[] objectArray = new Object[]{"Dismiss"};
                                JOptionPane jOptionPane = new JOptionPane(jScrollPane, -1, 0, null, objectArray);
                                JDialog jDialog = jOptionPane.createDialog(frame, "Document source for " + uRL);
                                jDialog.setResizable(true);
                                jDialog.setModal(false);
                                jDialog.setVisible(true);
                                break block45;
                            }
                            catch (Exception exception) {
                                System.err.println("we have a dialog issue " + exception.getMessage());
                            }
                        }
                        catch (IOException iOException) {
                            bec.notify(6, "I/O Exception: " + iOException);
                            iOException.printStackTrace();
                        }
                        catch (Exception exception) {
                            System.err.println("Error requesting raw data: " + exception.getMessage());
                            System.err.println("The class of general exception is " + exception.getClass().getName());
                            exception.printStackTrace();
                        }
                        break block45;
                    }
                    bec.notify(8, " You must load a document before you can see the raw version");
                    break block45;
                }
                if (actionEvent.getActionCommand().equals("Save")) {
                    this.saveDocument(urlLoader.getActualURLName());
                }
            }
            catch (MalformedURLException malformedURLException) {
                bec.notify(6, "Malformed URL: " + malformedURLException);
            }
        }
    }

    public void saveDocument(URL uRL) {
        int n;
        File file = null;
        boolean bl = true;
        try {
            if (this.failedSaveURL.containsKey(uRL)) {
                bl = true;
            } else if (uRL.getProtocol().equals("file")) {
                if (this.alreadySavedURL.containsKey(uRL) || !new File(new URI(uRL.toString())).exists()) {
                    bl = false;
                    file = new File(new URI(uRL.toString()));
                } else {
                    n = JOptionPane.showConfirmDialog(main_frame, "Would you like overwrite the current file on disk?", "File Overwrite Confirmation", 0);
                    if (n == 0) {
                        bl = false;
                        file = new File(new URI(uRL.toString()));
                    }
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(main_frame, "The file could not be saved due to an exception parsing the file location:\n" + exception, "Error Saving File", 0);
        }
        try {
            if (bl) {
                n = xmlFC.showSaveDialog(null);
                if (n == 0) {
                    String string = xmlFC.getSelectedFile().toString().trim();
                    file = !string.toLowerCase().endsWith(".xml") ? new File(string + ".xml") : xmlFC.getSelectedFile();
                    this.saveDocument(file.toURL());
                } else {
                    return;
                }
            }
            if (file == null) {
                throw new Exception("Could not determine a local file to save to (developer error): " + file);
            }
            uRL = file.toURL();
            XMLSerializer.save(dlist.getDocument(), file, null);
            this.alreadySavedURL.put(uRL, "saved");
            this.failedSaveURL.remove(uRL);
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(main_frame, "The file could not be saved due to an exception:\n" + exception, "Error Saving File", 0);
            this.failedSaveURL.put(uRL, "failed");
            this.alreadySavedURL.remove(uRL);
            this.saveDocument(uRL);
        }
    }

    public void setNotSigned(boolean bl) {
        this.notSigned = bl;
    }

    public void setXmlFC(JFileChooser jFileChooser) {
        xmlFC = jFileChooser;
    }

    public void setSVGFC(JFileChooser jFileChooser) {
        svgFC = jFileChooser;
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        urlLoader = bluejayURLLoader;
    }

    public void setEventCoordinator(BluejayEventCoordinator bluejayEventCoordinator) {
        bec = bluejayEventCoordinator;
    }

    public void setIO(BluejayIOController bluejayIOController) {
        io = bluejayIOController;
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setLocalHistory(History history) {
        localHistory = history;
    }

    public void setMimeTypes(String[] stringArray) {
        mimetypes = stringArray;
    }

    public void setMainFrame(JFrame jFrame) {
        main_frame = jFrame;
    }

    public ThumbnailDialog getThumbnailDialog() {
        return thumbnailDialog;
    }

    public void setOpenButton(JButton jButton) {
        openButton = jButton;
    }

    public void setComparisonMenuMgr(ComparisonMenuManager comparisonMenuManager) {
        this.comparisonMenuMgr = comparisonMenuManager;
    }

    public ComparisonMenuManager getComparisonMenuMgr() {
        return this.comparisonMenuMgr;
    }

    public void setViewMenuMgr(ViewMenuManager viewMenuManager) {
        this.viewMenuMgr = viewMenuManager;
    }

    public ViewMenuManager getViewMenuMgr() {
        return this.viewMenuMgr;
    }
}

