/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.menu;

import ca.ucalgary.bluejay.client.impl.BluejayURLLoader;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.ToolbarWidgets;
import ca.ucalgary.bluejay.gui.VisibilityManager;
import ca.ucalgary.bluejay.gui.menu.BluejayMenuManager;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.session.HistoryTable;
import ca.ucalgary.bluejay.session.StateCollection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class EditMenuManager
implements BluejayMenuManager,
ActionListener,
PropertyChangeListener {
    static StateCollection collection;
    BluejayDObjectList dlist;
    JMenuItem undoItem;
    JMenuItem item;
    ViewMenuManager viewMenu;
    ToolbarWidgets toolBar;
    VisibilityManager vizMgr;
    static HistoryTable ht;
    static BluejayURLLoader urlLoader;

    public EditMenuManager() {
        collection = new StateCollection(this);
    }

    public void setVisibilityManager(VisibilityManager visibilityManager) {
        this.vizMgr = visibilityManager;
    }

    public void setHistoryTable(HistoryTable historyTable) {
        ht = historyTable;
        ht.setChangeListener(this);
    }

    public void setURLLoader(BluejayURLLoader bluejayURLLoader) {
        urlLoader = bluejayURLLoader;
    }

    public JMenu createMenu() {
        JMenu jMenu = new JMenu("Edit");
        jMenu.setMnemonic(69);
        this.undoItem = new JMenuItem("Undo Action");
        this.undoItem.setMnemonic(85);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke("control Z"));
        this.undoItem.setEnabled(false);
        this.undoItem.addActionListener(this);
        this.undoItem.setActionCommand("Undo");
        jMenu.add(this.undoItem);
        this.item = new JMenuItem("Redo Action");
        this.item.setMnemonic(82);
        this.item.setAccelerator(KeyStroke.getKeyStroke("control Y"));
        this.item.setEnabled(false);
        this.item.addActionListener(this);
        this.item.setActionCommand("Redo");
        jMenu.add(this.item);
        this.toolBar.getUndoButton().addActionListener(this);
        this.toolBar.getRedoButton().addActionListener(this);
        return jMenu;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        collection = urlLoader.getCurrentCollection();
        if (collection == null) {
            System.out.println("coll == null");
        }
        if (actionEvent.getActionCommand().equals("Undo")) {
            int n = 2;
            Object object = collection.getPreviousState();
            n = this.retrieveState(object, n);
            boolean bl = collection.undoMostRecent(n);
            this.setUndoEnable(collection.hasUndo());
            this.setRedoEnable(collection.hasRedo());
        } else if (actionEvent.getActionCommand().equals("Redo")) {
            int n = 1;
            Object object = collection.getNextState();
            n = this.retrieveState(object, n);
            boolean bl = collection.redoMostRecent(n - 1);
            this.setUndoEnable(collection.hasUndo());
            this.setRedoEnable(collection.hasRedo());
        }
    }

    private int retrieveState(Object object, int n) {
        if (object instanceof String[]) {
            String string = ((String[])object)[0];
            String string2 = ((String[])object)[1];
            if (string.equals("reversecomplement")) {
                this.dlist.reverseComplement();
                n = 2;
            } else if (string.equals("cut")) {
                this.dlist.shift(new Integer(((String[])object)[1].toString()));
                n = 2;
            } else if (string.equals("shape")) {
                n = this.dlist.setGeometry(Integer.valueOf(string2), Integer.valueOf(((String[])object)[2]), collection.getTopPosition());
            } else if (string.equals("rotate")) {
                this.dlist.setRotation(Integer.valueOf(string2), Integer.valueOf(((String[])object)[2]));
            } else if (string.equals("navigation position")) {
                this.vizMgr.setFocusPosition(Integer.valueOf(((String[])object)[2]), Integer.valueOf(string2));
                n = 1;
            } else if (string.equals("view")) {
                this.viewMenu.setViewChoice(string2);
            } else if (string.equals("zoom")) {
                this.vizMgr.setScale(new Double(string2));
                n = 2;
            } else {
                string = (String)((Object[])object)[0];
                Hashtable hashtable = (Hashtable)((Object[])object)[1];
                Hashtable hashtable2 = (Hashtable)((Object[])object)[2];
                if (string.equals("legend")) {
                    this.dlist.repaintLegendUsing(hashtable, hashtable2, collection.getUnclicked(), collection.getGreyed());
                    n = 2;
                } else if (string.equals("selectall")) {
                    this.dlist.repaintLegendUsing(hashtable, hashtable2);
                    n = 3;
                }
            }
        }
        return n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        ht.propertyChange(propertyChangeEvent);
        StateCollection stateCollection = urlLoader.getCurrentCollection();
        this.setUndoEnable(stateCollection.hasUndo());
        this.setRedoEnable(stateCollection.hasRedo());
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        this.dlist = bluejayDObjectList;
    }

    public void setViewMenuManager(ViewMenuManager viewMenuManager) {
        this.viewMenu = viewMenuManager;
    }

    public void setToolbarWidgets(ToolbarWidgets toolbarWidgets) {
        this.toolBar = toolbarWidgets;
    }

    public JMenuItem getUndoMenu() {
        return this.undoItem;
    }

    public void setUndoEnable(boolean bl) {
        if (bl) {
            this.undoItem.setEnabled(true);
            this.toolBar.setUndoEnabled(true);
        } else {
            this.undoItem.setEnabled(false);
            this.toolBar.setUndoEnabled(false);
        }
    }

    public void setRedoEnable(boolean bl) {
        if (bl) {
            this.item.setEnabled(true);
            this.toolBar.setRedoEnabled(true);
        } else {
            this.item.setEnabled(false);
            this.toolBar.setRedoEnabled(false);
        }
    }

    public PropertyChangeListener getChangeListener() {
        return this;
    }

    public void setChangeListener(PropertyChangeListener propertyChangeListener) {
    }
}

