/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.menu.ViewMenuManager;
import ca.ucalgary.bluejay.gui.microarray.CentroidViewer;
import ca.ucalgary.bluejay.gui.microarray.CustomClusterGenerator;
import ca.ucalgary.bluejay.gui.microarray.HTMLWriter;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayClusterHTMLWriter;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayClusterRatioGUI;
import ca.ucalgary.bluejay.gui.microarray.MicroArrayRatioGUI;
import com.simonstl.sax.xlink.Link;
import edu.stanford.ejalbert.BrowserLauncher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.tigr.microarray.mev.MultipleArrayViewer;
import org.tigr.microarray.mev.cluster.algorithm.impl.ExperimentUtil;
import org.tigr.microarray.mev.cluster.gui.Experiment;
import org.tigr.microarray.mev.cluster.gui.IViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentClusterViewer;
import org.tigr.microarray.mev.cluster.gui.helpers.ExperimentViewer;
import org.tigr.util.FloatMatrix;

public class MicroArrayGUI
implements ActionListener {
    private static BluejayDObjectList dlist;
    private static String xptr;
    private static ViewMenuManager viewMenu;
    private static CustomClusterGenerator manualClusterGUI;
    public static String CLUSTER_HTML_CMD;
    public static String CLUSTER_ADD_CMD;
    public static String CLUSTER_RM_CMD;
    private float maxDistance = 0.0f;

    public MicroArrayGUI(BluejayDObjectList bluejayDObjectList, ViewMenuManager viewMenuManager) {
        viewMenu = viewMenuManager;
        dlist = bluejayDObjectList;
        if (manualClusterGUI == null) {
            manualClusterGUI = new CustomClusterGenerator(dlist, dlist.getArrayViewer());
        }
    }

    public MicroArrayGUI(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
        viewMenu = dlist.getViewMenu();
    }

    public JMenu createLinkPopup(String string) {
        Object object;
        xptr = string;
        JMenu jMenu = new JMenu("Microarray Options");
        if (string == null) {
            return jMenu;
        }
        String string2 = (String)dlist.getAbstractLinearGraphics().getxPtrToGBMap().get(string);
        if (string2 != null) {
            object = manualClusterGUI.getIDs();
            boolean bl = false;
            for (int i = 0; object != null && i < ((String[])object).length; ++i) {
                if (!string2.equals(object[i])) continue;
                bl = true;
            }
            JMenuItem jMenuItem = null;
            if (bl) {
                jMenuItem = new JMenuItem("Remove from Custom Cluster");
                jMenuItem.setActionCommand(CLUSTER_RM_CMD);
                jMenuItem.setToolTipText("Remove from manually created list of IDs to cluster together");
            } else {
                jMenuItem = new JMenuItem(object == null || ((Object)object).length == 0 ? "Start Custom Cluster" : "Add to Custom Cluster");
                jMenuItem.setActionCommand(CLUSTER_ADD_CMD);
                jMenuItem.setToolTipText("Add to a manually created list of IDs to cluster together");
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        if (!dlist.getAnalysisMonitor().isClusterDataShown()) {
            object = new JMenuItem("Run Menu->Microarray->Analysis to enable cluster options");
            ((JMenuItem)object).setEnabled(false);
            ((JComponent)object).setToolTipText("A clustering analysis must be performed before more options are available. KMC is a common selection.");
            jMenu.add((JMenuItem)object);
        } else if (string2 == null) {
            object = new JMenuItem("This ID does not map to any loaded microarray data points");
            ((JMenuItem)object).setEnabled(false);
            jMenu.add((JMenuItem)object);
        } else {
            object = (Integer)dlist.getAbstractLinearGraphics().getArrayViewer().getGbToClusterIDMap().get(string2);
            if (object == null) {
                JMenuItem jMenuItem = new JMenuItem("This ID is not part of any currently defined cluster");
                jMenuItem.setEnabled(false);
                jMenuItem.setToolTipText("By running another clustering analysis that includes this ID, you will get clustering display options.");
                jMenu.add(jMenuItem);
            } else {
                JMenuItem jMenuItem = new JMenuItem("Generate list of IDs from the same cluster");
                jMenuItem.setActionCommand(CLUSTER_HTML_CMD);
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
        }
        object = new JMenuItem("Run Distance Analysis");
        ((AbstractButton)object).setActionCommand("distance_analysis");
        ((AbstractButton)object).addActionListener(this);
        ((JComponent)object).setToolTipText("See which IDs follow similar expression patterns to this one");
        jMenu.add((JMenuItem)object);
        if (MicroArrayGUI.getGeneInfoURL(dlist, xptr) != null) {
            JMenuItem jMenuItem = new JMenuItem("See InfoCard");
            jMenuItem.setActionCommand("gene_card");
            jMenuItem.addActionListener(this);
            jMenuItem.setToolTipText("Launches a Web browser to view external info on this gene");
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    public static URL getGeneInfoURL(BluejayDObjectList bluejayDObjectList, String string) {
        String string2 = string.replaceFirst("/\\d+\\Z", "");
        List list = bluejayDObjectList.getDataManager().getHyperlinks(string2);
        if (list.size() > 0) {
            return ((Link)list.get(0)).getToNode().getURL();
        }
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals("distance_analysis")) {
                this.showDistanceAnalysis();
            } else if (actionEvent.getActionCommand().equals(CLUSTER_ADD_CMD)) {
                this.addGeneToCluster();
            } else if (actionEvent.getActionCommand().equals(CLUSTER_RM_CMD)) {
                this.removeGeneFromCluster();
            } else if (actionEvent.getActionCommand().equals("cluster_genes")) {
                this.createClusterTable();
            } else if (actionEvent.getActionCommand().equals(CLUSTER_HTML_CMD)) {
                this.createClusterTableMod();
            } else if (actionEvent.getActionCommand().equals("gene_card")) {
                URL uRL = MicroArrayGUI.getGeneInfoURL(dlist, xptr);
                try {
                    System.err.println("Launching browser for " + uRL);
                    if (uRL != null) {
                        BrowserLauncher.openURL(uRL.toString());
                    }
                }
                catch (IOException iOException) {
                    System.err.println("Couldn't launch external browser for " + uRL + " because of I/O exception: " + iOException);
                }
            }
        }
    }

    public void addGeneToCluster() {
        manualClusterGUI.setVisible(true);
        manualClusterGUI.addID((String)dlist.getAbstractLinearGraphics().getxPtrToGBMap().get(xptr));
    }

    public void removeGeneFromCluster() {
        manualClusterGUI.setVisible(true);
        manualClusterGUI.removeID((String)dlist.getAbstractLinearGraphics().getxPtrToGBMap().get(xptr));
    }

    public void createClusterTable() {
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        TreeMap treeMap = dlist.getAbstractLinearGraphics().getxPtrToGBMap();
        String string = (String)treeMap.get(xptr);
        Integer n = (Integer)multipleArrayViewer.getGbToClusterIDMap().get(string);
        this.createClusterTable(string, n);
    }

    public void createClusterTable(String string, Integer n) {
        int n2;
        Object object;
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        IViewer iViewer = (IViewer)multipleArrayViewer.getClusterIDToIViewerMap().get(n);
        Object var5_5 = null;
        Vector vector = (Vector)multipleArrayViewer.getClusterIDToIViewersMap().get(n);
        int[] nArray = null;
        if (iViewer instanceof ExperimentViewer) {
            object = (ExperimentViewer)iViewer;
            n2 = ((ExperimentViewer)object).getClusterIndex();
            ((ExperimentViewer)object).setClusterIndex(n);
            nArray = ((ExperimentViewer)object).getCluster();
            ((ExperimentViewer)object).setClusterIndex(n2);
        } else if (iViewer instanceof ExperimentClusterViewer) {
            object = (ExperimentClusterViewer)iViewer;
            n2 = ((ExperimentClusterViewer)object).getClusterIndex();
            ((ExperimentClusterViewer)object).setClusterIndex(n);
            nArray = ((ExperimentClusterViewer)object).getCluster();
            ((ExperimentClusterViewer)object).setClusterIndex(n2);
        } else if (iViewer instanceof CentroidViewer) {
            object = (CentroidViewer)iViewer;
            ((CentroidViewer)object).setClusterIndex(n);
            nArray = ((CentroidViewer)object).getCluster();
        }
        object = new MicroArrayClusterHTMLWriter(string);
        MicroArrayRatioGUI microArrayRatioGUI = new MicroArrayRatioGUI((HTMLWriter)object, dlist);
        URI uRI = ((MicroArrayClusterHTMLWriter)object).createHTMLFile(nArray);
        if (uRI != null) {
            microArrayRatioGUI.displayPage(uRI);
            org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer centroidViewer = (org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer)vector.get(1);
            centroidViewer.onDataChanged(multipleArrayViewer.getData());
            microArrayRatioGUI.setVisible(true);
        }
        object = null;
    }

    public void createClusterTableMod() {
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        TreeMap treeMap = dlist.getAbstractLinearGraphics().getxPtrToGBMap();
        String string = (String)treeMap.get(xptr);
        Integer n = (Integer)multipleArrayViewer.getGBToLocMap().get(string);
        Integer n2 = (Integer)multipleArrayViewer.getGbToClusterIDMap().get(string);
        if (n2 == null) {
            System.err.println("No cluster ID found for gene " + string);
        } else {
            this.createClusterTableMod(string, n2, n);
        }
    }

    public void createClusterTableMod(String string, Integer n, Integer n2) {
        int n3;
        JPanel jPanel;
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        IViewer iViewer = (IViewer)multipleArrayViewer.getClusterIDToIViewerMap().get(n);
        Vector vector = (Vector)multipleArrayViewer.getClusterIDToIViewersMap().get(n);
        int[] nArray = null;
        int[][] nArray2 = null;
        if (iViewer instanceof ExperimentViewer) {
            jPanel = (ExperimentViewer)iViewer;
            n3 = ((ExperimentViewer)jPanel).getClusterIndex();
            ((ExperimentViewer)jPanel).setClusterIndex(n);
            nArray = ((ExperimentViewer)jPanel).getCluster();
            nArray2 = ((ExperimentViewer)jPanel).getClusters();
            ((ExperimentViewer)jPanel).setClusterIndex(n3);
        } else if (iViewer instanceof ExperimentClusterViewer) {
            jPanel = (ExperimentClusterViewer)iViewer;
            n3 = ((ExperimentClusterViewer)jPanel).getClusterIndex();
            ((ExperimentClusterViewer)jPanel).setClusterIndex(n);
            nArray = ((ExperimentClusterViewer)jPanel).getCluster();
            nArray2 = ((ExperimentClusterViewer)jPanel).getClusters();
            ((ExperimentClusterViewer)jPanel).setClusterIndex(n3);
        } else if (iViewer instanceof CentroidViewer) {
            jPanel = (CentroidViewer)iViewer;
            ((CentroidViewer)jPanel).setClusterIndex(n);
            nArray = ((CentroidViewer)jPanel).getCluster();
            nArray2 = ((CentroidViewer)jPanel).getClusters();
        }
        jPanel = (org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer)vector.get(1);
        Experiment experiment = multipleArrayViewer.getData().getExperiment();
        FloatMatrix floatMatrix = experiment.getMatrix();
        float[][] fArray = ((org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer)jPanel).getMeans();
        TreeMap treeMap = this.calculateDistances(n2, nArray, floatMatrix);
        CentroidViewer centroidViewer = new CentroidViewer(experiment, nArray2);
        centroidViewer.setData(multipleArrayViewer.getData());
        centroidViewer.setAntiAliasing(true);
        centroidViewer.setClusterIndex(n);
        centroidViewer.setMode(1);
        centroidViewer.setMeans(fArray);
        centroidViewer.setGeneSelectedFromBluejay(n2);
        centroidViewer.setGeneDistanceMap(treeMap);
        centroidViewer.setMaximumDistance(this.maxDistance);
        MicroArrayClusterHTMLWriter microArrayClusterHTMLWriter = new MicroArrayClusterHTMLWriter(string);
        MicroArrayClusterRatioGUI microArrayClusterRatioGUI = new MicroArrayClusterRatioGUI(microArrayClusterHTMLWriter, centroidViewer, treeMap, dlist);
        URI uRI = microArrayClusterHTMLWriter.createHTMLFile(nArray);
        if (uRI != null) {
            microArrayClusterRatioGUI.displayPage(uRI);
            org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer centroidViewer2 = (org.tigr.microarray.mev.cluster.gui.helpers.CentroidViewer)vector.get(1);
            centroidViewer2.onDataChanged(multipleArrayViewer.getData());
            microArrayClusterRatioGUI.setVisible(true);
        }
        microArrayClusterHTMLWriter = null;
    }

    public void showDistanceAnalysis() {
        dlist.getDistanceWidget().prepareDistanceSliderWidget(xptr);
        viewMenu.getcbDistanceAnalysis().setSelected(true);
    }

    public TreeMap calculateDistances(int n, int[] nArray, FloatMatrix floatMatrix) {
        TreeMap<String, Float> treeMap = new TreeMap<String, Float>();
        MultipleArrayViewer multipleArrayViewer = dlist.getAbstractLinearGraphics().getArrayViewer();
        float f = 1.0f;
        boolean bl = true;
        int n2 = multipleArrayViewer.getMenuBar().getDistanceMenu().getDistanceFunction();
        String string = multipleArrayViewer.getMenuBar().getDistanceMenu().getFunctionName(n2);
        for (int i = 0; i < nArray.length; ++i) {
            float f2 = ExperimentUtil.geneDistance(floatMatrix, null, nArray[i], n, n2, f, bl);
            if (f2 < 0.0f) {
                f2 = Math.abs(f2);
            }
            String string2 = new Integer(nArray[i]).toString();
            treeMap.put(string2, new Float(f2));
            if (!(f2 > this.maxDistance)) continue;
            this.maxDistance = f2;
        }
        return treeMap;
    }

    static {
        CLUSTER_HTML_CMD = "cluster_genes_mod";
        CLUSTER_ADD_CMD = "custom_cluster_add";
        CLUSTER_RM_CMD = "custom_cluster_remove";
    }
}

