/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray;

import ca.ucalgary.bluejay.client.DTDElementInstance;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.HTMLWriter;
import com.simonstl.sax.xlink.Link;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class MicroArrayHTMLWriter
implements HTMLWriter {
    private static BluejayDObjectList dlist;
    private static String bufferedBody;
    public static final String LINK_POINTING = "   >   ";
    private static int currNumber;
    private static int numberOfGenesWithoutInformation;
    private static FileWriter outFileWriter;
    private static int colOne;
    private static int colTwo;
    private static int colThree;
    private static int colFour;

    public void moveTemporaryFile(String string, URL uRL) {
        try {
            File file = new File(uRL.getFile());
            File file2 = new File(string);
            this.copy(file, file2);
            file = null;
            file2 = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void copy(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        ((OutputStream)fileOutputStream).close();
    }

    public URI createHTMLFile(int[] nArray) {
        return null;
    }

    public URI createHTMLFile() {
        int n = colOne + colTwo + colThree + colFour;
        try {
            File file = File.createTempFile("list", ".tmp");
            file.deleteOnExit();
            outFileWriter = new FileWriter(file);
            this.writeHeader(outFileWriter);
            TreeMap treeMap = dlist.getAbstractLinearGraphics().getArrayViewer().getRatioToGbMap();
            Iterator iterator = treeMap.keySet().iterator();
            Vector<Float> vector = new Vector<Float>(10, 1);
            boolean bl = false;
            while (iterator.hasNext()) {
                vector.addElement((Float)iterator.next());
            }
            for (int i = vector.capacity() - 1; i >= 0; --i) {
                Float f = (Float)vector.elementAt(i);
                if (f.isNaN()) continue;
                Vector vector2 = (Vector)treeMap.get(f);
                int n2 = vector2.size();
                for (int j = 0; j < n2; ++j) {
                    String string = (String)vector2.elementAt(j);
                    String string2 = (String)dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(string);
                    if (string2 == null) continue;
                    while (string2.charAt(string2.length() - 1) != '/') {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    DTDElementInstance dTDElementInstance = dlist.getDTDElementInstance(string2 = string2.substring(0, string2.length() - 1));
                    if (dTDElementInstance != null) {
                        String string3 = dTDElementInstance.getPainter().getToolTip(dTDElementInstance);
                        outFileWriter.write(this.addToBody(string, f, string3));
                        continue;
                    }
                    outFileWriter.write(this.addToBody(string, f, null));
                }
            }
            this.writeFooter(outFileWriter);
            outFileWriter.close();
            currNumber = 0;
            numberOfGenesWithoutInformation = 0;
            return file.toURI();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void writeHeader(FileWriter fileWriter) {
        try {
            String string = "<html>\n<head><title>Microarray Expression List - generated by Bluejay</title></head>\n";
            int n = dlist.getAbstractLinearGraphics().getArrayViewer().getCurrentSlide();
            String string2 = dlist.getAbstractLinearGraphics().getArrayViewer().getData().getFullSampleName(n);
            String string3 = dlist.getAbstractLinearGraphics().getArrayViewer().getExperimentName();
            string = string + "<body>";
            string = string + "\n<FONT FACE=\"Arial\"><b><u>Microarray Expression List</u></b></FONT><br><br>";
            string = string + "\n<FONT FACE=\"Arial\">Experiment name : " + string3 + " - " + string2 + "</FONT><br>";
            string = string + "\n<table border=\"1\" width=\"800\" >";
            string = string + "\n   <tr bordercolor=\"#999999\" bgcolor=\"#E0DFE3\">";
            string = string + "\n     <td width=\"" + colOne + "\"><FONT FACE=\"Arial\"><b>#</b></td>";
            string = string + "\n     <td width=\"" + colTwo + "\"><FONT FACE=\"Arial\"><b>Gene ID</b></td>";
            string = string + "\n     <td width=\"" + colThree + "\"><FONT FACE=\"Arial\"><b>Ratio</b> </td>";
            string = string + "\n     <td width=\"" + colFour + "\"><FONT FACE=\"Arial\"><b>Magpie Gene Card</b> </td>";
            string = string + "\n   </tr>";
            fileWriter.write(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String addToBody(String string, Float f, String string2) {
        String string3 = (String)dlist.getAbstractLinearGraphics().getGBToXPtrMap().get(string);
        ++currNumber;
        if (string3 != null && dlist.getAnalysisMonitor().isMicroArrayElementPaintable(string3)) {
            bufferedBody = "\n   <tr bordercolor=\"#999999\" bgcolor=\"#E0DFE3\">";
            bufferedBody = bufferedBody + "\n     <td width=\"" + colOne + "\"><FONT FACE=\"Arial\">" + currNumber + "  </td>";
            bufferedBody = bufferedBody + "\n     <td width=\"" + colTwo + "\"><FONT FACE=\"Arial\">" + string + "  </td>";
            bufferedBody = bufferedBody + "\n     <td width=\"" + colThree + "\"><FONT FACE=\"Arial\">" + f + "  </td>";
            string3 = string3.substring(0, string3.lastIndexOf(47));
            this.findXLinks(string3, string2);
            bufferedBody = bufferedBody + "\n   </tr>";
            return bufferedBody;
        }
        bufferedBody = "\n   <tr bordercolor=\"#999999\" bgcolor=\"#E0DFE3\">";
        bufferedBody = bufferedBody + "\n     <td width=\"" + colOne + "\"><FONT FACE=\"Arial\">" + currNumber + "  </td>";
        bufferedBody = bufferedBody + "\n     <td width=\"" + colTwo + "\"><FONT FACE=\"Arial\">" + string + "  </td>";
        bufferedBody = bufferedBody + "\n     <td width=\"" + colThree + "\"><FONT FACE=\"Arial\">" + f + "  </td>";
        bufferedBody = bufferedBody + "\n   </tr>";
        return bufferedBody;
    }

    private void writeFooter(FileWriter fileWriter) {
        try {
            int n = dlist.getAbstractLinearGraphics().getArrayViewer().getGbToRatioMap().size();
            String string = "</table> \n ";
            string = string + "\n</body>";
            string = string + "\n</html>";
            fileWriter.write(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void findXLinks(String string, String string2) {
        try {
            List list = dlist.getDataManager().getHyperlinks(string);
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                String string3;
                Link link = (Link)list.get(i);
                String string4 = link.getInfo().getLinkTitle();
                String string5 = link.getToNode().getURL().toString();
                String string6 = string3 = "".equals(string4) ? string5 : string4 + LINK_POINTING + string5;
                if ("embed".equals(link.getArc().getShow().toLowerCase())) continue;
                bufferedBody = string2 != null ? bufferedBody + "\n     <td width=\"" + colFour + "\"><a href= \"" + string3 + "\">" + string2 + "</a></td>" : bufferedBody + "\n     <td width=\"" + colFour + "\"><a href= \"" + string3 + "\">" + "Click Here" + "</a></td>";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setDList(BluejayDObjectList bluejayDObjectList) {
        dlist = bluejayDObjectList;
    }

    public void setClusterImage(URI uRI) {
    }

    static {
        currNumber = 0;
        numberOfGenesWithoutInformation = 0;
        colOne = 25;
        colTwo = 150;
        colThree = 100;
        colFour = 500;
    }
}

