/*
 * Decompiled with CFR 0.152.
 */
package ca.ucalgary.bluejay.gui.microarray.player;

import ca.ucalgary.bluejay.gui.AbstractLinearGraphics;
import ca.ucalgary.bluejay.gui.BluejayDObjectList;
import ca.ucalgary.bluejay.gui.microarray.MicroarrayFunctions;
import ca.ucalgary.bluejay.gui.microarray.player.ComparisonModeGUI;
import ca.ucalgary.bluejay.gui.microarray.player.PlayerGUI;
import ca.ucalgary.bluejay.gui.microarray.player.SingleSlideGUI;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ExperimentSelectorWidget
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final String SINGLE = "Single Mode";
    private static final String PLAYER = "Player Mode";
    private static final String COMPARISON = "Comparison Mode";
    private static JLabel experimentName;
    private static JPanel cards;
    private static JRadioButton singleMode;
    private static JRadioButton playerMode;
    private static JRadioButton comparisonMode;
    private static PlayerGUI playerGUI;
    private static SingleSlideGUI singleGUI;
    private static ComparisonModeGUI comparisonGUI;
    private static BluejayDObjectList dlist;
    private static AbstractLinearGraphics alg;
    private static MicroarrayFunctions microArrayFunctions;

    public ExperimentSelectorWidget(BluejayDObjectList bluejayDObjectList, AbstractLinearGraphics abstractLinearGraphics, MicroarrayFunctions microarrayFunctions) {
        dlist = bluejayDObjectList;
        alg = abstractLinearGraphics;
        microArrayFunctions = microarrayFunctions;
        this.setPreferredSize(new Dimension(200, 150));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        playerGUI = new PlayerGUI();
        playerGUI.setALG(alg);
        playerGUI.setDList(dlist);
        playerGUI.setMicroArrayFunctions(microArrayFunctions);
        singleGUI = new SingleSlideGUI();
        singleGUI.setALG(alg);
        singleGUI.setDList(dlist);
        comparisonGUI = new ComparisonModeGUI();
        comparisonGUI.setALG(alg);
        comparisonGUI.setDList(dlist);
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        singleMode = new JRadioButton(SINGLE);
        singleMode.setSelected(true);
        singleMode.addActionListener(this);
        singleMode.setActionCommand(SINGLE);
        singleMode.addPropertyChangeListener(this);
        buttonGroup.add(singleMode);
        playerMode = new JRadioButton(PLAYER);
        playerMode.addActionListener(this);
        playerMode.addPropertyChangeListener(this);
        playerMode.setActionCommand(PLAYER);
        buttonGroup.add(playerMode);
        comparisonMode = new JRadioButton(COMPARISON);
        comparisonMode.setSelected(true);
        comparisonMode.addActionListener(this);
        comparisonMode.setActionCommand(COMPARISON);
        comparisonMode.addPropertyChangeListener(this);
        buttonGroup.add(comparisonMode);
        jPanel.add(singleMode);
        jPanel.add(playerMode);
        jPanel.add(comparisonMode);
        cards = new JPanel(new CardLayout());
        cards.setPreferredSize(new Dimension(200, 150));
        cards.add((Component)singleGUI, SINGLE);
        cards.add((Component)playerGUI, PLAYER);
        cards.add((Component)comparisonGUI, COMPARISON);
        experimentName = new JLabel();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        experimentName.setPreferredSize(new Dimension(200, 20));
        experimentName.setMinimumSize(new Dimension(200, 20));
        this.add((Component)experimentName, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        this.add((Component)cards, gridBagConstraints);
    }

    public void setExperimentName(String string) {
        experimentName.setText(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(SINGLE)) {
            dlist.enableSaveRatioValues();
            dlist.getArrayViewer().setPlayerSelected(false);
            dlist.getArrayViewer().setComparisonSelected(false);
            singleGUI.getSlider().setValue(playerGUI.getSlider().getValue());
            dlist.getArrayViewer().setCurrentSlide(singleGUI.getSlider().getValue() - 1);
        } else if (actionEvent.getActionCommand().equals(PLAYER)) {
            dlist.disableSaveRatioValues();
            dlist.getArrayViewer().setPlayerSelected(true);
            dlist.getArrayViewer().setComparisonSelected(false);
            playerGUI.getSlider().setValue(singleGUI.getSlider().getValue());
            dlist.getArrayViewer().setCurrentSlide(playerGUI.getSlider().getValue() - 1);
            dlist.repaint(true);
        } else if (actionEvent.getActionCommand().equals(COMPARISON)) {
            dlist.enableSaveRatioValues();
            dlist.getArrayViewer().setPlayerSelected(false);
            dlist.getArrayViewer().setComparisonSelected(true);
            comparisonGUI.resetGUI();
        }
        CardLayout cardLayout = (CardLayout)cards.getLayout();
        cardLayout.show(cards, actionEvent.getActionCommand());
    }

    public SingleSlideGUI getSingleSlideGUI() {
        return singleGUI;
    }

    public PlayerGUI getPlayerGUI() {
        return playerGUI;
    }

    public ComparisonModeGUI getComparisonGUI() {
        return comparisonGUI;
    }

    public JRadioButton getSingleModeRB() {
        return singleMode;
    }

    public JRadioButton getPlayerModeRB() {
        return playerMode;
    }

    public JRadioButton getComparisonModeRB() {
        return comparisonMode;
    }

    public void disablePlayerGUI() {
        playerGUI.diableGUI();
        playerMode.setEnabled(false);
    }

    public void disableSingleGUI() {
        singleGUI.disableGUI();
        singleMode.setEnabled(false);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(singleMode, "Selected", new Boolean(!singleMode.isSelected()), new Boolean(singleMode.isSelected()));
        this.propertyChange(propertyChangeEvent);
    }

    public void disableComparisonGUI() {
        comparisonGUI.disableGUI();
        comparisonMode.setEnabled(false);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(comparisonMode, "Selected", new Boolean(!comparisonMode.isSelected()), new Boolean(comparisonMode.isSelected()));
        this.propertyChange(propertyChangeEvent);
    }

    public void enablePlayerGUI(int n) {
        playerGUI.enableGUI(n);
        playerMode.setEnabled(true);
    }

    public void enableSingleGUI(int n) {
        singleGUI.enableGUI(n);
        singleMode.setEnabled(true);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(singleMode, "Selected", new Boolean(!singleMode.isSelected()), new Boolean(singleMode.isSelected()));
        this.propertyChange(propertyChangeEvent);
    }

    public void enableComparisonGUI(int n) {
        comparisonGUI.enableGUI(n);
        comparisonMode.setEnabled(true);
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(comparisonMode, "Selected", new Boolean(!comparisonMode.isSelected()), new Boolean(comparisonMode.isSelected()));
        this.propertyChange(propertyChangeEvent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "Selected") {
            CardLayout cardLayout = (CardLayout)cards.getLayout();
            if (propertyChangeEvent.getSource().hashCode() == singleMode.hashCode() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                cardLayout.show(cards, SINGLE);
            }
            if (propertyChangeEvent.getSource().hashCode() == comparisonMode.hashCode() && ((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
                cardLayout.show(cards, COMPARISON);
            }
        }
    }
}

